/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.VarsButton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CreateWorkItemsAspectEditor
extends OperationDetailsAspectEditor {
    static final String TAG_WORKITEMS = "workitems";
    static final String TAG_WORKITEM = "workitem";
    static final String ATTR_TYPE = "type";
    static final String ATTR_CATEGORY_PATH = "categoryPath";
    static final String ATTR_SUMMARY = "summary";
    static final String ATTR_DESCRIPTION = "description";
    static final String ATTR_HTML_DESCRIPTION = "htmlDescription";
    static final String VARS_TOOLTIP = Messages.SetupProjectAspectEditor_insertVar;
    static final String[] VAR_PROJECT_AREA_NAME = new String[]{Messages.SetupProjectAspectEditor_projectAreaName, "${project-area-name}"};
    static final String[] VAR_TEAM_AREA_NAME = new String[]{Messages.SetupProjectAspectEditor_teamAreaName, "${team-area-name}"};
    static final String[] VAR_PATH_SEPARATOR = new String[]{Messages.CreateWorkItemsAspectEditor_pathSeparator, "/"};
    static final String[][] CATEGORY_PATH_VARS = new String[][]{VAR_PROJECT_AREA_NAME, VAR_TEAM_AREA_NAME, VAR_PATH_SEPARATOR};
    static final String WORK_ITEM_TYPES_DATA_ID = "com.ibm.team.workitem.configuration.workItemTypes";
    static final String TAG_WORKITEM_TYPE = "type";
    static final String ATTR_WORKITEM_TYPE_ID = "id";
    static final String ATTR_WORKITEM_TYPE_NAME = "name";
    static final ImageDescriptor DELETE_IMAGE_DESCRIPTOR = DefinitionsIdeUIPlugin.getImageDescriptor("icons/copied/elcl16/rem_co.gif");
    private List fTemplates = new ArrayList();
    private List fTemplateForms = new ArrayList();
    private Label fCountLabel;
    protected FormToolkit fToolkit;
    protected LocalResourceManager fResourceManager;
    private Composite fContentArea;
    private List fWorkItemTypes;

    static String convertLineSeparators(String text) {
        String lineSep = System.getProperty("line.separator");
        if (lineSep != null) {
            return text.replaceAll(lineSep, "\n");
        }
        return text;
    }

    static String getAttrib(IMemento memento, String attr, String defaultValue) {
        String val = null;
        if (memento != null) {
            val = memento.getString(attr);
        }
        return val != null ? val : defaultValue;
    }

    private List getWorkItemTypes() {
        ArrayList<WorkItemType> types = new ArrayList<WorkItemType>();
        ModelElement typesElement = this.getSite().getConfigurationData(WORK_ITEM_TYPES_DATA_ID);
        if (typesElement != null) {
            List children = typesElement.getChildElements();
            for (ModelElement element : children) {
                String id;
                if (!"type".equals(element.getName()) || (id = element.getAttribute(ATTR_WORKITEM_TYPE_ID)) == null) continue;
                WorkItemType type = new WorkItemType();
                type.typeId = id;
                String name = element.getAttribute(ATTR_WORKITEM_TYPE_NAME);
                if (name != null) {
                    type.typeName = name;
                }
                types.add(type);
            }
        }
        return types;
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fWorkItemTypes = this.getWorkItemTypes();
    }

    public void restoreState(IMemento memento) {
        ArrayList<WorkItemTemplate> templates = new ArrayList<WorkItemTemplate>();
        IMemento workitemsMemento = memento.getChild(TAG_WORKITEMS);
        if (workitemsMemento != null) {
            IMemento[] children = workitemsMemento.getChildren(TAG_WORKITEM);
            int i = 0;
            while (i < children.length) {
                WorkItemTemplate template = new WorkItemTemplate();
                template.readFrom(children[i]);
                templates.add(template);
                ++i;
            }
        }
        this.fTemplates = templates;
    }

    public boolean saveState(IMemento memento) {
        IMemento workitemsMemento = memento.getChild(TAG_WORKITEMS);
        if (workitemsMemento == null) {
            workitemsMemento = memento.createChild(TAG_WORKITEMS);
        }
        for (WorkItemTemplate template : this.fTemplates) {
            template.createMemento(workitemsMemento);
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.createContents(composite, toolkit);
        this.updateUI();
    }

    protected void createContents(Composite parent, FormToolkit toolkit) {
        this.createTemplatesHeader(parent, toolkit);
        this.createContentArea(parent, toolkit);
    }

    protected void createTemplatesHeader(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.fCountLabel = toolkit.createLabel(composite, "");
        this.fCountLabel.setFont(CreateWorkItemsAspectEditor.getBoldFont());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fCountLabel);
        Button newButton = toolkit.createButton(composite, Messages.AcceptTeamInvitationAspectEditor_5, 8);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateWorkItemsAspectEditor.this.doNewTemplate();
            }
        });
    }

    protected Composite createContentArea(Composite parent, FormToolkit toolkit) {
        this.fContentArea = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fContentArea);
        GridLayoutFactory.fillDefaults().spacing(0, 10).applyTo(this.fContentArea);
        return this.fContentArea;
    }

    protected static Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    protected void updateUI() {
        this.disposeForms();
        this.createForms();
        this.updateCount();
    }

    private void updateCount() {
        this.fCountLabel.setText(NLS.bind((String)Messages.AcceptTeamInvitationAspectEditor_6, (Object)Integer.toString(this.fTemplates.size())));
    }

    private void createForms() {
        int index = 0;
        for (WorkItemTemplate template : this.fTemplates) {
            this.fTemplateForms.add(new WorkItemTemplateForm(template, this.getContentArea(), this.fToolkit, index++));
        }
    }

    private void disposeForms() {
        for (WorkItemTemplateForm form : this.fTemplateForms) {
            form.dispose();
        }
        this.fTemplateForms.clear();
    }

    private void doNewTemplate() {
        WorkItemTemplate template = new WorkItemTemplate();
        template.summary = Messages.AcceptTeamInvitationAspectEditor_7;
        template.description = Messages.AcceptTeamInvitationAspectEditor_8;
        template.isHTML = false;
        WorkItemTemplateForm form = new WorkItemTemplateForm(template, this.getContentArea(), this.fToolkit, this.fTemplates.size());
        this.fTemplates.add(template);
        this.fTemplateForms.add(form);
        this.updateCount();
        this.setDirty();
        this.getContentArea().layout();
        this.getSite().reflow();
        form.activate();
    }

    protected Composite getContentArea() {
        return this.fContentArea;
    }

    private void doDeleteTemplate(WorkItemTemplate template, WorkItemTemplateForm form) {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AcceptTeamInvitationAspectEditor_9, (String)NLS.bind((String)Messages.AcceptTeamInvitationAspectEditor_10, (Object)template.summary))) {
            form.dispose();
            this.fTemplates.remove(template);
            this.fTemplateForms.remove(form);
            this.updateCount();
            this.updateIndices();
            this.setDirty();
            this.getSite().reflow();
        }
    }

    protected Shell getShell() {
        return this.getContentArea().getShell();
    }

    private void updateIndices() {
        int index = 0;
        for (WorkItemTemplateForm form : this.fTemplateForms) {
            form.setIndex(index++);
        }
    }

    public void dispose() {
    }

    protected VarsButton createVarsButton(Composite composite, Text text, FormToolkit toolkit, String[][] vars) {
        VarsButton varsButton = new VarsButton(composite, VARS_TOOLTIP, vars);
        toolkit.adapt((Control)varsButton.getButton(), true, false);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)varsButton.getButton());
        varsButton.setText(text);
        return varsButton;
    }

    class WorkItemTemplate {
        WorkItemType type;
        String categoryPath;
        String summary;
        String description;
        boolean isHTML;

        WorkItemTemplate() {
        }

        public void readFrom(IMemento memento) {
            String typeId = CreateWorkItemsAspectEditor.getAttrib(memento, "type", "");
            for (WorkItemType type : CreateWorkItemsAspectEditor.this.fWorkItemTypes) {
                if (!typeId.equals(type.typeId)) continue;
                this.type = type;
                break;
            }
            if (this.type == null) {
                WorkItemType type = new WorkItemType();
                type.typeId = typeId;
                type.typeName = typeId;
                this.type = type;
            }
            this.categoryPath = CreateWorkItemsAspectEditor.getAttrib(memento, CreateWorkItemsAspectEditor.ATTR_CATEGORY_PATH, "");
            this.summary = CreateWorkItemsAspectEditor.getAttrib(memento, CreateWorkItemsAspectEditor.ATTR_SUMMARY, "");
            this.description = memento.getString(CreateWorkItemsAspectEditor.ATTR_DESCRIPTION);
            if (this.description != null) {
                this.isHTML = false;
            } else {
                this.description = memento.getString(CreateWorkItemsAspectEditor.ATTR_HTML_DESCRIPTION);
                if (this.description != null) {
                    this.isHTML = true;
                } else {
                    this.description = "";
                    this.isHTML = false;
                }
            }
        }

        public void createMemento(IMemento parentMemento) {
            IMemento memento = parentMemento.createChild(CreateWorkItemsAspectEditor.TAG_WORKITEM);
            if (this.type != null && this.type.typeId.length() > 0) {
                memento.putString("type", this.type.typeId);
            }
            if (this.categoryPath != null && this.categoryPath.length() > 0) {
                memento.putString(CreateWorkItemsAspectEditor.ATTR_CATEGORY_PATH, this.categoryPath);
            }
            memento.putString(CreateWorkItemsAspectEditor.ATTR_SUMMARY, this.summary);
            memento.putString(this.isHTML ? CreateWorkItemsAspectEditor.ATTR_HTML_DESCRIPTION : CreateWorkItemsAspectEditor.ATTR_DESCRIPTION, CreateWorkItemsAspectEditor.convertLineSeparators(this.description));
        }
    }

    class WorkItemTemplateForm {
        private WorkItemTemplate fTemplate;
        private Composite fComposite;
        private Text fCategoryPathText;
        private Label fSummaryLabel;
        private Text fSummaryText;
        private Text fDescriptionText;

        WorkItemTemplateForm(final WorkItemTemplate template, Composite parent, FormToolkit toolkit, int index) {
            this.fTemplate = template;
            this.fComposite = toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fComposite);
            GridLayoutFactory.fillDefaults().applyTo(this.fComposite);
            if (index != 0) {
                Label separator = toolkit.createLabel(this.fComposite, "", 258);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
            }
            Composite summaryComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)summaryComposite);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(summaryComposite);
            this.fSummaryLabel = toolkit.createLabel(summaryComposite, "");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fSummaryLabel);
            this.fSummaryText = toolkit.createText(summaryComposite, template.summary, 2180);
            this.fSummaryText.setMessage(Messages.CreateWorkItemsAspectEditor_summary_message);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(150, -1).applyTo((Control)this.fSummaryText);
            ToolBar toolbar = new ToolBar(summaryComposite, 0);
            toolkit.adapt((Control)toolbar, false, false);
            ToolItem deleteItem = new ToolItem(toolbar, 0);
            deleteItem.setImage(JazzResources.getImageWithDefault((ResourceManager)CreateWorkItemsAspectEditor.this.fResourceManager, (ImageDescriptor)DELETE_IMAGE_DESCRIPTOR));
            deleteItem.setToolTipText(Messages.AcceptTeamInvitationAspectEditor_0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)toolbar);
            deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CreateWorkItemsAspectEditor.this.doDeleteTemplate(template, WorkItemTemplateForm.this);
                }
            });
            Composite typeComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)typeComposite);
            GridLayoutFactory.fillDefaults().numColumns(5).applyTo(typeComposite);
            Label typeLabel = toolkit.createLabel(typeComposite, Messages.CreateWorkItemsAspectEditor_0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)typeLabel);
            final ComboViewer typeViewer = new ComboViewer(typeComposite, 2048);
            toolkit.adapt(typeViewer.getControl(), true, false);
            typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            typeViewer.setInput((Object)CreateWorkItemsAspectEditor.this.fWorkItemTypes);
            if (this.fTemplate.type != null) {
                typeViewer.getCombo().setText(this.fTemplate.type.toString());
            }
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(75, -1).applyTo(typeViewer.getControl());
            Label categoryPathLabel = toolkit.createLabel(typeComposite, Messages.CreateWorkItemsAspectEditor_1);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)categoryPathLabel);
            this.fCategoryPathText = toolkit.createText(typeComposite, template.categoryPath, 2052);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(150, -1).applyTo((Control)this.fCategoryPathText);
            CreateWorkItemsAspectEditor.this.createVarsButton(typeComposite, this.fCategoryPathText, toolkit, CATEGORY_PATH_VARS);
            Composite descriptionComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)descriptionComposite);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(descriptionComposite);
            Label descriptionLabel = toolkit.createLabel(descriptionComposite, Messages.AcceptTeamInvitationAspectEditor_1);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)descriptionLabel);
            this.createRadioButton(descriptionComposite, toolkit, Messages.AcceptTeamInvitationAspectEditor_2, false);
            this.createRadioButton(descriptionComposite, toolkit, Messages.AcceptTeamInvitationAspectEditor_3, true);
            this.fDescriptionText = toolkit.createText(descriptionComposite, template.description, 2626);
            int h = this.fDescriptionText.getLineHeight() * 8;
            h = this.fDescriptionText.computeTrim((int)0, (int)0, (int)100, (int)h).height;
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(150, h).applyTo((Control)this.fDescriptionText);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.widget == WorkItemTemplateForm.this.fSummaryText) {
                        ((WorkItemTemplateForm)WorkItemTemplateForm.this).fTemplate.summary = WorkItemTemplateForm.this.fSummaryText.getText();
                        CreateWorkItemsAspectEditor.this.setDirty();
                    } else if (e.widget == typeViewer.getCombo()) {
                        IStructuredSelection selection = (IStructuredSelection)typeViewer.getSelection();
                        ((WorkItemTemplateForm)WorkItemTemplateForm.this).fTemplate.type = (WorkItemType)selection.getFirstElement();
                        CreateWorkItemsAspectEditor.this.setDirty();
                    } else if (e.widget == WorkItemTemplateForm.this.fCategoryPathText) {
                        ((WorkItemTemplateForm)WorkItemTemplateForm.this).fTemplate.categoryPath = WorkItemTemplateForm.this.fCategoryPathText.getText();
                        CreateWorkItemsAspectEditor.this.setDirty();
                    } else if (e.widget == WorkItemTemplateForm.this.fDescriptionText) {
                        ((WorkItemTemplateForm)WorkItemTemplateForm.this).fTemplate.description = WorkItemTemplateForm.this.fDescriptionText.getText();
                        CreateWorkItemsAspectEditor.this.setDirty();
                    }
                }
            };
            typeViewer.getCombo().addModifyListener(modifyListener);
            this.fCategoryPathText.addModifyListener(modifyListener);
            this.fSummaryText.addModifyListener(modifyListener);
            this.fDescriptionText.addModifyListener(modifyListener);
            this.setIndex(index);
        }

        private void createRadioButton(Composite parent, FormToolkit toolkit, String text, final boolean isHTML) {
            Button button = toolkit.createButton(parent, text, 16);
            button.setSelection(this.fTemplate.isHTML == isHTML);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        ((WorkItemTemplateForm)WorkItemTemplateForm.this).fTemplate.isHTML = isHTML;
                        CreateWorkItemsAspectEditor.this.setDirty();
                    }
                }
            });
        }

        void setIndex(int index) {
            this.fSummaryLabel.setText(NLS.bind((String)Messages.AcceptTeamInvitationAspectEditor_4, (Object)Integer.toString(index + 1)));
        }

        void dispose() {
            this.fComposite.dispose();
        }

        public void activate() {
            this.fDescriptionText.setFocus();
            this.fSummaryText.setFocus();
            this.fSummaryText.selectAll();
        }
    }

    static class WorkItemType {
        String typeId;
        String typeName;

        WorkItemType() {
        }

        public String toString() {
            if (this.typeName != null) {
                return this.typeName;
            }
            return this.typeId;
        }
    }
}

