/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.CreateRootTeamAreaDialog;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.ImagePool;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.process.internal.ide.ui.editors.form.IDevelopmentLineProxy;
import com.ibm.team.process.internal.ide.ui.editors.form.IIterationStructureProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CreateTeamAreasAspectEditor
extends OperationDetailsAspectEditor {
    private static final String TAG_TEAM_AREA = "teamArea";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DEVELOPMENT_LINE = "timeline";
    private Model fModel;
    private Button fCreateButton;
    private Button fCreateRootButton;
    private Button fDeleteButton;
    private TreeViewer fTeamAreasViewer;

    private static String getUnqualifiedName(String qualifiedName) {
        int lastIndexOf = qualifiedName.lastIndexOf("/");
        if (lastIndexOf > -1) {
            return qualifiedName.substring(lastIndexOf + 1);
        }
        return qualifiedName;
    }

    private static String getQualifier(String qualifiedName) {
        int lastIndexOf = qualifiedName.lastIndexOf("/");
        if (lastIndexOf > -1) {
            return qualifiedName.substring(0, lastIndexOf);
        }
        return null;
    }

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    private static String normalize(String string) {
        return string == null ? "" : string.trim();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(1).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.CreateTeamAreasAspectEditor_9);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        Label description = toolkit.createLabel(parent, Messages.CreateTeamAreasAspectEditor_13, 64);
        int w = LayoutConstants.getSpacing().x * 30;
        GridDataFactory.fillDefaults().grab(true, false).hint(w, -1).applyTo((Control)description);
        heading.setFont(this.getBoldFont());
        Composite body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(2).applyTo(body);
        Tree treeControl = toolkit.createTree(body, 2050);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeControl);
        this.fTeamAreasViewer = new TreeViewer(treeControl);
        this.fTeamAreasViewer.setAutoExpandLevel(-1);
        this.fTeamAreasViewer.setComparator(new ViewerComparator());
        this.fTeamAreasViewer.setContentProvider((IContentProvider)new TeamAreasContentProvider());
        this.fTeamAreasViewer.setLabelProvider((IBaseLabelProvider)new TeamAreasLabelProvider());
        this.fTeamAreasViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    CreateTeamAreasAspectEditor.this.fCreateButton.setEnabled(false);
                    CreateTeamAreasAspectEditor.this.fDeleteButton.setEnabled(false);
                } else {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    if (ss.size() == 1) {
                        CreateTeamAreasAspectEditor.this.fCreateButton.setEnabled(true);
                    }
                    CreateTeamAreasAspectEditor.this.fDeleteButton.setEnabled(true);
                }
            }
        });
        this.fTeamAreasViewer.setInput((Object)this.fModel);
        final CreateTeamAreaAction createTeamAreaAction = new CreateTeamAreaAction();
        final CreateRootTeamAreaAction createRootTeamAreaAction = new CreateRootTeamAreaAction();
        final DeleteTeamAreaAction deleteTeamAreaAction = new DeleteTeamAreaAction();
        Composite toolbar = toolkit.createComposite(body);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)toolbar);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(toolbar);
        this.fCreateButton = toolkit.createButton(toolbar, createTeamAreaAction.getText(), 0x800000);
        this.fCreateButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fCreateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                createTeamAreaAction.run();
            }
        });
        this.fCreateButton.setToolTipText(createTeamAreaAction.getToolTipText());
        this.fCreateButton.setEnabled(false);
        this.fCreateRootButton = toolkit.createButton(toolbar, createRootTeamAreaAction.getText(), 0x800000);
        this.fCreateRootButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fCreateRootButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                createRootTeamAreaAction.run();
            }
        });
        this.fCreateRootButton.setToolTipText(createTeamAreaAction.getToolTipText());
        this.fDeleteButton = toolkit.createButton(toolbar, deleteTeamAreaAction.getText(), 0x800000);
        this.fDeleteButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteTeamAreaAction.run();
            }
        });
        this.fDeleteButton.setToolTipText(deleteTeamAreaAction.getToolTipText());
        this.fDeleteButton.setEnabled(false);
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        AbstractProcessAspect aspect = (AbstractProcessAspect)inputAspect;
        IIterationStructureProxy iterationStructureProxy = aspect.getIterationStructure();
        IDevelopmentLineProxy[] developmentLineProxies = iterationStructureProxy.getDevelopmentLines();
        this.fModel = new Model(developmentLineProxies);
    }

    public void restoreState(IMemento memento) {
        this.fModel.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        return this.fModel.saveTo(memento);
    }

    private class CreateRootTeamAreaAction
    extends Action {
        public CreateRootTeamAreaAction() {
            this.setText(Messages.CreateTeamAreasAspectEditor_11);
            this.setToolTipText(Messages.CreateTeamAreasAspectEditor_12);
        }

        public void run() {
            String root;
            CreateRootTeamAreaDialog dialog = new CreateRootTeamAreaDialog(CreateTeamAreasAspectEditor.this.fTeamAreasViewer.getControl().getShell(), ((CreateTeamAreasAspectEditor)CreateTeamAreasAspectEditor.this).fModel.fDevelopmentLines, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.length() == 0) {
                        return "";
                    }
                    if (newText.indexOf("/") > -1) {
                        return Messages.CreateTeamAreasAspectEditor_7;
                    }
                    if (CreateTeamAreasAspectEditor.this.fModel.exists(null, newText)) {
                        return Messages.CreateTeamAreasAspectEditor_8;
                    }
                    return null;
                }
            });
            if (dialog.open() == 0 && (root = CreateTeamAreasAspectEditor.this.fModel.createRoot(dialog.getDevelopmentLine(), dialog.getName())) != null) {
                CreateTeamAreasAspectEditor.this.fTeamAreasViewer.refresh();
                CreateTeamAreasAspectEditor.this.fTeamAreasViewer.setSelection((ISelection)new StructuredSelection((Object)root), true);
                CreateTeamAreasAspectEditor.this.setDirty();
            }
        }
    }

    private class CreateTeamAreaAction
    extends Action {
        public CreateTeamAreaAction() {
            this.setText(Messages.CreateTeamAreasAspectEditor_2);
            this.setToolTipText(Messages.CreateTeamAreasAspectEditor_3);
        }

        public void run() {
            ISelection selection = CreateTeamAreasAspectEditor.this.fTeamAreasViewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                String child;
                InputDialog dialog;
                IStructuredSelection ss = (IStructuredSelection)selection;
                String parent = null;
                Object selectedElement = ss.getFirstElement();
                if (selectedElement instanceof String) {
                    parent = (String)selectedElement;
                }
                final String qualifier = parent;
                if (parent != null && (dialog = new InputDialog(CreateTeamAreasAspectEditor.this.fTeamAreasViewer.getControl().getShell(), Messages.CreateTeamAreasAspectEditor_4, Messages.CreateTeamAreasAspectEditor_5, Messages.CreateTeamAreasAspectEditor_6, new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "";
                        }
                        if (newText.indexOf("/") > -1) {
                            return Messages.CreateTeamAreasAspectEditor_7;
                        }
                        if (CreateTeamAreasAspectEditor.this.fModel.exists(qualifier, newText)) {
                            return Messages.CreateTeamAreasAspectEditor_8;
                        }
                        return null;
                    }
                })).open() == 0 && (child = CreateTeamAreasAspectEditor.this.fModel.createChild(parent, dialog.getValue())) != null) {
                    CreateTeamAreasAspectEditor.this.fTeamAreasViewer.refresh(selectedElement);
                    CreateTeamAreasAspectEditor.this.fTeamAreasViewer.setSelection((ISelection)new StructuredSelection((Object)child), true);
                    CreateTeamAreasAspectEditor.this.setDirty();
                }
            }
        }
    }

    private class DeleteTeamAreaAction
    extends Action {
        public DeleteTeamAreaAction() {
            this.setText(Messages.CreateTeamAreasAspectEditor_0);
            this.setToolTipText(Messages.CreateTeamAreasAspectEditor_1);
        }

        public void run() {
            ISelection selection = CreateTeamAreasAspectEditor.this.fTeamAreasViewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                for (Object selected : ss) {
                    if (!(selected instanceof String) || !CreateTeamAreasAspectEditor.this.fModel.remove((String)selected)) continue;
                    CreateTeamAreasAspectEditor.this.setDirty();
                    CreateTeamAreasAspectEditor.this.fTeamAreasViewer.refresh();
                }
            }
        }
    }

    private static class Model {
        static final String SEPARATOR = "/";
        final IDevelopmentLineProxy[] fDevelopmentLines;
        HashMap fChildren = new HashMap();
        List fRoots = new ArrayList();
        HashMap fRootDevLines = new HashMap();

        public Model(IDevelopmentLineProxy[] developmentLineProxies) {
            this.fDevelopmentLines = developmentLineProxies;
        }

        public void readFrom(IMemento memento) {
            IMemento[] rootMementos = memento.getChildren(CreateTeamAreasAspectEditor.TAG_TEAM_AREA);
            if (rootMementos != null) {
                int i = 0;
                while (i < rootMementos.length) {
                    IMemento rootMemento = rootMementos[i];
                    if (rootMemento != null) {
                        String developmentLine = CreateTeamAreasAspectEditor.normalize(rootMemento.getString(CreateTeamAreasAspectEditor.ATTR_DEVELOPMENT_LINE));
                        String teamArea = CreateTeamAreasAspectEditor.normalize(rootMemento.getString(CreateTeamAreasAspectEditor.ATTR_NAME));
                        this.createRoot(developmentLine, teamArea, rootMemento);
                    }
                    ++i;
                }
            }
        }

        private void createRoot(String devLineId, String teamAreaName, IMemento childMemento) {
            if (CreateTeamAreasAspectEditor.isNotNull(teamAreaName)) {
                IDevelopmentLineProxy devLine;
                this.fRoots.add(teamAreaName);
                if (devLineId != null && (devLine = this.findDevelopmentLine(devLineId)) != null) {
                    this.fRootDevLines.put(teamAreaName, devLine);
                }
                this.createChildren(teamAreaName, childMemento.getChildren(CreateTeamAreasAspectEditor.TAG_TEAM_AREA));
            }
        }

        private void createChild(String parent, String unqualifiedChild, IMemento childMemento) {
            if (CreateTeamAreasAspectEditor.isNotNull(parent) && CreateTeamAreasAspectEditor.isNotNull(unqualifiedChild)) {
                ArrayList<String> children = (ArrayList<String>)this.fChildren.get(parent);
                if (children == null) {
                    children = new ArrayList<String>();
                    this.fChildren.put(parent, children);
                }
                String qualifiedChild = String.valueOf(parent) + SEPARATOR + unqualifiedChild;
                children.add(qualifiedChild);
                this.createChildren(qualifiedChild, childMemento.getChildren(CreateTeamAreasAspectEditor.TAG_TEAM_AREA));
            }
        }

        private void createChildren(String parent, IMemento[] childrenMemento) {
            if (childrenMemento != null) {
                int i = 0;
                while (i < childrenMemento.length) {
                    IMemento childMemento = childrenMemento[i];
                    if (childMemento != null) {
                        this.createChild(parent, CreateTeamAreasAspectEditor.normalize(childMemento.getString(CreateTeamAreasAspectEditor.ATTR_NAME)), childMemento);
                    }
                    ++i;
                }
            }
        }

        public boolean saveTo(IMemento memento) {
            for (String rootTeamArea : this.fRoots) {
                IMemento teamAreaMemento = memento.createChild(CreateTeamAreasAspectEditor.TAG_TEAM_AREA);
                teamAreaMemento.putString(CreateTeamAreasAspectEditor.ATTR_NAME, rootTeamArea);
                IDevelopmentLineProxy devLine = (IDevelopmentLineProxy)this.fRootDevLines.get(rootTeamArea);
                if (devLine != null) {
                    teamAreaMemento.putString(CreateTeamAreasAspectEditor.ATTR_DEVELOPMENT_LINE, devLine.getId());
                }
                this.saveChildren(teamAreaMemento, rootTeamArea);
            }
            return this.fRoots.size() > 0;
        }

        private void saveChildren(IMemento parentMemento, String parent) {
            ArrayList children = (ArrayList)this.fChildren.get(parent);
            if (children != null && !children.isEmpty()) {
                for (String teamArea : children) {
                    IMemento teamAreaMemento = parentMemento.createChild(CreateTeamAreasAspectEditor.TAG_TEAM_AREA);
                    teamAreaMemento.putString(CreateTeamAreasAspectEditor.ATTR_NAME, CreateTeamAreasAspectEditor.getUnqualifiedName(teamArea));
                    this.saveChildren(teamAreaMemento, teamArea);
                }
            }
        }

        public boolean remove(String qualifiedTeamArea) {
            ArrayList children;
            this.removeChildren(qualifiedTeamArea);
            String parent = CreateTeamAreasAspectEditor.getQualifier(qualifiedTeamArea);
            if (parent == null) {
                this.fRoots.remove(qualifiedTeamArea);
                this.fRootDevLines.remove(qualifiedTeamArea);
                return true;
            }
            if (parent != null && (children = (ArrayList)this.fChildren.get(parent)) != null) {
                boolean removed = children.remove(qualifiedTeamArea);
                if (children.isEmpty()) {
                    this.fChildren.remove(parent);
                }
                return removed;
            }
            return false;
        }

        private void removeChildren(String teamArea) {
            ArrayList children = (ArrayList)this.fChildren.remove(teamArea);
            if (children != null) {
                Iterator e = children.iterator();
                while (e.hasNext()) {
                    this.removeChildren((String)e.next());
                }
            }
        }

        public boolean exists(String parent, String unqualifiedTeamArea) {
            if (CreateTeamAreasAspectEditor.isNotNull(unqualifiedTeamArea)) {
                if (parent == null) {
                    return this.fRoots.contains(unqualifiedTeamArea);
                }
                ArrayList children = (ArrayList)this.fChildren.get(parent);
                if (children != null) {
                    return children.contains(String.valueOf(parent) + SEPARATOR + unqualifiedTeamArea);
                }
            }
            return false;
        }

        public String createRoot(String devLineId, String teamArea) {
            if (CreateTeamAreasAspectEditor.isNotNull(teamArea) && this.fRoots.add(teamArea)) {
                IDevelopmentLineProxy line = this.findDevelopmentLine(devLineId);
                if (line != null) {
                    this.fRootDevLines.put(teamArea, line);
                }
                return teamArea;
            }
            return null;
        }

        public String createChild(String parent, String unqualifiedTeamArea) {
            if (CreateTeamAreasAspectEditor.isNotNull(parent) && CreateTeamAreasAspectEditor.isNotNull(unqualifiedTeamArea)) {
                ArrayList<String> children = (ArrayList<String>)this.fChildren.get(parent);
                if (children == null) {
                    children = new ArrayList<String>();
                    this.fChildren.put(parent, children);
                }
                String qualifiedTeamArea = String.valueOf(parent) + SEPARATOR + unqualifiedTeamArea;
                children.add(qualifiedTeamArea);
                return qualifiedTeamArea;
            }
            return null;
        }

        public Object findParent(Object child) {
            if (child instanceof String) {
                return CreateTeamAreasAspectEditor.getQualifier((String)child);
            }
            return null;
        }

        private IDevelopmentLineProxy findDevelopmentLine(String devLineId) {
            if (devLineId != null) {
                int i = 0;
                while (i < this.fDevelopmentLines.length) {
                    IDevelopmentLineProxy proxy = this.fDevelopmentLines[i];
                    if (proxy.getId().equals(devLineId)) {
                        return proxy;
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    private class TeamAreasContentProvider
    implements ITreeContentProvider {
        private TeamAreasContentProvider() {
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Model) {
                return ((Model)parentElement).fRoots.toArray();
            }
            ArrayList children = (ArrayList)((CreateTeamAreasAspectEditor)CreateTeamAreasAspectEditor.this).fModel.fChildren.get(parentElement);
            if (children != null) {
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return CreateTeamAreasAspectEditor.this.fModel.findParent(element);
        }

        public boolean hasChildren(Object element) {
            ArrayList children = (ArrayList)((CreateTeamAreasAspectEditor)CreateTeamAreasAspectEditor.this).fModel.fChildren.get(element);
            return children != null && !children.isEmpty();
        }
    }

    private class TeamAreasLabelProvider
    extends LabelProvider {
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        public String getText(Object element) {
            if (element instanceof String) {
                String name = super.getText((Object)CreateTeamAreasAspectEditor.getUnqualifiedName((String)element));
                IDevelopmentLineProxy devLine = (IDevelopmentLineProxy)((CreateTeamAreasAspectEditor)CreateTeamAreasAspectEditor.this).fModel.fRootDevLines.get(element);
                if (devLine != null) {
                    name = NLS.bind((String)Messages.CreateTeamAreasAspectEditor_10, (Object)name, (Object)devLine.getName());
                }
                return CreateTeamAreasAspectEditor.normalize(name);
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDesc = this.getImageDescriptor(element);
            if (imageDesc != null) {
                Image image = (Image)this.fResourceManager.find((DeviceResourceDescriptor)imageDesc);
                if (image == null) {
                    image = this.fResourceManager.createImageWithDefault(imageDesc);
                }
                return image;
            }
            return super.getImage(element);
        }

        private ImageDescriptor getImageDescriptor(Object element) {
            if (element instanceof String) {
                return ImagePool.TEAM_AREA_NOT_CUSTOMIZED;
            }
            return null;
        }

        public void dispose() {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            super.dispose();
        }
    }
}

