/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.editors.form.IDevelopmentLineProxy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateRootTeamAreaDialog
extends Dialog {
    private Text fName;
    private Combo fCombo;
    private final IDevelopmentLineProxy[] fLineProxies;
    private String fNameResult;
    private String fLineResult;
    private Composite fComposite;
    private Label fErrorLabel;
    private final IInputValidator fValidator;

    protected CreateRootTeamAreaDialog(Shell parentShell, IDevelopmentLineProxy[] lineProxies, IInputValidator validator) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fLineProxies = lineProxies;
        this.fValidator = validator;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CreateRootTeamAreaDialog_0);
    }

    public String getName() {
        return this.fNameResult;
    }

    public String getDevelopmentLine() {
        return this.fLineResult;
    }

    protected Control createDialogArea(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginTop = 10;
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(1808));
        CreateRootTeamAreaDialog.applyDialogFont((Control)this.fComposite);
        Composite descriptionComposite = new Composite(this.fComposite, 0);
        descriptionComposite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 10;
        descriptionComposite.setLayout((Layout)layout);
        Label description = new Label(descriptionComposite, 64);
        description.setLayoutData((Object)new GridData(768));
        description.setText(Messages.CreateRootTeamAreaDialog_1);
        Label nameLabel = new Label(this.fComposite, 64);
        nameLabel.setLayoutData((Object)new GridData(768));
        nameLabel.setText(Messages.CreateRootTeamAreaDialog_2);
        this.fName = new Text(this.fComposite, 2052);
        GridData gridData = new GridData(768);
        gridData.minimumWidth = 500;
        this.fName.setLayoutData((Object)gridData);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateRootTeamAreaDialog.this.validateInput();
            }
        });
        Label label = new Label(this.fComposite, 64);
        label.setText(Messages.CreateRootTeamAreaDialog_3);
        label.setLayoutData((Object)new GridData(768));
        this.fCombo = new Combo(this.fComposite, 12);
        this.fCombo.setLayoutData((Object)new GridData(768));
        String none = Messages.CreateRootTeamAreaDialog_4;
        this.fCombo.add(none);
        this.fCombo.setText(none);
        int i = 0;
        while (i < this.fLineProxies.length) {
            this.fCombo.add(this.fLineProxies[i].getName());
            ++i;
        }
        Composite labelComposite = new Composite(this.fComposite, 0);
        labelComposite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginTop = layout.marginHeight;
        layout.marginHeight = 0;
        labelComposite.setLayout((Layout)layout);
        this.fErrorLabel = new Label(labelComposite, 64);
        this.fErrorLabel.setLayoutData((Object)new GridData(768));
        this.fErrorLabel.setText("");
        return this.fComposite;
    }

    public void create() {
        super.create();
        this.validateInput();
    }

    protected void validateInput() {
        if (this.fValidator != null) {
            String text = this.fName.getText();
            String errorText = this.fValidator.isValid(text);
            this.getButton(0).setEnabled(errorText == null);
            this.fErrorLabel.setText(errorText == null ? "" : errorText);
            this.updateShellSize();
        }
    }

    private void updateShellSize() {
        Point beforeSize = this.fComposite.getSize();
        this.fComposite.layout();
        Point afterSize = this.fComposite.computeSize(beforeSize.x, -1, true);
        int yDiff = afterSize.y - beforeSize.y;
        if (yDiff > 0) {
            Point shellSize = this.getShell().getSize();
            this.getShell().setSize(new Point(shellSize.x, shellSize.y + yDiff));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int index = this.fCombo.getSelectionIndex();
            if (index > 0 && index <= this.fLineProxies.length) {
                this.fLineResult = this.fLineProxies[index - 1].getId();
            }
            this.fNameResult = this.fName.getText();
        }
        super.buttonPressed(buttonId);
    }
}

