/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.feed.ui.internal.OpenFeedAction;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFeedServiceConstants;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPartSite;

public class FeedDomain
extends Domain {
    private static final String DFLT_ENCODING = "UTF-8";
    private static final String FEED_SERVICE = IFeedServiceConstants.SERVICE_NAME;
    private FeedLabelProvider fFeedLabelProvider = new FeedLabelProvider();

    public boolean supportsCategory(Category category) {
        if (category instanceof IProcessAreaCategory) {
            return ((IProcessAreaCategory)category).isTeamAreaCategory();
        }
        return false;
    }

    public boolean confineToSupportedCategories() {
        return true;
    }

    public boolean contains(Object element) {
        return element instanceof Channel;
    }

    public ITreePathContentProvider getContentProvider() {
        return new FeedContentProvider();
    }

    public ITreePathLabelProvider getLabelProvider() {
        return this.fFeedLabelProvider;
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.getFirstElement() == this.getRoot()) {
            return false;
        }
        OpenFeedAction action = new OpenFeedAction(selection, site.getPage());
        action.run(null);
        return true;
    }

    private Channel createChannel(ITeamArea teamArea) {
        String url = null;
        try {
            ITeamRepository teamRepository = (ITeamRepository)teamArea.getOrigin();
            url = this.buildURL(teamRepository, teamArea);
        }
        catch (Exception e) {
            DefinitionsIdeUIPlugin.getDefault().log(e);
            return null;
        }
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(Messages.FeedDomain_2);
        channel.setDescription(NLS.bind((String)Messages.FeedDomain_3, (Object)teamArea.getName()));
        channel.setForceDownload(true);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        FeedManager.getDefault().loadNews(channel);
        return channel;
    }

    private String buildURL(ITeamRepository repo, ITeamArea teamArea) throws UnsupportedEncodingException, URISyntaxException {
        StringBuffer url = new StringBuffer();
        url.append(FeedDomain.getBaseURI(new URI(repo.getRepositoryURI())));
        url.append("service/");
        url.append(FEED_SERVICE);
        url.append("?provider=team&team_area=");
        url.append(teamArea.getItemId().getUuidValue());
        url.append("&user=");
        url.append(URLEncoder.encode(repo.loggedInContributor().getUserId(), DFLT_ENCODING));
        return url.toString();
    }

    public static String getBaseURI(URI uri) {
        String protocol = uri.getScheme();
        String authority = uri.getAuthority();
        String path = uri.getPath();
        if (protocol == null || authority == null || path == null) {
            return null;
        }
        String[] segments = path.split("/");
        int i = 0;
        while (i < segments.length && segments[i].equals("")) {
            ++i;
        }
        path = "/";
        if (i < segments.length) {
            path = String.valueOf(path) + segments[i] + "/";
        }
        StringBuffer url = new StringBuffer();
        url.append(protocol);
        url.append("://");
        url.append(authority);
        url.append(path);
        return url.toString();
    }

    public void dispose() {
        this.fFeedLabelProvider.dispose();
        super.dispose();
    }

    private class FeedContentProvider
    implements ITreePathContentProvider {
        private FeedContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public boolean hasChildren(TreePath path) {
            return path.getLastSegment() instanceof DomainSubtreeRoot;
        }

        public TreePath[] getParents(Object element) {
            return new TreePath[0];
        }

        public Object[] getChildren(TreePath parentPath) {
            ITeamArea area;
            Channel channel;
            if (parentPath.getLastSegment() instanceof DomainSubtreeRoot && (channel = FeedDomain.this.createChannel(area = (ITeamArea)((DomainSubtreeRoot)parentPath.getLastSegment()).getCategoryElement())) != null) {
                return new Object[]{channel};
            }
            return new Object[0];
        }
    }

    private static class FeedLabelProvider
    extends TypeLabelProvider
    implements ITreePathLabelProvider {
        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof Channel) {
                ImageDescriptor descriptor = DefinitionsIdeUIPlugin.getImageDescriptor("icons/obj16/feeds_evnt_etern_obj.gif");
                Image image = this.getResources().createImageWithDefault(descriptor);
                label.setImage(image);
                Channel channel = (Channel)element;
                label.setText(channel.getTitle());
            }
        }

        public void updateLabel(ViewerLabel label, TreePath elementPath) {
            this.updateLabel(label, elementPath.getLastSegment());
        }
    }
}

