/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.ITeamData;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ProcessFactory;
import com.ibm.team.process.internal.common.RolePersistence;
import com.ibm.team.process.internal.common.TeamDataRecord;
import com.ibm.team.process.internal.common.impl.ProcessAreaImpl;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.TeamDataRecordsListener;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TeamData
implements ITeamData {
    public static final String[] EMPTYSTRINGARRAY = new String[0];
    public static final String ROLES_KEY = "roles";
    public static final String POPULATE_ROLES_MAP_ON_INITIALIZE = "PopulateRolesMapOnInitialize";
    private static final boolean populateRolesMapOnInitialize = Boolean.getBoolean("PopulateRolesMapOnInitialize");
    private ProcessAreaImpl fProcessAreaImpl;
    private ItemHandleAwareHashMap fContributorMap;
    private ItemHandleAwareHashMap fContributorRolesMap;
    private TeamDataRecordsListener fListener;

    public TeamData(ProcessAreaImpl impl) {
        this.fProcessAreaImpl = impl;
    }

    public static TeamData getInstance(ProcessAreaImpl processAreaImpl) {
        return new TeamData(processAreaImpl);
    }

    @Override
    public String getContributorData(IContributorHandle contributor, String key) {
        this.initialize();
        Map contributorData = (Map)this.fContributorMap.get(contributor);
        String result = null;
        if (contributorData != null) {
            result = (String)contributorData.get(key);
        }
        return result;
    }

    @Override
    public String[] getContributorRoleIds(IContributorHandle contributor) {
        String[] contributorRoleIds = null;
        if (this.fContributorRolesMap == null) {
            this.fContributorRolesMap = new ItemHandleAwareHashMap();
        } else {
            contributorRoleIds = (String[])this.fContributorRolesMap.get(contributor);
        }
        if (contributorRoleIds == null) {
            String persistentRoleData = this.getContributorData(contributor, ROLES_KEY);
            contributorRoleIds = RolePersistence.getRoleIds(persistentRoleData);
            if (contributorRoleIds == null) {
                contributorRoleIds = EMPTYSTRINGARRAY;
            }
            this.fContributorRolesMap.put(contributor, contributorRoleIds);
        }
        return contributorRoleIds;
    }

    @Override
    public void setContributorData(IContributorHandle contributor, String key, String value) {
        this.initialize();
        String oldValue = value == null ? this.removeContributorData(contributor, key) : this.internalSetContributorData(contributor, key, value, true);
        this.updateTeamDataRecords(contributor, key, oldValue, value);
    }

    @Override
    public void setContributorData(IContributorHandle[] contributors, String key, String value) {
        this.initialize();
        IContributorHandle[] iContributorHandleArray = contributors;
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            IContributorHandle contributor = iContributorHandleArray[n2];
            String oldValue = value == null ? this.removeContributorData(contributor, key) : this.internalSetContributorData(contributor, key, value, true);
            this.updateTeamDataRecords(contributor, key, oldValue, value);
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.initialize();
        this.uninstallChangeListener();
        try {
            if (this.fContributorMap != null) {
                this.fContributorMap.clear();
            }
            if (this.fContributorRolesMap != null) {
                this.fContributorRolesMap.clear();
            }
            this.fProcessAreaImpl.getTeamDataRecords().clear();
        }
        finally {
            this.installChangeListener();
        }
    }

    public void flush() {
        if (this.fContributorMap != null) {
            this.uninstallChangeListener();
            this.fContributorMap = null;
            this.fContributorRolesMap = null;
        }
    }

    private String removeContributorData(IContributorHandle contributor, String key) {
        Map contributorData = (Map)this.fContributorMap.get(contributor);
        if (contributorData != null) {
            return (String)contributorData.remove(key);
        }
        if (this.fContributorRolesMap != null && contributor != null && ROLES_KEY.equals(key)) {
            this.fContributorRolesMap.remove(contributor);
        }
        return null;
    }

    private void initialize() {
        if (this.fContributorMap == null) {
            List teamDataRecords = this.fProcessAreaImpl.getTeamDataRecords();
            this.fContributorMap = new ItemHandleAwareHashMap();
            for (TeamDataRecord record : teamDataRecords) {
                IContributorHandle recordContributor = record.getContributor();
                String recordKey = record.getKey();
                String obsoleteValue = record.getValue();
                if (obsoleteValue != null && obsoleteValue.length() > 0) {
                    this.internalSetContributorData(recordContributor, recordKey, obsoleteValue, populateRolesMapOnInitialize);
                    continue;
                }
                this.internalSetContributorData(recordContributor, recordKey, record.getValue2(), populateRolesMapOnInitialize);
            }
            this.installChangeListener();
        }
    }

    private void installChangeListener() {
        if (this.fListener == null) {
            this.fListener = new TeamDataRecordsListener(this);
        }
        this.fProcessAreaImpl.eAdapters().add((Object)this.fListener);
    }

    private void uninstallChangeListener() {
        if (this.fListener != null) {
            this.fProcessAreaImpl.eAdapters().remove((Object)this.fListener);
        }
    }

    private String internalSetContributorData(IContributorHandle contributor, String key, String value, boolean populateRolesMap) {
        ConcurrentHashMap<String, String> contributorData = (ConcurrentHashMap<String, String>)this.fContributorMap.get(contributor);
        if (contributorData == null) {
            contributorData = new ConcurrentHashMap<String, String>(16, 0.75f, 1);
            this.fContributorMap.put(contributor, contributorData);
        }
        if (populateRolesMap && ROLES_KEY.equals(key) && contributor != null) {
            if (this.fContributorRolesMap == null) {
                this.fContributorRolesMap = new ItemHandleAwareHashMap();
            }
            String[] contributorRoleIds = RolePersistence.getRoleIds(value);
            this.fContributorRolesMap.put(contributor, contributorRoleIds);
        }
        return contributorData.put(key, value);
    }

    private void updateTeamDataRecords(IContributorHandle contributor, String key, String oldValue, String value) {
        block10: {
            this.uninstallChangeListener();
            try {
                if (oldValue == null) {
                    if (value == null) {
                        return;
                    }
                    TeamDataRecord record = ProcessFactory.eINSTANCE.createTeamDataRecord();
                    record.setContributor(contributor);
                    record.setKey(key);
                    record.setValue2(value);
                    this.fProcessAreaImpl.getTeamDataRecords().add(record);
                    break block10;
                }
                List records = this.fProcessAreaImpl.getTeamDataRecords();
                Iterator e = records.iterator();
                while (e.hasNext()) {
                    TeamDataRecord record = (TeamDataRecord)e.next();
                    if (!contributor.sameItemId((IItemHandle)record.getContributor()) || !key.equals(record.getKey()) || !oldValue.equals(record.getValue2())) continue;
                    if (value != null) {
                        record.setValue2(value);
                    } else {
                        e.remove();
                    }
                    return;
                }
                RuntimeException x = new RuntimeException(Messages.getCommonString("TeamData.0"));
                InternalProcessCommon.log(x);
                throw x;
            }
            finally {
                this.installChangeListener();
            }
        }
    }
}

