/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.TeamAreaHierarchyException;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.common.ProcessFactory;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.process.internal.common.TeamAreaHierarchyRecord;
import com.ibm.team.process.internal.common.TeamAreaHierarchyTag;
import com.ibm.team.process.internal.common.impl.ProjectAreaImpl;
import com.ibm.team.process.internal.common.util.HierarchyRecordsListener;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.JazzLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TeamAreaHierarchy
implements ITeamAreaHierarchy {
    private final ProjectAreaImpl fProjectAreaImpl;
    private ItemHandleAwareHashMap fChildrenMap;
    private ItemHandleAwareHashMap fParentMap;
    private HierarchyRecordsListener fListener;
    private final boolean fImmutable;
    private static JazzLog LOGGER = JazzLog.getLog(TeamAreaHierarchy.class);

    public TeamAreaHierarchy(ProjectAreaImpl impl) {
        this(impl, false);
    }

    public TeamAreaHierarchy(ProjectAreaImpl impl, boolean immutable) {
        this.fProjectAreaImpl = impl;
        this.fImmutable = immutable;
        if (this.fImmutable) {
            this.initialize();
        }
    }

    public IProjectArea getProjectArea() {
        return this.fProjectAreaImpl;
    }

    @Override
    public synchronized List getTeamAreas() {
        this.initialize();
        ArrayList teamAreas = new ArrayList();
        teamAreas.addAll(this.fChildrenMap.keySet());
        return Collections.unmodifiableList(teamAreas);
    }

    @Override
    public synchronized void addChild(ITeamAreaHandle parent, ITeamAreaHandle child) {
        this.initialize();
        this.check(this.fChildrenMap.containsKey(parent), Messages.getCommonString("TeamAreaHierarchy.0"));
        this.check(!this.fParentMap.containsKey(child), Messages.getCommonString("TeamAreaHierarchy.1"));
        this.children(parent).add(child);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding child " + child.toString() + " for parent: " + parent.toString()));
        }
        this.fParentMap.put(child, parent);
        this.children(child);
        this.addPersistedRelationship(parent, child);
    }

    @Override
    public synchronized void addRoot(ITeamAreaHandle root, IDevelopmentLineHandle developmentLine) {
        this.initialize();
        this.check(!this.fParentMap.containsKey(root), Messages.getCommonString("TeamAreaHierarchy.2"));
        if (developmentLine != null) {
            this.assertSameProjectArea(developmentLine);
        }
        this.children(root);
        this.addPersistedRelationship(root, null);
        if (developmentLine != null) {
            TeamAreaHierarchyTag developmentLineRecord = this.findTag(developmentLine);
            if (developmentLineRecord == null) {
                developmentLineRecord = TeamAreaHierarchy.createTeamAreaHierarchyTag();
                developmentLineRecord.setDevelopmentLine(developmentLine);
                this.fProjectAreaImpl.getTeamAreaHierarchyTags().add(developmentLineRecord);
            }
            developmentLineRecord.applyTo(root);
        }
    }

    private TeamAreaHierarchyTag findTag(IDevelopmentLineHandle developmentLine) {
        List tags = this.fProjectAreaImpl.getTeamAreaHierarchyTags();
        for (TeamAreaHierarchyTag tag : tags) {
            if (!tag.getDevelopmentLine().sameItemId((IItemHandle)developmentLine)) continue;
            return tag;
        }
        return null;
    }

    @Override
    public synchronized Set getChildren(ITeamAreaHandle parent) {
        this.initialize();
        this.check(this.fChildrenMap.containsKey(parent), Messages.getCommonString("TeamAreaHierarchy.4"));
        return Collections.unmodifiableSet(new ItemHandleAwareHashSet(this.children(parent)));
    }

    @Override
    public synchronized ITeamAreaHandle getParent(ITeamAreaHandle child) {
        this.initialize();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("In getParent(). Checking whether child " + child.toString() + " exists in fChildrenMap"));
        }
        this.check(this.fChildrenMap.containsKey(child), Messages.getCommonString("TeamAreaHierarchy.5"));
        return (ITeamAreaHandle)this.fParentMap.get(child);
    }

    @Override
    public synchronized Set getRoots() {
        this.initialize();
        ItemHandleAwareHashSet roots = new ItemHandleAwareHashSet();
        for (ITeamAreaHandle handle : this.fChildrenMap.keySet()) {
            if (this.fParentMap.containsKey(handle)) continue;
            roots.add(handle);
        }
        return Collections.unmodifiableSet(new ItemHandleAwareHashSet(roots));
    }

    @Override
    public synchronized void remove(ITeamAreaHandle teamArea) {
        this.initialize();
        this.check(this.fChildrenMap.containsKey(teamArea), Messages.getCommonString("TeamAreaHierarchy.6"));
        this.check(this.children(teamArea).isEmpty(), Messages.getCommonString("TeamAreaHierarchy.7"));
        ITeamAreaHandle parent = this.getParent(teamArea);
        if (parent != null) {
            this.children(parent).remove(teamArea);
            this.fParentMap.remove(teamArea);
            this.removePersistedRelationship(parent, teamArea, true);
        } else {
            TeamAreaHierarchyTag developmentLineRecord = this.getTeamAreaHierarchyTag(teamArea);
            if (developmentLineRecord != null) {
                developmentLineRecord.removeFrom(teamArea);
                if (developmentLineRecord.getRoots().isEmpty()) {
                    this.fProjectAreaImpl.getTeamAreaHierarchyTags().remove(developmentLineRecord);
                }
            }
            this.removePersistedRelationship(teamArea, null, true);
        }
        this.fChildrenMap.remove(teamArea);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Removing key " + teamArea.toString() + " from fChildrenMap"));
        }
    }

    private void initialize() {
        if (this.fChildrenMap == null) {
            this.fChildrenMap = new ItemHandleAwareHashMap();
            this.fParentMap = new ItemHandleAwareHashMap();
            this.initializeMaps();
            if (!this.fImmutable) {
                this.installChangeListener();
            }
        }
    }

    public synchronized void flush() {
        if (!this.fImmutable && this.fChildrenMap != null) {
            this.uninstallChangeListener();
            this.fChildrenMap = null;
            this.fParentMap = null;
        }
    }

    private void initializeMaps() {
        List records = this.fProjectAreaImpl.getTeamAreaHierarchyRecords();
        for (TeamAreaHierarchyRecord record : records) {
            ITeamAreaHandle parent = record.getParent();
            Set children = this.children(parent);
            children.addAll(record.getChildren());
            for (ITeamAreaHandle child : children) {
                this.fParentMap.put(child, parent);
                this.children(child);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Added child " + child.toString() + " for parent: " + parent.toString()));
            }
        }
    }

    private Set children(ITeamAreaHandle parent) {
        Set children = (Set)this.fChildrenMap.get(parent);
        if (children == null) {
            children = new ItemHandleAwareHashSet();
            this.fChildrenMap.put(parent, children);
        }
        return children;
    }

    private void installChangeListener() {
        if (this.fListener == null) {
            this.fListener = new HierarchyRecordsListener(this);
        }
        this.fProjectAreaImpl.eAdapters().add((Object)this.fListener);
    }

    private void uninstallChangeListener() {
        if (this.fListener != null) {
            this.fProjectAreaImpl.eAdapters().remove((Object)this.fListener);
        }
    }

    private void addPersistedRelationship(ITeamAreaHandle parent, ITeamAreaHandle child) {
        this.uninstallChangeListener();
        try {
            List teamAreaHierarchyRecords = this.fProjectAreaImpl.getTeamAreaHierarchyRecords();
            TeamAreaHierarchyRecord record = this.findRecord(teamAreaHierarchyRecords, parent);
            if (record == null) {
                record = ProcessFactory.eINSTANCE.createTeamAreaHierarchyRecord();
                record.setParent(parent);
                teamAreaHierarchyRecords.add(record);
            }
            if (child != null) {
                List children = record.getChildren();
                children.add(child);
            }
        }
        finally {
            this.installChangeListener();
        }
    }

    private TeamAreaHierarchyRecord findRecord(List records, ITeamAreaHandle handle) {
        for (TeamAreaHierarchyRecord record : records) {
            if (!handle.sameItemId((IItemHandle)record.getParent())) continue;
            return record;
        }
        return null;
    }

    private void removePersistedRelationship(ITeamAreaHandle parent, ITeamAreaHandle child, boolean touchChildRecords) {
        this.uninstallChangeListener();
        try {
            List teamAreaHierarchyRecords = this.fProjectAreaImpl.getTeamAreaHierarchyRecords();
            TeamAreaHierarchyRecord record = this.findRecord(teamAreaHierarchyRecords, parent);
            if (child != null) {
                this.removeFromList(record.getChildren(), (IItemHandle)child);
                if (touchChildRecords) {
                    this.removeRecord(teamAreaHierarchyRecords, child);
                }
            } else {
                this.removeRecord(teamAreaHierarchyRecords, parent);
            }
        }
        finally {
            this.installChangeListener();
        }
    }

    @Override
    public synchronized void promoteToRoot(ITeamAreaHandle teamArea) {
        this.initialize();
        IDevelopmentLineHandle inheritedLine = this.getRawDevelopmentLine(teamArea);
        ITeamAreaHandle parent = this.getParent(teamArea);
        this.check(parent != null, Messages.getCommonString("TeamAreaHierarchy.8"));
        this.children(parent).remove(teamArea);
        this.fParentMap.remove(teamArea);
        this.uninstallChangeListener();
        try {
            List teamAreaHierarchyRecords = this.fProjectAreaImpl.getTeamAreaHierarchyRecords();
            TeamAreaHierarchyRecord record = this.findRecord(teamAreaHierarchyRecords, parent);
            this.removeFromList(record.getChildren(), (IItemHandle)teamArea);
        }
        finally {
            this.installChangeListener();
        }
        this.addRoot(teamArea, inheritedLine);
    }

    @Override
    public void setDevelopmentLine(ITeamAreaHandle root, IDevelopmentLineHandle developmentLine) {
        this.initialize();
        ITeamAreaHandle parent = this.getParent(root);
        this.check(parent == null, Messages.getCommonString("TeamAreaHierarchy.9"));
        IDevelopmentLineHandle currentDevLine = this.getRawDevelopmentLine(root);
        if (currentDevLine == null && developmentLine == null || currentDevLine != null && currentDevLine.sameItemId((IItemHandle)developmentLine)) {
            return;
        }
        TeamAreaHierarchyTag currentLineRecord = this.findTag(currentDevLine);
        if (currentLineRecord != null) {
            currentLineRecord.removeFrom(root);
            if (currentLineRecord.getRoots().isEmpty()) {
                this.fProjectAreaImpl.getTeamAreaHierarchyTags().remove(currentLineRecord);
            }
        }
        if (developmentLine != null) {
            TeamAreaHierarchyTag newLineRecord = this.findTag(developmentLine);
            if (newLineRecord == null) {
                newLineRecord = TeamAreaHierarchy.createTeamAreaHierarchyTag();
                newLineRecord.setDevelopmentLine(developmentLine);
                this.fProjectAreaImpl.getTeamAreaHierarchyTags().add(newLineRecord);
            }
            newLineRecord.applyTo(root);
        }
    }

    @Override
    public synchronized void reparent(ITeamAreaHandle newParent, ITeamAreaHandle child) {
        this.initialize();
        this.check(this.fChildrenMap.containsKey(newParent), Messages.getCommonString("TeamAreaHierarchy.10"));
        ITeamAreaHandle parent = (ITeamAreaHandle)this.fParentMap.get(child);
        if (parent != null) {
            this.children(parent).remove(child);
            this.fParentMap.remove(child);
            this.removePersistedRelationship(parent, child, false);
        } else {
            TeamAreaHierarchyTag developmentLineRecord = this.getTeamAreaHierarchyTag(child);
            if (developmentLineRecord != null) {
                developmentLineRecord.removeFrom(child);
                if (developmentLineRecord.getRoots().isEmpty()) {
                    this.fProjectAreaImpl.getTeamAreaHierarchyTags().remove(developmentLineRecord);
                }
            }
        }
        this.addChild(newParent, child);
    }

    @Override
    public IDevelopmentLineHandle getDevelopmentLine(ITeamAreaHandle teamAreaHandle) {
        IDevelopmentLineHandle developmentLine = this.getRawDevelopmentLine(teamAreaHandle);
        if (developmentLine == null) {
            developmentLine = this.fProjectAreaImpl.getProjectDevelopmentLine();
        }
        return developmentLine;
    }

    @Override
    public IDevelopmentLineHandle getRawDevelopmentLine(ITeamAreaHandle teamAreaHandle) {
        ITeamAreaHandle parentTeamAreaHandle = this.getParent(teamAreaHandle);
        if (parentTeamAreaHandle != null) {
            return this.getRawDevelopmentLine(parentTeamAreaHandle);
        }
        TeamAreaHierarchyTag teamAreaTag = null;
        Iterator iter = this.fProjectAreaImpl.getTeamAreaHierarchyTags().iterator();
        block0: while (iter.hasNext() && teamAreaTag == null) {
            TeamAreaHierarchyTag tag = (TeamAreaHierarchyTag)iter.next();
            for (ITeamAreaHandle handle : tag.getRoots()) {
                if (!handle.sameItemId((IItemHandle)teamAreaHandle)) continue;
                teamAreaTag = tag;
                continue block0;
            }
        }
        if (teamAreaTag != null) {
            return teamAreaTag.getDevelopmentLine();
        }
        return null;
    }

    public static TeamAreaHierarchyTag createTeamAreaHierarchyTag() {
        return ProcessPackage.eINSTANCE.getProcessFactory().createTeamAreaHierarchyTag();
    }

    private TeamAreaHierarchyTag getTeamAreaHierarchyTag(ITeamAreaHandle teamAreaHandle) {
        ITeamAreaHierarchy hierarchy = this.fProjectAreaImpl.getTeamAreaHierarchy();
        ITeamAreaHandle parentTeamAreaHandle = hierarchy.getParent(teamAreaHandle);
        if (parentTeamAreaHandle != null) {
            return this.getTeamAreaHierarchyTag(parentTeamAreaHandle);
        }
        TeamAreaHierarchyTag teamAreaTag = null;
        Iterator iter = this.fProjectAreaImpl.getTeamAreaHierarchyTags().iterator();
        block0: while (iter.hasNext() && teamAreaTag == null) {
            TeamAreaHierarchyTag tag = (TeamAreaHierarchyTag)iter.next();
            for (ITeamAreaHandle handle : tag.getRoots()) {
                if (!handle.sameItemId((IItemHandle)teamAreaHandle)) continue;
                teamAreaTag = tag;
                continue block0;
            }
        }
        return teamAreaTag;
    }

    private void removeFromList(List list, IItemHandle element) {
        Iterator e = list.iterator();
        while (e.hasNext()) {
            IItemHandle handle = (IItemHandle)e.next();
            if (!handle.sameItemId(element)) continue;
            e.remove();
        }
    }

    private void removeRecord(List records, ITeamAreaHandle element) {
        Iterator e = records.iterator();
        while (e.hasNext()) {
            TeamAreaHierarchyRecord record = (TeamAreaHierarchyRecord)e.next();
            if (!element.sameItemId((IItemHandle)record.getParent())) continue;
            e.remove();
        }
    }

    private void check(boolean value, String message) {
        if (!value) {
            throw new TeamAreaHierarchyException(message);
        }
    }

    private void assertSameProjectArea(IDevelopmentLineHandle line) {
        IDevelopmentLineHandle[] lineHandles = this.fProjectAreaImpl.getDevelopmentLines();
        int i = 0;
        while (i < lineHandles.length) {
            if (lineHandles[i].sameItemId((IItemHandle)line)) {
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException(Messages.getCommonString("TeamAreaHierarchy.12"));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator e = this.getRoots().iterator();
        while (e.hasNext()) {
            this.print(buffer, (ITeamAreaHandle)e.next(), 0);
        }
        return buffer.toString();
    }

    private void print(StringBuffer buffer, ITeamAreaHandle teamArea, int indentation) {
        int i = 0;
        while (i < indentation) {
            buffer.append('\t');
            ++i;
        }
        buffer.append(teamArea.toString());
        buffer.append('\n');
        try {
            Set children = this.getChildren(teamArea);
            Iterator e = children.iterator();
            while (e.hasNext()) {
                this.print(buffer, (ITeamAreaHandle)e.next(), indentation + 1);
            }
        }
        catch (TeamAreaHierarchyException teamAreaHierarchyException) {
            // empty catch block
        }
    }
}

