/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.internal.common.util.CacheKey;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SoftReferenceCache<K extends CacheKey, V> {
    public static final int CAPACITY_ALLAVAILABLE = -1;
    public static final int CAPACITY_TECHNICALMAXIMUM = 0x40000000;
    private InternalMap<K, SoftReference<V>> internal;
    public static final int MAXIMUMCAPACITY = 1000;
    public static final int INITIALCAPACITY = 10;
    private static final float LOADFACTOR = 0.75f;
    private static final int CONCURRENCYLEVEL = 2;
    private static final boolean ORDER = true;
    int capacity;

    public SoftReferenceCache() {
        this.internal = new InternalConcurrentHashMap(10, 0.75f, 2);
    }

    public SoftReferenceCache(int maximumCapacity) {
        this.internal = new InternalLinkedHashMap(maximumCapacity < 0 ? 0 : maximumCapacity, 10, 0.75f, true);
    }

    public SoftReferenceCache(int maximumCapacity, int initialCapacity) {
        this.internal = new InternalLinkedHashMap(maximumCapacity < 0 ? 0 : maximumCapacity, initialCapacity < 0 ? 0 : initialCapacity, 0.75f, true);
    }

    public synchronized V remove(K key) {
        SoftReference internalValue = (SoftReference)this.internal.remove(key);
        if (internalValue == null) {
            return null;
        }
        Object value = internalValue.get();
        return (V)value;
    }

    public synchronized V getValue(K key) {
        SoftReference internalValue = (SoftReference)this.internal.get(key);
        if (internalValue == null) {
            return null;
        }
        Object value = internalValue.get();
        if (value == null) {
            this.internal.remove(key);
            return null;
        }
        return (V)value;
    }

    public synchronized void setValue(K key, V value) {
        this.setValueAndGetReference(key, value);
    }

    protected synchronized SoftReference<V> setValueAndGetReference(K key, V value) {
        if (key == null || value == null) {
            return null;
        }
        SoftReference<V> internalValue = new SoftReference<V>(value);
        this.internal.put(key, internalValue);
        return internalValue;
    }

    public int size() {
        return this.internal.size();
    }

    public int capacity() {
        return this.internal.storageCapacity();
    }

    public boolean isCapacitySet() {
        return this.internal.storageCapacity() != -1;
    }

    protected Set<K> keySet() {
        return this.internal.keySet();
    }

    private class InternalConcurrentHashMap
    extends ConcurrentHashMap<K, SoftReference<V>>
    implements InternalMap<K, SoftReference<V>> {
        private static final long serialVersionUID = 1L;
        int internal_capacity;

        public InternalConcurrentHashMap(int initialCapacity, float loadfactor, int concurrencyLevel) {
            super(initialCapacity, loadfactor, concurrencyLevel);
            this.internal_capacity = -1;
        }

        @Override
        public int storageCapacity() {
            return this.internal_capacity;
        }
    }

    private class InternalLinkedHashMap
    extends LinkedHashMap<K, SoftReference<V>>
    implements InternalMap<K, SoftReference<V>> {
        private static final long serialVersionUID = 1L;
        int internal_capacity;

        public InternalLinkedHashMap(int maximumCapacity, int initialCapacity, float loadfactor, boolean order) {
            super(initialCapacity, loadfactor, order);
            this.internal_capacity = maximumCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.internal_capacity || eldest.getValue() == null || ((SoftReference)eldest.getValue()).get() == null;
        }

        @Override
        public int storageCapacity() {
            return this.internal_capacity;
        }
    }

    private static interface InternalMap<S, T>
    extends Map<S, T> {
        public int storageCapacity();
    }
}

