/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IIterationTypeHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.ITeamData;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.ProcessProviderCacheItem;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.enterprise.IProcessProvider;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.ProcessExporter;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProjectAreaRuntimeReportExporter
extends ProcessExporter {
    private static final String FILE_INDEX_HTML = "index.html";
    private static final String FILE_PROJECT_AREA = "projectarea.html";
    private static final String FILE_SPECIFICATION = "specification.xml";
    private static final String FILE_MERGED_SPECIFICATION = "merged-specification.xml";
    private static final String FILE_CUSTOMIZATION = "customization.xml";
    private static final String FILE_README_TXT = "readme.txt";
    private static final String DIR_DATA = "data";
    private static final String DIR_PROVIDER = "provider";
    private static final String ICON_PROJECTAREA = "projectarea_obj.gif";
    private static final String ICON_PROCESSPROVIDER = "processprovider_obj.gif";
    private static final String ICON_ITERATION_CURRENT = "current_phase_co.gif";
    private static final String ICON_ITERATION = "milestone_obj.gif";
    private static final String ICON_TIMELINE = "develop_line_obj.gif";
    private static final String ICON_TEAMAREA_CONFIGURED = "teamarea_ps_obj.gif";
    private static final String ICON_TEAMAREA = "teamarea_obj.gif";
    private final IProjectAreaSetupExportContext fContext;
    private IProjectArea fProjectArea;
    private ItemHandleAwareHashMap fProcessAreaNumberMap = new ItemHandleAwareHashMap();

    public ProjectAreaRuntimeReportExporter(IProjectArea projectArea, IProjectAreaSetupExportContext context) {
        this.fProjectArea = projectArea;
        this.fContext = context;
    }

    @Override
    public ProcessExporter.IProcessExportContext getContext() {
        return this.fContext;
    }

    public void exportProjectAreaToArchive(File exportDirectory, File archivePath, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        this.exportProjectAreaToDirectory(exportDirectory.toString(), monitor);
        ProjectAreaRuntimeReportExporter.createZip(exportDirectory, archivePath);
    }

    public void exportProjectAreaToDirectory(String directoryPath, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1000);
        File baseDir = new File(directoryPath);
        if (!baseDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.0"), directoryPath));
        }
        if (!baseDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.1"), directoryPath));
        }
        ArrayList<IProjectArea> processAreaHandles = new ArrayList<IProjectArea>(this.fProjectArea.getTeamAreaHierarchy().getTeamAreas());
        processAreaHandles.add(this.fProjectArea);
        List processAreas = this.fContext.fetchCompleteItems(processAreaHandles, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        int index = 0;
        for (IProcessArea area : processAreas) {
            this.fProcessAreaNumberMap.put(area, (Object)index++);
        }
        this.fProjectArea = (IProjectArea)processAreas.remove(processAreas.size() - 1);
        IProcessProvider processProvider = null;
        IProcessContainerHandle providerHandle = ((ProjectArea)this.fProjectArea).getProcessProvider();
        if (providerHandle == null) {
            providerHandle = ((ProjectArea)this.fProjectArea).getRemoteProcessProvider();
        }
        if (providerHandle != null) {
            ArrayList<IProjectAreaHandle> handleList = new ArrayList<IProjectAreaHandle>();
            handleList.add((IProjectAreaHandle)providerHandle);
            List completeItems = this.fContext.fetchCompleteItems(handleList, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            processProvider = (IProcessProvider)completeItems.get(0);
        }
        IProcessItem[] iterationItems = this.fContext.fetchCompleteIterationStructure(this.fProjectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        this.createRootIndex(baseDir);
        this.createReadMe(baseDir);
        File fileDir = this.createDirectory(baseDir, DIR_DATA);
        this.createNavigation(fileDir, processAreas, processProvider);
        if (processProvider != null) {
            File subDir = this.createDirectory(fileDir, DIR_PROVIDER);
            this.createProcessProviderPage(processProvider, subDir, this.fContext, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        this.createProjectAreaPage(fileDir, iterationItems, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
        this.createTeamAreaPages(hierarchy.getRoots(), hierarchy, fileDir, processAreas, iterationItems, (IProgressMonitor)new SubProgressMonitor(monitor, 700));
        monitor.done();
    }

    private void createReadMe(File baseDir) throws IOException {
        String readMe = Messages.getCommonString("ProjectAreaRuntimeReportExporter.2");
        this.writeStringToFile(baseDir, FILE_README_TXT, readMe);
    }

    protected void createRootIndex(File baseDir) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><head><title>");
        String projectName = this.fProjectArea.getName();
        buffer.append(this.escapeHtml(projectName)).append("</title>");
        buffer.append("<frameset cols=\"25%,75%\"><frame src=\"data/leftNav.html\"><frame src=\"").append(DIR_DATA).append('/').append(FILE_PROJECT_AREA).append("\" name=\"contentframe\"></frameset>");
        buffer.append("</html>");
        this.writeStringToFile(baseDir, FILE_INDEX_HTML, buffer.toString());
    }

    protected void createNavigation(File baseDir, List processAreas, IProcessProvider processProvider) throws IOException, TeamRepositoryException {
        ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
        StringBuffer buffer = new StringBuffer();
        String name = this.fProjectArea.getName();
        buffer.append("<ul><li><a href=\"").append(FILE_PROJECT_AREA).append("\" target=\"contentframe\">");
        buffer.append("<img src=\"").append(ICON_PROJECTAREA).append("\" border=\"0\"> ").append(this.escapeHtml(name)).append("</a>");
        if (processProvider != null) {
            buffer.append("<ul><li><a href=\"").append(DIR_PROVIDER).append("/").append(FILE_PROJECT_AREA).append("\" target=\"contentframe\">");
            buffer.append("<img src=\"").append(ICON_PROCESSPROVIDER).append("\" border=\"0\"> ").append(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.36"), this.escapeHtml(processProvider.getName()))).append("</a>");
            buffer.append("</li></ul>");
        }
        this.appendTeamAreasToNavigation(hierarchy.getRoots(), hierarchy, processAreas, buffer, (IPath)new Path(""));
        buffer.append("</li></ul>");
        this.writeStringToFile(baseDir, "leftNav.html", buffer.toString());
        this.writeFileFromPlugin(baseDir, ICON_PROJECTAREA, "icons/obj16/projectarea_obj.gif");
        this.writeFileFromPlugin(baseDir, ICON_PROCESSPROVIDER, "icons/obj16/processprovider_obj.gif");
        this.writeFileFromPlugin(baseDir, ICON_TEAMAREA, "icons/obj16/teamarea_obj.gif");
        this.writeFileFromPlugin(baseDir, ICON_TEAMAREA_CONFIGURED, "icons/obj16/teamarea_ps_obj.gif");
        this.writeFileFromPlugin(baseDir, ICON_TIMELINE, "icons/obj16/develop_line_obj.gif");
        this.writeFileFromPlugin(baseDir, ICON_ITERATION, "icons/obj16/milestone_obj.gif");
        this.writeFileFromPlugin(baseDir, ICON_ITERATION_CURRENT, "icons/obj16/current_phase_co.gif");
    }

    private File writeFileFromPlugin(File baseDir, String fileName, String filePath) throws TeamRepositoryException, IOException {
        File outputFile = null;
        URL fileURL = FileLocator.find((String)"com.ibm.team.process.common", (IPath)new Path(filePath));
        if (fileURL == null) {
            throw new TeamRepositoryException((Object)Messages.getCommonString("ProjectAreaRuntimeReportExporter.3"), filePath);
        }
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                int b;
                inputStream = fileURL.openStream();
                outputFile = this.createFile(baseDir, fileName);
                outputStream = new FileOutputStream(outputFile);
                while ((b = inputStream.read()) > -1) {
                    outputStream.write(b);
                }
                outputStream.flush();
            }
            catch (UnsupportedEncodingException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        return outputFile;
    }

    private void appendTeamAreasToNavigation(Set teamAreaHandles, ITeamAreaHierarchy hierarchy, List processAreas, StringBuffer buffer, IPath parentPath) {
        TreeSet<ITeamArea> teamAreas = new TreeSet<ITeamArea>(new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((ITeamArea)obj1).getName().compareTo(((ITeamArea)obj2).getName());
            }
        });
        Iterator iterator = teamAreaHandles.iterator();
        while (iterator.hasNext()) {
            ITeamArea teamArea = (ITeamArea)this.findItem((IItemHandle)((ITeamAreaHandle)iterator.next()), processAreas);
            if (teamArea == null) continue;
            teamAreas.add(teamArea);
        }
        buffer.append("<ul>");
        for (ITeamArea teamArea : teamAreas) {
            Integer number = (Integer)this.fProcessAreaNumberMap.get(teamArea);
            String name = teamArea.getName();
            buffer.append("<li>");
            buffer.append("<a href=\"");
            IPath path = parentPath.append(number.toString());
            buffer.append(path.append(FILE_INDEX_HTML));
            buffer.append("\" target=\"contentframe\">");
            if (this.affectsRuntime(teamArea)) {
                buffer.append("<img src=\"").append(ICON_TEAMAREA_CONFIGURED).append("\" border=\"0\"> ");
            } else {
                buffer.append("<img src=\"").append(ICON_TEAMAREA).append("\" border=\"0\"> ");
            }
            buffer.append(this.escapeHtml(name)).append("</a>");
            this.appendTeamAreasToNavigation(hierarchy.getChildren(teamArea), hierarchy, processAreas, buffer, path);
            buffer.append("</li>");
        }
        buffer.append("</ul>");
    }

    private boolean affectsRuntime(ITeamArea teamArea) {
        if (teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml") != null) {
            return true;
        }
        ITeamData teamData = teamArea.getTeamData();
        IContributorHandle[] members = teamArea.getMembers();
        int i = 0;
        while (i < members.length) {
            if (teamData.getContributorData(members[i], "roles") != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createProcessProviderPage(IProcessProvider processProvider, File baseDir, IProjectAreaSetupExportContext context, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        monitor.beginTask(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.4"), processProvider.getName()), 1000);
        StringBuffer buffer = new StringBuffer();
        String name = processProvider.getName();
        buffer.append("<html><head><style type=\"text/css\">html {overflow-x:auto}</style></head><body style=\"fontfamily: arial, helvetica, sans-serif\">");
        buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.37")).append(" </b>").append(this.escapeHtml(name));
        if (processProvider instanceof ProcessProviderCacheItem) {
            String server = context.getRemoteServerTitle((ProcessProviderCacheItem)processProvider, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            buffer.append("<br>").append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.38")).append(" </b>").append(this.escapeHtml(server));
        }
        buffer.append("<br><br>");
        this.appendSpecification(processProvider, baseDir, buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        buffer.append("<br><br>");
        if (processProvider instanceof IProjectArea) {
            this.appendRoleAssignments((IProjectArea)((Object)processProvider), buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            buffer.append("<br><br>");
            this.appendAdministrators((IProjectArea)((Object)processProvider), buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            buffer.append("<br><br>");
        }
        buffer.append("</body></html>");
        this.writeStringToFile(baseDir, FILE_PROJECT_AREA, buffer.toString());
        monitor.done();
    }

    private void createProjectAreaPage(File baseDir, IProcessItem[] iterationItems, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        monitor.beginTask(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.4"), this.fProjectArea.getName()), 1000);
        StringBuffer buffer = new StringBuffer();
        String name = this.fProjectArea.getName();
        buffer.append("<html><head><style type=\"text/css\">html {overflow-x:auto}</style></head><body style=\"fontfamily: arial, helvetica, sans-serif\">");
        buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.5")).append(" </b>").append(this.escapeHtml(name));
        buffer.append("<br><br>");
        this.appendSpecification((IProcessProvider)((Object)this.fProjectArea), baseDir, buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        buffer.append("<br><br>");
        this.appendRoleAssignments(this.fProjectArea, buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        buffer.append("<br><br>");
        this.appendAdministrators(this.fProjectArea, buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        buffer.append("<br><br>");
        this.appendTimelines(this.fProjectArea, iterationItems, buffer, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        buffer.append("<br><br>");
        buffer.append("<i>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.6")).append(new SimpleDateFormat().format(new Date())).append("</i>");
        buffer.append("</body></html>");
        this.writeStringToFile(baseDir, FILE_PROJECT_AREA, buffer.toString());
        monitor.done();
    }

    private void appendSpecification(IProcessProvider projectOrCache, File baseDir, StringBuffer buffer, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        IContent mergedSpec;
        Map data = projectOrCache.getProcessData();
        IContent rawSpec = (IContent)data.get("com.ibm.team.internal.process.40.compiled.xml");
        byte[] rawBytes = null;
        if (rawSpec != null) {
            rawBytes = this.getContext().readContent(rawSpec, monitor);
            this.writeFile(baseDir, FILE_SPECIFICATION, rawBytes);
            buffer.append("<a href=\"").append(FILE_SPECIFICATION).append("\">").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.7")).append("</a>");
        }
        if ((mergedSpec = (IContent)data.get("com.ibm.team.internal.process.compiled.xml")) != null) {
            byte[] mergedBytes = this.getContext().readContent(mergedSpec, monitor);
            if (rawBytes == null || !Arrays.equals(rawBytes, mergedBytes)) {
                this.writeFile(baseDir, FILE_MERGED_SPECIFICATION, mergedBytes);
                buffer.append("<br><a href=\"").append(FILE_MERGED_SPECIFICATION).append("\">").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.39")).append("</a>");
            }
        }
    }

    private void appendTimelines(IProjectArea projectArea, IProcessItem[] iterationItems, StringBuffer buffer, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLineHandle[] lineHandles = projectArea.getDevelopmentLines();
        buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.8")).append(" </b>");
        if (lineHandles.length > 0) {
            IDevelopmentLineHandle projectTimeline = projectArea.getProjectDevelopmentLine();
            int i = 0;
            while (i < lineHandles.length) {
                IDevelopmentLine line = (IDevelopmentLine)this.findItem((IItemHandle)lineHandles[i], (IItem[])iterationItems);
                if (line != null) {
                    buffer.append("<table width=\"100%\" border=\"1\"><tr><td>");
                    buffer.append("<img src=\"").append(ICON_TIMELINE).append("\"><b> ");
                    String name = line.getName();
                    String timelineString = name != null && name.length() > 0 ? (line.sameItemId((IItemHandle)projectTimeline) ? NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.9"), line.getId(), name) : NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.10"), line.getId(), name)) : (line.sameItemId((IItemHandle)projectTimeline) ? NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.11"), line.getId()) : NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.12"), line.getId()));
                    buffer.append(this.escapeHtml(timelineString));
                    buffer.append("</b></td></tr><tr><td>");
                    IIteration[] currentIterations = this.fContext.getCurrentIterations(line, monitor);
                    this.appendIterations(line.getIterations(), currentIterations, iterationItems, buffer);
                    buffer.append("</td></tr></table><br>");
                }
                ++i;
            }
        } else {
            buffer.append("&lt;").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.13")).append("&gt;");
        }
    }

    private void appendIterations(IIterationHandle[] iterations, IIteration[] currentIterations, IProcessItem[] iterationItems, StringBuffer buffer) {
        if (iterations.length > 0) {
            buffer.append("<ul>");
            int i = 0;
            while (i < iterations.length) {
                IIteration iteration = (IIteration)this.findItem((IItemHandle)iterations[i], (IItem[])iterationItems);
                if (iteration != null) {
                    String name;
                    boolean isCurrent;
                    buffer.append("<li>");
                    boolean bl = isCurrent = this.findItem((IItemHandle)iteration, (IItem[])currentIterations) != null;
                    if (isCurrent) {
                        buffer.append("<img src=\"").append(ICON_ITERATION_CURRENT).append("\"> ");
                    }
                    IIterationType type = null;
                    IIterationTypeHandle typeHandle = iteration.getIterationType();
                    if (typeHandle != null) {
                        type = (IIterationType)this.findItem((IItemHandle)typeHandle, (IItem[])iterationItems);
                    }
                    if ((name = iteration.getName()) != null && name.length() > 0) {
                        if (type != null) {
                            if (isCurrent) {
                                buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.14"), new Object[]{iteration.getId(), name, type.getId()})));
                            } else {
                                buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.15"), new Object[]{iteration.getId(), name, type.getId()})));
                            }
                        } else if (isCurrent) {
                            buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.16"), new Object[]{iteration.getId(), name})));
                        } else {
                            buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.17"), new Object[]{iteration.getId(), name})));
                        }
                    } else if (type != null) {
                        if (isCurrent) {
                            buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.18"), new Object[]{iteration.getId(), type.getId()})));
                        } else {
                            buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.19"), new Object[]{iteration.getId(), type.getId()})));
                        }
                    } else if (isCurrent) {
                        buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.20"), new Object[]{iteration.getId()})));
                    } else {
                        buffer.append(this.escapeHtml(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.21"), new Object[]{iteration.getId()})));
                    }
                    this.appendIterations(iteration.getChildren(), currentIterations, iterationItems, buffer);
                    buffer.append("</li>");
                }
                ++i;
            }
            buffer.append("</ul>");
        }
    }

    private void appendRoleAssignments(IProcessArea processArea, StringBuffer buffer, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        monitor.beginTask("", 1000);
        IContributorHandle[] contributorHandles = processArea.getMembers();
        buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.22")).append(" </b>");
        if (contributorHandles.length > 0) {
            Collection contributors = this.fContext.fetchCompleteItems(Arrays.asList(contributorHandles), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            contributors = this.sortContributors(contributors);
            buffer.append("<br><table width=\"100%\" border=\"1\"><tr><td><b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.23")).append("</b></td><td><b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.24")).append("</b></td><td><b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.25")).append("</b></td></tr>");
            IRole[] roles = this.fContext.getAvailableRoles(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            for (IContributor contributor : contributors) {
                buffer.append("<tr><td>").append(this.escapeHtml(contributor.getName())).append("</td><td>");
                buffer.append(this.escapeHtml(contributor.getUserId())).append("</td><td>");
                IRole[] assignedRoles = processArea.getRoleAssignments((IContributorHandle)contributor, roles);
                if (assignedRoles.length > 0) {
                    int i = 0;
                    while (i < assignedRoles.length) {
                        buffer.append(this.escapeHtml(assignedRoles[i].getId()));
                        if (i < assignedRoles.length - 1) {
                            buffer.append(", ");
                        }
                        ++i;
                    }
                } else {
                    buffer.append("&nbsp;");
                }
                buffer.append("</td></tr>");
            }
            buffer.append("</table>");
        } else {
            buffer.append("&lt;").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.26")).append("&gt;");
        }
        monitor.done();
    }

    private Set sortContributors(Collection contributors) {
        final Collator collator = CollatorCache.getInstance((Locale)this.fContext.getLocale());
        TreeSet sortedSet = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return collator.compare(((IContributor)o1).getName(), ((IContributor)o2).getName());
            }
        });
        sortedSet.addAll(contributors);
        return sortedSet;
    }

    private void appendAdministrators(IProcessArea processArea, StringBuffer buffer, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IContributorHandle[] contributorHandles = processArea.getAdministrators();
        buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.27")).append(" </b>");
        if (contributorHandles.length > 0) {
            Collection contributors = this.fContext.fetchCompleteItems(Arrays.asList(contributorHandles), monitor);
            contributors = this.sortContributors(contributors);
            buffer.append("<br><table width=\"100%\" border=\"1\"><tr><td><b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.28")).append("</b></td><td><b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.29")).append("</b></td></tr>");
            for (IContributor contributor : contributors) {
                buffer.append("<tr><td>").append(this.escapeHtml(contributor.getName())).append("</td><td>");
                buffer.append(this.escapeHtml(contributor.getUserId())).append("</td></tr>");
            }
            buffer.append("</table>");
        } else {
            buffer.append("&lt;").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.30")).append("&gt;");
        }
    }

    private void createTeamAreaPages(Set teamAreaHandles, ITeamAreaHierarchy hierarchy, File parentDir, List processAreas, IProcessItem[] iterationItems, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        monitor.beginTask("", 1000 * teamAreaHandles.size());
        Iterator iterator = teamAreaHandles.iterator();
        while (iterator.hasNext()) {
            ITeamArea teamArea = (ITeamArea)this.findItem((IItemHandle)((ITeamAreaHandle)iterator.next()), processAreas);
            if (teamArea == null) continue;
            SubProgressMonitor teamMonitor = new SubProgressMonitor(monitor, 1000);
            teamMonitor.beginTask(NLS.bind(Messages.getCommonString("ProjectAreaRuntimeReportExporter.31"), teamArea.getName()), 1000);
            StringBuffer buffer = new StringBuffer();
            Integer number = (Integer)this.fProcessAreaNumberMap.get(teamArea);
            File areaDir = this.createDirectory(parentDir, number.toString());
            buffer.append("<html><body style=\"fontfamily: arial, helvetica, sans-serif\">");
            String name = teamArea.getName();
            buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.32")).append(" </b>").append(this.escapeHtml(name)).append("<br><br>");
            buffer.append("<b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.33")).append(" </b>");
            IDevelopmentLine line = null;
            IDevelopmentLineHandle lineHandle = hierarchy.getRawDevelopmentLine(teamArea);
            if (lineHandle != null) {
                line = (IDevelopmentLine)this.findItem((IItemHandle)lineHandle, (IItem[])iterationItems);
            }
            if (line != null) {
                buffer.append(this.escapeHtml(line.getId()));
            } else {
                buffer.append("&lt;").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.34")).append("&gt;");
            }
            buffer.append("<br><br>");
            this.appendCustomization(teamArea, areaDir, buffer, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)teamMonitor, 50));
            this.appendRoleAssignments(teamArea, buffer, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)teamMonitor, 50));
            buffer.append("<br><br>");
            this.appendAdministrators(teamArea, buffer, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)teamMonitor, 50));
            buffer.append("<br><br>");
            buffer.append("</body></html>");
            this.writeStringToFile(areaDir, FILE_INDEX_HTML, buffer.toString());
            this.createTeamAreaPages(hierarchy.getChildren(teamArea), hierarchy, areaDir, processAreas, iterationItems, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)teamMonitor, 850));
        }
        monitor.done();
    }

    private void appendCustomization(ITeamArea teamArea, File baseDir, StringBuffer buffer, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        IContent customization = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
        if (customization != null) {
            this.writeFile(baseDir, FILE_CUSTOMIZATION, customization, monitor);
            buffer.append("<a href=\"").append(FILE_CUSTOMIZATION).append("\"><b>").append(Messages.getCommonString("ProjectAreaRuntimeReportExporter.35")).append("</b></a><br><br>");
        }
    }

    private String escapeHtml(String name) {
        name = name.replace("/", "&#47;");
        name = name.replace("\\", "&#92;");
        name = name.replace("<", "&lt;");
        name = name.replace(">", "&gt;");
        name = name.replace("\"", "&quot;");
        name = name.replace(" ", "&nbsp;");
        return name;
    }

    private IItem findItem(IItemHandle handle, IItem[] fullItems) {
        int i = 0;
        while (i < fullItems.length) {
            IItem processItem = fullItems[i];
            if (handle.sameItemId((IItemHandle)processItem)) {
                return processItem;
            }
            ++i;
        }
        return null;
    }

    private IItem findItem(IItemHandle handle, List fullItems) {
        for (IItem processItem : fullItems) {
            if (!handle.sameItemId((IItemHandle)processItem)) continue;
            return processItem;
        }
        return null;
    }

    public static interface IProjectAreaSetupExportContext
    extends ProcessExporter.IProcessExportContext {
        public IProcessItem[] fetchCompleteIterationStructure(IProjectArea var1, IProgressMonitor var2) throws TeamRepositoryException;

        public IRole[] getAvailableRoles(IProcessArea var1, IProgressMonitor var2) throws TeamRepositoryException;

        public IIteration[] getCurrentIterations(IDevelopmentLine var1, IProgressMonitor var2) throws TeamRepositoryException;

        public Locale getLocale();

        public String getRemoteServerTitle(ProcessProviderCacheItem var1, IProgressMonitor var2) throws TeamRepositoryException;
    }
}

