/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.util.CacheKey;
import com.ibm.team.process.internal.common.util.SoftReferenceCache;
import com.ibm.team.repository.common.UUID;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectAreaProjectConfigurationData {
    private static final String NOTHING = "";
    public static Log logger = LogFactory.getLog(ProjectAreaProjectConfigurationData.class);
    private static ProjectConfigurationDataCache internalCache = new ProjectConfigurationDataCache();
    private Map<String, ConfigurationDataElement> configurationDataMap = new ConcurrentHashMap<String, ConfigurationDataElement>(10, 0.75f, 4);
    private static boolean useCache = ProjectAreaProjectConfigurationData.useCaching();

    protected ProjectAreaProjectConfigurationData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectAreaProjectConfigurationData getInstance(IProcessContainerHandle projectArea, IProcessContainerHandle processProvider) {
        if (!useCache) {
            return new ProjectAreaProjectConfigurationData();
        }
        ProjectAreaProjectConfigurationData data = internalCache.getProjectConfigurationData(projectArea, processProvider);
        if (data == null) {
            ProjectConfigurationDataCache projectConfigurationDataCache = internalCache;
            synchronized (projectConfigurationDataCache) {
                data = internalCache.getProjectConfigurationData(projectArea, processProvider);
                if (data == null) {
                    data = new ProjectAreaProjectConfigurationData();
                    internalCache.setProjectConfigurationData(projectArea, processProvider, data);
                }
            }
        }
        return data;
    }

    public ConfigurationDataElement getConfigurationData(String configPointId) {
        ConfigurationDataElement cde = this.configurationDataMap.get(configPointId);
        return cde;
    }

    public void setConfigurationData(String configPointId, ConfigurationDataElement element) {
        this.configurationDataMap.put(configPointId, element == null ? ConfigurationDataElement.NULLREPRESENTATION : element);
    }

    protected static boolean useCaching() {
        Boolean useCacheNow = ProjectAreaProjectConfigurationData.getStaticPropertyBoolean("com.ibm.team.process.ProjectConfigurationData.useCache", null);
        if (useCacheNow != null && !useCacheNow.booleanValue()) {
            System.out.println("com.ibm.team.process.ProjectConfigurationData.useCache used to turn ProjectAreaProjectConfigurationData cache off");
            if (logger.isInfoEnabled()) {
                logger.info((Object)"com.ibm.team.process.ProjectConfigurationData.useCache used to turn ProjectAreaProjectConfigurationData cache off");
            }
        }
        return useCacheNow == null || useCacheNow != false;
    }

    public static Boolean getStaticPropertyBoolean(String property, Boolean defaultValue) {
        String valueString = System.getProperty(property);
        if (valueString != null) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.FALSE;
            }
        }
        return defaultValue;
    }

    public static void logCacheHitOrMiss(ProjectProcessDataCacheKey key, ProjectAreaProjectConfigurationData value, SoftReferenceCache<ProjectProcessDataCacheKey, ProjectAreaProjectConfigurationData> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            if (value == null) {
                sb.append("cache miss ProjectAreaProjectConfigurationData key=").append(key);
            } else {
                sb.append("cache hit ProjectAreaProjectConfigurationData key=").append(key);
            }
            Set<ProjectProcessDataCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append(" keys.");
            logger.debug((Object)sb.toString());
        }
    }

    public static void logCacheAdd(ProjectProcessDataCacheKey key, SoftReferenceCache<ProjectProcessDataCacheKey, ProjectAreaProjectConfigurationData> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("cache add ProjectAreaProjectConfigurationData key=").append(key);
            Set<ProjectProcessDataCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append("keys.");
            logger.debug((Object)sb.toString());
        }
    }

    private static class ProjectConfigurationDataCache
    extends SoftReferenceCache<ProjectProcessDataCacheKey, ProjectAreaProjectConfigurationData> {
        public synchronized ProjectAreaProjectConfigurationData getProjectConfigurationData(IProcessContainerHandle projectArea, IProcessContainerHandle processProvider) {
            if (projectArea == null && processProvider == null) {
                return null;
            }
            ProjectProcessDataCacheKey key = new ProjectProcessDataCacheKey(projectArea, processProvider);
            ProjectAreaProjectConfigurationData data = (ProjectAreaProjectConfigurationData)this.getValue(key);
            return data;
        }

        public synchronized void setProjectConfigurationData(IProcessContainerHandle projectArea, IProcessContainerHandle processProvider, ProjectAreaProjectConfigurationData data) {
            if (data == null) {
                return;
            }
            ProjectProcessDataCacheKey key = new ProjectProcessDataCacheKey(projectArea, processProvider);
            this.setValue(key, data);
        }
    }

    protected static class ProjectProcessDataCacheKey
    extends CacheKey {
        UUID projectAreaKey;
        UUID processProviderKey;
        UUID projectAreaStateKey;
        UUID processProviderStateKey;

        public ProjectProcessDataCacheKey(UUID projectAreaUuid, UUID processProviderUuid, UUID projectAreaStateUuid, UUID processProviderStateUuid) {
            super(projectAreaUuid, processProviderUuid, projectAreaStateUuid, processProviderStateUuid);
            this.projectAreaKey = projectAreaUuid;
            this.processProviderKey = processProviderUuid;
            this.projectAreaStateKey = projectAreaStateUuid;
            this.processProviderStateKey = processProviderStateUuid;
        }

        public ProjectProcessDataCacheKey(IProcessContainerHandle projectArea, IProcessContainerHandle processProvider) {
            super(new Object[0]);
            if (projectArea == null) {
                this.projectAreaKey = null;
                this.projectAreaStateKey = null;
            } else {
                this.projectAreaKey = projectArea.getItemId();
                this.projectAreaStateKey = projectArea.getStateId();
            }
            if (processProvider == null) {
                this.processProviderKey = null;
                this.processProviderStateKey = null;
            } else {
                this.processProviderKey = processProvider.getItemId();
                this.processProviderStateKey = processProvider.getStateId();
            }
            this.hashCode = ProjectProcessDataCacheKey.makeCacheHashCode(new Object[]{this.projectAreaKey, this.processProviderKey, this.projectAreaStateKey, this.processProviderStateKey});
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ProjectProcessDataCacheKey) {
                ProjectProcessDataCacheKey key = (ProjectProcessDataCacheKey)obj;
                return (this.projectAreaKey == null && key.projectAreaKey == null || this.projectAreaKey != null && this.projectAreaKey.equals((Object)key.projectAreaKey)) && (this.projectAreaStateKey == null && key.projectAreaStateKey == null || this.projectAreaStateKey != null && this.projectAreaStateKey.equals((Object)key.projectAreaStateKey)) && (this.processProviderKey == null && key.processProviderKey == null || this.processProviderKey != null && this.processProviderKey.equals((Object)key.processProviderKey)) && (this.processProviderStateKey == null && key.processProviderStateKey == null || this.processProviderStateKey != null && this.processProviderStateKey.equals((Object)key.processProviderStateKey));
            }
            return false;
        }

        public String toString() {
            return "ContainersKey{ project[" + (this.projectAreaKey == null ? ProjectAreaProjectConfigurationData.NOTHING : this.projectAreaKey.toString()) + " , " + (this.projectAreaStateKey == null ? ProjectAreaProjectConfigurationData.NOTHING : this.projectAreaStateKey.toString()) + "] , provider[" + (this.processProviderKey == null ? ProjectAreaProjectConfigurationData.NOTHING : this.processProviderKey.toString()) + " , " + (this.processProviderStateKey == null ? ProjectAreaProjectConfigurationData.NOTHING : this.processProviderStateKey.toString()) + "] }";
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.projectAreaKey == null ? 0 : this.projectAreaKey.hashCode();
                this.hashCode = 31 * this.hashCode + (this.projectAreaStateKey == null ? 0 : this.projectAreaStateKey.hashCode());
                this.hashCode = 31 * this.hashCode + (this.processProviderKey == null ? 0 : this.processProviderKey.hashCode());
                this.hashCode = 31 * this.hashCode + (this.processProviderStateKey == null ? 0 : this.processProviderStateKey.hashCode());
            }
            return this.hashCode;
        }
    }
}

