/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IAddition;
import com.ibm.team.process.common.IRemoveAttribute;
import com.ibm.team.process.common.ISetAttribute;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.AddElement;
import com.ibm.team.process.internal.common.model.specification.AdditionElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataDeltaElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.ModifyElement;
import com.ibm.team.process.internal.common.model.specification.PathElement;
import com.ibm.team.process.internal.common.util.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProcessDelta {
    private String fDeltaID;
    private ConfigurationDataElement fConfigData;
    private ConfigurationDataElement fMergedConfigData;
    private List<IStatus> fProblems = new ArrayList<IStatus>();
    private Map<AbstractElement, List<AddElementInfo>> fAddMap = new HashMap<AbstractElement, List<AddElementInfo>>();
    private Map<AbstractElement, List<ModifyElement>> fModifyMap = new HashMap<AbstractElement, List<ModifyElement>>();
    private Set<AbstractElement> fRemoveSet = new HashSet<AbstractElement>();
    private static final String REMOVE_ELEMENT_TAG = "remove-element";
    private static final Log log = LogFactory.getLog(ProcessDelta.class);

    public static ConfigurationDataElement computeEffectiveConfigurationData(ConfigurationDataElement providerData, ConfigurationDataDeltaElement providerDelta, ConfigurationDataElement consumerData, ConfigurationDataDeltaElement consumerDelta) {
        IStatus status;
        int n;
        int n2;
        IStatus[] iStatusArray;
        ConfigurationDataElement data = providerData;
        if (data != null && data.isFinal()) {
            data = data.duplicate();
            data.setIsInheritedFromProcessProvider(true);
            return data;
        }
        boolean toBeDuplicated = true;
        boolean inherited = false;
        if (providerDelta != null) {
            toBeDuplicated = false;
            ProcessDelta providerProcessDelta = new ProcessDelta(data, providerDelta);
            data = providerProcessDelta.getMergedConfigurationData();
            iStatusArray = providerProcessDelta.getProblemStatus();
            n2 = iStatusArray.length;
            n = 0;
            while (n < n2) {
                status = iStatusArray[n];
                InternalProcessCommon.log(status);
                ++n;
            }
        }
        if (data != null) {
            inherited = true;
        }
        if (consumerData != null) {
            data = consumerData;
            toBeDuplicated = false;
            inherited = false;
        }
        if (data != null && data.isFinal()) {
            if (toBeDuplicated) {
                data = data.duplicate();
            }
            if (inherited) {
                data.setIsInheritedFromProcessProvider(inherited);
            }
            return data;
        }
        if (consumerDelta != null) {
            toBeDuplicated = false;
            ProcessDelta consumerProcessDelta = new ProcessDelta(data, consumerDelta);
            data = consumerProcessDelta.getMergedConfigurationData();
            iStatusArray = consumerProcessDelta.getProblemStatus();
            n2 = iStatusArray.length;
            n = 0;
            while (n < n2) {
                status = iStatusArray[n];
                InternalProcessCommon.log(status);
                ++n;
            }
        }
        if (data != null) {
            if (toBeDuplicated) {
                data = data.duplicate();
            }
            if (inherited) {
                data.setIsInheritedFromProcessProvider(true);
            }
        }
        return data;
    }

    public ProcessDelta(ConfigurationDataElement configData, ConfigurationDataDeltaElement configDelta) {
        this.fDeltaID = configDelta.getConfigurationDataId();
        if (configData == null) {
            configData = new ConfigurationDataElement(null, null, "configuration-data", null);
            configData.modifyAttribute("id", configDelta.getConfigurationDataId());
        }
        this.fConfigData = configData;
        for (Object deltaObject : configDelta.getChildElements()) {
            AbstractElement delta = (AbstractElement)deltaObject;
            if (delta.getName().equals("add-element") && delta instanceof AddElement) {
                this.processAdd((AddElement)delta);
                continue;
            }
            if (delta.getName().equals("modify-element")) {
                this.processModify((ModifyElement)delta);
                continue;
            }
            if (!delta.getName().equals(REMOVE_ELEMENT_TAG)) continue;
            this.processRemove(delta);
        }
        this.fMergedConfigData = new ConfigurationDataElement(null, configData.getNamespaceURI(), configData.getName(), null);
        String[] stringArray = configData.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            this.fMergedConfigData.modifyAttribute(attributeName, configData.getAttribute(attributeName));
            ++n2;
        }
        this.copyChildrenAndApplyDeltas(configData, this.fMergedConfigData);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Delta config: Merging delta:\n" + configDelta.toXML("", "\n")));
            log.trace((Object)("Delta config: Configuration data after merge:\n" + this.fMergedConfigData.toXML("", "\n")));
        }
    }

    public ConfigurationDataElement getMergedConfigurationData() {
        return this.fMergedConfigData;
    }

    public IStatus[] getProblemStatus() {
        return this.fProblems.toArray(new IStatus[this.fProblems.size()]);
    }

    static boolean nameAndAttributesMatch(AbstractElement model, AbstractElement path) {
        if (!model.getName().equals(path.getName())) {
            return false;
        }
        String[] stringArray = path.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            if (!path.getAttribute(attributeName).equals(model.getAttribute(attributeName))) {
                return false;
            }
            ++n2;
        }
        String pathCData = path.getCharacterData();
        return pathCData == null || pathCData.equals(model.getCharacterData());
    }

    private static AbstractElement shallowMatch(AbstractElement modelParent, AbstractElement pathChild) {
        for (Object childObject : modelParent.getChildElements()) {
            AbstractElement child = (AbstractElement)childObject;
            if (!ProcessDelta.nameAndAttributesMatch(child, pathChild)) continue;
            return child;
        }
        return null;
    }

    private static AbstractElement shallowMatch(AbstractElement modelParent, AbstractElement startSearchingAt, AbstractElement pathChild) {
        if (startSearchingAt == null) {
            return ProcessDelta.shallowMatch(modelParent, pathChild);
        }
        boolean startSearching = false;
        for (Object childObject : modelParent.getChildElements()) {
            AbstractElement child = (AbstractElement)childObject;
            if (startSearching && ProcessDelta.nameAndAttributesMatch(child, pathChild)) {
                return child;
            }
            if (startSearching || !child.equals(startSearchingAt)) continue;
            startSearching = true;
        }
        return null;
    }

    private static AbstractElement deepMatch(AbstractElement model, AbstractElement path) {
        if (path.getChildElements().size() == 0) {
            return model;
        }
        AbstractElement result = null;
        AbstractElement currentModelChild = null;
        for (Object pathChildObject : path.getChildElements()) {
            AbstractElement pathChild = (AbstractElement)pathChildObject;
            do {
                if ((currentModelChild = ProcessDelta.shallowMatch(model, currentModelChild, pathChild)) != null) continue;
                return null;
            } while ((result = ProcessDelta.deepMatch(currentModelChild, pathChild)) == null);
        }
        return result;
    }

    private void processAdd(AddElement addElement) {
        AbstractElement pathReference;
        PathElement pathElement = addElement.getPathElement();
        if (pathElement == null) {
            pathReference = this.fConfigData;
        } else {
            pathReference = ProcessDelta.deepMatch(this.fConfigData, pathElement);
            if (pathReference == null) {
                this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.UnresolvedPath"), (Object)ProcessDelta.pathAsShortString(pathElement), (Object)this.fDeltaID));
                return;
            }
        }
        if (addElement.getAdditions().isEmpty()) {
            this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.NoAddition"), (Object)this.fDeltaID));
        }
        for (IAddition iAddition : addElement.getAdditions()) {
            IAddition.Location location;
            AdditionElement addition = (AdditionElement)iAddition;
            int mergeDepth = addition.getMergeDepth();
            if (mergeDepth == Integer.MIN_VALUE) {
                this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.BadMergeDepth"), (Object)addition.getRawMergeDepth()));
                mergeDepth = 0;
            }
            if ((location = addition.getLocation()) == IAddition.Location.UNKNOWN) {
                this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.BadLocation"), (Object)addition.getRawLocation()));
                location = IAddition.Location.LAST_CHILD;
            }
            AbstractElement parent = pathReference;
            AbstractElement sibling = null;
            if (location == IAddition.Location.BEFORE || location == IAddition.Location.AFTER) {
                if (pathReference.getName().equals("configuration-data")) {
                    this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.ConfigDataSibling"), (Object)addition.getRawLocation()));
                    location = IAddition.Location.LAST_CHILD;
                } else {
                    sibling = pathReference;
                    parent = sibling.getParentElement();
                }
            }
            this.handleMergesWhileAdding(parent, sibling, addition.getChildElements(), mergeDepth, location);
        }
    }

    private void handleMergesWhileAdding(AbstractElement modelParent, AbstractElement sibling, List<AbstractElement> additions, int mergeDepth, IAddition.Location location) {
        if (additions.isEmpty()) {
            return;
        }
        if (mergeDepth == 0) {
            ProcessDelta.addToMap(this.fAddMap, modelParent, new AddElementInfo(sibling, additions, mergeDepth, location));
            return;
        }
        for (AbstractElement addition : additions) {
            AbstractElement mergeInto = ProcessDelta.shallowMatch(modelParent, addition);
            if (mergeInto == null) {
                this.registerAddition(modelParent, new AddElementInfo(sibling, Collections.singletonList(addition), mergeDepth, location));
                continue;
            }
            this.handleMergesWhileAdding(mergeInto, null, addition.getChildElements(), mergeDepth - 1, IAddition.Location.LAST_CHILD);
        }
    }

    private void registerAddition(AbstractElement modelParent, AddElementInfo addition) {
        if (addition.getMergeDepth() == 0) {
            ProcessDelta.addToMap(this.fAddMap, modelParent, addition);
            return;
        }
        List<AddElementInfo> existing = this.fAddMap.get(modelParent);
        if (existing != null) {
            HashSet<AbstractElement> mergedElements = new HashSet<AbstractElement>();
            block0: for (AbstractElement newElement : addition.getNewElements()) {
                boolean wasMerged = false;
                for (AddElementInfo existingAddition : existing) {
                    if (existingAddition.getMergeDepth() == 0) continue;
                    for (AbstractElement existingElement : existingAddition.getNewElements()) {
                        if (!ProcessDelta.nameAndAttributesMatch(newElement, existingElement) || !ProcessDelta.nameAndAttributesMatch(existingElement, newElement)) continue;
                        this.mergeElements(existingElement, newElement, this.minMergeDepth(existingAddition.getMergeDepth() - 1, addition.getMergeDepth() - 1));
                        mergedElements.add(newElement);
                        wasMerged = true;
                        break;
                    }
                    if (wasMerged) continue block0;
                }
            }
            if (mergedElements.size() != addition.getNewElements().size()) {
                if (!mergedElements.isEmpty()) {
                    ArrayList<AbstractElement> remainingNewElements = new ArrayList<AbstractElement>(addition.getNewElements());
                    remainingNewElements.removeAll(mergedElements);
                    addition = new AddElementInfo(addition.getSibling(), remainingNewElements, addition.getMergeDepth(), addition.getLocation());
                }
                ProcessDelta.addToMap(this.fAddMap, modelParent, addition);
            }
        } else {
            ProcessDelta.addToMap(this.fAddMap, modelParent, addition);
        }
    }

    private void mergeElements(AbstractElement mergeInto, AbstractElement copyFrom, int mergeDepth) {
        for (Object childObject : copyFrom.getChildElements()) {
            AbstractElement child = (AbstractElement)childObject;
            mergeInto.addChildElement(child);
            child.setParent(mergeInto);
        }
        Iterator childIterator = mergeInto.getChildElements().iterator();
        while (childIterator.hasNext()) {
            AbstractElement child = (AbstractElement)childIterator.next();
            AbstractElement potentialMatch = ProcessDelta.shallowMatch(mergeInto, child, child);
            if (potentialMatch == null || !ProcessDelta.nameAndAttributesMatch(child, potentialMatch)) continue;
            this.mergeElements(potentialMatch, child, mergeDepth - 1);
            childIterator.remove();
        }
    }

    private void processModify(ModifyElement modifyElement) {
        AbstractElement pathElement = ProcessDelta.getChild(modifyElement, "path");
        if (pathElement == null) {
            this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.NoPath"), (Object)"modify-element", (Object)this.fDeltaID));
            return;
        }
        AbstractElement toBeModified = ProcessDelta.deepMatch(this.fConfigData, pathElement);
        if (toBeModified == null) {
            this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.UnresolvedPath"), (Object)ProcessDelta.pathAsShortString(pathElement), (Object)this.fDeltaID));
            return;
        }
        ProcessDelta.addToMap(this.fModifyMap, toBeModified, modifyElement);
    }

    private void processRemove(AbstractElement removeElement) {
        AbstractElement pathElement = ProcessDelta.getChild(removeElement, "path");
        if (pathElement == null) {
            this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.NoPath"), (Object)REMOVE_ELEMENT_TAG, (Object)this.fDeltaID));
            return;
        }
        AbstractElement toBeRemoved = ProcessDelta.deepMatch(this.fConfigData, pathElement);
        if (toBeRemoved == null) {
            this.foundError(NLS.bind((String)Messages.getCommonString("ProcessDelta.UnresolvedPath"), (Object)ProcessDelta.pathAsShortString(pathElement), (Object)this.fDeltaID));
            return;
        }
        this.fRemoveSet.add(toBeRemoved);
    }

    private void copyChildrenAndApplyDeltas(AbstractElement source, AbstractElement target) {
        List<AddElementInfo> additions = this.fAddMap.get(source);
        if (additions == null) {
            additions = Collections.emptyList();
        }
        for (AddElementInfo addition : additions) {
            if (addition.getLocation() != IAddition.Location.FIRST_CHILD) continue;
            this.applyAddition(target, addition);
        }
        for (AddElementInfo childObject : source.getChildElements()) {
            AbstractElement child = (AbstractElement)((Object)childObject);
            for (AddElementInfo addition : additions) {
                if (!child.equals(addition.getSibling()) || addition.getLocation() != IAddition.Location.BEFORE) continue;
                this.applyAddition(target, addition);
            }
            if (!this.fRemoveSet.contains(child)) {
                this.copyElementAndApplyDeltas(target, child);
            }
            for (AddElementInfo addition : additions) {
                if (!child.equals(addition.getSibling()) || addition.getLocation() != IAddition.Location.AFTER) continue;
                this.applyAddition(target, addition);
            }
        }
        for (AddElementInfo addition : additions) {
            if (addition.getLocation() != IAddition.Location.LAST_CHILD) continue;
            this.applyAddition(target, addition);
        }
    }

    private void applyAddition(AbstractElement parent, AddElementInfo addition) {
        for (AbstractElement newElement : addition.getNewElements()) {
            this.copyElementAndApplyDeltas(parent, newElement);
        }
    }

    private void copyElementAndApplyDeltas(AbstractElement parent, AbstractElement source) {
        ProcessConfigurationElement createdElement = new ProcessConfigurationElement(parent, parent.getNamespaceURI(), source.getName(), null);
        String characterData = source.getCharacterData();
        List<ModifyElement> modifications = this.fModifyMap.get(source);
        if (modifications == null) {
            modifications = Collections.emptyList();
        }
        HashSet<String> removedAttributes = new HashSet<String>();
        for (ModifyElement modifyElement : modifications) {
            for (IRemoveAttribute removeAttribute : modifyElement.getRemoveAttributes()) {
                removedAttributes.add(removeAttribute.getAttributeName());
            }
            if (modifyElement.getSetText() == null) continue;
            characterData = modifyElement.getSetText().getText();
        }
        String[] stringArray = source.getAttributeNames();
        int removeAttribute = stringArray.length;
        int n = 0;
        while (n < removeAttribute) {
            Object attributeName = stringArray[n];
            if (!removedAttributes.contains(attributeName)) {
                createdElement.modifyAttribute((String)attributeName, source.getAttribute((String)attributeName));
            }
            ++n;
        }
        if (characterData != null) {
            createdElement.setCharacterData(characterData);
        }
        for (ModifyElement modifyElement : modifications) {
            for (ISetAttribute setAttribute : modifyElement.getSetAttributes()) {
                createdElement.modifyAttribute(setAttribute.getAttributeName(), setAttribute.getAttributeValue());
            }
        }
        parent.addChildElement(createdElement);
        this.copyChildrenAndApplyDeltas(source, createdElement);
    }

    private static AbstractElement getChild(AbstractElement parent, String name) {
        for (Object childObject : parent.getChildElements()) {
            AbstractElement child = (AbstractElement)childObject;
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private void foundError(String message) {
        this.fProblems.add((IStatus)new Status(4, "com.ibm.team.process.common", message));
    }

    private int minMergeDepth(int a, int b) {
        if (a < 0) {
            return b;
        }
        if (b < 0) {
            return a;
        }
        return Math.min(a, b);
    }

    private static <T> void addToMap(Map<AbstractElement, List<T>> map, AbstractElement key, T newValue) {
        List<T> existing = map.get(key);
        if (existing == null) {
            existing = new ArrayList<T>();
            map.put(key, existing);
        }
        existing.add(newValue);
    }

    private static AbstractElement lastChild(AbstractElement element) {
        List children = element.getChildElements();
        if (children.isEmpty()) {
            return null;
        }
        return (AbstractElement)children.get(children.size() - 1);
    }

    private static String pathAsShortString(AbstractElement root) {
        if (root.getChildElements().isEmpty()) {
            return "[empty]";
        }
        StringBuilder result = new StringBuilder();
        ProcessDelta.pathAsShortString(result, ProcessDelta.lastChild(root));
        return result.toString();
    }

    private static void pathAsShortString(StringBuilder buffer, AbstractElement element) {
        buffer.append(element.getName());
        String[] attributeNames = element.getAttributeNames();
        if (attributeNames.length > 0) {
            buffer.append('[');
            String[] stringArray = attributeNames;
            int n = attributeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                buffer.append(name).append("=\"").append(element.getAttribute(name)).append("\",");
                ++n2;
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(']');
        }
        if (!element.getChildElements().isEmpty()) {
            buffer.append('/');
            ProcessDelta.pathAsShortString(buffer, ProcessDelta.lastChild(element));
        }
    }

    private static final class AddElementInfo {
        private AbstractElement fSibling;
        private List<AbstractElement> fNewElements;
        private int fMergeDepth;
        private IAddition.Location fLocation;

        public AddElementInfo(AbstractElement sibling, List<AbstractElement> newElements, int mergeDepth, IAddition.Location location) {
            this.fSibling = sibling;
            this.fNewElements = newElements;
            this.fMergeDepth = mergeDepth;
            this.fLocation = location;
        }

        public AbstractElement getSibling() {
            return this.fSibling;
        }

        public List<AbstractElement> getNewElements() {
            return this.fNewElements;
        }

        public int getMergeDepth() {
            return this.fMergeDepth;
        }

        public IAddition.Location getLocation() {
            return this.fLocation;
        }
    }
}

