/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ConfigurationSource;
import com.ibm.team.process.internal.common.advice.PermissionSource;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.util.AbstractProcess;
import com.ibm.team.process.internal.common.util.PermittedConfigurationsCacheKey;
import com.ibm.team.process.internal.common.util.SoftReferenceCache;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermittedConfigurationsAndActionsCache {
    SoftReferenceCache<PermittedConfigurationsCacheKey, PermittedConfigurationsValue> permcache = new SoftReferenceCache();
    private boolean useCache = true;
    private boolean checkedCacheSetting = false;
    public static Log logger = LogFactory.getLog(PermittedConfigurationsAndActionsCache.class);

    public static boolean[] calculatePermittedActions(OperationPermissionsConfiguration[] permissionConfigs, String[] actions) {
        boolean[] permitted = new boolean[actions == null ? 0 : actions.length];
        if (permissionConfigs != null && actions != null) {
            HashSet permittedActions = new HashSet();
            List<String> actionList = Arrays.asList(actions);
            int i = 0;
            while (i < permissionConfigs.length && permittedActions.size() < actions.length) {
                OperationPermissionsConfiguration config = permissionConfigs[i];
                List perm = PermittedConfigurationsAndActionsCache.getPermittedActions(actionList, config);
                permittedActions.addAll(perm);
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                permitted[i] = permittedActions.contains(actions[i]);
                ++i;
            }
        }
        return permitted;
    }

    private static List getPermittedActions(List actions, OperationPermissionsConfiguration configuration) {
        return OperationAdviceManager.getPermittedActions(actions, configuration);
    }

    public static final IItemHandle[] getSourcesForCaching(OperationPermissionsConfiguration[] permissionConfigs) {
        if (permissionConfigs == null) {
            return null;
        }
        if (permissionConfigs.length == 0) {
            return new IItemHandle[0];
        }
        IItemHandle[] sources = new IItemHandle[permissionConfigs.length];
        int i = 0;
        while (i < permissionConfigs.length) {
            IProcessArea processArea;
            sources[i] = null;
            OperationPermissionsConfiguration permissionConfig = permissionConfigs[i];
            ConfigurationSource configSource = permissionConfig.getSource();
            if (configSource != null && (processArea = configSource.getSourceArea()) != null) {
                sources[i] = processArea.getItemHandle();
            }
            ++i;
        }
        return sources;
    }

    public static final OperationPermissionsConfiguration[] cleanForCaching(OperationPermissionsConfiguration[] permissionConfigs) {
        if (permissionConfigs == null || permissionConfigs.length == 0) {
            return permissionConfigs;
        }
        int i = 0;
        while (i < permissionConfigs.length) {
            OperationPermissionsConfiguration permissionConfig = permissionConfigs[i];
            ConfigurationSource configSource = permissionConfig.getSource();
            if (configSource != null) {
                configSource.setSourceArea(null);
            }
            ++i;
        }
        return permissionConfigs;
    }

    public static final OperationPermissionsConfiguration[] removePermissionConfigsSources(OperationPermissionsConfiguration[] permissionConfigs) {
        if (permissionConfigs == null || permissionConfigs.length == 0) {
            return new OperationPermissionsConfiguration[0];
        }
        OperationPermissionsConfiguration[] copyPermissionConfigs = new OperationPermissionsConfiguration[permissionConfigs.length];
        int i = 0;
        while (i < permissionConfigs.length) {
            copyPermissionConfigs[i] = (OperationPermissionsConfiguration)permissionConfigs[i].createCopyWithSource(null);
            ++i;
        }
        return copyPermissionConfigs;
    }

    public static final OperationPermissionsConfiguration[] copyFromCaching(OperationPermissionsConfiguration[] permissionConfigs, IItemHandle[] sourceHandles, AbstractProcess abstractProcess) {
        if (permissionConfigs == null || permissionConfigs.length == 0) {
            return new OperationPermissionsConfiguration[0];
        }
        OperationPermissionsConfiguration[] copyToUse = new OperationPermissionsConfiguration[permissionConfigs.length];
        int i = 0;
        while (i < permissionConfigs.length) {
            OperationPermissionsConfiguration permissionConfig = permissionConfigs[i];
            ConfigurationSource configSource = permissionConfig.getSource();
            if (configSource == null) {
                copyToUse[i] = (OperationPermissionsConfiguration)permissionConfig.createCopyWithSource(null);
            } else if (configSource instanceof PermissionSource) {
                PermissionSource permissionSource = (PermissionSource)configSource;
                String contentKey = permissionSource.getContentKey();
                String contentUUIDString = permissionSource.getContentUuid();
                String roleIdString = permissionSource.getRoleId();
                String processAreaUUIDString = permissionSource.getSourceAreaItemUuid();
                IProcessArea processArea = null;
                try {
                    if (sourceHandles != null && processAreaUUIDString != null && sourceHandles[i] != null && processAreaUUIDString.equals(sourceHandles[i].getItemId().getUuidValue())) {
                        IItem item = abstractProcess.fetchCompleteItem(sourceHandles[i], null);
                        processArea = (IProcessArea)item;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                PermissionSource editedPermissionSource = PermittedConfigurationsAndActionsCache.generatePermissionSource(contentKey, contentUUIDString, roleIdString, processAreaUUIDString, processArea);
                if (permissionSource.isSetInternalPermittedActions()) {
                    editedPermissionSource.setPermittedActions(permissionSource.getPermittedActions());
                }
                if (permissionSource.isSetAreaIsTeamArea()) {
                    editedPermissionSource.setAreaIsTeamArea(permissionSource.isAreaIsTeamArea());
                }
                if (permissionSource.isSetFinal()) {
                    editedPermissionSource.setFinal(permissionSource.isFinal());
                }
                copyToUse[i] = (OperationPermissionsConfiguration)permissionConfig.createCopyWithSource(editedPermissionSource);
            } else {
                String contentKey = configSource.getContentKey();
                String contentUUIDString = configSource.getContentUuid();
                String roleIdString = configSource.getRoleId();
                String processAreaUUIDString = configSource.getSourceAreaItemUuid();
                IProcessArea processArea = null;
                try {
                    if (sourceHandles != null && processAreaUUIDString != null && sourceHandles[i] != null && processAreaUUIDString.equals(sourceHandles[i].getItemId().getUuidValue())) {
                        IItem item = abstractProcess.fetchCompleteItem(sourceHandles[i], null);
                        processArea = (IProcessArea)item;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ConfigurationSource editedConfigurationSource = PermittedConfigurationsAndActionsCache.generateConfigurationSource(contentKey, contentUUIDString, roleIdString, processAreaUUIDString, processArea);
                copyToUse[i] = (OperationPermissionsConfiguration)permissionConfig.createCopyWithSource(editedConfigurationSource);
            }
            ++i;
        }
        return copyToUse;
    }

    public static final OperationPermissionsConfiguration[] copyFromCaching(OperationPermissionsConfiguration[] permissionConfigs) {
        if (permissionConfigs == null || permissionConfigs.length == 0) {
            return new OperationPermissionsConfiguration[0];
        }
        OperationPermissionsConfiguration[] copyToUse = new OperationPermissionsConfiguration[permissionConfigs.length];
        int i = 0;
        while (i < permissionConfigs.length) {
            OperationPermissionsConfiguration permissionConfig = permissionConfigs[i];
            ConfigurationSource configSource = permissionConfig.getSource();
            if (configSource == null) {
                copyToUse[i] = (OperationPermissionsConfiguration)permissionConfig.createCopyWithSource(null);
            } else if (configSource instanceof PermissionSource) {
                PermissionSource permissionSource = (PermissionSource)configSource;
                String contentKey = permissionSource.getContentKey();
                String contentUUIDString = permissionSource.getContentUuid();
                String roleIdString = permissionSource.getRoleId();
                String processAreaUUIDString = permissionSource.getSourceAreaItemUuid();
                IProcessArea processArea = null;
                PermissionSource editedPermissionSource = PermittedConfigurationsAndActionsCache.generatePermissionSource(contentKey, contentUUIDString, roleIdString, processAreaUUIDString, processArea);
                if (permissionSource.isSetInternalPermittedActions()) {
                    editedPermissionSource.setPermittedActions(permissionSource.getPermittedActions());
                }
                if (permissionSource.isSetAreaIsTeamArea()) {
                    editedPermissionSource.setAreaIsTeamArea(permissionSource.isAreaIsTeamArea());
                }
                if (permissionSource.isSetFinal()) {
                    editedPermissionSource.setFinal(permissionSource.isFinal());
                }
                copyToUse[i] = (OperationPermissionsConfiguration)permissionConfig.createCopyWithSource(editedPermissionSource);
            } else {
                String contentKey = configSource.getContentKey();
                String contentUUIDString = configSource.getContentUuid();
                String roleIdString = configSource.getRoleId();
                String processAreaUUIDString = configSource.getSourceAreaItemUuid();
                IProcessArea processArea = null;
                ConfigurationSource editedConfigurationSource = PermittedConfigurationsAndActionsCache.generateConfigurationSource(contentKey, contentUUIDString, roleIdString, processAreaUUIDString, processArea);
                copyToUse[i] = (OperationPermissionsConfiguration)permissionConfig.createCopyWithSource(editedConfigurationSource);
            }
            ++i;
        }
        return copyToUse;
    }

    public static final PermissionSource generatePermissionSource(String contentKey, String contentUUIDString, String roleIdString, String processAreaUUIDString, IProcessArea processArea) {
        PermissionSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
        source.setSourceArea(processArea);
        source.setSourceAreaItemUuid(processAreaUUIDString);
        source.setContentKey(contentKey);
        source.setRoleId(roleIdString);
        source.setContentUuid(contentUUIDString);
        return source;
    }

    public static final ConfigurationSource generateConfigurationSource(String contentKey, String contentUUIDString, String roleIdString, String processAreaUUIDString, IProcessArea processArea) {
        ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
        source.setSourceArea(processArea);
        source.setSourceAreaItemUuid(processAreaUUIDString);
        source.setContentKey(contentKey);
        source.setRoleId(roleIdString);
        source.setContentUuid(contentUUIDString);
        return source;
    }

    public boolean[] addToCacheAndGetPermittedActions(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, String[] actions, OperationPermissionsConfiguration[] permissions) {
        IItemHandle[] sources = PermittedConfigurationsAndActionsCache.getSourcesForCaching(permissions);
        OperationPermissionsConfiguration[] permissionsCopy = PermittedConfigurationsAndActionsCache.cleanForCaching(permissions);
        boolean[] permitted = PermittedConfigurationsAndActionsCache.calculatePermittedActions(permissionsCopy, actions);
        if (this.useCaching()) {
            PermittedConfigurationsCacheKey key = new PermittedConfigurationsCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos, actions);
            PermittedConfigurationsAndActionsCache.logCacheAdd(key, this.permcache);
            PermittedConfigurationsValue value = new PermittedConfigurationsValue();
            value.permissions = permissionsCopy;
            value.permittedActions = permitted;
            value.permissionsSources = sources;
            this.permcache.setValue(key, value);
        }
        return permitted;
    }

    public OperationPermissionsConfiguration[] addToCacheAndGetPermissions(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, String[] actions, OperationPermissionsConfiguration[] permissions) {
        IItemHandle[] sources = PermittedConfigurationsAndActionsCache.getSourcesForCaching(permissions);
        OperationPermissionsConfiguration[] permissionsCopy = PermittedConfigurationsAndActionsCache.cleanForCaching(permissions);
        if (this.useCaching()) {
            boolean[] permitted = PermittedConfigurationsAndActionsCache.calculatePermittedActions(permissionsCopy, actions);
            PermittedConfigurationsCacheKey key = new PermittedConfigurationsCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos, actions);
            PermittedConfigurationsAndActionsCache.logCacheAdd(key, this.permcache);
            PermittedConfigurationsValue value = new PermittedConfigurationsValue();
            value.permissions = permissionsCopy;
            value.permittedActions = permitted;
            value.permissionsSources = sources;
            this.permcache.setValue(key, value);
        }
        OperationPermissionsConfiguration[] returnValue = PermittedConfigurationsAndActionsCache.copyFromCaching(permissionsCopy);
        return returnValue;
    }

    public OperationPermissionsConfiguration[] addToCacheAndGetPermissions(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, String[] actions, OperationPermissionsConfiguration[] permissions, AbstractProcess abstractProcess) {
        IItemHandle[] sources = PermittedConfigurationsAndActionsCache.getSourcesForCaching(permissions);
        OperationPermissionsConfiguration[] permissionsCopy = PermittedConfigurationsAndActionsCache.cleanForCaching(permissions);
        if (this.useCaching()) {
            boolean[] permitted = PermittedConfigurationsAndActionsCache.calculatePermittedActions(permissionsCopy, actions);
            PermittedConfigurationsCacheKey key = new PermittedConfigurationsCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos, actions);
            PermittedConfigurationsAndActionsCache.logCacheAdd(key, this.permcache);
            PermittedConfigurationsValue value = new PermittedConfigurationsValue();
            value.permissions = permissionsCopy;
            value.permittedActions = permitted;
            value.permissionsSources = sources;
            this.permcache.setValue(key, value);
        }
        OperationPermissionsConfiguration[] returnValue = PermittedConfigurationsAndActionsCache.copyFromCaching(permissionsCopy, sources, abstractProcess);
        return returnValue;
    }

    public OperationPermissionsConfiguration[] getPermissions(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, String[] actions) {
        if (!this.useCaching()) {
            return null;
        }
        PermittedConfigurationsCacheKey key = new PermittedConfigurationsCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos, actions);
        PermittedConfigurationsValue value = this.permcache.getValue(key);
        PermittedConfigurationsAndActionsCache.logCacheHitOrMiss(key, value, this.permcache);
        if (value == null) {
            return null;
        }
        OperationPermissionsConfiguration[] returnValue = PermittedConfigurationsAndActionsCache.copyFromCaching(value.permissions);
        return returnValue;
    }

    public OperationPermissionsConfiguration[] getPermissions(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, String[] actions, AbstractProcess abstractProcess) {
        if (!this.useCaching()) {
            return null;
        }
        PermittedConfigurationsCacheKey key = new PermittedConfigurationsCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos, actions);
        PermittedConfigurationsValue value = this.permcache.getValue(key);
        PermittedConfigurationsAndActionsCache.logCacheHitOrMiss(key, value, this.permcache);
        if (value == null) {
            return null;
        }
        OperationPermissionsConfiguration[] returnValue = PermittedConfigurationsAndActionsCache.copyFromCaching(value.permissions, value.permissionsSources, abstractProcess);
        return returnValue;
    }

    public boolean[] getPermittedActions(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, String[] actions) {
        if (!this.useCaching()) {
            return null;
        }
        PermittedConfigurationsCacheKey key = new PermittedConfigurationsCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos, actions);
        PermittedConfigurationsValue value = this.permcache.getValue(key);
        PermittedConfigurationsAndActionsCache.logCacheHitOrMiss(key, value, this.permcache);
        if (value == null) {
            return null;
        }
        return value.permittedActions;
    }

    protected boolean useCaching() {
        if (!this.checkedCacheSetting) {
            Boolean useCacheNow = PermittedConfigurationsAndActionsCache.getStaticPropertyBoolean("com.ibm.team.process.PermissionsCache.useCache", null);
            if (useCacheNow != null) {
                this.useCache = useCacheNow;
                if (!this.useCache) {
                    System.out.println("com.ibm.team.process.PermissionsCache.useCache used to turn PermittedConfigurationsAndActionsCache off");
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"com.ibm.team.process.PermissionsCache.useCache used to turn PermittedConfigurationsAndActionsCache off");
                    }
                }
            }
            this.checkedCacheSetting = true;
        }
        return this.useCache;
    }

    public static Boolean getStaticPropertyBoolean(String property, Boolean defaultValue) {
        String valueString = System.getProperty(property);
        if (valueString != null) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.FALSE;
            }
        }
        return defaultValue;
    }

    public static void logCacheHitOrMiss(PermittedConfigurationsCacheKey key, PermittedConfigurationsValue value, SoftReferenceCache<PermittedConfigurationsCacheKey, PermittedConfigurationsValue> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            if (value == null) {
                sb.append("cache miss PermittedConfigurationsAndActionsCache key=").append(key);
            } else {
                sb.append("cache hit PermittedConfigurationsAndActionsCache key=").append(key);
            }
            Set<PermittedConfigurationsCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append(" keys.");
            logger.debug((Object)sb.toString());
        }
    }

    public static void logCacheAdd(PermittedConfigurationsCacheKey key, SoftReferenceCache<PermittedConfigurationsCacheKey, PermittedConfigurationsValue> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("cache add PermittedConfigurationsAndActionsCache key=").append(key);
            Set<PermittedConfigurationsCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append("keys.");
            logger.debug((Object)sb.toString());
        }
    }

    private class PermittedConfigurationsValue {
        boolean[] permittedActions;
        OperationPermissionsConfiguration[] permissions;
        IItemHandle[] permissionsSources;

        private PermittedConfigurationsValue() {
        }
    }
}

