/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.util.CacheKey;
import com.ibm.team.process.internal.common.util.ProcessModelCache;
import com.ibm.team.process.internal.common.util.SoftReferenceCache;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentBasedProcessModelCache
extends ProcessModelCache {
    private ModelCache internalModelCache;
    public static Log logger = LogFactory.getLog(ContentBasedProcessModelCache.class);

    public ContentBasedProcessModelCache(int size) {
        super(size);
        this.internalModelCache = new ModelCache(size);
    }

    @Override
    public AbstractModel get(IProcessContainer container, IContent content, IDevelopmentLine line, CurrentIterationInfo[] iterationInfos) {
        return this.internalModelCache.getModel(content, line, iterationInfos);
    }

    @Override
    public void put(IProcessContainer container, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, AbstractModel model) {
        this.internalModelCache.setModel(content, line, currentIterationInfos, model);
    }

    public int size() {
        return this.internalModelCache.size();
    }

    public int capacity() {
        return this.internalModelCache.capacity();
    }

    public static Boolean getStaticPropertyBoolean(String property, Boolean defaultValue) {
        String valueString = System.getProperty(property);
        if (valueString != null) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.FALSE;
            }
        }
        return defaultValue;
    }

    public static void logCacheHitOrMiss(ModelCacheKey key, AbstractModel value, SoftReferenceCache<ModelCacheKey, AbstractModel> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            if (value == null) {
                sb.append("cache miss ContentBasedProcessModelCache key=").append(key);
            } else {
                sb.append("cache hit ContentBasedProcessModelCache key=").append(key);
            }
            Set<ModelCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append(" keys.");
            logger.debug((Object)sb.toString());
        }
    }

    public static void logCacheAdd(ModelCacheKey key, SoftReferenceCache<ModelCacheKey, AbstractModel> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("cache add ContentBasedProcessModelCache key=").append(key);
            Set<ModelCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append("keys.");
            logger.debug((Object)sb.toString());
        }
    }

    private class ModelCache
    extends SoftReferenceCache<ModelCacheKey, AbstractModel> {
        private boolean useCache;
        private boolean checkedCacheSetting;

        public ModelCache(int capacity) {
            super(capacity);
            this.useCache = true;
            this.checkedCacheSetting = false;
        }

        public AbstractModel getModel(IContent content, IDevelopmentLine line, CurrentIterationInfo[] iterationInfos) {
            if (content == null || !this.useCaching()) {
                return null;
            }
            ModelCacheKey key = new ModelCacheKey(content, line, iterationInfos);
            AbstractModel model = (AbstractModel)this.getValue(key);
            ContentBasedProcessModelCache.logCacheHitOrMiss(key, model, this);
            return model;
        }

        public void setModel(IContent content, IDevelopmentLine line, CurrentIterationInfo[] iterationInfos, AbstractModel model) {
            if (model == null || content == null || !this.useCaching()) {
                return;
            }
            ModelCacheKey key = new ModelCacheKey(content, line, iterationInfos);
            this.setValue(key, model);
            ContentBasedProcessModelCache.logCacheAdd(key, this);
        }

        protected boolean useCaching() {
            if (!this.checkedCacheSetting) {
                Boolean useCacheNow = ContentBasedProcessModelCache.getStaticPropertyBoolean("com.ibm.team.process.ProcessModelCache.useCache", null);
                if (useCacheNow != null) {
                    this.useCache = useCacheNow;
                    if (!this.useCache) {
                        System.out.println("com.ibm.team.process.ProcessModelCache.useCache used to turn ContentBasedProcessModelCache off");
                    }
                }
                this.checkedCacheSetting = true;
            }
            return this.useCache;
        }
    }

    private class ModelCacheKey
    extends CacheKey {
        public UUID contentId;
        public IDevelopmentLineHandle lineHandle;
        public CurrentIterationInfo[] currentIterationInfos;

        public ModelCacheKey(IContent content, IDevelopmentLine line, CurrentIterationInfo[] iterationInfos) {
            super(new Object[0]);
            this.contentId = content == null ? null : content.getContentId();
            this.lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
            this.currentIterationInfos = iterationInfos;
            this.hashCode = this.makeHashCode();
            this.forceHandles();
        }

        void forceHandles() {
            this.lineHandle = this.lineHandle == null ? null : (IDevelopmentLineHandle)this.lineHandle.getItemType().createItemHandle(this.lineHandle.getItemId(), this.lineHandle.getStateId());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ModelCacheKey) {
                ModelCacheKey key = (ModelCacheKey)obj;
                if (this.contentId == null || key.contentId == null) {
                    return false;
                }
                if (!this.contentId.equals((Object)key.contentId)) {
                    return false;
                }
                if (!(this.lineHandle == null && key.lineHandle == null || this.lineHandle != null && this.lineHandle.sameItemId((IItemHandle)key.lineHandle))) {
                    return false;
                }
                if (this.currentIterationInfos == null && key.currentIterationInfos == null) {
                    return true;
                }
                if (this.currentIterationInfos == null || key.currentIterationInfos == null) {
                    return false;
                }
                if (this.equalIterationInfos(this.currentIterationInfos, key.currentIterationInfos)) {
                    return true;
                }
            }
            return false;
        }

        private boolean equalIterationInfos(CurrentIterationInfo[] iterationInfosA, CurrentIterationInfo[] iterationInfosB) {
            if (iterationInfosA != null && iterationInfosB != null && iterationInfosA.length == iterationInfosB.length) {
                int i = 0;
                while (i < iterationInfosA.length) {
                    if (!this.equalIterationInfo(iterationInfosA[i], iterationInfosB[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        private boolean equalIterationInfo(CurrentIterationInfo infoA, CurrentIterationInfo infoB) {
            if (infoA.getIteration().sameItemId((IItemHandle)infoB.getIteration())) {
                IIterationType typeA = infoA.getIterationType();
                IIterationType typeB = infoB.getIterationType();
                return typeA == null && typeB == null || typeA != null && typeA.sameItemId((IItemHandle)typeB) || typeB != null && typeB.sameItemId((IItemHandle)typeA);
            }
            return false;
        }

        private int makeHashCode() {
            int newHashCode = 0;
            if (this.contentId != null) {
                newHashCode = 31 * newHashCode + this.contentId.hashCode();
            }
            if (this.lineHandle != null) {
                newHashCode = 31 * newHashCode + this.lineHandle.getItemId().hashCode();
            }
            if (this.currentIterationInfos != null) {
                CurrentIterationInfo[] currentIterationInfoArray = this.currentIterationInfos;
                int n = this.currentIterationInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    IIterationType type;
                    CurrentIterationInfo currentIterationInfo = currentIterationInfoArray[n2];
                    IIteration iteration = currentIterationInfo.getIteration();
                    if (iteration != null) {
                        newHashCode = 31 * newHashCode + iteration.getItemId().hashCode();
                    }
                    if ((type = currentIterationInfo.getIterationType()) != null) {
                        newHashCode = 31 * newHashCode + type.getItemId().hashCode();
                    }
                    ++n2;
                }
            }
            return newHashCode;
        }
    }
}

