/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.util.CacheKey;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;

public class ConfigurationCacheKey
extends CacheKey {
    String configurationId;
    IProjectAreaHandle projectAreaHandle;
    IProcessContainerHandle processProviderHandle;
    IProcessAreaHandle startingAreaHandle;
    IContributorHandle contributorHandle;
    IDevelopmentLineHandle lineHandle;
    CurrentIterationInfo[] currentIterationInfos;
    ITeamAreaHandle[] teamAreas;

    public String toString() {
        int n;
        int n2;
        Object[] objectArray;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("{ configurationId: ").append(this.configurationId);
        sb.append(", projectAreaHandle: ").append(this.projectAreaHandle);
        sb.append(", processProviderHandle: ").append(this.processProviderHandle);
        sb.append(", startingAreaHandle: ").append(this.startingAreaHandle);
        sb.append(", contributorHandle: ").append(this.contributorHandle);
        sb.append(", lineHandle: ").append(this.lineHandle);
        sb.append(", currentIterationInfos: {");
        if (this.currentIterationInfos != null) {
            objectArray = this.currentIterationInfos;
            n2 = this.currentIterationInfos.length;
            n = 0;
            while (n < n2) {
                CurrentIterationInfo currentIterationInfo = objectArray[n];
                sb.append(", ").append(currentIterationInfo);
                ++n;
            }
        }
        sb.append("}, ");
        sb.append(", teamAreas: {");
        if (this.teamAreas != null) {
            objectArray = this.teamAreas;
            n2 = this.teamAreas.length;
            n = 0;
            while (n < n2) {
                Object teamArea = objectArray[n];
                sb.append(", ").append(teamArea);
                ++n;
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public ConfigurationCacheKey(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos) {
        super(configurationId, contributorHandle, projectAreaHandle, processProviderHandle, startingAreaHandle, lineHandle, currentIterationInfos, teamAreas);
        this.configurationId = configurationId;
        this.projectAreaHandle = projectAreaHandle;
        this.processProviderHandle = processProviderHandle;
        this.startingAreaHandle = startingAreaHandle;
        this.contributorHandle = contributorHandle;
        this.lineHandle = lineHandle;
        this.currentIterationInfos = currentIterationInfos;
        this.teamAreas = teamAreas;
        this.forceHandles();
    }

    void forceHandles() {
        this.projectAreaHandle = this.projectAreaHandle == null ? null : (IProjectAreaHandle)this.projectAreaHandle.getItemType().createItemHandle(this.projectAreaHandle.getItemId(), this.projectAreaHandle.getStateId());
        this.processProviderHandle = this.processProviderHandle == null ? null : (IProcessContainerHandle)this.processProviderHandle.getItemType().createItemHandle(this.processProviderHandle.getItemId(), this.processProviderHandle.getStateId());
        this.startingAreaHandle = this.startingAreaHandle == null ? null : (IProcessAreaHandle)this.startingAreaHandle.getItemType().createItemHandle(this.startingAreaHandle.getItemId(), this.startingAreaHandle.getStateId());
        this.contributorHandle = this.contributorHandle == null ? null : (IContributorHandle)this.contributorHandle.getItemType().createItemHandle(this.contributorHandle.getItemId(), this.contributorHandle.getStateId());
        IDevelopmentLineHandle iDevelopmentLineHandle = this.lineHandle = this.lineHandle == null ? null : (IDevelopmentLineHandle)this.lineHandle.getItemType().createItemHandle(this.lineHandle.getItemId(), this.lineHandle.getStateId());
        if (this.teamAreas != null) {
            ITeamAreaHandle[] iTeamAreaHandleArray = this.teamAreas;
            int n = this.teamAreas.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamAreaHandle teamAreaHandle = iTeamAreaHandleArray[n2];
                ITeamAreaHandle iTeamAreaHandle = teamAreaHandle == null ? null : (ITeamAreaHandle)teamAreaHandle.getItemType().createItemHandle(teamAreaHandle.getItemId(), teamAreaHandle.getStateId());
                ++n2;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigurationCacheKey) {
            ConfigurationCacheKey confObj = (ConfigurationCacheKey)obj;
            if (!(this.configurationId == null && confObj.configurationId == null || this.configurationId != null && this.configurationId.equals(confObj.configurationId))) {
                return false;
            }
            if (!(this.projectAreaHandle == null && confObj.projectAreaHandle == null || this.projectAreaHandle != null && this.projectAreaHandle.sameStateId((IItemHandle)confObj.projectAreaHandle))) {
                return false;
            }
            if (!(this.processProviderHandle == null && confObj.processProviderHandle == null || this.processProviderHandle != null && this.processProviderHandle.sameStateId((IItemHandle)confObj.processProviderHandle))) {
                return false;
            }
            if (!(this.startingAreaHandle == null && confObj.startingAreaHandle == null || this.startingAreaHandle != null && this.startingAreaHandle.sameStateId((IItemHandle)confObj.startingAreaHandle))) {
                return false;
            }
            if (!(this.contributorHandle == null && confObj.contributorHandle == null || this.contributorHandle != null && this.contributorHandle.sameItemId((IItemHandle)confObj.contributorHandle))) {
                return false;
            }
            if (!(this.lineHandle == null && confObj.lineHandle == null || this.lineHandle != null && this.lineHandle.sameItemId((IItemHandle)confObj.lineHandle))) {
                return false;
            }
            if (this.currentIterationInfos != null || confObj.currentIterationInfos != null) {
                if (this.currentIterationInfos == null || confObj.currentIterationInfos == null) {
                    return false;
                }
                if (!this.equalIterationInfos(this.currentIterationInfos, confObj.currentIterationInfos)) {
                    return false;
                }
            }
            if (this.teamAreas != null || confObj.teamAreas != null) {
                if (this.teamAreas == null || confObj.teamAreas == null) {
                    return false;
                }
                if (this.teamAreas.length != confObj.teamAreas.length) {
                    return false;
                }
                int i = 0;
                while (i < this.teamAreas.length) {
                    if (this.teamAreas[i] == null) {
                        if (confObj.teamAreas[i] != null) {
                            return false;
                        }
                    } else if (!this.teamAreas[i].sameItemId((IItemHandle)confObj.teamAreas[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private boolean equalIterationInfos(CurrentIterationInfo[] iterationInfosA, CurrentIterationInfo[] iterationInfosB) {
        if (iterationInfosA != null && iterationInfosB != null && iterationInfosA.length == iterationInfosB.length) {
            int i = 0;
            while (i < iterationInfosA.length) {
                if (!this.equalIterationInfo(iterationInfosA[i], iterationInfosB[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean equalIterationInfo(CurrentIterationInfo infoA, CurrentIterationInfo infoB) {
        if (infoA.getIteration().sameItemId((IItemHandle)infoB.getIteration())) {
            IIterationType typeA = infoA.getIterationType();
            IIterationType typeB = infoB.getIterationType();
            return typeA == null && typeB == null || typeA != null && typeA.sameItemId((IItemHandle)typeB) || typeB != null && typeB.sameItemId((IItemHandle)typeA);
        }
        return false;
    }
}

