/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;

public abstract class CacheKey {
    public static final int HASHJUMP = 31;
    protected int hashCode = 0;

    public abstract boolean equals(Object var1);

    public CacheKey(Object ... objects) {
        this.hashCode = CacheKey.makeCacheHashCode(objects);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static final int modifyHash(int inithash, UUID uuid) {
        if (uuid == null) {
            return inithash;
        }
        return 31 * inithash + uuid.hashCode();
    }

    public static final int modifyHash(int inithash, String string) {
        if (string == null) {
            return inithash;
        }
        return 31 * inithash + string.hashCode();
    }

    public static final int modifyHash(int inithash, IItemHandle handle) {
        if (handle == null) {
            return inithash;
        }
        int hash = inithash;
        hash = 31 * hash + handle.getItemId().hashCode();
        if (handle.hasStateId()) {
            hash = 31 * hash + handle.getStateId().hashCode();
        }
        return hash;
    }

    public static final int modifyHash(int inithash, CurrentIterationInfo currentIterationInfo) {
        if (currentIterationInfo == null) {
            return inithash;
        }
        int hash = inithash;
        IIteration iteration = currentIterationInfo.getIteration();
        hash = CacheKey.modifyHash(hash, (IItemHandle)iteration);
        IIterationType type = currentIterationInfo.getIterationType();
        hash = CacheKey.modifyHash(hash, (IItemHandle)type);
        return hash;
    }

    public static int formHashCode(Object ... objects) {
        return CacheKey.makeCacheHashCode(objects);
    }

    public static int makeCacheHashCode(Object[] objects) {
        int hash = 0;
        if (objects == null) {
            return hash;
        }
        hash = CacheKey.modifyHash(hash, objects);
        return hash;
    }

    public static int modifyHash(int inithash, Object[] objects) {
        if (objects == null) {
            return inithash;
        }
        int hash = inithash;
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            if (obj != null) {
                if (obj.getClass().isArray()) {
                    hash = CacheKey.modifyHash(hash, (Object[])obj);
                } else if (objects[i] instanceof String) {
                    hash = CacheKey.modifyHash(hash, (String)obj);
                } else if (objects[i] instanceof UUID) {
                    hash = CacheKey.modifyHash(hash, (UUID)obj);
                } else if (objects[i] instanceof IItemHandle) {
                    hash = CacheKey.modifyHash(hash, (IItemHandle)obj);
                }
            }
            ++i;
        }
        return hash;
    }
}

