/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.util.ConfigurationCacheKey;
import com.ibm.team.process.internal.common.util.SoftReferenceCache;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BehaviorConfigurationsCache {
    public static final int MAXIMUMCAPACITY = 10000;
    private int capacity;
    SoftReferenceCache<ConfigurationCacheKey, BehaviorConfigurationsValue> behavecache;
    private boolean useCache = true;
    private boolean checkedCacheSetting = false;
    public static Log logger = LogFactory.getLog(BehaviorConfigurationsCache.class);

    public BehaviorConfigurationsCache() {
        this.capacity = 10000;
        this.behavecache = new SoftReferenceCache(this.capacity);
    }

    public BehaviorConfigurationsCache(int size) {
        this.capacity = size < 1 ? 1 : size;
        this.behavecache = new SoftReferenceCache(size);
    }

    public void addToCache(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos, OperationBehaviorConfiguration behavior) {
        if (!this.useCaching()) {
            return;
        }
        ConfigurationCacheKey key = new ConfigurationCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos);
        BehaviorConfigurationsCache.logCacheAdd(key, this.behavecache);
        BehaviorConfigurationsValue value = new BehaviorConfigurationsValue();
        value.behavior = behavior;
        this.behavecache.setValue(key, value);
    }

    public OperationBehaviorConfiguration getBehavior(String configurationId, IProjectAreaHandle projectAreaHandle, IProcessContainerHandle processProviderHandle, IProcessAreaHandle startingAreaHandle, ITeamAreaHandle[] teamAreas, IContributorHandle contributorHandle, IDevelopmentLineHandle lineHandle, CurrentIterationInfo[] currentIterationInfos) {
        if (!this.useCaching()) {
            return null;
        }
        ConfigurationCacheKey key = new ConfigurationCacheKey(configurationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributorHandle, lineHandle, currentIterationInfos);
        BehaviorConfigurationsValue value = this.behavecache.getValue(key);
        BehaviorConfigurationsCache.logCacheHitOrMiss(key, value, this.behavecache);
        if (value == null) {
            return null;
        }
        return value.behavior;
    }

    protected boolean useCaching() {
        if (!this.checkedCacheSetting) {
            Boolean useCacheNow = BehaviorConfigurationsCache.getStaticPropertyBoolean("com.ibm.team.process.BehaviorCache.useCache", null);
            if (useCacheNow != null) {
                this.useCache = useCacheNow;
                if (!this.useCache) {
                    System.out.println("com.ibm.team.process.BehaviorCache.useCache used to turn BehaviorConfigurationsCache off");
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"com.ibm.team.process.BehaviorCache.useCache used to turn BehaviorConfigurationsCache off");
                    }
                }
            }
            this.checkedCacheSetting = true;
        }
        return this.useCache;
    }

    public static Boolean getStaticPropertyBoolean(String property, Boolean defaultValue) {
        String valueString = System.getProperty(property);
        if (valueString != null) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equalsIgnoreCase(valueString)) {
                return Boolean.FALSE;
            }
        }
        return defaultValue;
    }

    public static void logCacheHitOrMiss(ConfigurationCacheKey key, BehaviorConfigurationsValue value, SoftReferenceCache<ConfigurationCacheKey, BehaviorConfigurationsValue> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            if (value == null) {
                sb.append("cache miss BehaviorConfigurationsCache key=").append(key);
            } else {
                sb.append("cache hit BehaviorConfigurationsCache key=").append(key);
            }
            Set<ConfigurationCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append(" keys.");
            logger.debug((Object)sb.toString());
        }
    }

    public static void logCacheAdd(ConfigurationCacheKey key, SoftReferenceCache<ConfigurationCacheKey, BehaviorConfigurationsValue> cache) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("cache add BehaviorConfigurationsCache key=").append(key);
            Set<ConfigurationCacheKey> keys = cache.keySet();
            int setkeysCount = keys.size();
            sb.append(" , cache has ").append(setkeysCount).append("keys.");
            logger.debug((Object)sb.toString());
        }
    }

    private class BehaviorConfigurationsValue {
        OperationBehaviorConfiguration behavior;

        private BehaviorConfigurationsValue() {
        }
    }
}

