/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IBehaviorConfiguration;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IPermissionConfigurationData;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantDeclaration;
import com.ibm.team.process.common.advice.ProjectOperation;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.IProcessProviderCacheItemHandle;
import com.ibm.team.process.internal.common.ITeamConfiguration;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ConfigurationSource;
import com.ibm.team.process.internal.common.advice.PermissionSource;
import com.ibm.team.process.internal.common.advice.runtime.IDynamicActionProviderInitializer;
import com.ibm.team.process.internal.common.advice.runtime.ILicenseChecker;
import com.ibm.team.process.internal.common.advice.runtime.IPremiumLicenseChecker;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.enterprise.IProcessProvider;
import com.ibm.team.process.internal.common.impl.PermissionConfigurationData;
import com.ibm.team.process.internal.common.model.ConfigurationDataAndDeltaElementPair;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.IIterationParent;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.BehaviorRoleElement;
import com.ibm.team.process.internal.common.model.settings.ChangeEventConfiguration;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsRoleElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfiguration;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataDeltaElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.InitializationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.util.BehaviorConfigurationsCache;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.PermittedConfigurationsAndActionsCache;
import com.ibm.team.process.internal.common.util.ProcessAttachmentFilePathComparator;
import com.ibm.team.process.internal.common.util.ProcessDelta;
import com.ibm.team.process.internal.common.util.ProcessModelCache;
import com.ibm.team.process.internal.common.util.ProjectAreaProjectConfigurationData;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PremiumLicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractProcess {
    public static final String ID_ENFORCE_PROCESS_PERMISSIONS = "com.ibm.team.process.enforceProcessPermissions";
    private static final int PERMISSIONS_TYPE = 0;
    private static final int BEHAVIOR_TYPE = 1;
    private static final int CHANGE_EVENT_TYPE = 2;
    protected IProjectAreaHandle fProjectAreaHandle;
    protected IProjectArea fProjectArea;
    protected static final HashSet fgInitializingThreads = new HashSet();
    private ProcessModelCache fModelCache;
    static PermittedConfigurationsAndActionsCache fPermittedActionCache = new PermittedConfigurationsAndActionsCache();
    static BehaviorConfigurationsCache fBehaviorCache = new BehaviorConfigurationsCache();
    public static final IRole fgDefaultRole = new IRole2(){

        @Override
        public String getId() {
            return "default";
        }

        @Override
        public String getDescription() {
            return Messages.getCommonString("AbstractProcess.0");
        }

        @Override
        public int getCardinality() {
            return 0;
        }

        @Override
        public String getRoleName() {
            return Messages.getCommonString("AbstractProcess.13");
        }

        @Override
        public String getRoleLabel() {
            String label = this.getRoleName();
            if (label != null && label.trim().length() > 0) {
                return label;
            }
            return this.getId();
        }

        public boolean equals(Object other) {
            if (other instanceof IRole) {
                return this.getId().equals(((IRole)other).getId());
            }
            return false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    };
    public static final IAdvisorDeclaration[] EMPTYIADVISORDECLARATIONARRAY = new IAdvisorDeclaration[0];
    public static final IParticipantDeclaration[] EMPTYIPARTICIPANTDECLARATIONARRAY = new IParticipantDeclaration[0];
    private boolean fInternalSingleCallLicenseCheck = false;
    private boolean fInternalSingleCallLicenceCheckValue = false;
    private boolean notCheckedProjectAreaComplete = true;
    private boolean fReloadedOnceFlag = false;
    protected final IProgressMonitor NULLMONITOR = new NullProgressMonitor();
    private static final IItem[] EMPTYIITEMARRAY = new IItem[0];

    protected AbstractProcess(IProjectArea projectArea, ProcessModelCache modelCache) {
        this.fProjectArea = projectArea;
        this.fProjectAreaHandle = projectArea;
        this.fModelCache = modelCache;
    }

    protected AbstractProcess(IProjectAreaHandle projectAreaHandle, ProcessModelCache modelCache) {
        this.fProjectAreaHandle = projectAreaHandle;
        if (projectAreaHandle.hasFullState()) {
            try {
                this.fProjectArea = (IProjectArea)projectAreaHandle;
                this.fReloadedOnceFlag = false;
            }
            catch (ClassCastException c) {
                this.fProjectArea = null;
            }
        }
        this.fModelCache = modelCache;
    }

    protected abstract String createStringFromContent(IContent var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IContributorHandle getContributor();

    protected abstract CurrentIterationInfo[] getCurrentIterationInfos(IDevelopmentLine var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IItem fetchCompleteItem(IItemHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IItemHandle fetchStateHandle(IItemHandle var1) throws TeamRepositoryException;

    protected abstract IDevelopmentLine getDevelopmentLine(IProcessArea var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected IDevelopmentLine getDevelopmentLineFromProcess(IProcessAreaHandle processAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessArea processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)processAreaHandle, monitor);
        return this.getDevelopmentLine(processArea, monitor);
    }

    protected abstract OperationAdviceManager getOperationAdviceManager();

    protected abstract ILicenseChecker getLicenseChecker();

    protected abstract IPremiumLicenseChecker getPremiumLicenseChecker();

    protected abstract IProcessAttachment doGetProcessAttachment(IProcessContainer var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected abstract IItem[] fetchCompleteItems(IItemHandle[] var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IOperationReport executeInitializer(ProjectOperation initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.doExecuteInitializer(initializer, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IOperationReport doExecuteInitializer(ProjectOperation initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet hashSet;
        IOperationReport iOperationReport;
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IProjectArea projectArea = this.getInternalProjectArea();
            this.assertSameProjectArea(initializer.getProcessArea(), projectArea);
            boolean isPremiumProject = this.isPremiumProjectArea(projectArea);
            OperationBehaviorConfiguration behavior = this.getInternalInitializationBehaviorConfiguration(initializer.getOperationIdentifier(), this.newSubProgressMonitor(monitor, 50));
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap();
            HashSet hashSet2 = fgInitializingThreads;
            synchronized (hashSet2) {
                fgInitializingThreads.add(Thread.currentThread());
            }
            iOperationReport = this.getOperationAdviceManager().advise(initializer, 1, permissions, behavior, null, this.getLicenseChecker(), this.getDynamicActionInitializer(), this.newSubProgressMonitor(monitor, 950), this.getPremiumLicenseChecker(), isPremiumProject);
            hashSet = fgInitializingThreads;
        }
        catch (Throwable throwable) {
            HashSet hashSet3 = fgInitializingThreads;
            synchronized (hashSet3) {
                fgInitializingThreads.remove(Thread.currentThread());
            }
            monitor.done();
            throw throwable;
        }
        synchronized (hashSet) {
            fgInitializingThreads.remove(Thread.currentThread());
        }
        monitor.done();
        return iOperationReport;
    }

    public IOperationReport advise(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.doAdvise(operation, 0, null, monitor);
    }

    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.doAdvise(operation, 1, null, monitor);
    }

    protected IOperationReport doAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operation instanceof ProjectOperation) {
            return this.doInternalCachedProjectAdvise(operation, mode, oldReport, monitor);
        }
        return this.doInternalCachedAdvise(operation, mode, oldReport, monitor);
    }

    private IOperationReport doInternalCachedProjectAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IProjectArea projectArea = this.getInternalProjectArea();
            this.assertSameProjectArea(operation.getProcessArea(), projectArea);
            boolean isPremiumProject = this.isPremiumProjectArea(projectArea);
            IDevelopmentLine line = this.innerProjectGetOperationDevelopmentLine(projectArea, operation.getDevelopmentLine(), this.newSubProgressMonitor(monitor, 25));
            operation.setDevelopmentLine(line);
            String operationId = operation.getOperationIdentifier();
            IContributorHandle contributor = this.getContributor();
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
            IProcessProvider processProvider = this.innerGetProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
            IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
            IRole[] operationRoles = null;
            OperationBehaviorConfiguration behaviorConfig = fBehaviorCache.getBehavior(operationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null);
            if (behaviorConfig == null) {
                operationRoles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                behaviorConfig = this.getInternalStaticBehaviorConfiguration(projectArea, processProvider, operationRoles, operationId, monitor);
                fBehaviorCache.addToCache(operationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, behaviorConfig);
            }
            if (behaviorConfig != null && this.isDebugLogEnabled()) {
                this.debugLog("[doInternalCachedProjectAdvise] Behavior configuration source: {0}", behaviorConfig.getSource() == null ? "<none>" : behaviorConfig.getSource().toString());
            }
            String[] actions = operation.getActions();
            OperationPermissionsConfiguration[] permissionConfigs = null;
            if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), isPremiumProject)) {
                permissionConfigs = this.createAnyPermissions();
            } else {
                permissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, actions);
                if (permissionConfigs == null) {
                    if (operationRoles == null) {
                        operationRoles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                    }
                    permissionConfigs = operationRoles == null || operationRoles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetStaticPermissionConfigurations(projectArea, processProvider, operationRoles, operationId, actions, this.newSubProgressMonitor(monitor, 500));
                    permissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, actions, permissionConfigs, this);
                }
            }
            IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap((permissionConfigs == null ? 0 : 1) + (secondaryAreas == null ? 0 : secondaryAreas.length));
            if (permissionConfigs != null) {
                permissions.put(projectArea, permissionConfigs);
            }
            this.innerDoInternalCachedAdviseForSecondaries(contributor, projectArea, projectAreaHandle, processProvider, processProviderHandle, operation, permissions, monitor);
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, mode, permissions, behaviorConfig, oldReport, this.getLicenseChecker(), this.getDynamicActionInitializer(), this.newSubProgressMonitor(monitor, 925), this.getPremiumLicenseChecker(), isPremiumProject);
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    private IOperationReport doInternalCachedAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        IProcessArea processArea = operation.getProcessArea();
        if (processArea instanceof ITeamArea) {
            ITeamArea primaryArea = (ITeamArea)this.confirmProcessArea(processArea, projectArea, monitor);
            return this.innerCachedDoAdviseForTeam(primaryArea, projectArea, operation, mode, oldReport, monitor);
        }
        this.assertSameProjectArea(processArea, projectArea);
        return this.innerCachedDoAdviseForProject(projectArea, operation, mode, oldReport, monitor);
    }

    private IOperationReport innerCachedDoAdviseForProject(IProjectArea projectArea, AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.innerGetOperationDevelopmentLine(projectArea, operation.getDevelopmentLine(), this.newSubProgressMonitor(monitor, 25));
            operation.setDevelopmentLine(line);
            String operationId = operation.getOperationIdentifier();
            IContributorHandle contributor = this.getContributor();
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
            IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
            IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
            IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
            ITeamAreaHandle[] teamAreas = new ITeamAreaHandle[]{};
            CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
            IRole[] operationRoles = null;
            OperationBehaviorConfiguration behaviorConfig = fBehaviorCache.getBehavior(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos);
            if (behaviorConfig == null) {
                operationRoles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                behaviorConfig = operationRoles == null || operationRoles.length == 0 ? null : this.getInternalContributorBehaviorConfiguration(projectArea, processProvider, operationRoles, line, currentIterationInfos, teamAreas, operationId, monitor);
                fBehaviorCache.addToCache(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, behaviorConfig);
            }
            if (behaviorConfig != null && this.isDebugLogEnabled()) {
                this.debugLog("[innerCachedDoAdviseForProject] Behavior configuration source: {0}", behaviorConfig.getSource() == null ? "<none>" : behaviorConfig.getSource().toString());
            }
            String[] actions = operation.getActions();
            OperationPermissionsConfiguration[] permissionConfigs = null;
            boolean isPremiumProject = this.isPremiumProjectArea(projectArea);
            if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), isPremiumProject)) {
                permissionConfigs = this.createAnyPermissions();
            } else {
                permissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions);
                if (permissionConfigs == null) {
                    if (operationRoles == null) {
                        operationRoles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                    }
                    permissionConfigs = operationRoles == null || operationRoles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, operationRoles, line, currentIterationInfos, teamAreas, operationId, actions, this.newSubProgressMonitor(monitor, 900));
                    permissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions, permissionConfigs, this);
                }
            }
            IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap((permissionConfigs == null ? 0 : 1) + (secondaryAreas == null ? 0 : secondaryAreas.length));
            if (permissionConfigs != null) {
                permissions.put(projectArea, permissionConfigs);
            }
            this.innerDoInternalCachedAdviseForSecondaries(contributor, projectArea, projectAreaHandle, processProvider, processProviderHandle, operation, permissions, monitor);
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, mode, permissions, behaviorConfig, oldReport, this.getLicenseChecker(), this.getDynamicActionInitializer(), this.newSubProgressMonitor(monitor, 925), this.getPremiumLicenseChecker(), isPremiumProject);
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    private IOperationReport innerCachedDoAdviseForTeam(ITeamArea primaryArea, IProjectArea projectArea, AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.innerGetOperationDevelopmentLine(primaryArea, operation.getDevelopmentLine(), this.newSubProgressMonitor(monitor, 25));
            operation.setDevelopmentLine(line);
            String operationId = operation.getOperationIdentifier();
            IContributorHandle contributor = this.getContributor();
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
            IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
            IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
            ITeamAreaHandle startingAreaHandle = primaryArea == null ? null : (ITeamAreaHandle)primaryArea.getStateHandle();
            IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
            ITeamAreaHandle[] teamAreas = this.innerComputeTeamAreaPathArray(primaryArea, projectArea);
            CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
            IRole[] operationRoles = null;
            OperationBehaviorConfiguration behaviorConfig = fBehaviorCache.getBehavior(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos);
            if (behaviorConfig == null) {
                operationRoles = this.innerGetContributorRolesForTeam(contributor, primaryArea, projectArea, true, this.newSubProgressMonitor(monitor, 10));
                behaviorConfig = operationRoles == null || operationRoles.length == 0 ? null : this.getInternalContributorBehaviorConfiguration(projectArea, processProvider, operationRoles, line, currentIterationInfos, teamAreas, operationId, monitor);
                fBehaviorCache.addToCache(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, behaviorConfig);
            }
            if (behaviorConfig != null && this.isDebugLogEnabled()) {
                this.debugLog("[innerCachedDoAdviseForTeam] Behavior configuration source: {0}", behaviorConfig.getSource() == null ? "<none>" : behaviorConfig.getSource().toString());
            }
            String[] actions = operation.getActions();
            OperationPermissionsConfiguration[] permissionConfigs = null;
            boolean isPremiumProject = this.isPremiumProjectArea(projectArea);
            if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), isPremiumProject)) {
                permissionConfigs = this.createAnyPermissions();
            } else {
                permissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions);
                if (permissionConfigs == null) {
                    if (operationRoles == null) {
                        operationRoles = this.innerGetContributorRolesForTeam(contributor, primaryArea, projectArea, true, this.newSubProgressMonitor(monitor, 10));
                    }
                    permissionConfigs = operationRoles == null || operationRoles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, operationRoles, line, currentIterationInfos, teamAreas, operationId, actions, this.newSubProgressMonitor(monitor, 900));
                    permissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions, permissionConfigs, this);
                }
            }
            IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap((permissionConfigs == null ? 0 : 1) + (secondaryAreas == null ? 0 : secondaryAreas.length));
            if (permissionConfigs != null) {
                permissions.put(primaryArea, permissionConfigs);
            }
            this.innerDoInternalCachedAdviseForSecondaries(contributor, projectArea, projectAreaHandle, processProvider, processProviderHandle, operation, permissions, monitor);
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, mode, permissions, behaviorConfig, oldReport, this.getLicenseChecker(), this.getDynamicActionInitializer(), this.newSubProgressMonitor(monitor, 925), this.getPremiumLicenseChecker(), isPremiumProject);
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    private void innerDoInternalCachedAdviseForSecondaries(IContributorHandle contributor, IProjectArea projectArea, IProjectAreaHandle projectAreaHandle, IProcessProvider processProvider, IProcessContainerHandle processProviderHandle, AdvisableOperation operation, ItemHandleAwareHashMap permissions, IProgressMonitor monitor) throws TeamRepositoryException {
        String operationId = operation.getOperationIdentifier();
        IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
        IProgressMonitor secondaryMonitor = this.newSubProgressMonitor(monitor, 500);
        secondaryMonitor.beginTask("", 1000 * secondaryAreas.length);
        int i = 0;
        while (i < secondaryAreas.length) {
            IProcessArea secondaryProcessArea = secondaryAreas[i];
            String[] secondaryActions = operation.getSecondaryActions(secondaryProcessArea);
            if (secondaryProcessArea instanceof IProjectArea) {
                this.assertSameProjectArea(secondaryProcessArea, projectArea);
                OperationPermissionsConfiguration[] secondaryPermissionConfigs = null;
                if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
                    secondaryPermissionConfigs = this.createAnyPermissions();
                } else {
                    secondaryPermissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, secondaryActions);
                    if (secondaryPermissionConfigs == null) {
                        IRole[] secondaryOperationRoles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                        if (secondaryOperationRoles == null || secondaryOperationRoles.length == 0) {
                            secondaryPermissionConfigs = new OperationPermissionsConfiguration[]{};
                        } else {
                            IDevelopmentLine secondaryLine = this.getOperationDevelopmentLine(secondaryProcessArea, operation.getSecondaryDevelopmentLine(secondaryProcessArea), this.newSubProgressMonitor(secondaryMonitor, 250));
                            CurrentIterationInfo[] secondaryCurrentIterationInfos = secondaryLine == null ? null : this.getCurrentIterationInfos(secondaryLine, this.newSubProgressMonitor(monitor, 100));
                            ITeamAreaHandle[] secondaryTeamAreas = new ITeamAreaHandle[]{};
                            secondaryPermissionConfigs = this.innerGetPermissionConfigurations(projectArea, processProvider, secondaryOperationRoles, secondaryLine, secondaryCurrentIterationInfos, secondaryTeamAreas, operationId, secondaryActions, this.newSubProgressMonitor(monitor, 900));
                        }
                        secondaryPermissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, secondaryActions, secondaryPermissionConfigs, this);
                    }
                }
                if (secondaryPermissionConfigs != null) {
                    permissions.put(projectArea, secondaryPermissionConfigs);
                }
            } else {
                ITeamArea secondaryArea = (ITeamArea)this.confirmProcessArea(secondaryProcessArea, projectArea, monitor);
                OperationPermissionsConfiguration[] secondaryPermissionConfigs = null;
                if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
                    secondaryPermissionConfigs = this.createAnyPermissions();
                } else {
                    ITeamAreaHandle secondaryAreaHandle = secondaryArea == null ? null : (ITeamAreaHandle)secondaryArea.getStateHandle();
                    IDevelopmentLine secondaryLine = this.getOperationDevelopmentLine(secondaryArea, operation.getSecondaryDevelopmentLine(secondaryArea), this.newSubProgressMonitor(secondaryMonitor, 250));
                    IDevelopmentLineHandle secondaryLineHandle = secondaryLine == null ? null : (IDevelopmentLineHandle)secondaryLine.getStateHandle();
                    CurrentIterationInfo[] secondaryCurrentIterationInfos = secondaryLine == null ? null : this.getCurrentIterationInfos(secondaryLine, this.newSubProgressMonitor(monitor, 100));
                    ITeamAreaHandle[] secondaryTeamAreas = this.innerComputeTeamAreaPathArray(secondaryArea, projectArea);
                    secondaryPermissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, secondaryAreaHandle, secondaryTeamAreas, contributor, secondaryLineHandle, secondaryCurrentIterationInfos, secondaryActions);
                    if (secondaryPermissionConfigs == null) {
                        IRole[] secondaryOperationRoles = this.innerGetContributorRolesForTeam(contributor, secondaryArea, projectArea, true, this.newSubProgressMonitor(monitor, 10));
                        secondaryPermissionConfigs = secondaryOperationRoles == null || secondaryOperationRoles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, secondaryOperationRoles, secondaryLine, secondaryCurrentIterationInfos, secondaryTeamAreas, operationId, secondaryActions, this.newSubProgressMonitor(monitor, 900));
                        secondaryPermissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, secondaryAreaHandle, secondaryTeamAreas, contributor, secondaryLineHandle, secondaryCurrentIterationInfos, secondaryActions, secondaryPermissionConfigs, this);
                    }
                }
                if (secondaryPermissionConfigs != null) {
                    permissions.put(secondaryArea, secondaryPermissionConfigs);
                }
            }
            ++i;
        }
        secondaryMonitor.done();
    }

    protected abstract IDynamicActionProviderInitializer getDynamicActionInitializer();

    public IAdvisorDeclaration[] getAdvisorDeclarations(IBehaviorConfiguration configuration) {
        this.resetReloadProjectAreaOnce();
        return this.getInternalAdvisorDeclarations(configuration);
    }

    protected IAdvisorDeclaration[] getInternalAdvisorDeclarations(IBehaviorConfiguration configuration) {
        if (configuration instanceof OperationBehaviorConfiguration) {
            return this.getOperationAdviceManager().getAdvisorDeclarations((OperationBehaviorConfiguration)configuration);
        }
        return EMPTYIADVISORDECLARATIONARRAY;
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalAdvisorDeclarations(processArea, operationId, monitor);
    }

    protected IAdvisorDeclaration[] getInternalAdvisorDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLine(processArea, this.newSubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getInternalBehaviorConfiguration(processArea, line, operationId, this.newSubProgressMonitor(monitor, 900));
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.getInternalAdvisorDeclarations(behaviorConfiguration);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    protected IAdvisorDeclaration[] getInternalAdvisorDeclarationsForProject(String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IProjectArea projectArea = this.getInternalProjectArea();
            IDevelopmentLine line = this.getDevelopmentLine(projectArea, this.newSubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getInternalBehaviorConfiguration(projectArea, line, operationId, this.newSubProgressMonitor(monitor, 900));
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.getInternalAdvisorDeclarations(behaviorConfiguration);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    protected IAdvisorDeclaration[] getInternalAdvisorDeclarationsForTeam(IProcessAreaHandle processAreaHandle, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLineFromProcess(processAreaHandle, this.newSubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getInternalBehaviorConfiguration(processAreaHandle, line, operationId, this.newSubProgressMonitor(monitor, 900));
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.getInternalAdvisorDeclarations(behaviorConfiguration);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    protected IAdvisorDeclaration[] getInternalAdvisorDeclarationsForProcess(IProcessAreaHandle processAreaHandle, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLineFromProcess(processAreaHandle, this.newSubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getInternalBehaviorConfiguration(processAreaHandle, line, operationId, this.newSubProgressMonitor(monitor, 900));
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.getInternalAdvisorDeclarations(behaviorConfiguration);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(String projectOperationId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalAdvisorDeclarations(projectOperationId, monitor);
    }

    protected IAdvisorDeclaration[] getInternalAdvisorDeclarations(String projectOperationId, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationBehaviorConfiguration behaviorConfiguration = this.getInternalStaticBehaviorConfiguration(projectOperationId, monitor);
        return this.getInternalAdvisorDeclarations(behaviorConfiguration);
    }

    public IParticipantDeclaration[] getParticipantDeclarations(IBehaviorConfiguration configuration) {
        this.resetReloadProjectAreaOnce();
        return this.getInternalParticipantDeclarations(configuration);
    }

    protected IParticipantDeclaration[] getInternalParticipantDeclarations(IBehaviorConfiguration configuration) {
        if (configuration instanceof OperationBehaviorConfiguration) {
            return this.getOperationAdviceManager().getParticipantDeclarations((OperationBehaviorConfiguration)configuration);
        }
        return EMPTYIPARTICIPANTDECLARATIONARRAY;
    }

    public IParticipantDeclaration[] getParticipantDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalParticipantDeclarations(processArea, operationId, monitor);
    }

    protected IParticipantDeclaration[] getInternalParticipantDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLine(processArea, this.newSubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getInternalBehaviorConfiguration(processArea, line, operationId, this.newSubProgressMonitor(monitor, 900));
            IParticipantDeclaration[] iParticipantDeclarationArray = this.getInternalParticipantDeclarations(behaviorConfiguration);
            return iParticipantDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    public boolean[] getPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalPermittedActions(processArea, operationId, actions, monitor);
    }

    protected boolean[] getInternalPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalCachedPermittedActions(processArea, operationId, actions, monitor);
    }

    protected boolean[] getInternalPermittedActionsForProcess(IProcessAreaHandle processAreaHandle, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalCachedPermittedActionsForProcess(processAreaHandle, operationId, actions, monitor);
    }

    protected boolean[] getInternalPermittedActionsForProject(String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        return this.innerGetCachedPermittedActionsForProject(projectArea, operationId, actions, monitor);
    }

    protected boolean[] getInternalPermittedActionsForTeam(ITeamAreaHandle teamAreaHandle, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessAreaHandle(teamAreaHandle, projectArea, monitor);
        return this.innerGetCachedPermittedActionsForTeam(startingTeamArea, projectArea, operationId, actions, monitor);
    }

    protected boolean[] getInternalCachedPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        if (processArea instanceof ITeamArea) {
            ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessArea(processArea, projectArea, monitor);
            return this.innerGetCachedPermittedActionsForTeam(startingTeamArea, projectArea, operationId, actions, monitor);
        }
        if (processArea instanceof IProjectArea) {
            this.assertSameProjectArea(processArea, projectArea);
            return this.innerGetCachedPermittedActionsForProject(projectArea, operationId, actions, monitor);
        }
        throw new TeamRepositoryException(processArea + " is not a teamArea or ProjectArea and cannot be used in getPermittedActions");
    }

    protected boolean[] getInternalCachedPermittedActionsForProcess(IProcessAreaHandle processAreaHandle, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        if (processAreaHandle instanceof ITeamAreaHandle) {
            ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessAreaHandle(processAreaHandle, projectArea, monitor);
            return this.innerGetCachedPermittedActionsForTeam(startingTeamArea, projectArea, operationId, actions, monitor);
        }
        if (processAreaHandle instanceof IProjectAreaHandle) {
            this.confirmProcessAreaHandle(processAreaHandle, projectArea, monitor);
            return this.innerGetCachedPermittedActionsForProject(projectArea, operationId, actions, monitor);
        }
        throw new TeamRepositoryException(processAreaHandle + " is not a teamArea or ProjectArea and cannot be used in getPermittedActions");
    }

    protected boolean[] innerGetCachedPermittedActionsForTeam(ITeamArea teamArea, IProjectArea projectArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        IProcessAreaHandle startingAreaHandle = teamArea == null ? null : (IProcessAreaHandle)teamArea.getStateHandle();
        IDevelopmentLine line = this.getDevelopmentLine(teamArea, this.newSubProgressMonitor(monitor, 100));
        IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
        CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
        ITeamAreaHandle[] teamAreas = this.innerComputeTeamAreaPathArray(teamArea, projectArea);
        IContributorHandle contributor = this.getContributor();
        boolean[] permitted = null;
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            permitted = PermittedConfigurationsAndActionsCache.calculatePermittedActions(this.createAnyPermissions(), actions);
        } else {
            permitted = fPermittedActionCache.getPermittedActions(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions);
            if (permitted == null) {
                OperationPermissionsConfiguration[] permissionConfigs = null;
                IRole[] roles = this.innerGetContributorRolesForTeam(contributor, teamArea, projectArea, true, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = roles == null || roles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, roles, line, currentIterationInfos, teamAreas, operationId, actions, this.newSubProgressMonitor(monitor, 900));
                permitted = fPermittedActionCache.addToCacheAndGetPermittedActions(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions, permissionConfigs);
            }
        }
        return permitted;
    }

    protected boolean[] innerGetCachedPermittedActionsForProject(IProjectArea projectArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        IDevelopmentLine line = this.getDevelopmentLine(projectArea, this.newSubProgressMonitor(monitor, 100));
        IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
        CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
        ITeamAreaHandle[] teamAreas = new ITeamAreaHandle[]{};
        IContributorHandle contributor = this.getContributor();
        boolean[] permitted = null;
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            permitted = PermittedConfigurationsAndActionsCache.calculatePermittedActions(this.createAnyPermissions(), actions);
        } else {
            permitted = fPermittedActionCache.getPermittedActions(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions);
            if (permitted == null) {
                OperationPermissionsConfiguration[] permissionConfigs = null;
                IRole[] roles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = roles == null || roles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, roles, line, currentIterationInfos, teamAreas, operationId, actions, this.newSubProgressMonitor(monitor, 900));
                permitted = fPermittedActionCache.addToCacheAndGetPermittedActions(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions, permissionConfigs);
            }
        }
        return permitted;
    }

    public boolean[] getPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalPermittedActions(projectOperationId, actions, monitor);
    }

    protected boolean[] getInternalPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalCachedPermittedActions(projectOperationId, actions, monitor);
    }

    protected boolean[] getInternalCachedPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle contributor = this.getContributor();
        IProjectArea projectArea = this.getInternalProjectArea();
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        boolean[] permitted = null;
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            permitted = PermittedConfigurationsAndActionsCache.calculatePermittedActions(this.createAnyPermissions(), actions);
        } else {
            permitted = fPermittedActionCache.getPermittedActions(projectOperationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, actions);
            if (permitted == null) {
                OperationPermissionsConfiguration[] permissionConfigs = null;
                IRole[] roles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = roles == null || roles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetStaticPermissionConfigurations(projectArea, processProvider, roles, projectOperationId, actions, this.newSubProgressMonitor(monitor, 500));
                permitted = fPermittedActionCache.addToCacheAndGetPermittedActions(projectOperationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, actions, permissionConfigs);
            }
        }
        return permitted;
    }

    protected ISimpleMap getPermissionsMap(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            OperationPermissionsConfiguration[] permissionConfigs;
            IProjectArea projectArea = this.getInternalProjectArea();
            String operationId = operation.getOperationIdentifier();
            if (operation instanceof ProjectOperation) {
                permissionConfigs = this.getInternalStaticPermissionConfigurations(projectArea, operation.getOperationIdentifier(), operation.getActions(), this.newSubProgressMonitor(monitor, 500));
            } else {
                IProcessArea primaryArea = this.confirmProcessArea(operation.getProcessArea(), projectArea, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = this.getInternalPermissionConfigurations(primaryArea, operation.getDevelopmentLine(), operationId, operation.getActions(), this.newSubProgressMonitor(monitor, 250));
            }
            IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap((permissionConfigs == null ? 0 : 1) + (secondaryAreas == null ? 0 : secondaryAreas.length));
            if (permissionConfigs != null) {
                permissions.put(projectArea, permissionConfigs);
            }
            if (secondaryAreas != null) {
                IProgressMonitor secondaryMonitor = this.newSubProgressMonitor(monitor, 500);
                secondaryMonitor.beginTask("", 1000 * secondaryAreas.length);
                int i = 0;
                while (i < secondaryAreas.length) {
                    IProcessArea secondaryArea = this.confirmProcessArea(secondaryAreas[i], this.newSubProgressMonitor(secondaryMonitor, 10));
                    String[] secondaryActions = operation.getSecondaryActions(secondaryArea);
                    IDevelopmentLine secondaryLine = this.getOperationDevelopmentLine(secondaryArea, operation.getSecondaryDevelopmentLine(secondaryArea), this.newSubProgressMonitor(secondaryMonitor, 250));
                    permissionConfigs = this.getInternalPermissionConfigurations(secondaryArea, secondaryLine, operationId, secondaryActions, this.newSubProgressMonitor(secondaryMonitor, 750));
                    if (permissionConfigs != null) {
                        permissions.put(secondaryArea, permissionConfigs);
                    }
                    ++i;
                }
            }
            ItemHandleAwareHashMap itemHandleAwareHashMap = permissions;
            return itemHandleAwareHashMap;
        }
        finally {
            monitor.done();
        }
    }

    public IProcessConfigurationData getProjectConfigurationData(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalProjectConfigurationData(configPointId, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProcessConfigurationData getInternalProjectConfigurationData(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        ConfigurationDataElement effectiveConfigurationData = null;
        try {
            IProjectArea projectArea = this.getInternalProjectArea();
            IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 200));
            ProjectAreaProjectConfigurationData data = ProjectAreaProjectConfigurationData.getInstance(projectArea, processProvider);
            effectiveConfigurationData = data.getConfigurationData(configPointId);
            if (effectiveConfigurationData == null) {
                ProjectAreaProjectConfigurationData projectAreaProjectConfigurationData = data;
                synchronized (projectAreaProjectConfigurationData) {
                    effectiveConfigurationData = data.getConfigurationData(configPointId);
                    if (effectiveConfigurationData == null) {
                        ConfigurationDataAndDeltaElementPair dataAndDeltaPair;
                        ConfigurationDataElement providerData = null;
                        ConfigurationDataDeltaElement providerDelta = null;
                        if (processProvider != null) {
                            dataAndDeltaPair = this.getProjectConfigurationDataAndDeltaPair(processProvider, configPointId, this.newSubProgressMonitor(monitor, 100));
                            providerData = dataAndDeltaPair.configurationData;
                            providerDelta = dataAndDeltaPair.configurationDataDelta;
                        } else {
                            monitor.worked(200);
                        }
                        dataAndDeltaPair = this.getProjectConfigurationDataAndDeltaPair(projectArea, configPointId, this.newSubProgressMonitor(monitor, 100));
                        ConfigurationDataElement consumerData = dataAndDeltaPair.configurationData;
                        ConfigurationDataDeltaElement consumerDelta = dataAndDeltaPair.configurationDataDelta;
                        this.startLoggingDeltaConfigMerge(consumerDelta);
                        effectiveConfigurationData = ProcessDelta.computeEffectiveConfigurationData(providerData, providerDelta, consumerData, consumerDelta);
                        this.finishLoggingDeltaConfigMerge(consumerDelta);
                        data.setConfigurationData(configPointId, effectiveConfigurationData);
                    }
                }
            }
            if (effectiveConfigurationData == ConfigurationDataElement.NULLREPRESENTATION) {
                effectiveConfigurationData = null;
            }
            ConfigurationDataElement configurationDataElement = effectiveConfigurationData;
            return configurationDataElement;
        }
        finally {
            monitor.done();
        }
    }

    protected void startLoggingDeltaConfigMerge(ConfigurationDataDeltaElement consumerDelta) {
    }

    protected void finishLoggingDeltaConfigMerge(ConfigurationDataDeltaElement consumerDelta) {
    }

    protected boolean isDebugLogEnabled() {
        return false;
    }

    protected void debugLog(String message, Object ... bindings) {
    }

    protected ConfigurationDataDeltaElement getProjectConfigurationDataDelta(IProcessContainer processContainer, String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        DataElement data;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        IContent content = (IContent)processContainer.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(processContainer, content, null, null, monitor)).getProjectConfiguration()) != null && (data = projectConfiguration.getData()) != null) {
            return data.getConfigurationDataDelta(configPointId);
        }
        return null;
    }

    protected ConfigurationDataElement getProjectConfigurationData(IProcessContainer processContainer, String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        DataElement data;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        IContent content = (IContent)processContainer.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(processContainer, content, null, null, monitor)).getProjectConfiguration()) != null && (data = projectConfiguration.getData()) != null) {
            return data.getConfigurationData(configPointId);
        }
        return null;
    }

    private ConfigurationDataAndDeltaElementPair getProjectConfigurationDataAndDeltaPair(IProcessContainer processContainer, String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        DataElement data;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        IContent content = (IContent)processContainer.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(processContainer, content, null, null, monitor)).getProjectConfiguration()) != null && (data = projectConfiguration.getData()) != null) {
            ConfigurationDataAndDeltaElementPair dataAndDeltaPair = data.getProjectConfigurationDataAndDeltaPair(configPointId);
            if (dataAndDeltaPair == null) {
                return new ConfigurationDataAndDeltaElementPair();
            }
            return dataAndDeltaPair;
        }
        return new ConfigurationDataAndDeltaElementPair();
    }

    protected ProcessSpecificationModel getSpecificationModel(IProcessContainer processContainer, IContent content, final IDevelopmentLine line, final CurrentIterationInfo[] currentIterationInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = (ProcessSpecificationModel)this.fModelCache.get(processContainer, content, line, currentIterationInfos);
        if (model == null) {
            Exception exception;
            model = new ProcessSpecificationModel(){

                @Override
                protected ModelGenerator createModelGenerator() {
                    ModelGenerator generator = super.createModelGenerator();
                    generator.setDirective(ElementBuilderDirectives.DEVELOPMENT_LINE, line);
                    generator.setDirective(ElementBuilderDirectives.ITERATION_PATH_INFOS, currentIterationInfos);
                    return generator;
                }
            };
            if (content != null && (exception = model.initialize(this.createStringFromContent(content, monitor))) != null) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.fModelCache.put(processContainer, content, line, currentIterationInfos, model);
        }
        return model;
    }

    protected TeamCustomizationModel getCustomizationModel(ITeamArea teamArea, IContent content, final IDevelopmentLine line, final CurrentIterationInfo[] currentIterationInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = (TeamCustomizationModel)this.fModelCache.get(teamArea, content, line, currentIterationInfos);
        if (model == null) {
            Exception exception;
            model = new TeamCustomizationModel(){

                @Override
                protected ModelGenerator createModelGenerator() {
                    ModelGenerator generator = super.createModelGenerator();
                    generator.setDirective(ElementBuilderDirectives.DEVELOPMENT_LINE, line);
                    generator.setDirective(ElementBuilderDirectives.ITERATION_PATH_INFOS, currentIterationInfos);
                    return generator;
                }
            };
            if (content != null && (exception = model.initialize(this.createStringFromContent(content, monitor))) != null) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.fModelCache.put(teamArea, content, line, currentIterationInfos, model);
        }
        return model;
    }

    public OperationBehaviorConfiguration getStaticBehaviorConfiguration(IProjectArea projectArea, String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalStaticBehaviorConfiguration(projectArea, operationIdentifier, monitor);
    }

    protected OperationBehaviorConfiguration getInternalStaticBehaviorConfiguration(IProjectArea projectArea, String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea innerProjectArea = this.getInternalProjectArea();
        this.assertSameProjectArea(projectArea, innerProjectArea);
        return this.getInternalStaticBehaviorConfiguration(operationIdentifier, monitor);
    }

    protected OperationBehaviorConfiguration getInternalStaticBehaviorConfiguration(String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalCachedStaticBehaviorConfiguration(operationIdentifier, monitor);
    }

    private OperationBehaviorConfiguration getInternalCachedStaticBehaviorConfiguration(String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessProvider processProvider;
        IProcessContainerHandle processProviderStateHandle;
        IContributorHandle contributor = this.getContributor();
        IProjectArea projectArea = this.getInternalProjectArea();
        IProjectAreaHandle projectAreaStateHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        OperationBehaviorConfiguration behaviorConfig = fBehaviorCache.getBehavior(operationIdentifier, projectAreaStateHandle, processProviderStateHandle = (processProvider = this.getInternalProcessProvider(this.newSubProgressMonitor(monitor, 100))) == null ? null : (IProcessContainerHandle)processProvider.getStateHandle(), null, null, contributor, null, null);
        if (behaviorConfig == null) {
            IRole[] operationRoles = this.getInternalContributorRoles(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
            behaviorConfig = this.getInternalStaticBehaviorConfiguration(projectArea, processProvider, operationRoles, operationIdentifier, monitor);
            fBehaviorCache.addToCache(operationIdentifier, projectAreaStateHandle, processProviderStateHandle, null, null, contributor, null, null, behaviorConfig);
        }
        return behaviorConfig;
    }

    protected OperationBehaviorConfiguration getInternalStaticBehaviorConfiguration(IRole[] projectRoles, String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        ProcessSpecificationModel model2;
        ProjectConfigurationElement projectConfiguration2;
        IContent content;
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.1"), 1000);
        OperationBehaviorConfiguration operation = null;
        if (projectRoles == null || projectRoles.length == 0) {
            return operation;
        }
        IProjectArea projectArea = this.getInternalProjectArea();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        if (processProvider != null && (content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml")) != null && (projectConfiguration2 = (model2 = this.getSpecificationModel(processProvider, content, null, null, this.newSubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null) {
            int i = 0;
            while (i < projectRoles.length) {
                IRole role = projectRoles[i];
                String roleId = role.getId();
                operation = AbstractProcess.getBehaviorOperation(projectConfiguration2.getBehavior(), roleId, operationIdentifier);
                if (operation != null) {
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    if (processProvider instanceof IProcessArea) {
                        source.setSourceArea((IProcessArea)((Object)processProvider));
                    }
                    source.setSourceAreaItemUuid(processProvider.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(((IRole2)role).getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    if (operation.isFinal()) {
                        return operation;
                    }
                }
                ++i;
            }
        }
        OperationBehaviorConfiguration projectAreaOperation = null;
        IContent content2 = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content2 != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content2, null, null, this.newSubProgressMonitor(monitor, 200))).getProjectConfiguration()) != null) {
            int i = 0;
            while (i < projectRoles.length) {
                IRole role = projectRoles[i];
                String roleId = role.getId();
                projectAreaOperation = AbstractProcess.getBehaviorOperation(projectConfiguration.getBehavior(), roleId, operationIdentifier);
                if (projectAreaOperation != null) {
                    operation = projectAreaOperation;
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    source.setSourceArea(projectArea);
                    source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(((IRole2)role).getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content2.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    return operation;
                }
                ++i;
            }
        }
        return operation;
    }

    private OperationBehaviorConfiguration getInternalStaticBehaviorConfiguration(IProjectArea projectArea, IProcessProvider processProvider, IRole[] projectRoles, String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        ProcessSpecificationModel model2;
        ProjectConfigurationElement projectConfiguration2;
        IContent content;
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.1"), 1000);
        OperationBehaviorConfiguration operation = null;
        if (projectRoles == null || projectRoles.length == 0) {
            return operation;
        }
        if (processProvider != null && (content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml")) != null && (projectConfiguration2 = (model2 = this.getSpecificationModel(processProvider, content, null, null, this.newSubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null) {
            int i = 0;
            while (i < projectRoles.length) {
                IRole role = projectRoles[i];
                String roleId = role.getId();
                operation = AbstractProcess.getBehaviorOperation(projectConfiguration2.getBehavior(), roleId, operationIdentifier);
                if (operation != null) {
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    if (processProvider instanceof IProcessArea) {
                        source.setSourceArea((IProcessArea)((Object)processProvider));
                    }
                    source.setSourceAreaItemUuid(processProvider.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(((IRole2)role).getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    if (operation.isFinal()) {
                        return operation;
                    }
                }
                ++i;
            }
        }
        OperationBehaviorConfiguration projectAreaOperation = null;
        IContent content2 = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content2 != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content2, null, null, this.newSubProgressMonitor(monitor, 200))).getProjectConfiguration()) != null) {
            int i = 0;
            while (i < projectRoles.length) {
                IRole role = projectRoles[i];
                String roleId = role.getId();
                projectAreaOperation = AbstractProcess.getBehaviorOperation(projectConfiguration.getBehavior(), roleId, operationIdentifier);
                if (projectAreaOperation != null) {
                    operation = projectAreaOperation;
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    source.setSourceArea(projectArea);
                    source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(((IRole2)role).getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content2.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    return operation;
                }
                ++i;
            }
        }
        return operation;
    }

    protected ChangeEventConfiguration getStaticChangeEventConfiguration(IProjectArea projectArea, String eventId, IProgressMonitor monitor) throws TeamRepositoryException {
        ChangeEventConfiguration projectAreaConfiguration;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        ProcessSpecificationModel model2;
        ProjectConfigurationElement projectConfiguration2;
        IContent content;
        projectArea = (IProjectArea)this.fetchCurrentCallCompleteItem((IItemHandle)projectArea, monitor);
        this.assertSameProjectArea(projectArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.2"), 1000);
        ChangeEventConfiguration configuration = null;
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 200));
        if (processProvider != null && (content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml")) != null && (projectConfiguration2 = (model2 = this.getSpecificationModel(processProvider, content, null, null, this.newSubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null && (configuration = AbstractProcess.getChangeEvent(projectConfiguration2.getBehavior(), eventId)) != null && configuration.isFinal()) {
            return configuration;
        }
        IContent content2 = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content2 != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content2, null, null, this.newSubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null && (projectAreaConfiguration = AbstractProcess.getChangeEvent(projectConfiguration.getBehavior(), eventId)) != null) {
            return projectAreaConfiguration;
        }
        return configuration;
    }

    public OperationPermissionsConfiguration[] getStaticPermissionConfigurations(IProjectArea projectArea, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalStaticPermissionConfigurations(projectArea, operationIdentifier, actions, monitor);
    }

    protected OperationPermissionsConfiguration[] getInternalStaticPermissionConfigurations(IProjectArea projectArea, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea innerProjectArea = this.getInternalProjectArea();
        this.assertSameProjectArea(projectArea, innerProjectArea);
        return this.innerGetStaticPermissionConfigurations(this.getContributor(), projectArea, operationIdentifier, actions, monitor);
    }

    private OperationPermissionsConfiguration[] innerGetStaticPermissionConfigurations(IContributorHandle contributor, IProjectArea projectArea, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            return this.createAnyPermissions();
        }
        IRole[] roles = this.innerGetContributorRolesForProject(contributor, projectArea, monitor);
        if (roles == null || roles.length == 0) {
            return new OperationPermissionsConfiguration[0];
        }
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        return this.innerGetStaticPermissionConfigurations(projectArea, processProvider, roles, operationIdentifier, actions, monitor);
    }

    /*
     * Unable to fully structure code
     */
    private OperationPermissionsConfiguration[] innerGetStaticPermissionConfigurations(IProjectArea projectArea, IProcessProvider processProvider, IRole[] projectRoles, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.3"), 1000);
        permissionConfigurations = new ArrayList<OperationPermissionsConfiguration>();
        roleConfigurations = new ArrayList<OperationPermissionsConfiguration>();
        try {
            remainingActions = new ArrayList<String>(actions.length);
            i = 0;
            while (i < actions.length) {
                remainingActions.add(actions[i]);
                ++i;
            }
            providerDataLoaded = false;
            processProviderSpecificationPermissions = null;
            processProviderSpecificationContent = null;
            projectAreaLoaded = false;
            projectAreaSpecificationPermissions = null;
            projectAreaSpecificationContent = null;
            operation = null;
            projectAreaOperation = null;
            i = 0;
            while (i < projectRoles.length) {
                role = projectRoles[i];
                roleId = role.getId();
                if (processProvider != null && !providerDataLoaded) {
                    processProviderProcessDataMap = processProvider == null ? null : processProvider.getProcessData();
                    processProviderSpecificationContent = processProviderProcessDataMap == null ? null : (IContent)processProviderProcessDataMap.get("com.ibm.team.internal.process.40.compiled.xml");
                    processProviderSpecificationModel = processProviderSpecificationContent == null ? null : this.getSpecificationModel(processProvider, processProviderSpecificationContent, null, null, this.newSubProgressMonitor(monitor, 150));
                    processProviderSpecificationConfiguration = processProviderSpecificationModel == null ? null : processProviderSpecificationModel.getProjectConfiguration();
                    processProviderSpecificationPermissions = processProviderSpecificationConfiguration == null ? null : processProviderSpecificationConfiguration.getPermissions();
                    providerDataLoaded = true;
                }
                if (processProviderSpecificationPermissions == null || (operation = AbstractProcess.getPermissionOperation(processProviderSpecificationPermissions, roleId, operationIdentifier)) == null) ** GOTO lbl-1000
                source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                source.setSourceArea(null);
                source.setSourceAreaItemUuid(processProvider.getItemId().getUuidValue());
                source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                if (role instanceof IRole2) {
                    source.setRoleId(((IRole2)role).getRoleLabel());
                } else {
                    source.setRoleId(roleId);
                }
                source.setContentUuid(processProviderSpecificationContent.getContentId().getUuidValue());
                operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                if (operation.isFinal()) {
                    roleConfigurations.add(operation);
                    permitted = this.getPermittedActions(remainingActions, operation);
                    if (permitted.size() > 0) {
                        remainingActions.removeAll(permitted);
                        source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                        permissionConfigurations.add(operation);
                    }
                    if (remainingActions.size() == 0) {
                        var25_24 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                        return var25_24;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (!projectAreaLoaded) {
                        projectAreaProcessDataMap = projectArea == null ? null : projectArea.getProcessData();
                        projectAreaSpecificationContent = projectAreaProcessDataMap == null ? null : (IContent)projectAreaProcessDataMap.get("com.ibm.team.internal.process.40.compiled.xml");
                        projectAreaSpecificationModel = projectAreaSpecificationContent == null ? null : this.getSpecificationModel(projectArea, projectAreaSpecificationContent, null, null, this.newSubProgressMonitor(monitor, 150));
                        projectAreaSpecificationConfiguration = projectAreaSpecificationModel == null ? null : projectAreaSpecificationModel.getProjectConfiguration();
                        projectAreaSpecificationPermissions = projectAreaSpecificationConfiguration == null ? null : projectAreaSpecificationConfiguration.getPermissions();
                        projectAreaLoaded = true;
                    }
                    if (projectAreaSpecificationPermissions != null && (projectAreaOperation = AbstractProcess.getPermissionOperation(projectAreaSpecificationPermissions, roleId, operationIdentifier)) != null) {
                        operation = projectAreaOperation;
                        source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                        source.setSourceArea(projectArea);
                        source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                        source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                        if (role instanceof IRole2) {
                            source.setRoleId(((IRole2)role).getRoleLabel());
                        } else {
                            source.setRoleId(roleId);
                        }
                        source.setContentUuid(projectAreaSpecificationContent.getContentId().getUuidValue());
                        operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                        roleConfigurations.add(operation);
                        permitted = this.getPermittedActions(remainingActions, operation);
                        if (permitted.size() > 0) {
                            remainingActions.removeAll(permitted);
                            source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            var25_25 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var25_25;
                        }
                    }
                    if (operation != null) {
                        if (!operation.isFinal()) {
                            roleConfigurations.add(operation);
                        }
                        if ((permitted = this.getPermittedActions(remainingActions, operation)).size() > 0) {
                            ((PermissionSource)operation.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            var25_26 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var25_26;
                        }
                    }
                }
                ++i;
            }
            if (remainingActions.size() == 0) {
                var25_27 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                return var25_27;
            }
            var25_28 = roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
            return var25_28;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected OperationPermissionsConfiguration[] getInternalStaticPermissionConfigurations(IRole[] projectRoles, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.3"), 1000);
        permissionConfigurations = new ArrayList<OperationPermissionsConfiguration>();
        roleConfigurations = new ArrayList<OperationPermissionsConfiguration>();
        try {
            remainingActions = new ArrayList<String>(actions.length);
            i = 0;
            while (i < actions.length) {
                remainingActions.add(actions[i]);
                ++i;
            }
            providerDataLoaded = false;
            processProviderSpecificationPermissions = null;
            processProviderSpecificationContent = null;
            projectArea = this.getInternalProjectArea();
            processProvider = this.getInternalProcessProvider(this.newSubProgressMonitor(monitor, 100));
            projectAreaLoaded = false;
            projectAreaSpecificationPermissions = null;
            projectAreaSpecificationContent = null;
            operation = null;
            projectAreaOperation = null;
            i = 0;
            while (i < projectRoles.length) {
                role = projectRoles[i];
                roleId = role.getId();
                if (processProvider != null && !providerDataLoaded) {
                    processProviderProcessDataMap = processProvider == null ? null : processProvider.getProcessData();
                    processProviderSpecificationContent = processProviderProcessDataMap == null ? null : (IContent)processProviderProcessDataMap.get("com.ibm.team.internal.process.40.compiled.xml");
                    processProviderSpecificationModel = processProviderSpecificationContent == null ? null : this.getSpecificationModel(processProvider, processProviderSpecificationContent, null, null, this.newSubProgressMonitor(monitor, 150));
                    processProviderSpecificationConfiguration = processProviderSpecificationModel == null ? null : processProviderSpecificationModel.getProjectConfiguration();
                    processProviderSpecificationPermissions = processProviderSpecificationConfiguration == null ? null : processProviderSpecificationConfiguration.getPermissions();
                    providerDataLoaded = true;
                }
                if (processProviderSpecificationPermissions == null || (operation = AbstractProcess.getPermissionOperation(processProviderSpecificationPermissions, roleId, operationIdentifier)) == null) ** GOTO lbl-1000
                source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                source.setSourceArea(null);
                source.setSourceAreaItemUuid(processProvider.getItemId().getUuidValue());
                source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                if (role instanceof IRole2) {
                    source.setRoleId(((IRole2)role).getRoleLabel());
                } else {
                    source.setRoleId(roleId);
                }
                source.setContentUuid(processProviderSpecificationContent.getContentId().getUuidValue());
                operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                if (operation.isFinal()) {
                    roleConfigurations.add(operation);
                    permitted = this.getPermittedActions(remainingActions, operation);
                    if (permitted.size() > 0) {
                        remainingActions.removeAll(permitted);
                        source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                        permissionConfigurations.add(operation);
                    }
                    if (remainingActions.size() == 0) {
                        var25_24 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                        return var25_24;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (!projectAreaLoaded) {
                        projectAreaProcessDataMap = projectArea == null ? null : projectArea.getProcessData();
                        projectAreaSpecificationContent = projectAreaProcessDataMap == null ? null : (IContent)projectAreaProcessDataMap.get("com.ibm.team.internal.process.40.compiled.xml");
                        projectAreaSpecificationModel = projectAreaSpecificationContent == null ? null : this.getSpecificationModel(projectArea, projectAreaSpecificationContent, null, null, this.newSubProgressMonitor(monitor, 150));
                        projectAreaSpecificationConfiguration = projectAreaSpecificationModel == null ? null : projectAreaSpecificationModel.getProjectConfiguration();
                        projectAreaSpecificationPermissions = projectAreaSpecificationConfiguration == null ? null : projectAreaSpecificationConfiguration.getPermissions();
                        projectAreaLoaded = true;
                    }
                    if (projectAreaSpecificationPermissions != null && (projectAreaOperation = AbstractProcess.getPermissionOperation(projectAreaSpecificationPermissions, roleId, operationIdentifier)) != null) {
                        operation = projectAreaOperation;
                        source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                        source.setSourceArea(projectArea);
                        source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                        source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                        if (role instanceof IRole2) {
                            source.setRoleId(((IRole2)role).getRoleLabel());
                        } else {
                            source.setRoleId(roleId);
                        }
                        source.setContentUuid(projectAreaSpecificationContent.getContentId().getUuidValue());
                        operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                        roleConfigurations.add(operation);
                        permitted = this.getPermittedActions(remainingActions, operation);
                        if (permitted.size() > 0) {
                            remainingActions.removeAll(permitted);
                            source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            var25_25 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var25_25;
                        }
                    }
                    if (operation != null) {
                        if (!operation.isFinal()) {
                            roleConfigurations.add(operation);
                        }
                        if ((permitted = this.getPermittedActions(remainingActions, operation)).size() > 0) {
                            ((PermissionSource)operation.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            var25_26 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var25_26;
                        }
                    }
                }
                ++i;
            }
            if (remainingActions.size() == 0) {
                var25_27 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                return var25_27;
            }
            var25_28 = roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
            return var25_28;
        }
        finally {
            monitor.done();
        }
    }

    protected OperationBehaviorConfiguration getBehaviorConfiguration(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operation instanceof ProjectOperation) {
            this.assertSameProjectArea(operation.getProcessArea());
            return this.getInternalStaticBehaviorConfiguration(operation.getOperationIdentifier(), monitor);
        }
        return this.getInternalBehaviorConfiguration(operation.getProcessArea(), operation.getDevelopmentLine(), operation.getOperationIdentifier(), monitor);
    }

    protected OperationBehaviorConfiguration getInternalContributorBehaviorConfiguration(AdvisableOperation operation, IRole[] operationRoles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalCachedBehaviorConfiguration(operation, operationRoles, monitor);
    }

    protected OperationBehaviorConfiguration getInternalCachedBehaviorConfiguration(AdvisableOperation operation, IRole[] operationRoles, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationBehaviorConfiguration behavior = null;
        String operationId = operation.getOperationIdentifier();
        IProjectArea projectArea = null;
        IProjectAreaHandle projectAreaHandle = null;
        IProcessProvider processProvider = null;
        IProcessContainerHandle processProviderHandle = null;
        if (operation instanceof ProjectOperation) {
            projectArea = (IProjectArea)operation.getProcessArea();
            projectAreaHandle = (IProjectAreaHandle)(projectArea = (IProjectArea)this.confirmProcessArea(projectArea, monitor)).getStateHandle();
            behavior = fBehaviorCache.getBehavior(operationId, projectAreaHandle, processProviderHandle = (processProvider = this.getInternalProcessProvider(this.newSubProgressMonitor(monitor, 100))) == null ? null : (IProcessContainerHandle)processProvider.getStateHandle(), null, null, this.getContributor(), null, null);
            if (behavior == null) {
                behavior = this.getInternalStaticBehaviorConfiguration(projectArea, processProvider, operationRoles, operationId, monitor);
                fBehaviorCache.addToCache(operationId, projectAreaHandle, processProviderHandle, null, null, this.getContributor(), null, null, behavior);
            }
        } else {
            IProcessArea processArea = operation.getProcessArea();
            processArea = this.confirmProcessArea(processArea, monitor);
            projectArea = this.getInternalProjectArea();
            projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
            processProvider = this.getInternalProcessProvider(this.newSubProgressMonitor(monitor, 100));
            processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
            IProcessAreaHandle startingAreaHandle = processArea == null ? null : (IProcessAreaHandle)processArea.getStateHandle();
            IDevelopmentLine line = operation.getDevelopmentLine();
            IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
            CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
            ITeamAreaHandle[] teamAreas = this.computeTeamAreaPathArray(processArea);
            behavior = fBehaviorCache.getBehavior(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, this.getContributor(), lineHandle, currentIterationInfos);
            if (behavior == null) {
                behavior = this.getInternalContributorBehaviorConfiguration(projectArea, processProvider, operationRoles, line, currentIterationInfos, teamAreas, operationId, monitor);
                fBehaviorCache.addToCache(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, this.getContributor(), lineHandle, currentIterationInfos, behavior);
            }
        }
        return behavior;
    }

    public OperationBehaviorConfiguration getBehaviorConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalBehaviorConfiguration(startingArea, developmentLine, operationId, monitor);
    }

    protected OperationBehaviorConfiguration getInternalBehaviorConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        startingArea = this.confirmProcessArea(startingArea, monitor);
        return this.getInternalCachedBehaviorConfiguration(startingArea, developmentLine, operationId, monitor);
    }

    protected OperationBehaviorConfiguration getInternalBehaviorConfiguration(IProcessAreaHandle startingAreaHandle, IDevelopmentLine developmentLine, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessArea startingArea = this.confirmProcessAreaHandle(startingAreaHandle, monitor);
        return this.getInternalCachedBehaviorConfiguration(startingArea, developmentLine, operationId, monitor);
    }

    protected OperationBehaviorConfiguration getInternalCachedBehaviorConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle contributor = this.getContributor();
        IProjectArea projectArea = this.getInternalProjectArea();
        IProjectAreaHandle projectAreaStateHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderStateHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        IProcessAreaHandle startingAreaStateHandle = startingArea == null ? null : (IProcessAreaHandle)startingArea.getStateHandle();
        IDevelopmentLineHandle lineStateHandle = developmentLine == null ? null : (IDevelopmentLineHandle)developmentLine.getStateHandle();
        CurrentIterationInfo[] currentIterationInfos = developmentLine == null ? null : this.getCurrentIterationInfos(developmentLine, this.newSubProgressMonitor(monitor, 100));
        ITeamAreaHandle[] teamAreas = this.computeTeamAreaPathArray(startingArea);
        OperationBehaviorConfiguration behavior = fBehaviorCache.getBehavior(operationId, projectAreaStateHandle, processProviderStateHandle, startingAreaStateHandle, teamAreas, contributor, lineStateHandle, currentIterationInfos);
        if (behavior == null) {
            IRole[] roles = this.getInternalContributorRoles(contributor, startingArea, this.newSubProgressMonitor(monitor, 10));
            if (roles == null || roles.length == 0) {
                return null;
            }
            behavior = this.getInternalContributorBehaviorConfiguration(projectArea, processProvider, roles, developmentLine, currentIterationInfos, teamAreas, operationId, monitor);
            fBehaviorCache.addToCache(operationId, projectAreaStateHandle, processProviderStateHandle, startingAreaStateHandle, teamAreas, contributor, lineStateHandle, currentIterationInfos, behavior);
        }
        return behavior;
    }

    protected OperationBehaviorConfiguration getInternalContributorBehaviorConfiguration(IProcessArea startingArea, IRole[] operationRoles, IDevelopmentLine developmentLine, CurrentIterationInfo[] currentIterationInfos, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (OperationBehaviorConfiguration)this.getInternalBehaviorOrEventConfiguration(startingArea, operationRoles, developmentLine, currentIterationInfos, operationId, 1, monitor);
    }

    protected OperationBehaviorConfiguration getInternalContributorBehaviorConfiguration(IProjectArea projectArea, IProcessProvider processProvider, IRole[] operationRoles, IDevelopmentLine developmentLine, CurrentIterationInfo[] currentIterationInfos, ITeamAreaHandle[] teamAreas, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (OperationBehaviorConfiguration)this.getInternalBehaviorOrEventConfiguration(projectArea, processProvider, operationRoles, developmentLine, currentIterationInfos, teamAreas, operationId, 1, monitor);
    }

    protected ChangeEventConfiguration getChangeEventConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String eventId) throws TeamRepositoryException {
        return (ChangeEventConfiguration)this.getInternalBehaviorOrEventConfiguration(startingArea, developmentLine, eventId, 2, null);
    }

    public ProcessConfiguration getBehaviorOrEventConfiguration(IProcessArea startingArea, IDevelopmentLine line, String configurationId, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalBehaviorOrEventConfiguration(startingArea, line, configurationId, configurationType, monitor);
    }

    protected ProcessConfiguration getInternalBehaviorOrEventConfiguration(IProcessArea startingArea, IDevelopmentLine line, String configurationId, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        if (configurationType == 0) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.4"));
        }
        IRole[] roles = this.getInternalContributorRoles(this.getContributor(), startingArea, this.newSubProgressMonitor(monitor, 10));
        if (roles == null || roles.length == 0) {
            return null;
        }
        CurrentIterationInfo[] currentIterationInfos = null;
        if (line != null) {
            currentIterationInfos = this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 10));
        }
        return this.getInternalBehaviorOrEventConfiguration(startingArea, roles, line, currentIterationInfos, configurationId, configurationType, monitor);
    }

    protected ProcessConfiguration getInternalBehaviorOrEventConfiguration(IProjectArea projectArea, IProcessProvider processProvider, IRole[] roles, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, ITeamAreaHandle[] teamAreas, String configurationId, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.5"), 1000);
        if (this.isDebugLogEnabled()) {
            Object[] bindigs = new Object[]{configurationId, configurationType, projectArea == null ? "<unknown>" : projectArea.getName(), projectArea == null ? "<unknown>" : projectArea.getItemId().getUuidValue(), processProvider == null ? "<none>" : processProvider.getName(), processProvider == null ? "<none>" : processProvider.getItemId().getUuidValue(), line == null ? "<none>" : line.getName()};
            this.debugLog("Looking up process configuration for configurationId \"{0}\" and configurationType \"{1}\" in project area \"{2}\" ({3}) which is using a process provider of \"{4}\" ({5}) and development line of \"{6}\"", bindigs);
        }
        try {
            IProgressMonitor rolesMonitor = this.newSubProgressMonitor(monitor, 950);
            rolesMonitor.beginTask("", 1000 * roles.length);
            int i = 0;
            while (i < roles.length) {
                IRole role = roles[i];
                if (this.isDebugLogEnabled()) {
                    this.debugLog("Looking up process configuration for role: {0}", role == null ? "<unknown>" : role.getId());
                }
                ProcessConfiguration configuration = null;
                if (processProvider != null) {
                    IContent content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                    if (content != null) {
                        configuration = this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.40.compiled.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                    }
                    if (configuration != null) {
                        if (this.isDebugLogEnabled()) {
                            this.debugLog("A process configuration was found in the enterprise process specification.", new Object[0]);
                        }
                        if (configuration.isFinal()) {
                            if (this.isDebugLogEnabled()) {
                                this.debugLog("Returning the process configuration found in the enterprise process specification because it was marked as 'final'.", new Object[0]);
                            }
                            ProcessConfiguration processConfiguration = configuration;
                            return processConfiguration;
                        }
                    }
                    ProcessConfiguration lowerConfig = null;
                    content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                    }
                    if (lowerConfig != null) {
                        if (this.isDebugLogEnabled()) {
                            this.debugLog("A process configuration was found in the enterprise process customization.", new Object[0]);
                        }
                        if ((configuration = lowerConfig).isFinal()) {
                            if (this.isDebugLogEnabled()) {
                                this.debugLog("Returning the process configuration found in the enterprise process customization because it was marked as 'final'.", new Object[0]);
                            }
                            ProcessConfiguration processConfiguration = configuration;
                            return processConfiguration;
                        }
                    }
                }
                ProcessConfiguration lowerConfig = null;
                IContent content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                if (content != null) {
                    lowerConfig = this.getCurrentProcessConfiguration(projectArea, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.40.compiled.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                }
                if (lowerConfig != null) {
                    if (this.isDebugLogEnabled()) {
                        this.debugLog("A process configuration was found in the process specification.", new Object[0]);
                    }
                    if ((configuration = lowerConfig).isFinal()) {
                        if (this.isDebugLogEnabled()) {
                            this.debugLog("Returning the process configuration found in the process specification because it was marked as 'final'.", new Object[0]);
                        }
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                }
                if ((content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml")) != null && (lowerConfig = this.getCurrentProcessConfiguration(projectArea, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100))) != null && this.isDebugLogEnabled()) {
                    this.debugLog("A process configuration was found in the process customization.", new Object[0]);
                }
                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                    if (this.isDebugLogEnabled()) {
                        this.debugLog("Returning the process configuration found in the process customization because it was marked as 'final'.", new Object[0]);
                    }
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                if (teamAreas != null && teamAreas.length > 0) {
                    int numAreas = teamAreas.length;
                    IProgressMonitor hierarchyMonitor = this.newSubProgressMonitor(rolesMonitor, 700);
                    hierarchyMonitor.beginTask("", 1000 * numAreas);
                    int j = numAreas - 1;
                    while (j >= 0) {
                        ITeamAreaHandle teamAreaHandle = teamAreas[j];
                        ITeamArea teamArea = (ITeamArea)this.fetchCurrentCallCompleteItem((IItemHandle)teamAreaHandle, this.newSubProgressMonitor(hierarchyMonitor, 500));
                        if (this.isDebugLogEnabled()) {
                            this.debugLog("Looking up process configuration in team area: {0} ({1})", teamArea == null ? "<unknown>" : teamArea.getName(), teamAreaHandle.getItemId().getUuidValue());
                        }
                        if ((content = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml")) != null) {
                            lowerConfig = this.getCurrentProcessConfiguration(teamArea, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", configurationType, this.newSubProgressMonitor(hierarchyMonitor, 500));
                        }
                        if (lowerConfig != null) {
                            if (this.isDebugLogEnabled()) {
                                this.debugLog("A process configuration was found in the team area.", new Object[0]);
                            }
                            if ((configuration = lowerConfig).isFinal()) {
                                if (this.isDebugLogEnabled()) {
                                    this.debugLog("Returning the process configuration found in the team area because it was marked as 'final'.", new Object[0]);
                                }
                                ProcessConfiguration processConfiguration = configuration;
                                return processConfiguration;
                            }
                        }
                        --j;
                    }
                    hierarchyMonitor.done();
                }
                if (configuration != null) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                ++i;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    protected ProcessConfiguration getInternalBehaviorOrEventConfiguration(IProcessArea startingArea, IRole[] roles, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, String configurationId, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.5"), 1000);
        try {
            IProgressMonitor rolesMonitor = this.newSubProgressMonitor(monitor, 950);
            rolesMonitor.beginTask("", 1000 * roles.length);
            IProjectArea projectArea = this.getInternalProjectArea();
            IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(rolesMonitor, 10));
            int i = 0;
            while (i < roles.length) {
                IRole role = roles[i];
                ProcessConfiguration configuration = null;
                if (processProvider != null) {
                    IContent content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                    if (content != null) {
                        configuration = this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.40.compiled.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                    }
                    if (configuration != null && configuration.isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                    ProcessConfiguration lowerConfig = null;
                    content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                }
                ProcessConfiguration lowerConfig = null;
                IContent content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                if (content != null) {
                    lowerConfig = this.getCurrentProcessConfiguration(projectArea, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.40.compiled.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                }
                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                if (content != null) {
                    lowerConfig = this.getCurrentProcessConfiguration(projectArea, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", configurationType, this.newSubProgressMonitor(rolesMonitor, 100));
                }
                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                List teamAreaHandles = this.computeTeamAreaPath(startingArea);
                int numAreas = teamAreaHandles.size();
                IProgressMonitor hierarchyMonitor = this.newSubProgressMonitor(rolesMonitor, 700);
                hierarchyMonitor.beginTask("", 1000 * numAreas);
                int j = numAreas - 1;
                while (j >= 0) {
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreaHandles.get(j);
                    ITeamArea teamArea = (ITeamArea)this.fetchCurrentCallCompleteItem((IItemHandle)teamAreaHandle, this.newSubProgressMonitor(hierarchyMonitor, 500));
                    content = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = this.getCurrentProcessConfiguration(teamArea, content, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", configurationType, this.newSubProgressMonitor(hierarchyMonitor, 500));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                    --j;
                }
                hierarchyMonitor.done();
                if (configuration != null) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                ++i;
            }
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            monitor.done();
        }
    }

    public OperationPermissionsConfiguration[] getPermissionConfigurations(IProcessArea startingArea, IDevelopmentLine line, String configurationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalPermissionConfigurations(startingArea, line, configurationId, actions, monitor);
    }

    protected OperationPermissionsConfiguration[] getInternalPermissionConfigurations(IProcessArea startingArea, IDevelopmentLine line, String configurationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        startingArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)startingArea, monitor);
        this.assertSameProjectArea(startingArea);
        boolean isPremiumProject = false;
        if (startingArea instanceof IProjectArea) {
            isPremiumProject = ((ProjectArea)startingArea).isPremiumProject();
        }
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), isPremiumProject)) {
            return this.createAnyPermissions();
        }
        IRole[] roles = this.getInternalContributorRoles(this.getContributor(), startingArea, this.newSubProgressMonitor(monitor, 10));
        if (roles == null || roles.length == 0) {
            return new OperationPermissionsConfiguration[0];
        }
        CurrentIterationInfo[] currentIterationInfos = null;
        if (line != null) {
            currentIterationInfos = this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 10));
        }
        return this.getInternalPermissionConfigurations(startingArea, roles, line, currentIterationInfos, configurationId, actions, monitor);
    }

    /*
     * Unable to fully structure code
     */
    protected OperationPermissionsConfiguration[] getInternalPermissionConfigurations(IProcessArea startingArea, IRole[] roles, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, String configurationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.7"), 1000);
        permissionConfigurations = new ArrayList<ProcessConfiguration>();
        roleConfigurations = new ArrayList<ProcessConfiguration>();
        try {
            remainingActions = new ArrayList<String>();
            i = 0;
            while (i < actions.length) {
                remainingActions.add(actions[i]);
                ++i;
            }
            rolesMonitor = this.newSubProgressMonitor(monitor, 960);
            rolesMonitor.beginTask("", 1000 * roles.length);
            projectArea = this.getInternalProjectArea();
            projectSpecificationContent = null;
            projectSpecificationModel = null;
            projectCustomizationContent = null;
            projectCustomizationModel = null;
            processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(rolesMonitor, 10));
            providerSpecificationContent = null;
            providerSpecificationModel = null;
            teamAreaHandles = null;
            teamAreaHandleArray = null;
            teamAreas = null;
            teamAreaCustomizationContents = null;
            teamAreaCustomizationModels = null;
            numAreas = 0;
            i = 0;
            while (i < roles.length) {
                block43: {
                    block44: {
                        block42: {
                            role = roles[i];
                            configuration = null;
                            if (processProvider == null) break block42;
                            if (providerSpecificationContent == null) {
                                providerSpecificationContent = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                            }
                            if (providerSpecificationContent == null) break block42;
                            if (providerSpecificationModel == null) {
                                providerSpecificationModel = this.getSpecificationModel(processProvider, providerSpecificationContent, line, currentIterationInfos, monitor);
                            }
                            if ((configuration = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(providerSpecificationModel, processProvider, providerSpecificationContent, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.40.compiled.xml", 0, this.newSubProgressMonitor(rolesMonitor, 100))) == null || !configuration.isFinal()) break block42;
                            roleConfigurations.add(configuration);
                            permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                            if (permitted.size() > 0) {
                                ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                remainingActions.removeAll(permitted);
                                permissionConfigurations.add(configuration);
                                if (remainingActions.size() == 0) {
                                    var33_33 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                    return var33_33;
                                }
                            }
                            break block43;
                        }
                        lowerConfig = null;
                        if (projectSpecificationContent == null) {
                            projectSpecificationContent = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                        }
                        if (projectSpecificationContent == null) break block44;
                        if (projectSpecificationModel == null) {
                            projectSpecificationModel = this.getSpecificationModel(projectArea, projectSpecificationContent, line, currentIterationInfos, monitor);
                        }
                        if ((lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(projectSpecificationModel, projectArea, projectSpecificationContent, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.40.compiled.xml", 0, this.newSubProgressMonitor(rolesMonitor, 100))) == null || !(configuration = lowerConfig).isFinal()) break block44;
                        roleConfigurations.add(configuration);
                        permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                        if (permitted.size() > 0) {
                            ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(configuration);
                            if (remainingActions.size() == 0) {
                                var33_34 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                return var33_34;
                            }
                        }
                        break block43;
                    }
                    lowerConfig = null;
                    if (projectCustomizationContent == null) {
                        projectCustomizationContent = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    }
                    if (projectCustomizationContent == null) ** GOTO lbl-1000
                    if (projectCustomizationModel == null) {
                        projectCustomizationModel = this.getSpecificationModel(projectArea, projectCustomizationContent, line, currentIterationInfos, monitor);
                    }
                    if ((lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(projectCustomizationModel, projectArea, projectCustomizationContent, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", 0, this.newSubProgressMonitor(rolesMonitor, 100))) != null && (configuration = lowerConfig).isFinal()) {
                        roleConfigurations.add(configuration);
                        permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                        if (permitted.size() > 0) {
                            ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(configuration);
                            if (remainingActions.size() == 0) {
                                var33_35 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                return var33_35;
                            }
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (teamAreaHandles == null) {
                            teamAreaHandles = this.computeTeamAreaPath(startingArea);
                            numAreas = teamAreaHandles.size();
                        }
                        if (numAreas > 0) {
                            hierarchyMonitor = this.newSubProgressMonitor(rolesMonitor, 600);
                            hierarchyMonitor.beginTask("", 1000 * numAreas);
                            j = numAreas - 1;
                            while (j >= 0) {
                                if (teamAreaHandleArray == null) {
                                    teamAreaHandleArray = new ITeamAreaHandle[numAreas];
                                }
                                if (teamAreaHandleArray[j] == null) {
                                    teamAreaHandleArray[j] = (ITeamAreaHandle)teamAreaHandles.get(j);
                                }
                                if (teamAreas == null) {
                                    teamAreas = new ITeamArea[numAreas];
                                }
                                if (teamAreas[j] == null) {
                                    teamAreas[j] = (ITeamArea)this.fetchCurrentCallCompleteItem((IItemHandle)teamAreaHandleArray[j], this.newSubProgressMonitor(hierarchyMonitor, 500));
                                }
                                if (teamAreaCustomizationContents == null) {
                                    teamAreaCustomizationContents = new IContent[numAreas];
                                }
                                if (teamAreaCustomizationContents[j] == null) {
                                    teamAreaCustomizationContents[j] = (IContent)teamAreas[j].getProcessData().get("com.ibm.team.internal.process.settings.xml");
                                }
                                if (teamAreaCustomizationContents[j] != null) {
                                    if (teamAreaCustomizationModels == null) {
                                        teamAreaCustomizationModels = new TeamCustomizationModel[numAreas];
                                    }
                                    if (teamAreaCustomizationModels[j] == null) {
                                        teamAreaCustomizationModels[j] = this.getCustomizationModel(teamAreas[j], teamAreaCustomizationContents[j], line, currentIterationInfos, monitor);
                                    }
                                    if ((lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(teamAreaCustomizationModels[j], teamAreas[j], teamAreaCustomizationContents[j], line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", 0, this.newSubProgressMonitor(hierarchyMonitor, 500))) != null && (configuration = lowerConfig).isFinal()) {
                                        roleConfigurations.add(configuration);
                                        break;
                                    }
                                }
                                --j;
                            }
                            hierarchyMonitor.done();
                        }
                        if (configuration != null) {
                            if (!configuration.isFinal()) {
                                roleConfigurations.add(configuration);
                            }
                            if ((permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration)).size() > 0) {
                                ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                remainingActions.removeAll(permitted);
                                permissionConfigurations.add(configuration);
                                if (remainingActions.size() == 0) {
                                    var33_36 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                    return var33_36;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            if (remainingActions.size() == 0) {
                var33_37 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                return var33_37;
            }
            var33_38 = roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
            return var33_38;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected OperationPermissionsConfiguration[] innerGetPermissionConfigurations(IProjectArea projectArea, IProcessProvider processProvider, IRole[] roles, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, ITeamAreaHandle[] computedTeamAreaHandles, String configurationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.7"), 1000);
        permissionConfigurations = new ArrayList<ProcessConfiguration>();
        roleConfigurations = new ArrayList<ProcessConfiguration>();
        try {
            remainingActions = new ArrayList<String>();
            i = 0;
            while (i < actions.length) {
                remainingActions.add(actions[i]);
                ++i;
            }
            rolesMonitor = this.newSubProgressMonitor(monitor, 960);
            rolesMonitor.beginTask("", 1000 * roles.length);
            projectSpecificationContent = null;
            projectSpecificationModel = null;
            projectCustomizationContent = null;
            projectCustomizationModel = null;
            providerSpecificationContent = null;
            providerSpecificationModel = null;
            teamAreas = null;
            teamAreaCustomizationContents = null;
            teamAreaCustomizationModels = null;
            numAreas = computedTeamAreaHandles == null ? 0 : computedTeamAreaHandles.length;
            i = 0;
            while (i < roles.length) {
                block40: {
                    block41: {
                        block39: {
                            role = roles[i];
                            configuration = null;
                            if (processProvider == null) break block39;
                            if (providerSpecificationContent == null) {
                                providerSpecificationContent = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                            }
                            if (providerSpecificationContent == null) break block39;
                            if (providerSpecificationModel == null) {
                                providerSpecificationModel = this.getSpecificationModel(processProvider, providerSpecificationContent, line, currentIterationInfos, monitor);
                            }
                            if ((configuration = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(providerSpecificationModel, processProvider, providerSpecificationContent, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.40.compiled.xml", 0, this.newSubProgressMonitor(rolesMonitor, 100))) == null || !configuration.isFinal()) break block39;
                            roleConfigurations.add(configuration);
                            permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                            if (permitted.size() > 0) {
                                ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                remainingActions.removeAll(permitted);
                                permissionConfigurations.add(configuration);
                                if (remainingActions.size() == 0) {
                                    var31_31 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                    return var31_31;
                                }
                            }
                            break block40;
                        }
                        lowerConfig = null;
                        if (projectSpecificationContent == null) {
                            projectSpecificationContent = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                        }
                        if (projectSpecificationContent == null) break block41;
                        if (projectSpecificationModel == null) {
                            projectSpecificationModel = this.getSpecificationModel(projectArea, projectSpecificationContent, line, currentIterationInfos, monitor);
                        }
                        if ((lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(projectSpecificationModel, projectArea, projectSpecificationContent, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.40.compiled.xml", 0, this.newSubProgressMonitor(rolesMonitor, 100))) == null || !(configuration = lowerConfig).isFinal()) break block41;
                        roleConfigurations.add(configuration);
                        permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                        if (permitted.size() > 0) {
                            ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(configuration);
                            if (remainingActions.size() == 0) {
                                var31_32 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                return var31_32;
                            }
                        }
                        break block40;
                    }
                    lowerConfig = null;
                    if (projectCustomizationContent == null) {
                        projectCustomizationContent = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    }
                    if (projectCustomizationContent == null) ** GOTO lbl-1000
                    if (projectCustomizationModel == null) {
                        projectCustomizationModel = this.getSpecificationModel(projectArea, projectCustomizationContent, line, currentIterationInfos, monitor);
                    }
                    if ((lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(projectCustomizationModel, projectArea, projectCustomizationContent, line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", 0, this.newSubProgressMonitor(rolesMonitor, 100))) != null && (configuration = lowerConfig).isFinal()) {
                        roleConfigurations.add(configuration);
                        permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                        if (permitted.size() > 0) {
                            ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(configuration);
                            if (remainingActions.size() == 0) {
                                var31_33 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                return var31_33;
                            }
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (numAreas > 0) {
                            hierarchyMonitor = this.newSubProgressMonitor(rolesMonitor, 600);
                            hierarchyMonitor.beginTask("", 1000 * numAreas);
                            j = numAreas - 1;
                            while (j >= 0) {
                                if (teamAreas == null) {
                                    teamAreas = new ITeamArea[numAreas];
                                }
                                if (teamAreas[j] == null) {
                                    teamAreas[j] = (ITeamArea)this.fetchCurrentCallCompleteItem((IItemHandle)computedTeamAreaHandles[j], this.newSubProgressMonitor(hierarchyMonitor, 500));
                                }
                                if (teamAreaCustomizationContents == null) {
                                    teamAreaCustomizationContents = new IContent[numAreas];
                                }
                                if (teamAreaCustomizationContents[j] == null) {
                                    teamAreaCustomizationContents[j] = (IContent)teamAreas[j].getProcessData().get("com.ibm.team.internal.process.settings.xml");
                                }
                                if (teamAreaCustomizationContents[j] != null) {
                                    if (teamAreaCustomizationModels == null) {
                                        teamAreaCustomizationModels = new TeamCustomizationModel[numAreas];
                                    }
                                    if (teamAreaCustomizationModels[j] == null) {
                                        teamAreaCustomizationModels[j] = this.getCustomizationModel(teamAreas[j], teamAreaCustomizationContents[j], line, currentIterationInfos, monitor);
                                    }
                                    if ((lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(teamAreaCustomizationModels[j], teamAreas[j], teamAreaCustomizationContents[j], line, currentIterationInfos, role, configurationId, "com.ibm.team.internal.process.settings.xml", 0, this.newSubProgressMonitor(hierarchyMonitor, 500))) != null && (configuration = lowerConfig).isFinal()) {
                                        roleConfigurations.add(configuration);
                                        break;
                                    }
                                }
                                --j;
                            }
                            hierarchyMonitor.done();
                        }
                        if (configuration != null) {
                            if (!configuration.isFinal()) {
                                roleConfigurations.add(configuration);
                            }
                            if ((permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration)).size() > 0) {
                                ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                remainingActions.removeAll(permitted);
                                permissionConfigurations.add(configuration);
                                if (remainingActions.size() == 0) {
                                    var31_34 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                    return var31_34;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            if (remainingActions.size() == 0) {
                var31_35 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                return var31_35;
            }
            var31_36 = roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
            return var31_36;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCheckPermissions(IProgressMonitor monitor, boolean isPremiumProject) throws TeamRepositoryException {
        if (this.fInternalSingleCallLicenseCheck) {
            return this.fInternalSingleCallLicenceCheckValue;
        }
        try {
            if (isPremiumProject) {
                this.getPremiumLicenseChecker().assertPremiumLicense(ID_ENFORCE_PROCESS_PERMISSIONS, monitor, isPremiumProject);
            } else {
                this.getLicenseChecker().assertLicense(ID_ENFORCE_PROCESS_PERMISSIONS, monitor);
            }
        }
        catch (PremiumLicenseNotGrantedException e) {
            this.fInternalSingleCallLicenseCheck = true;
            this.fInternalSingleCallLicenceCheckValue = false;
            return this.fInternalSingleCallLicenceCheckValue;
        }
        catch (LicenseNotGrantedException e) {
            this.fInternalSingleCallLicenseCheck = true;
            this.fInternalSingleCallLicenceCheckValue = false;
            return this.fInternalSingleCallLicenceCheckValue;
        }
        HashSet hashSet = fgInitializingThreads;
        synchronized (hashSet) {
            if (fgInitializingThreads.contains(Thread.currentThread())) {
                this.fInternalSingleCallLicenseCheck = true;
                this.fInternalSingleCallLicenceCheckValue = false;
                return this.fInternalSingleCallLicenceCheckValue;
            }
        }
        this.fInternalSingleCallLicenseCheck = true;
        this.fInternalSingleCallLicenceCheckValue = true;
        return this.fInternalSingleCallLicenceCheckValue;
    }

    private OperationPermissionsConfiguration[] createAnyPermissions() {
        final PermissionActionElement anyAction = new PermissionActionElement(null, null, null, null){

            @Override
            public String getId() {
                return "any";
            }
        };
        OperationPermissionsConfiguration anyConfig = new OperationPermissionsConfiguration(null, null, null, null){

            @Override
            public PermissionActionElement[] getActions() {
                return new PermissionActionElement[]{anyAction};
            }
        };
        return new OperationPermissionsConfiguration[]{anyConfig};
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(ITeamArea teamArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String configurationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = this.getCustomizationModel(teamArea, content, line, currentIterationInfos, monitor);
        return this.getCurrentProcessConfiguration(model, teamArea, content, line, currentIterationInfos, role, configurationId, startingArea, contentKey, configurationType, monitor);
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(TeamCustomizationModel model, ITeamArea teamArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String configurationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCurrentProcessConfiguration(model, teamArea, content, line, currentIterationInfos, role, configurationId, contentKey, configurationType, monitor);
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(ITeamArea teamArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String configurationId, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = this.getCustomizationModel(teamArea, content, line, currentIterationInfos, monitor);
        return this.getCurrentProcessConfiguration(model, teamArea, content, line, currentIterationInfos, role, configurationId, contentKey, configurationType, monitor);
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(TeamCustomizationModel model, ITeamArea teamArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String configurationId, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamConfiguration teamCustomization = model.getTeamConfiguration();
        String roleId = role.getId();
        ProcessConfiguration configuration = null;
        switch (configurationType) {
            case 1: {
                configuration = AbstractProcess.getBehaviorOperation(model.getBehavior(), roleId, configurationId);
                break;
            }
            case 0: {
                configuration = AbstractProcess.getPermissionOperation(model.getPermissions(), roleId, configurationId);
                break;
            }
            case 2: {
                configuration = AbstractProcess.getChangeEvent(model.getBehavior(), configurationId);
                break;
            }
            default: {
                return null;
            }
        }
        ProcessConfiguration lowerOperation = this.getCurrentOperationConfiguration(model, currentIterationInfos, teamCustomization, 0, roleId, configurationId, configurationType);
        if (lowerOperation != null) {
            configuration = lowerOperation;
        }
        if (configuration instanceof OperationConfiguration) {
            ConfigurationSource source = configurationType == 0 ? AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource() : AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            source.setSourceArea(teamArea);
            source.setAreaIsTeamArea(true);
            source.setSourceAreaItemUuid(teamArea.getItemId().getUuidValue());
            source.setContentKey(contentKey);
            if (role instanceof IRole2) {
                source.setRoleId(((IRole2)role).getRoleLabel());
            } else {
                source.setRoleId(roleId);
            }
            source.setContentUuid(content.getContentId().getUuidValue());
            source.setFinal(configuration.isFinal());
            configuration = ((OperationConfiguration)configuration).createCopyWithSource(source);
        }
        return configuration;
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(IProcessContainer processContainer, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String operationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = this.getSpecificationModel(processContainer, content, line, currentIterationInfos, monitor);
        return this.getCurrentProcessConfiguration(model, processContainer, content, line, currentIterationInfos, role, operationId, contentKey, configurationType, monitor);
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(IProcessContainer processContainer, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String operationId, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = this.getSpecificationModel(processContainer, content, line, currentIterationInfos, monitor);
        return this.getCurrentProcessConfiguration(model, processContainer, content, line, currentIterationInfos, role, operationId, contentKey, configurationType, monitor);
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(ProcessSpecificationModel model, IProcessContainer processContainer, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String operationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCurrentProcessConfiguration(model, processContainer, content, line, currentIterationInfos, role, operationId, contentKey, configurationType, monitor);
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(ProcessSpecificationModel model, IProcessContainer processContainer, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String operationId, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamConfigurationElement teamConfiguration = model.getTeamConfiguration();
        if (teamConfiguration == null) {
            return null;
        }
        String roleId = role.getId();
        ProcessConfiguration configuration = null;
        switch (configurationType) {
            case 1: {
                configuration = AbstractProcess.getBehaviorOperation(teamConfiguration.getBehavior(), roleId, operationId);
                if (!this.isDebugLogEnabled()) break;
                if (configuration != null) {
                    this.debugLog("A process configuration for behavior was found while looking into the 'team configuration' element.", new Object[0]);
                    break;
                }
                this.debugLog("A process configuration for behavior was NOT found while looking into the 'team configuration' element.", new Object[0]);
                break;
            }
            case 0: {
                configuration = AbstractProcess.getPermissionOperation(teamConfiguration.getPermissions(), roleId, operationId);
                break;
            }
            case 2: {
                configuration = AbstractProcess.getChangeEvent(teamConfiguration.getBehavior(), operationId);
                break;
            }
            default: {
                return null;
            }
        }
        if (line != null) {
            ProcessConfiguration lowerConfig;
            String lineId = line.getId();
            DevelopmentLineConfiguration matchingLineConfig = teamConfiguration.getDevelopmentLineConfiguration(lineId);
            if (matchingLineConfig != null) {
                switch (configurationType) {
                    case 1: {
                        lowerConfig = AbstractProcess.getBehaviorOperation(matchingLineConfig.getBehavior(), roleId, operationId);
                        if (!this.isDebugLogEnabled()) break;
                        if (lowerConfig != null) {
                            this.debugLog("A process configuration for behavior was found while looking into the development line \"{0}\" configuration .", lineId);
                            break;
                        }
                        this.debugLog("A process configuration for behavior was NOT found while looking into the development line \"{0}\" configuration .", lineId);
                        break;
                    }
                    case 0: {
                        lowerConfig = AbstractProcess.getPermissionOperation(matchingLineConfig.getPermissions(), roleId, operationId);
                        break;
                    }
                    case 2: {
                        lowerConfig = AbstractProcess.getChangeEvent(matchingLineConfig.getBehavior(), operationId);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (lowerConfig != null) {
                    configuration = lowerConfig;
                }
            }
            if ((lowerConfig = this.getCurrentOperationConfiguration(matchingLineConfig, currentIterationInfos, teamConfiguration, 0, roleId, operationId, configurationType)) != null) {
                configuration = lowerConfig;
            }
        }
        if (configuration instanceof OperationConfiguration) {
            ConfigurationSource source = configurationType == 0 ? AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource() : AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            if (processContainer instanceof IProcessArea) {
                source.setSourceArea((IProcessArea)processContainer);
            }
            source.setSourceAreaItemUuid(processContainer.getItemId().getUuidValue());
            source.setContentKey(contentKey);
            if (role instanceof IRole2) {
                source.setRoleId(((IRole2)role).getRoleLabel());
            } else {
                source.setRoleId(roleId);
            }
            source.setContentUuid(content.getContentId().getUuidValue());
            source.setFinal(configuration.isFinal());
            configuration = ((OperationConfiguration)configuration).createCopyWithSource(source);
        }
        return configuration;
    }

    private ProcessConfiguration getCurrentOperationConfiguration(IIterationParent matchingLineConfig, CurrentIterationInfo[] currentIterationInfos, ITeamConfiguration teamConfiguration, int currentDepth, String roleId, String operationId, int configurationType) throws TeamRepositoryException {
        ProcessConfiguration configuration = null;
        if (currentIterationInfos != null && currentDepth < currentIterationInfos.length) {
            ProcessConfiguration lowerConfig;
            String typeId;
            IterationTypeConfiguration typeConfig;
            CurrentIterationInfo iterationInfo = currentIterationInfos[currentDepth];
            String currentId = iterationInfo.getIteration().getId();
            IterationConfiguration matchingIterationConfig = null;
            if (matchingLineConfig != null && (matchingIterationConfig = matchingLineConfig.getIterationConfiguration(currentId)) != null) {
                switch (configurationType) {
                    case 1: {
                        String iterationId;
                        configuration = AbstractProcess.getBehaviorOperation(matchingIterationConfig.getBehavior(), roleId, operationId);
                        if (!this.isDebugLogEnabled()) break;
                        String string = iterationId = matchingIterationConfig.getId() == null ? "<null_id>" : matchingIterationConfig.getId();
                        if (configuration != null) {
                            this.debugLog("A process configuration for behavior was found while looking into the iteration \"{0}\" configuration.", iterationId);
                            break;
                        }
                        this.debugLog("A process configuration for behavior was NOT found while looking into the iteration \"{0}\" configuration.", iterationId);
                        break;
                    }
                    case 0: {
                        configuration = AbstractProcess.getPermissionOperation(matchingIterationConfig.getPermissions(), roleId, operationId);
                        break;
                    }
                    case 2: {
                        configuration = AbstractProcess.getChangeEvent(matchingIterationConfig.getBehavior(), operationId);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            IIterationType iterationType = iterationInfo.getIterationType();
            if (configuration == null && iterationType != null && (typeConfig = teamConfiguration.getIterationTypeConfiguration(typeId = iterationType.getId())) != null) {
                switch (configurationType) {
                    case 1: {
                        String iterationTypeId;
                        configuration = AbstractProcess.getBehaviorOperation(typeConfig.getBehavior(), roleId, operationId);
                        if (!this.isDebugLogEnabled()) break;
                        String string = iterationTypeId = typeConfig.getId() == null ? "<null_type_id>" : typeConfig.getId();
                        if (configuration != null) {
                            this.debugLog("A process configuration for behavior was found while looking into the iteration type \"{0}\" configuration.", iterationTypeId);
                            break;
                        }
                        this.debugLog("A process configuration for behavior was NOT found while looking into the iteration type \"{0}\" configuration.", iterationTypeId);
                        break;
                    }
                    case 0: {
                        configuration = AbstractProcess.getPermissionOperation(typeConfig.getPermissions(), roleId, operationId);
                        break;
                    }
                    case 2: {
                        configuration = AbstractProcess.getChangeEvent(typeConfig.getBehavior(), operationId);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if ((lowerConfig = this.getCurrentOperationConfiguration(matchingIterationConfig, currentIterationInfos, teamConfiguration, currentDepth + 1, roleId, operationId, configurationType)) != null) {
                configuration = lowerConfig;
            }
        }
        return configuration;
    }

    private static OperationPermissionsConfiguration getPermissionOperation(PermissionsElement permissions, String roleId, String operationId) {
        PermissionsRoleElement roleElement;
        if (permissions != null && (roleElement = permissions.getRoleElement(roleId)) != null) {
            OperationPermissionsConfiguration operation = roleElement.getOperation(operationId);
            return operation;
        }
        return null;
    }

    private static OperationBehaviorConfiguration getBehaviorOperation(BehaviorElement behavior, String roleId, String operationId) {
        BehaviorRoleElement roleElement;
        if (behavior != null && (roleElement = behavior.getRoleElement(roleId)) != null) {
            OperationBehaviorConfiguration operation = roleElement.getOperation(operationId);
            return operation;
        }
        return null;
    }

    private static ChangeEventConfiguration getChangeEvent(BehaviorElement behavior, String eventId) {
        if (behavior != null) {
            ChangeEventConfiguration event = behavior.getChangeEventElement(eventId);
            return event;
        }
        return null;
    }

    protected List computeTeamAreaPath(IProcessArea processArea) {
        if (processArea instanceof ITeamArea) {
            IProjectArea projectArea = this.attemptGetInternalProjectArea();
            return this.innerComputeTeamAreaPath((ITeamArea)processArea, projectArea);
        }
        return new ArrayList(0);
    }

    private List innerComputeTeamAreaPath(ITeamArea teamArea, IProjectArea projectArea) {
        ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
        teamAreaHandles.add(teamArea);
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        ITeamAreaHandle teamAreaHandle = hierarchy.getParent(teamArea);
        while (teamAreaHandle != null) {
            teamAreaHandles.add(teamAreaHandle);
            teamAreaHandle = hierarchy.getParent(teamAreaHandle);
        }
        return teamAreaHandles;
    }

    protected ITeamAreaHandle[] computeTeamAreaPathArray(IProcessArea processArea) throws TeamRepositoryException {
        if (processArea instanceof ITeamArea) {
            IProjectArea projectArea = this.attemptGetInternalProjectArea();
            return this.innerComputeTeamAreaPathArray((ITeamArea)processArea, projectArea);
        }
        return new ITeamAreaHandle[0];
    }

    private ITeamAreaHandle[] innerComputeTeamAreaPathArray(ITeamArea teamArea, IProjectArea projectArea) throws TeamRepositoryException {
        ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
        teamAreaHandles.add(teamArea);
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        ITeamAreaHandle teamAreaHandle = hierarchy.getParent(teamArea);
        while (teamAreaHandle != null) {
            teamAreaHandle = (ITeamAreaHandle)this.fetchStateHandle((IItemHandle)teamAreaHandle);
            teamAreaHandles.add(teamAreaHandle);
            teamAreaHandle = hierarchy.getParent(teamAreaHandle);
        }
        return teamAreaHandles.toArray(new ITeamAreaHandle[teamAreaHandles.size()]);
    }

    public OperationBehaviorConfiguration getInitializationBehaviorConfiguration(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalInitializationBehaviorConfiguration(configPointId, monitor);
    }

    protected OperationBehaviorConfiguration getInternalInitializationBehaviorConfiguration(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        return this.innerGetInitializationBehaviorConfiguration(projectArea, configPointId, monitor);
    }

    private OperationBehaviorConfiguration innerGetInitializationBehaviorConfiguration(IProjectArea projectArea, String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            OperationBehaviorConfiguration obconfiguration;
            InitializationElement initialization;
            ProcessSpecificationModel model;
            ProjectConfigurationElement projectConfiguration;
            Map processData = projectArea.getProcessData();
            IContent content = (IContent)processData.get("com.ibm.team.internal.process.40.compiled.xml");
            if (content != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content, null, null, this.newSubProgressMonitor(monitor, 800))).getProjectConfiguration()) != null && (initialization = projectConfiguration.getInitialization()) != null && (obconfiguration = initialization.getOperation(configPointId)) != null) {
                ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                source.setSourceArea(projectArea);
                source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                source.setContentUuid(content.getContentId().getUuidValue());
                OperationBehaviorConfiguration operationBehaviorConfiguration = obconfiguration = (OperationBehaviorConfiguration)obconfiguration.createCopyWithSource(source);
                return operationBehaviorConfiguration;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public IRole2[] getRoles(IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalRoles(startingArea, monitor);
    }

    protected IRole2[] getInternalRoles(IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        if (startingArea instanceof ITeamArea) {
            startingArea = this.confirmProcessArea(startingArea, projectArea, monitor);
            return this.innerGetRolesForTeam((ITeamArea)startingArea, projectArea, monitor);
        }
        if (startingArea instanceof IProjectArea) {
            this.assertSameProjectArea(startingArea, projectArea);
            return this.innerGetRolesForProject(projectArea, monitor);
        }
        throw new TeamRepositoryException(startingArea + " is not a valid IProcessArea, getInternalRoles could not proceed");
    }

    protected IRole2[] getInternalRolesForProject(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        return this.innerGetRolesForProject(projectArea, monitor);
    }

    protected IRole2[] getInternalRolesForTeam(ITeamAreaHandle startingTeamAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessAreaHandle(startingTeamAreaHandle, projectArea, monitor);
        return this.innerGetRolesForTeam(startingTeamArea, projectArea, monitor);
    }

    protected IRole2[] getInternalRolesForProcess(IProcessAreaHandle startingAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        if (startingAreaHandle instanceof ITeamAreaHandle) {
            IProcessArea startingArea = this.confirmProcessAreaHandle(startingAreaHandle, projectArea, monitor);
            return this.innerGetRolesForTeam((ITeamArea)startingArea, projectArea, monitor);
        }
        if (startingAreaHandle instanceof IProjectAreaHandle) {
            this.assertSameProjectAreaForProcess(startingAreaHandle, projectArea);
            return this.innerGetRolesForProject(projectArea, monitor);
        }
        throw new TeamRepositoryException(startingAreaHandle + " is not a valid IProcessArea, getInternalRoles could not proceed");
    }

    protected IRole2[] getInternalProjectRoles(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        return this.innerGetRolesForProject(projectArea, monitor);
    }

    private IRole2[] innerGetRolesForProject(IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.getCommonString("AbstractProcess.9"), 1000);
            ArrayList<IRole> allRoles = new ArrayList<IRole>();
            HashSet<String> roleSet = new HashSet<String>();
            this.addRoles(allRoles, roleSet, projectArea, "com.ibm.team.internal.process.settings.xml", this.newSubProgressMonitor(monitor, 100));
            this.addRoles(allRoles, roleSet, projectArea, "com.ibm.team.internal.process.40.compiled.xml", this.newSubProgressMonitor(monitor, 100));
            IProcessProvider processProvider = this.innerGetProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 50));
            if (processProvider != null) {
                this.addRoles(allRoles, roleSet, processProvider, "com.ibm.team.internal.process.40.compiled.xml", this.newSubProgressMonitor(monitor, 50));
            }
            allRoles.add(fgDefaultRole);
            IRole2[] iRole2Array = allRoles.toArray(new IRole2[allRoles.size()]);
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    private IRole2[] innerGetRolesForTeam(ITeamArea startingTeamArea, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.getCommonString("AbstractProcess.9"), 1000);
            ArrayList<IRole> allRoles = new ArrayList<IRole>();
            HashSet<String> roleSet = new HashSet<String>();
            IProgressMonitor hierarchyMonitor = this.newSubProgressMonitor(monitor, 600);
            hierarchyMonitor.beginTask("", 1000);
            this.addRoles(allRoles, roleSet, startingTeamArea, "com.ibm.team.internal.process.settings.xml", this.newSubProgressMonitor(hierarchyMonitor, 50));
            ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
            ITeamAreaHandle teamAreaHandle = hierarchy.getParent(startingTeamArea);
            while (teamAreaHandle != null) {
                ITeamArea teamArea = (ITeamArea)this.fetchCurrentCallCompleteItem((IItemHandle)teamAreaHandle, this.newSubProgressMonitor(hierarchyMonitor, 50));
                this.addRoles(allRoles, roleSet, teamArea, "com.ibm.team.internal.process.settings.xml", this.newSubProgressMonitor(hierarchyMonitor, 50));
                teamAreaHandle = hierarchy.getParent(teamArea);
            }
            hierarchyMonitor.done();
            this.addRoles(allRoles, roleSet, projectArea, "com.ibm.team.internal.process.settings.xml", this.newSubProgressMonitor(monitor, 100));
            this.addRoles(allRoles, roleSet, projectArea, "com.ibm.team.internal.process.40.compiled.xml", this.newSubProgressMonitor(monitor, 100));
            IProcessProvider processProvider = this.innerGetProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 50));
            if (processProvider != null) {
                this.addRoles(allRoles, roleSet, processProvider, "com.ibm.team.internal.process.40.compiled.xml", this.newSubProgressMonitor(monitor, 50));
            }
            allRoles.add(fgDefaultRole);
            IRole2[] iRole2Array = allRoles.toArray(new IRole2[allRoles.size()]);
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    private void addRoles(List allRoles, Set<String> roleSet, IProcessContainer processContainer, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IRole2[] areaRoles = this.getRoles(processContainer, contentKey, monitor);
        int i = 0;
        while (i < areaRoles.length) {
            String roleId = areaRoles[i].getId();
            if (roleId != null && roleSet.add(roleId)) {
                allRoles.add(areaRoles[i]);
            }
            ++i;
        }
    }

    protected boolean containsRole(List roles, IRole role) {
        for (IRole existing : roles) {
            if (!role.getId().equals(existing.getId())) continue;
            return true;
        }
        return false;
    }

    public IRole2[] getContributorRoles(IContributorHandle contributor, IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalContributorRoles(contributor, startingArea, monitor);
    }

    protected IRole2[] getInternalContributorRoles(IContributorHandle contributor, IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalContributorRolesForProcess(contributor, startingArea, monitor);
    }

    protected IRole2[] getInternalCurrentContributorRoles(IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalContributorRolesForProcess(this.getContributor(), startingArea, monitor);
    }

    protected IRole2[] getInternalContributorRolesForProcess(IContributorHandle contributor, IProcessAreaHandle startingAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getInternalContributorRolesForProcess(contributor, startingAreaHandle, true, monitor);
    }

    protected IRole2[] getInternalContributorRolesForProcess(IContributorHandle contributor, IProcessAreaHandle startingAreaHandle, boolean includeInherited, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        if (startingAreaHandle instanceof ITeamAreaHandle) {
            ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessAreaHandle(startingAreaHandle, projectArea, monitor);
            return this.innerGetContributorRolesForTeam(contributor, startingTeamArea, projectArea, includeInherited, monitor);
        }
        if (startingAreaHandle instanceof IProjectAreaHandle) {
            this.assertSameProjectAreaForProcess(startingAreaHandle, projectArea);
            return this.innerGetContributorRolesForProject(contributor, projectArea, monitor);
        }
        throw new TeamRepositoryException(startingAreaHandle + " is not a valid IProcessArea, getInternalContributorRolesForProcess could not proceed");
    }

    protected IRole2[] getInternalCurrentContributorRolesForTeam(ITeamAreaHandle startingAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessAreaHandle(startingAreaHandle, projectArea, monitor);
        return this.innerGetContributorRolesForTeam(this.getContributor(), startingTeamArea, projectArea, true, monitor);
    }

    protected IRole2[] getInternalContributorRolesForTeam(IContributorHandle contributor, ITeamAreaHandle startingAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessAreaHandle(startingAreaHandle, projectArea, monitor);
        return this.innerGetContributorRolesForTeam(contributor, startingTeamArea, projectArea, true, monitor);
    }

    private IRole2[] innerGetContributorRolesForTeam(IContributorHandle contributor, ITeamArea startingTeamArea, IProjectArea projectArea, boolean includeInherited, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.getCommonString("AbstractProcess.10"), 1000);
            IRole[] availableRoles = this.innerGetRolesForTeam(startingTeamArea, projectArea, this.newSubProgressMonitor(monitor, 100));
            ArrayList<IRole> assignedRoles = new ArrayList<IRole>();
            HashSet<String> roleSet = new HashSet<String>();
            IProgressMonitor contributorRolesMonitor = this.newSubProgressMonitor(monitor, 600);
            contributorRolesMonitor.beginTask("", 1000);
            this.addContributorRoles(assignedRoles, roleSet, startingTeamArea.getRoleAssignments(contributor, availableRoles), this.newSubProgressMonitor(contributorRolesMonitor, 50));
            if (includeInherited) {
                ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
                ITeamAreaHandle teamAreaHandle = hierarchy.getParent(startingTeamArea);
                while (teamAreaHandle != null) {
                    ITeamArea teamArea = (ITeamArea)this.fetchCurrentCallCompleteItem((IItemHandle)teamAreaHandle, this.newSubProgressMonitor(contributorRolesMonitor, 50));
                    this.addContributorRoles(assignedRoles, roleSet, teamArea.getRoleAssignments(contributor, availableRoles), this.newSubProgressMonitor(contributorRolesMonitor, 50));
                    teamAreaHandle = hierarchy.getParent(teamArea);
                }
                contributorRolesMonitor.done();
                this.addContributorRoles(assignedRoles, roleSet, projectArea.getRoleAssignments(contributor, availableRoles), this.newSubProgressMonitor(monitor, 100));
            } else {
                contributorRolesMonitor.done();
            }
            assignedRoles.add(fgDefaultRole);
            IRole2[] iRole2Array = assignedRoles.toArray(new IRole2[assignedRoles.size()]);
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    protected IRole2[] getInternalCurrentContributorRolesForProject(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        return this.innerGetContributorRolesForProject(this.getContributor(), projectArea, monitor);
    }

    protected IRole2[] getInternalContributorRolesForProject(IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        return this.innerGetContributorRolesForProject(contributor, projectArea, monitor);
    }

    private IRole2[] innerGetContributorRolesForProject(IContributorHandle contributor, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.getCommonString("AbstractProcess.10"), 1000);
            IRole[] availableRoles = this.innerGetRolesForProject(projectArea, this.newSubProgressMonitor(monitor, 100));
            ArrayList<IRole> assignedRoles = new ArrayList<IRole>();
            HashSet<String> roleSet = new HashSet<String>();
            this.addContributorRoles(assignedRoles, roleSet, projectArea.getRoleAssignments(contributor, availableRoles), this.newSubProgressMonitor(monitor, 100));
            assignedRoles.add(fgDefaultRole);
            IRole2[] iRole2Array = assignedRoles.toArray(new IRole2[assignedRoles.size()]);
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    private void addContributorRoles(List allRoles, Set<String> roleSet, IRole[] assignedRoles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (assignedRoles != null) {
            int i = 0;
            while (i < assignedRoles.length) {
                String roleId = assignedRoles[i].getId();
                if (roleId != null && roleSet.add(roleId)) {
                    allRoles.add(assignedRoles[i]);
                }
                ++i;
            }
        }
    }

    protected IRole2[] getRoles(IProcessContainer processContainer, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent content;
        Map processData = processContainer == null ? null : processContainer.getProcessData();
        IContent iContent = content = processData == null ? null : (IContent)processData.get(contentKey);
        if (content != null) {
            if (processContainer instanceof ITeamArea) {
                TeamCustomizationModel model = this.getCustomizationModel((ITeamArea)processContainer, content, null, null, monitor);
                return model.getRoleDefinitions();
            }
            ProcessSpecificationModel model = this.getSpecificationModel(processContainer, content, null, null, monitor);
            return model.getRoleDefinitions();
        }
        return new IRole2[0];
    }

    protected Map<String, IRole2> getRolesMap(IProcessContainer processContainer, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent content;
        Map processData = processContainer == null ? null : processContainer.getProcessData();
        IContent iContent = content = processData == null ? null : (IContent)processData.get(contentKey);
        if (content != null) {
            if (processContainer instanceof ITeamArea) {
                TeamCustomizationModel model = this.getCustomizationModel((ITeamArea)processContainer, content, null, null, monitor);
                return model.getRoleDefinitionsMap();
            }
            ProcessSpecificationModel model = this.getSpecificationModel(processContainer, content, null, null, monitor);
            return model.getRoleDefinitionsMap();
        }
        return Collections.emptyMap();
    }

    public IContributorHandle[] getContributorsWithRole(IContributorHandle[] contributors, IProcessAreaHandle areaHandle, String[] roleIds, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        return this.getInternalContributorsWithRole(contributors, areaHandle, roleIds, monitor);
    }

    protected IContributorHandle[] getInternalContributorsWithRole(IContributorHandle[] contributors, IProcessAreaHandle areaHandle, String[] roleIds, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        int i = 0;
        while (i < roleIds.length) {
            if ("default".equals(roleIds[i])) {
                return contributors;
            }
            ++i;
        }
        ItemHandleAwareHashSet resultSet = new ItemHandleAwareHashSet();
        ItemHandleAwareHashSet contributorsToSearch = new ItemHandleAwareHashSet();
        contributorsToSearch.addAll(Arrays.asList(contributors));
        IProcessArea processArea = null;
        IProjectArea projectArea = this.getInternalProjectArea();
        if (!areaHandle.sameItemId((IItemHandle)projectArea)) {
            processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)areaHandle, this.newSubProgressMonitor(monitor, 100));
            List teamAreaHandles = this.computeTeamAreaPath(processArea);
            IItem[] teamAreas = this.fetchCurrentCallCompleteItems(teamAreaHandles.toArray(new IItemHandle[teamAreaHandles.size()]), this.newSubProgressMonitor(monitor, 600));
            int i2 = 0;
            while (i2 < teamAreas.length) {
                this.addContributorsWithRole(contributorsToSearch, (IProcessArea)teamAreas[i2], roleIds, resultSet);
                ++i2;
            }
        }
        this.addContributorsWithRole(contributorsToSearch, projectArea, roleIds, resultSet);
        return (IContributorHandle[])resultSet.toArray(new IContributorHandle[resultSet.size()]);
    }

    private void addContributorsWithRole(ItemHandleAwareHashSet contributors, IProcessArea processArea, String[] roleIds, ItemHandleAwareHashSet resultSet) {
        Iterator iter = contributors.iterator();
        block0: while (iter.hasNext()) {
            IContributorHandle contributor = (IContributorHandle)iter.next();
            String[] assignmentIds = processArea.getRoleAssignmentIds(contributor);
            int i = 0;
            while (i < assignmentIds.length) {
                String assigned = assignmentIds[i];
                int j = 0;
                while (j < roleIds.length) {
                    if (assigned.equals(roleIds[j])) {
                        iter.remove();
                        resultSet.add(contributor);
                        continue block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private List getPermittedActions(List actions, OperationPermissionsConfiguration configuration) {
        return OperationAdviceManager.getPermittedActions(actions, configuration);
    }

    protected IDevelopmentLine getOperationDevelopmentLine(IProcessArea processArea, IDevelopmentLine operationLine, IProgressMonitor monitor) throws TeamRepositoryException {
        processArea = (IProcessArea)this.fetchCompleteItem((IItemHandle)processArea, monitor);
        return this.innerGetOperationDevelopmentLine(processArea, operationLine, monitor);
    }

    private IDevelopmentLine innerGetOperationDevelopmentLine(IProcessArea processArea, IDevelopmentLine operationLine, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea instanceof ITeamArea) {
            IDevelopmentLine line = this.getDevelopmentLine(processArea, monitor);
            return line;
        }
        IDevelopmentLine line = this.getDevelopmentLine(processArea, monitor);
        if (line != null) {
            return line;
        }
        return operationLine;
    }

    private IDevelopmentLine innerProjectGetOperationDevelopmentLine(IProjectArea projectArea, IDevelopmentLine operationLine, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLine line = this.getDevelopmentLine(projectArea, monitor);
        if (line != null) {
            return line;
        }
        return operationLine;
    }

    public IProcessAttachment getProcessAttachment(IProcessArea processArea, String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        IProcessAttachment attachment = this.getInternalProcessAttachment(processArea, attachmentPath, monitor);
        return attachment;
    }

    protected IProcessAttachment getInternalProcessAttachment(IProcessArea processArea, String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.6"), 1000);
        try {
            IProcessProvider processProvider;
            IProcessAttachment attachment = this.doGetProcessAttachment(processArea, attachmentPath, this.newSubProgressMonitor(monitor, 500));
            if (attachment == null && processArea instanceof IProjectArea && (processProvider = this.getInternalProcessProvider((IProjectArea)processArea, this.newSubProgressMonitor(monitor, 100))) != null) {
                attachment = this.doGetProcessAttachment(processProvider, attachmentPath, this.newSubProgressMonitor(monitor, 400));
            }
            IProcessAttachment iProcessAttachment = attachment;
            return iProcessAttachment;
        }
        finally {
            monitor.done();
        }
    }

    protected void assertSameProjectArea(IProcessArea processArea) throws TeamRepositoryException {
        if (processArea == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.11")));
        }
        IProjectArea internalProjectArea = this.attemptGetInternalProjectArea();
        if (processArea instanceof IProjectArea) {
            if (!processArea.sameItemId((IItemHandle)internalProjectArea)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
            }
            return;
        }
        IProjectAreaHandle actual = processArea.getProjectArea();
        if (actual == null || !actual.sameItemId((IItemHandle)internalProjectArea)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
        }
    }

    protected void assertSameProjectAreaForProcess(IProcessAreaHandle processAreaHandle) throws TeamRepositoryException {
        IProcessArea processArea;
        if (processAreaHandle == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.11")));
        }
        IProjectArea internalProjectArea = this.attemptGetInternalProjectArea();
        if (processAreaHandle instanceof IProjectAreaHandle) {
            if (!processAreaHandle.sameItemId((IItemHandle)internalProjectArea)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
            }
            return;
        }
        try {
            processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)processAreaHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
        }
        IProjectAreaHandle actual = processArea.getProjectArea();
        if (actual == null || !actual.sameItemId((IItemHandle)internalProjectArea)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
        }
    }

    protected void assertSameProjectArea(IProcessArea processArea, IProjectArea internalProjectArea) throws TeamRepositoryException {
        if (processArea == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.11")));
        }
        if (processArea instanceof IProjectArea) {
            if (!processArea.sameItemId((IItemHandle)internalProjectArea)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
            }
            return;
        }
        IProjectAreaHandle actual = processArea.getProjectArea();
        if (actual == null || !actual.sameItemId((IItemHandle)internalProjectArea)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
        }
    }

    protected void assertSameProjectAreaForProcess(IProcessAreaHandle processAreaHandle, IProjectArea internalProjectArea) throws TeamRepositoryException {
        IProcessArea processArea;
        if (processAreaHandle == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.11")));
        }
        if (processAreaHandle instanceof IProjectAreaHandle) {
            if (!processAreaHandle.sameItemId((IItemHandle)internalProjectArea)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
            }
            return;
        }
        try {
            processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)processAreaHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
        }
        IProjectAreaHandle actual = processArea.getProjectArea();
        if (actual == null || !actual.sameItemId((IItemHandle)internalProjectArea)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12")));
        }
    }

    private IProcessArea confirmProcessArea(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)processArea, monitor);
        this.assertSameProjectArea(processArea);
        return processArea;
    }

    private IProcessArea confirmProcessAreaHandle(IProcessAreaHandle startingAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessArea processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)startingAreaHandle, monitor);
        this.assertSameProjectArea(processArea);
        return processArea;
    }

    private IProcessArea confirmProcessArea(IProcessArea processArea, IProjectArea internalProjectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)processArea, monitor);
        this.assertSameProjectArea(processArea, internalProjectArea);
        return processArea;
    }

    private IProcessArea confirmProcessAreaHandle(IProcessAreaHandle startingAreaHandle, IProjectArea internalProjectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessArea processArea = (IProcessArea)this.fetchCurrentCallCompleteItem((IItemHandle)startingAreaHandle, monitor);
        this.assertSameProjectArea(processArea, internalProjectArea);
        return processArea;
    }

    public IProjectArea getProjectArea() {
        if (this.notCheckedProjectAreaComplete) {
            if (this.fProjectArea == null || !this.fProjectArea.isComplete() || this.fProjectArea.isWorkingCopy()) {
                try {
                    this.fProjectArea = (IProjectArea)this.fetchCurrentCallCompleteItem((IItemHandle)this.fProjectAreaHandle, null);
                    if (this.fProjectArea != null && this.fProjectArea.hasStateId()) {
                        this.fProjectAreaHandle = (IProjectAreaHandle)this.fProjectArea.getStateHandle();
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                this.fReloadedOnceFlag = true;
            }
            this.notCheckedProjectAreaComplete = false;
        }
        return this.fProjectArea;
    }

    protected void resetReloadProjectAreaOnce() {
        this.fReloadedOnceFlag = false;
        this.fInternalSingleCallLicenseCheck = false;
    }

    protected IProjectArea getInternalProjectArea() throws TeamRepositoryException {
        return this.getInternalProjectArea(null);
    }

    protected IProjectArea attemptGetInternalProjectArea() {
        try {
            return this.getInternalProjectArea();
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
            return this.fProjectArea;
        }
    }

    protected IProjectArea innerGetProjectArea() throws TeamRepositoryException {
        if (this.fProjectArea == null) {
            this.reloadProjectArea(null);
        }
        return this.fProjectArea;
    }

    protected IProjectArea getInternalProjectArea(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.fReloadedOnceFlag || this.fProjectArea == null) {
            this.reloadProjectArea(monitor);
        }
        return this.fProjectArea;
    }

    protected IProjectArea attemptGetInternalProjectArea(IProgressMonitor monitor) {
        try {
            return this.getInternalProjectArea(monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
            return this.fProjectArea;
        }
    }

    protected void reloadProjectArea(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea temp = this.fProjectArea == null ? (IProjectArea)this.fetchCurrentCallCompleteItem((IItemHandle)this.fProjectAreaHandle, monitor) : (IProjectArea)this.fetchCurrentCallCompleteItem((IItemHandle)this.fProjectArea, monitor);
        if (!(temp == null || this.fProjectArea != null && this.fReloadedOnceFlag && this.fProjectArea.sameStateId((IItemHandle)temp) && this.fProjectArea.isComplete() && !this.fProjectArea.isWorkingCopy())) {
            this.fProjectArea = temp;
            if (this.fProjectArea != null) {
                this.fProjectAreaHandle = (IProjectAreaHandle)this.fProjectArea.getStateHandle();
            }
        }
        this.fReloadedOnceFlag = true;
    }

    protected IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return this.NULLMONITOR;
        }
        return monitor;
    }

    protected IProgressMonitor newSubProgressMonitor(IProgressMonitor monitor, int value) {
        if (monitor == null) {
            return this.NULLMONITOR;
        }
        return new SubProgressMonitor(monitor, value);
    }

    protected IItem provide(IItemHandle handle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.fetchCompleteItem(handle, progressMonitor);
    }

    protected IItem[] provide(IItemHandle[] handles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.fetchCompleteItems(handles, progressMonitor);
    }

    protected IItem fetchCurrentCallCompleteItem(IItemHandle itemHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            return this.fetchCompleteItem(itemHandle, progressMonitor);
        }
        IItem item = this.provide(itemHandle, progressMonitor);
        return item;
    }

    protected IItem[] fetchCurrentCallCompleteItems(IItemHandle[] itemHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (itemHandles == null) {
            return this.fetchCompleteItems(itemHandles, progressMonitor);
        }
        if (itemHandles.length == 0) {
            return EMPTYIITEMARRAY;
        }
        IItem[] fetchedItems = this.provide(itemHandles, progressMonitor);
        return fetchedItems;
    }

    public IProcessProvider getProcessProvider(IProjectArea area, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.resetReloadProjectAreaOnce();
        IProcessProvider processProvider = this.getInternalProcessProvider(area, progressMonitor);
        return processProvider;
    }

    protected IProcessProvider getInternalProcessProvider(IProjectArea area, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProcessProvider provider = null;
        IProgressMonitor monitor = this.getProgressMonitor(progressMonitor);
        monitor.beginTask("Fetching process from provider... ", 1000);
        try {
            IProcessContainerHandle providerHandle = this.innerGetProcessProviderHandle(area, this.newSubProgressMonitor(monitor, 500));
            if (providerHandle != null) {
                provider = (IProcessProvider)this.fetchCurrentCallCompleteItem((IItemHandle)providerHandle, this.newSubProgressMonitor(monitor, 500));
            }
            IProcessProvider iProcessProvider = provider;
            return iProcessProvider;
        }
        finally {
            monitor.done();
        }
    }

    private IProcessProvider innerGetProcessProvider(IProjectArea area, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProcessProvider provider = null;
        IProgressMonitor monitor = this.getProgressMonitor(progressMonitor);
        monitor.beginTask("Fetching process from provider... ", 1000);
        try {
            IProcessContainerHandle providerHandle = this.innerGetProcessProviderHandle(area, this.newSubProgressMonitor(monitor, 500));
            if (providerHandle != null) {
                provider = (IProcessProvider)this.fetchCurrentCallCompleteItem((IItemHandle)providerHandle, this.newSubProgressMonitor(monitor, 500));
            }
            IProcessProvider iProcessProvider = provider;
            return iProcessProvider;
        }
        finally {
            monitor.done();
        }
    }

    private IProcessProvider getInternalProcessProvider(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProcessProvider provider = null;
        IProgressMonitor monitor = this.getProgressMonitor(progressMonitor);
        monitor.beginTask("Fetching process from provider... ", 1000);
        try {
            IProcessContainerHandle providerHandle = this.getProcessProviderHandle(this.newSubProgressMonitor(monitor, 500));
            if (providerHandle != null) {
                provider = (IProcessProvider)this.fetchCurrentCallCompleteItem((IItemHandle)providerHandle, this.newSubProgressMonitor(monitor, 500));
            }
            IProcessProvider iProcessProvider = provider;
            return iProcessProvider;
        }
        finally {
            monitor.done();
        }
    }

    public IProcessAttachment[] getProcessAttachments(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAttachment[] attachments = this.getInternalProcessAttachments(processArea, monitor);
        return attachments;
    }

    protected IProcessAttachment[] getInternalProcessAttachments(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IProcessAttachment> allAttachments;
        processArea = this.confirmProcessArea(processArea, monitor);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.8"), 1000);
        try {
            IItem[] providerAttachments;
            IProcessAttachmentHandle[] processAreaAttachmentHandles = processArea.getAttachments();
            IItem[] projectAreaAttachmentItems = this.fetchCompleteItems((IItemHandle[])processAreaAttachmentHandles, this.newSubProgressMonitor(monitor, 400));
            ArrayList<IProcessAttachment> processAreaAttachments = new ArrayList<IProcessAttachment>(projectAreaAttachmentItems == null ? 0 : projectAreaAttachmentItems.length);
            if (projectAreaAttachmentItems != null) {
                IItem[] iItemArray = projectAreaAttachmentItems;
                int n = projectAreaAttachmentItems.length;
                int n2 = 0;
                while (n2 < n) {
                    IItem processAttachmentItem = iItemArray[n2];
                    processAreaAttachments.add((IProcessAttachment)processAttachmentItem);
                    ++n2;
                }
            }
            if ((providerAttachments = this.innerGetProcessProviderAttachmentItems(processArea, this.newSubProgressMonitor(monitor, 600))) == null || providerAttachments.length == 0) {
                allAttachments = processAreaAttachments;
            } else {
                allAttachments = new ArrayList(processAreaAttachments.size() + (providerAttachments == null ? 0 : providerAttachments.length));
                ProcessAttachmentFilePathComparator attachmentComparator = new ProcessAttachmentFilePathComparator();
                Collections.sort(processAreaAttachments, attachmentComparator);
                IItem[] iItemArray = providerAttachments;
                int n = providerAttachments.length;
                int n3 = 0;
                while (n3 < n) {
                    IItem providerAttachmentItem = iItemArray[n3];
                    IProcessAttachment attachment = (IProcessAttachment)providerAttachmentItem;
                    int foundIndex = Collections.binarySearch(processAreaAttachments, attachment, attachmentComparator);
                    if (foundIndex < 0) {
                        allAttachments.add(attachment);
                    }
                    ++n3;
                }
                allAttachments.addAll(processAreaAttachments);
            }
        }
        finally {
            monitor.done();
        }
        IProcessAttachment[] attachments = allAttachments.toArray(new IProcessAttachment[allAttachments.size()]);
        return attachments;
    }

    private IItem[] innerGetProcessProviderAttachmentItems(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAttachmentHandle[] providerAttachmentHandles;
        IProjectArea projectArea;
        IProcessProvider provider;
        if (processArea instanceof IProjectArea && (provider = this.getInternalProcessProvider(projectArea = (IProjectArea)processArea, this.newSubProgressMonitor(monitor, 200))) != null && (providerAttachmentHandles = provider.getAttachments()).length > 0) {
            IItem[] items = this.fetchCompleteItems((IItemHandle[])providerAttachmentHandles, this.newSubProgressMonitor(monitor, 400));
            return items;
        }
        return EMPTYIITEMARRAY;
    }

    protected IProcessContainerHandle getProcessProviderHandle(IProjectArea area, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.attemptGetInternalProjectArea();
        this.assertSameProjectArea(area, projectArea);
        return this.innerGetProcessProviderHandle(projectArea, monitor);
    }

    private IProcessContainerHandle innerGetProcessProviderHandle(IProjectArea projectArea, IProgressMonitor monitor) {
        try {
            IProjectAreaHandle providerProjectAreaHandle = ((ProjectArea)projectArea).getProcessProvider();
            if (providerProjectAreaHandle != null) {
                return providerProjectAreaHandle;
            }
            IProcessProviderCacheItemHandle providerHandle = ((ProjectArea)projectArea).getRemoteProcessProvider();
            if (providerHandle != null) {
                return providerHandle;
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
        return null;
    }

    private IProcessContainerHandle getProcessProviderHandle(IProgressMonitor monitor) {
        try {
            IProjectArea projectArea = this.attemptGetInternalProjectArea();
            IProjectAreaHandle providerProjectAreaHandle = ((ProjectArea)projectArea).getProcessProvider();
            if (providerProjectAreaHandle != null) {
                return providerProjectAreaHandle;
            }
            IProcessProviderCacheItemHandle providerHandle = ((ProjectArea)projectArea).getRemoteProcessProvider();
            if (providerHandle != null) {
                return providerHandle;
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
        return null;
    }

    private boolean isPremiumProjectArea(IProjectArea projectArea) {
        boolean isPremiumProject = false;
        if (projectArea instanceof ProjectArea) {
            isPremiumProject = ((ProjectArea)projectArea).isPremiumProject();
        }
        return isPremiumProject;
    }

    protected IPermissionConfigurationData[] getInternalPermissionConfigurations(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationPermissionsConfiguration[] opPermissions = this.getInternalCachedPermissionConfigurations(processArea, operationId, actions, monitor);
        IPermissionConfigurationData[] returnedPermissions = new PermissionConfigurationData[opPermissions.length];
        int i = 0;
        OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = opPermissions;
        int n = opPermissions.length;
        int n2 = 0;
        while (n2 < n) {
            OperationPermissionsConfiguration opPermission = operationPermissionsConfigurationArray[n2];
            returnedPermissions[i++] = new PermissionConfigurationData(opPermission);
            ++n2;
        }
        return returnedPermissions;
    }

    private OperationPermissionsConfiguration[] getInternalCachedPermissionConfigurations(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.getInternalProjectArea();
        if (processArea instanceof ITeamArea) {
            ITeamArea startingTeamArea = (ITeamArea)this.confirmProcessArea(processArea, projectArea, monitor);
            return this.innerGetCachedPermissionConfigurationsForTeam(startingTeamArea, projectArea, operationId, actions, monitor);
        }
        if (processArea instanceof IProjectArea) {
            this.assertSameProjectArea(processArea, projectArea);
            return this.innerGetCachedPermissionConfigurationsForProject(projectArea, operationId, actions, monitor);
        }
        throw new TeamRepositoryException(processArea + " is not a TeamArea or ProjectArea and cannot be used in getPermissionConfiguration");
    }

    private OperationPermissionsConfiguration[] innerGetCachedPermissionConfigurationsForTeam(ITeamArea teamArea, IProjectArea projectArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        IProcessAreaHandle startingAreaHandle = teamArea == null ? null : (IProcessAreaHandle)teamArea.getStateHandle();
        IDevelopmentLine line = this.getDevelopmentLine(teamArea, this.newSubProgressMonitor(monitor, 100));
        IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
        CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
        ITeamAreaHandle[] teamAreas = this.innerComputeTeamAreaPathArray(teamArea, projectArea);
        IContributorHandle contributor = this.getContributor();
        OperationPermissionsConfiguration[] permissionConfigs = null;
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            permissionConfigs = this.createAnyPermissions();
        } else {
            permissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions);
            if (permissionConfigs == null) {
                IRole[] roles = this.innerGetContributorRolesForTeam(contributor, teamArea, projectArea, true, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = roles == null || roles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, roles, line, currentIterationInfos, teamAreas, operationId, actions, this.newSubProgressMonitor(monitor, 900));
                permissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, startingAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions, permissionConfigs, this);
            }
        }
        return permissionConfigs;
    }

    private OperationPermissionsConfiguration[] innerGetCachedPermissionConfigurationsForProject(IProjectArea projectArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        IDevelopmentLine line = this.getDevelopmentLine(projectArea, this.newSubProgressMonitor(monitor, 100));
        IDevelopmentLineHandle lineHandle = line == null ? null : (IDevelopmentLineHandle)line.getStateHandle();
        CurrentIterationInfo[] currentIterationInfos = line == null ? null : this.getCurrentIterationInfos(line, this.newSubProgressMonitor(monitor, 100));
        ITeamAreaHandle[] teamAreas = new ITeamAreaHandle[]{};
        IContributorHandle contributor = this.getContributor();
        OperationPermissionsConfiguration[] permissionConfigs = null;
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            permissionConfigs = this.createAnyPermissions();
        } else {
            permissionConfigs = fPermittedActionCache.getPermissions(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions);
            if (permissionConfigs == null) {
                IRole[] roles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = roles == null || roles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetPermissionConfigurations(projectArea, processProvider, roles, line, currentIterationInfos, teamAreas, operationId, actions, this.newSubProgressMonitor(monitor, 900));
                permissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(operationId, projectAreaHandle, processProviderHandle, projectAreaHandle, teamAreas, contributor, lineHandle, currentIterationInfos, actions, permissionConfigs);
            }
        }
        return permissionConfigs;
    }

    protected IPermissionConfigurationData[] getInternalPermissionConfigurations(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationPermissionsConfiguration[] opPermissions = this.getInternalCachedPermissionConfigurations(projectOperationId, actions, monitor);
        IPermissionConfigurationData[] returnedPermissions = new PermissionConfigurationData[opPermissions.length];
        int i = 0;
        OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = opPermissions;
        int n = opPermissions.length;
        int n2 = 0;
        while (n2 < n) {
            OperationPermissionsConfiguration opPermission = operationPermissionsConfigurationArray[n2];
            returnedPermissions[i++] = new PermissionConfigurationData(opPermission);
            ++n2;
        }
        return returnedPermissions;
    }

    private OperationPermissionsConfiguration[] getInternalCachedPermissionConfigurations(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle contributor = this.getContributor();
        IProjectArea projectArea = this.getInternalProjectArea();
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)projectArea.getStateHandle();
        IProcessProvider processProvider = this.getInternalProcessProvider(projectArea, this.newSubProgressMonitor(monitor, 100));
        IProcessContainerHandle processProviderHandle = processProvider == null ? null : (IProcessContainerHandle)processProvider.getStateHandle();
        OperationPermissionsConfiguration[] permissionConfigs = null;
        if (!this.shouldCheckPermissions(this.newSubProgressMonitor(monitor, 10), this.isPremiumProjectArea(projectArea))) {
            permissionConfigs = this.createAnyPermissions();
        } else {
            permissionConfigs = fPermittedActionCache.getPermissions(projectOperationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, actions);
            if (permissionConfigs == null) {
                IRole[] roles = this.innerGetContributorRolesForProject(contributor, projectArea, this.newSubProgressMonitor(monitor, 10));
                permissionConfigs = roles == null || roles.length == 0 ? new OperationPermissionsConfiguration[]{} : this.innerGetStaticPermissionConfigurations(projectArea, processProvider, roles, projectOperationId, actions, this.newSubProgressMonitor(monitor, 500));
                permissionConfigs = fPermittedActionCache.addToCacheAndGetPermissions(projectOperationId, projectAreaHandle, processProviderHandle, null, null, contributor, null, null, actions, permissionConfigs);
            }
        }
        return permissionConfigs;
    }
}

