/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.specification;

import com.ibm.team.process.internal.common.model.ProcessModelChange;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.RoleDefinitions;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.util.ConfigurationPath;

public class WriteableProcessSpecificationModel
extends ProcessSpecificationModel {
    public WriteableProcessSpecificationModel() {
        this.setIsReadOnly(false);
    }

    public ProcessModelChange[] revokeProjectConfigurationPermissions(String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        ProjectConfigurationElement projectConfiguration = this.getProjectConfiguration();
        PermissionsElement permissions = projectConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, false, permissions);
    }

    public ProcessModelChange[] grantProjectConfigurationPermissions(String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        ProjectConfigurationElement projectConfiguration = this.getProjectConfiguration();
        return this.grantConfigurationPermissions(roleId, paths, projectConfiguration, projectConfiguration.getPermissions());
    }

    public ProcessModelChange[] updateProjectConfigurationBehavior(String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents) {
        this.assertNotReadOnly();
        ProjectConfigurationElement configuration = this.getProjectConfiguration();
        BehaviorElement behavior = configuration.getBehavior();
        ProcessModelChange change = this.updateConfigurationBehavior(roleId, paths, enabled, isFinal, names, descriptions, optionals, namespaces, xmlContents, configuration, behavior);
        return new ProcessModelChange[]{change};
    }

    public ProcessModelChange[] changeProjectConfigurationOperation(String roleId, String operationId, boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        ProjectConfigurationElement projectConfiguration = this.getProjectConfiguration();
        return this.changeOperation(roleId, operationId, isFinal, explanation, projectConfiguration, projectConfiguration.getPermissions());
    }

    public ProcessModelChange[] addRoleDefinitions(String[] roleIds, String[] names, String[] descriptions, boolean[] singleCardinality) {
        this.assertNotReadOnly();
        ProcessSpecificationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        return this.createRoleDefinitions(roleIds, names, descriptions, singleCardinality, roleDefinitionsElement);
    }

    public ProcessModelChange[] removeRoleDefinitions(String[] roleIds) {
        this.assertNotReadOnly();
        ProcessSpecificationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        return this.removeRoleDefinitions(roleIds, roleDefinitionsElement);
    }

    public ProcessModelChange[] removeRoles(String[] roleIds) {
        PermissionsElement permissionsElement;
        this.assertNotReadOnly();
        ProcessModelChange[] changes = new ProcessModelChange[3];
        ProcessSpecificationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        ProcessModelChange[] tempChanges = this.removeRoleDefinitions(roleIds, roleDefinitionsElement);
        changes[0] = tempChanges[0];
        if (root.getProjectConfiguration() != null) {
            permissionsElement = root.getProjectConfiguration().getPermissions();
            tempChanges = this.removeRolePermission(roleIds, permissionsElement);
            changes[1] = tempChanges[0];
        } else {
            changes[1] = null;
        }
        if (root.getTeamConfiguration() != null) {
            permissionsElement = root.getTeamConfiguration().getPermissions();
            tempChanges = this.removeRolePermission(roleIds, permissionsElement);
            changes[2] = tempChanges[0];
        } else {
            changes[2] = null;
        }
        return changes;
    }

    public ProcessModelChange addIteration(ConfigurationPath iterationPath, IterationConfiguration iterationConfiguration) {
        this.assertNotReadOnly();
        String timelineId = iterationPath.segment(0);
        DevelopmentLineConfiguration timelineConfiguration = this.getDevelopmentLineConfiguration(timelineId);
        iterationPath = iterationPath.removeFirstSegments(1);
        if (timelineConfiguration == null) {
            timelineConfiguration = this.createDevelopmentLineConfiguration(timelineId, this.getTeamConfiguration());
            if (iterationPath.segmentCount() == 1) {
                timelineConfiguration.addChildElement(iterationConfiguration);
                return this.generateChangesForNewDevelopmentLine(timelineConfiguration)[0];
            }
        }
        IterationConfiguration[] iterationConfigurations = this.getIterationConfigurations(timelineConfiguration, iterationPath.segments());
        IterationConfiguration newIterationConfiguration = iterationConfigurations[0];
        IterationConfiguration lastIterationConfiguration = iterationConfigurations[1];
        if (newIterationConfiguration != null) {
            return this.generateChangesForNewIteration(newIterationConfiguration)[0];
        }
        lastIterationConfiguration.addChildElement(iterationConfiguration);
        String changedXML = lastIterationConfiguration.toXML(this.computeLineIndent(this.getCurrentDocument(), lastIterationConfiguration.getStartOffset()), this.getLineDelimiter());
        return new ProcessModelChange(lastIterationConfiguration.getStartOffset(), lastIterationConfiguration.getEndOffset(), changedXML);
    }
}

