/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.specification;

import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.ProcessModelChange;
import com.ibm.team.process.internal.common.model.settings.RoleDefinitions;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationBuilder;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationElement;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.util.XMLUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessSpecificationModel
extends AbstractModel {
    public static final int COMPLETE = 2;
    public static final int ITERATION_STRUCTURE_ONLY = 4;
    private final int fFlags;

    public ProcessSpecificationModel() {
        this(2);
    }

    public ProcessSpecificationModel(int flags) {
        this.fFlags = flags;
    }

    @Override
    protected ModelGenerator createModelGenerator() {
        ModelGenerator generator = new ModelGenerator(this);
        if ((this.fFlags & 4) != 0) {
            generator.setDirective(ElementBuilderDirectives.ITERATION_STRUCTURE_ONLY, Boolean.TRUE);
        }
        return generator;
    }

    @Override
    public ProcessSpecificationElement getRoot() {
        List childElements = this.getChildElements();
        if (childElements.size() > 0) {
            return (ProcessSpecificationElement)childElements.get(0);
        }
        return null;
    }

    public static String toXMLData(ProcessSpecificationElement settings) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = settings.createElement(document);
            root.setAttribute("xmlns", "http://com.ibm.team.process");
            document.appendChild(root);
            return AbstractModel.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            InternalProcessCommon.log(e);
        }
        catch (TransformerException e) {
            InternalProcessCommon.log(e);
        }
        catch (IOException e) {
            InternalProcessCommon.log(e);
        }
        return null;
    }

    @Override
    public AbstractElementBuilder getRootBuilder() {
        return new ProcessSpecificationBuilder();
    }

    @Override
    public TeamConfigurationElement getTeamConfiguration() {
        return (TeamConfigurationElement)super.getTeamConfiguration();
    }

    public ProjectConfigurationElement getProjectConfiguration() {
        ProcessSpecificationElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return root.getProjectConfiguration();
        }
        return null;
    }

    public ProjectConfigurationElement createProjectConfigurationElement() {
        ProcessSpecificationElement root = this.getRoot();
        ProjectConfigurationElement projectConfigurationElement = new ProjectConfigurationElement(root, root.getNamespaceURI(), "project-configuration", null);
        root.addChildElement(projectConfigurationElement);
        return projectConfigurationElement;
    }

    public DataElement createDataElement(ProjectConfigurationElement parent) {
        DataElement dataElement = new DataElement(parent, parent.getNamespaceURI(), "data", null);
        parent.addChildElement(dataElement);
        return dataElement;
    }

    protected ProcessModelChange generateChangesForNewProjectConfiguration(ProjectConfigurationElement projectConfigurationElement) {
        ProcessSpecificationElement parent = (ProcessSpecificationElement)projectConfigurationElement.getParentElement();
        int startOffset = parent.getStartTagEndOffset() + 1;
        RoleDefinitions roleDefinitions = parent.getRoleDefinitionsElement();
        if (roleDefinitions != null) {
            startOffset = roleDefinitions.getEndOffset() + 1;
        }
        StringBuilder sb = new StringBuilder(this.getLineDelimiter());
        projectConfigurationElement.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter(), sb);
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, sb.toString());
        return change;
    }

    protected ProcessModelChange generateChangesForNewData(DataElement dataElement) {
        ProjectConfigurationElement parent = (ProjectConfigurationElement)dataElement.getParentElement();
        int startOffset = parent.getStartTagEndOffset() + 1;
        AbstractElement siblingElement = null;
        siblingElement = parent.getBehavior();
        if (siblingElement == null && (siblingElement = parent.getPermissions()) == null) {
            siblingElement = parent.getInitialization();
        }
        if (siblingElement != null) {
            startOffset = siblingElement.getEndOffset() + 1;
        }
        StringBuilder sb = new StringBuilder(this.getLineDelimiter());
        dataElement.toXML("\t\t", this.getLineDelimiter(), sb);
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, sb.toString());
        return change;
    }

    public ProcessModelChange generateChangesForNewData() {
        ProjectConfigurationElement projectConfigurationElement = this.getProjectConfiguration();
        DataElement dataElement = null;
        ProcessModelChange change = null;
        if (projectConfigurationElement == null) {
            projectConfigurationElement = this.createProjectConfigurationElement();
            dataElement = this.createDataElement(projectConfigurationElement);
            change = this.generateChangesForNewProjectConfiguration(projectConfigurationElement);
        } else {
            dataElement = projectConfigurationElement.getData();
            if (dataElement == null) {
                dataElement = this.createDataElement(projectConfigurationElement);
                change = this.generateChangesForNewData(dataElement);
            }
        }
        return change;
    }

    public ProcessModelChange changeConfigurationData(String configurationDataId, String configurationDataContent, boolean isFinal) throws TeamRepositoryException {
        ConfigurationDataElement[] configurationDataElements;
        XMLMemento xmlMemento = null;
        try {
            if (configurationDataContent == null || configurationDataContent.length() == 0) {
                xmlMemento = XMLMemento.createWriteRoot((String)"configuration-data");
                xmlMemento.putString("id", configurationDataId);
            } else {
                xmlMemento = XMLMemento.createReadRoot((Reader)new StringReader(configurationDataContent));
            }
        }
        catch (CoreException e) {
            throw new TeamRepositoryException(e.getMessage());
        }
        xmlMemento.putBoolean("final", isFinal);
        String lineDelimiter = this.getLineDelimiter();
        configurationDataContent = XMLUtil.asXMLString(xmlMemento, lineDelimiter);
        if (configurationDataContent.endsWith(lineDelimiter)) {
            configurationDataContent = configurationDataContent.substring(0, configurationDataContent.length() - 1);
        }
        String prefix = "\t\t\t";
        configurationDataContent = configurationDataContent.replaceAll(lineDelimiter, String.valueOf(lineDelimiter) + prefix);
        DataElement dataElement = this.getProjectConfiguration().getData();
        ProcessModelChange configDataChange = null;
        ConfigurationDataElement[] configurationDataElementArray = configurationDataElements = this.getProjectConfiguration().getData().getConfigurationData();
        int n = configurationDataElements.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDataElement element = configurationDataElementArray[n2];
            if (element.getId().equals(configurationDataId)) {
                configDataChange = new ProcessModelChange(element.getStartOffset(), element.getEndOffset(), configurationDataContent);
                break;
            }
            ++n2;
        }
        if (configDataChange == null) {
            configDataChange = new ProcessModelChange(dataElement.getEndOffset() - 7, dataElement.getEndOffset() - 7, "\t" + configurationDataContent + lineDelimiter + "\t\t");
        }
        return configDataChange;
    }

    public ProcessModelChange removeConfigurationData(String configurationDataId) throws TeamRepositoryException {
        ConfigurationDataElement[] configurationDataElements;
        ProcessModelChange configDataChange = null;
        ConfigurationDataElement[] configurationDataElementArray = configurationDataElements = this.getProjectConfiguration().getData().getConfigurationData();
        int n = configurationDataElements.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDataElement element = configurationDataElementArray[n2];
            if (element.getId().equals(configurationDataId)) {
                configDataChange = new ProcessModelChange(element.getStartOffset(), element.getEndOffset(), "");
                break;
            }
            ++n2;
        }
        return configDataChange;
    }
}

