/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.specification;

import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.BuildContext;
import com.ibm.team.process.internal.common.model.IUniqueElement;
import com.ibm.team.process.internal.common.model.SingularChildElement;
import com.ibm.team.process.internal.common.model.UniqueChildElementClassGroup;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class ConfigurationDataElement
extends AbstractElement
implements IProcessConfigurationData,
IUniqueElement {
    private boolean fIsFinal;
    private boolean fIsInheritedFromProcessProvider = false;
    private static final String NOTHING = "";
    public static final ConfigurationDataElement NULLREPRESENTATION = new ConfigurationDataElement(null, "", "", null){

        @Override
        protected void addAttributes(Element element) {
        }

        @Override
        public void setIsInheritedFromProcessProvider(boolean isInheritedFromProcessProvider) {
        }

        @Override
        public void setParent(AbstractElement parent) {
        }

        @Override
        public void setIsFinal(boolean isFinal) {
        }

        @Override
        public void setOffsetsForStart(BuildContext context) {
        }

        @Override
        public void setOffsetsForEnd(BuildContext context) {
        }

        @Override
        public void setStartTagEndOffset(int offset) {
        }

        @Override
        public void setStartOffset(int offset) {
        }

        @Override
        public void setSelectionStartOffset(int offset) {
        }

        @Override
        public void setSelectionLength(int length) {
        }

        @Override
        public void setEndOffset(int offset) {
        }

        @Override
        public void setEndOffset(BuildContext context) {
        }

        @Override
        protected void registerGrouping(UniqueChildElementClassGroup ... knownUniqueGrouping) {
        }

        @Override
        protected void addChildElementToGrouping(AbstractElement child) {
        }

        @Override
        protected void addChildElementToGrouping(int location, AbstractElement child) {
        }

        @Override
        protected void removeChildElementFromGrouping(AbstractElement child) {
        }

        @Override
        protected void registerDefined(SingularChildElement ... knownSingularDefined) {
        }

        @Override
        public void appendElement(Element parent, Document document) {
        }

        @Override
        public void modifyAttribute(String name, String value) {
        }

        @Override
        public void setCharacterData(String characters) {
        }

        @Override
        public AbstractElement addChildElement(AbstractElement child) {
            return null;
        }

        @Override
        public AbstractElement addChildElement(int location, AbstractElement child) {
            return null;
        }

        @Override
        public AbstractElement removeChildElement(AbstractElement child) {
            return null;
        }

        @Override
        public boolean clearChildElements() {
            return false;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    };

    public ConfigurationDataElement(AbstractElement parent, String namespaceURI, String localName, Attributes attributes) {
        super(parent, namespaceURI, localName, attributes);
        if (attributes != null) {
            this.processAttributes(attributes);
        }
    }

    private void processAttributes(Attributes attributes) {
        this.fIsFinal = Boolean.parseBoolean(attributes.getValue("final"));
    }

    @Override
    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    public IProcessConfigurationElement[] getElements() {
        List children = this.getChildElements();
        return children.toArray(new IProcessConfigurationElement[children.size()]);
    }

    public boolean isInheritedFromProcessProvider() {
        return this.fIsInheritedFromProcessProvider;
    }

    public void setIsInheritedFromProcessProvider(boolean isInheritedFromProcessProvider) {
        this.fIsInheritedFromProcessProvider = isInheritedFromProcessProvider;
    }

    @Override
    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        if (appendPrefix) {
            sb.append(prefix);
        }
        String name = this.getName();
        sb.append('<').append(name);
        Object[] attributeNames = this.getAttributeNames();
        Arrays.sort(attributeNames);
        Object[] objectArray = attributeNames;
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object attributeName = objectArray[n2];
            this.appendXmlAttribute((String)attributeName, sb);
            ++n2;
        }
        IProcessConfigurationElement[] children = this.getElements();
        String characterData = this.getCharacterData();
        if (children.length == 0 && characterData == null) {
            sb.append("/>").append(lineDelimiter);
        } else {
            sb.append('>').append(lineDelimiter);
            if (characterData != null) {
                characterData = this.escapeXML(characterData);
                sb.append(String.valueOf(prefix) + '\t').append(characterData).append(lineDelimiter);
            }
            int i = 0;
            while (i < children.length) {
                IProcessConfigurationElement child = children[i];
                ((ProcessConfigurationElement)child).toXML(String.valueOf(prefix) + '\t', lineDelimiter, sb);
                ++i;
            }
            sb.append(prefix).append("</").append(name).append('>').append(lineDelimiter);
        }
    }

    public boolean isFinal() {
        return this.fIsFinal;
    }

    public void setIsFinal(boolean isFinal) {
        this.fIsFinal = isFinal;
    }

    public ConfigurationDataElement duplicate() {
        ConfigurationDataElement data = new ConfigurationDataElement(this.getParentElement(), this.getNamespaceURI(), this.getName(), null);
        data.fAttributes.putAll(this.fAttributes);
        data.setIsFinal(this.isFinal());
        data.setIsInheritedFromProcessProvider(this.isInheritedFromProcessProvider());
        data.setCharacterData(this.getCharacterData());
        List children = this.getChildElements();
        for (IProcessConfigurationElement child : children) {
            data.addChildElement((AbstractElement)((Object)child));
        }
        return data;
    }
}

