/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.specification;

import com.ibm.team.process.common.IAddition;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.AbstractElement;
import java.util.List;
import org.xml.sax.Attributes;

public class AdditionElement
extends AbstractElement
implements IAddition {
    public AdditionElement(AbstractElement parent, String namespaceURI, String name, Attributes attributes) {
        super(parent, namespaceURI, name, attributes);
    }

    @Override
    public List<IProcessConfigurationElement> getElementsToBeAdded() {
        return this.getChildElements();
    }

    public String getRawMergeDepth() {
        return this.getAttribute("merge-depth");
    }

    @Override
    public int getMergeDepth() {
        String value = this.getRawMergeDepth();
        int result = 0;
        if (value == null) {
            return result;
        }
        if (value.equals("unlimited")) {
            return -1;
        }
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
        return result;
    }

    public String getRawLocation() {
        return this.getAttribute("location");
    }

    @Override
    public IAddition.Location getLocation() {
        String value = this.getRawLocation();
        if (value == null) {
            return IAddition.Location.LAST_CHILD;
        }
        if (value.equals("before")) {
            return IAddition.Location.BEFORE;
        }
        if (value.equals("after")) {
            return IAddition.Location.AFTER;
        }
        if (value.equals("first-child")) {
            return IAddition.Location.FIRST_CHILD;
        }
        if (value.equals("last-child")) {
            return IAddition.Location.LAST_CHILD;
        }
        return IAddition.Location.UNKNOWN;
    }

    @Override
    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        super.toXML(prefix, lineDelimiter, new String[]{"merge-depth", "location"}, sb, appendPrefix, false);
    }
}

