/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.settings;

import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.IUniqueElement;
import org.xml.sax.Attributes;

public class RoleDefinition
extends AbstractElement
implements IRole2,
IUniqueElement {
    private int fCardinality = 0;
    public static final String STRING_CARDINALITY_SINGLE = "single";
    public static final String STRING_CARDINALITY_MANY = "many";

    public RoleDefinition(AbstractElement parent, String namespaceURI, String name, Attributes attributes) {
        super(parent, namespaceURI, name, attributes);
        this.processAttributes();
    }

    protected void processAttributes() {
        String cardinality = this.getAttribute("cardinality");
        if (cardinality != null) {
            this.fCardinality = cardinality.equalsIgnoreCase(STRING_CARDINALITY_SINGLE) ? 1 : 0;
        }
    }

    @Override
    public String getAttribute(String name) {
        String value = super.getAttribute(name);
        if ("description".equals(name)) {
            return value == null ? "" : value;
        }
        return value;
    }

    @Override
    public int getCardinality() {
        return this.fCardinality;
    }

    @Override
    public String getDescription() {
        return this.getAttribute("description");
    }

    @Override
    public String getId() {
        return this.getAttribute("role-id");
    }

    @Override
    public String getRoleName() {
        return this.getAttribute("name");
    }

    @Override
    public String getRoleLabel() {
        String label = this.getRoleName();
        if (label != null && label.trim().length() > 0) {
            return label;
        }
        return this.getId();
    }

    public boolean equals(Object other) {
        if (other instanceof IRole) {
            return this.getId().equals(((IRole)other).getId());
        }
        return super.equals(other);
    }

    public int hashCode() {
        String id = this.getId();
        return id == null ? super.hashCode() : 31 * super.hashCode() + id.hashCode();
    }

    @Override
    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        String roleName;
        if (appendPrefix) {
            sb.append(prefix);
        }
        sb.append('<').append("role-definition");
        this.appendXmlAttribute("cardinality", sb);
        String description = this.getDescription();
        if (description != null && description.length() > 0) {
            this.appendXmlAttribute("description", description, sb);
        }
        if ((roleName = this.getRoleName()) == null || roleName.trim().length() == 0) {
            roleName = "";
        }
        this.appendXmlAttribute("name", roleName, sb);
        this.appendXmlAttribute("role-id", sb);
        sb.append("/>").append(lineDelimiter);
    }
}

