/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.customization;

import com.ibm.team.process.internal.common.model.ProcessModelChange;
import com.ibm.team.process.internal.common.model.customization.Messages;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationElement;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.RoleDefinitions;
import com.ibm.team.process.internal.common.util.ConfigurationPath;

public class WriteableTeamCustomizationModel
extends TeamCustomizationModel {
    private boolean fNewCustomization = false;

    public WriteableTeamCustomizationModel() {
        this.setIsReadOnly(false);
    }

    public void setNewCustomization(boolean newCustomization) {
        this.assertNotReadOnly();
        this.fNewCustomization = newCustomization;
    }

    public boolean isNewCustomization() {
        return this.fNewCustomization;
    }

    @Override
    public ProcessModelChange[] grantIterationPermissions(String notUsed, ConfigurationPath iterationPath, String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        TeamCustomizationElement teamCustomization = (TeamCustomizationElement)this.getTeamConfiguration();
        return this.grantIterationPermissions(iterationPath, roleId, paths, teamCustomization);
    }

    @Override
    public ProcessModelChange[] revokeIterationPermissions(String notUsed, ConfigurationPath iterationPath, String roleId, ConfigurationPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        TeamCustomizationElement teamCustomization = (TeamCustomizationElement)this.getTeamConfiguration();
        return this.revokeIterationPermissions(iterationPath, roleId, paths, teamCustomization, clearOverride);
    }

    public ProcessModelChange[] changeDevelopmentLineOperation(String developmentLineId, String roleId, String operationId, boolean isFinal, String explanation) {
        throw new IllegalStateException(Messages.getCommonString("TeamCustomizationModel.0"));
    }

    public static String getDefaultXML() {
        String lineDelimiter = System.getProperty("line.separator");
        String expectedXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineDelimiter + "<team-customization xmlns=\"http://com.ibm.team.process\">" + lineDelimiter + "\t<permissions>" + lineDelimiter + "\t</permissions>" + lineDelimiter + "\t<behavior>" + lineDelimiter + "\t</behavior>" + lineDelimiter + "</team-customization>" + lineDelimiter;
        return expectedXML;
    }

    public ProcessModelChange[] addRoleDefinitions(String[] roleIds, String[] names, String[] descriptions, boolean[] singleCardinality) {
        this.assertNotReadOnly();
        TeamCustomizationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        return this.createRoleDefinitions(roleIds, names, descriptions, singleCardinality, roleDefinitionsElement);
    }

    public ProcessModelChange[] removeRoleDefinitions(String[] roleIds) {
        this.assertNotReadOnly();
        TeamCustomizationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        return this.removeRoleDefinitions(roleIds, roleDefinitionsElement);
    }
}

