/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.IUniqueDependentElement;
import com.ibm.team.process.internal.common.model.IUniqueElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UniqueChildElementClassGroup<T extends AbstractElement> {
    private static final int DEFAULTINITIALSIZE = 10;
    private HashMap<String, T> map = null;
    private ArrayList<T> list = null;
    private T[] array = null;
    Class classType;
    int initialSize = 10;

    public UniqueChildElementClassGroup(Class<T> classType) {
        this.classType = classType;
    }

    public UniqueChildElementClassGroup(Class<T> classType, int initialSize) {
        this.classType = classType;
        if (initialSize > 1) {
            this.initialSize = initialSize;
        }
    }

    public Class getClassType() {
        return this.classType;
    }

    public void load(AbstractElement parent) {
        this.clearElements();
        if (parent != null) {
            for (AbstractElement child : parent.getChildElements()) {
                this.addElement(child);
            }
        }
    }

    public AbstractElement addElement(AbstractElement child) {
        if (child != null && this.classType.isInstance(child)) {
            IUniqueDependentElement uchild;
            AbstractElement tchild = child;
            if (this.list == null) {
                this.list = new ArrayList(this.initialSize);
            }
            this.list.add(tchild);
            if (tchild instanceof IUniqueElement) {
                IUniqueElement uchild2 = (IUniqueElement)((Object)tchild);
                if (uchild2.getId() != null) {
                    if (this.map == null) {
                        this.map = new HashMap(this.initialSize);
                    }
                    this.map.put(uchild2.getId(), tchild);
                }
            } else if (tchild instanceof IUniqueDependentElement && (uchild = (IUniqueDependentElement)((Object)tchild)).getDependentId() != null) {
                if (this.map == null) {
                    this.map = new HashMap(this.initialSize);
                }
                this.map.put(uchild.getDependentId(), tchild);
            }
            this.array = null;
        }
        return child;
    }

    public AbstractElement removeElement(AbstractElement child) {
        if (child != null && this.classType.isInstance(child)) {
            if (this.list != null) {
                this.list.remove(child);
            }
            if (this.map != null) {
                String key;
                if (IUniqueElement.class.isInstance(child)) {
                    String key2 = ((IUniqueElement)((Object)child)).getId();
                    if (key2 != null) {
                        this.map.remove(key2);
                    }
                } else if (IUniqueDependentElement.class.isInstance(child) && (key = ((IUniqueDependentElement)((Object)child)).getDependentId()) != null) {
                    this.map.remove(key);
                }
            }
            this.array = null;
        }
        return child;
    }

    public void updateIds(String oldKey, String newKey, AbstractElement child) {
        if (child == null) {
            return;
        }
        if (this.classType.isInstance(child)) {
            AbstractElement tchild = child;
            if (oldKey != null && this.map != null) {
                AbstractElement temp = (AbstractElement)this.map.remove(oldKey);
                if (newKey != null) {
                    if (temp != null) {
                        this.map.put(newKey, temp);
                    } else {
                        this.map.put(newKey, tchild);
                    }
                }
            } else if (newKey != null && this.map == null && child != null) {
                if (this.map == null) {
                    this.map = new HashMap();
                }
                this.map.put(newKey, tchild);
            }
        }
    }

    public boolean trimToSize() {
        if (this.list != null) {
            this.list.trimToSize();
        }
        if (this.array == null) {
            AbstractElement[] arrayTemp;
            if (this.list == null || this.list.size() == 0) {
                arrayTemp = (AbstractElement[])Array.newInstance(this.classType, 0);
                this.array = arrayTemp;
            } else {
                arrayTemp = (AbstractElement[])Array.newInstance(this.classType, this.list.size());
                arrayTemp = this.list.toArray(arrayTemp);
                this.array = arrayTemp;
            }
        }
        if (this.map != null) {
            HashMap<String, T> temp = this.map;
            this.map = new HashMap<String, T>(this.map);
            temp.clear();
            Object var1_1 = null;
        }
        return true;
    }

    public boolean clearElements() {
        this.list = null;
        this.map = null;
        this.array = null;
        return true;
    }

    public T[] getElements() {
        if (this.array == null) {
            if (this.list == null || this.list.size() == 0) {
                AbstractElement[] arrayTemp = (AbstractElement[])Array.newInstance(this.classType, 0);
                this.array = arrayTemp;
            } else {
                AbstractElement[] arrayTemp = (AbstractElement[])Array.newInstance(this.classType, this.list.size());
                arrayTemp = this.list.toArray(arrayTemp);
                this.array = arrayTemp;
            }
        }
        return this.array;
    }

    public List<T> getElementList() {
        if (this.list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.list);
    }

    public T getElement(String id) {
        if (id == null) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        AbstractElement element = (AbstractElement)this.map.get(id);
        return (T)element;
    }

    public Set<String> getElementIds() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Map<String, T> getElementMap() {
        if (this.map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.map);
    }
}

