/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.BuildContext;
import com.ibm.team.process.internal.common.model.Messages;
import com.ibm.team.process.internal.common.model.ModelParsingException;
import com.ibm.team.process.internal.common.model.StartBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ModelHandler
extends DefaultHandler {
    private final AbstractModel fModel;
    private BuildContext fContext;
    private AbstractElementBuilder fCurrentBuilder;
    private Stack fBuilder = new Stack();

    public ModelHandler(AbstractModel model) {
        this.fModel = model;
        this.fContext = new BuildContext(this.fModel);
        this.fCurrentBuilder = new StartBuilder(model.getRootBuilder());
        this.fBuilder.push(this.fCurrentBuilder);
    }

    public void setDirectives(Map directives) {
        this.fContext.setDirectives(directives);
    }

    @Override
    public void error(SAXParseException e) {
        this.fModel.error(new ModelParsingException(e, this.fContext.getCurrentModelElement()));
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.fModel.fatalError(new ModelParsingException(e, this.fContext.getCurrentModelElement()));
    }

    @Override
    public void warning(SAXParseException e) {
        this.fModel.warning(new ModelParsingException(e, this.fContext.getCurrentModelElement()));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AbstractElementBuilder next = this.fCurrentBuilder.childStart(uri, localName, qName, attributes, this.fContext);
        if (next == null) {
            throw new ModelParsingException(NLS.bind(Messages.getCommonString("ModelHandler.0"), qName), this.fContext);
        }
        this.fBuilder.push(this.fCurrentBuilder);
        this.fCurrentBuilder = next;
        this.fCurrentBuilder.start(uri, localName, qName, attributes, this.fContext);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        this.fCurrentBuilder.end(uri, localName, this.fContext);
        this.fCurrentBuilder = (AbstractElementBuilder)this.fBuilder.pop();
        if (this.fCurrentBuilder != null) {
            this.fCurrentBuilder.childEnd(uri, localName, qName, this.fContext);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fCurrentBuilder != null) {
            this.fCurrentBuilder.characters(ch, start, length, this.fContext);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fContext.setLocator(locator);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null) {
            if (systemId.startsWith("file:/") && systemId.endsWith(".xsd") || systemId.startsWith("platform:/")) {
                return null;
            }
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }
}

