/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelHandler;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ModelGenerator {
    private static final String SAX_PROPERTIES_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String SAX_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String SAX_FEATURES_INCLUDE_XMLNS_ATTRIBUTE = "http://xml.org/sax/features/namespace-prefixes";
    private AbstractModel fModel;
    private Map fDirectives;

    public ModelGenerator(AbstractModel model) {
        this.fModel = model;
    }

    public void setDirective(Object directive, Object value) {
        if (value == null) {
            if (this.fDirectives != null) {
                this.fDirectives.remove(directive);
                if (this.fDirectives.isEmpty()) {
                    this.fDirectives = null;
                }
            }
        } else {
            if (this.fDirectives == null) {
                this.fDirectives = new HashMap();
            }
            this.fDirectives.put(directive, value);
        }
    }

    public Object getDirective(Object directive) {
        if (this.fDirectives == null) {
            return null;
        }
        return this.fDirectives.get(directive);
    }

    private Map getDirectives() {
        return this.fDirectives;
    }

    public void generate(String textToParse) {
        StringReader stream = new StringReader(textToParse);
        InputSource inputSource = new InputSource(stream);
        try {
            ModelHandler handler = new ModelHandler(this.getProcessModel());
            handler.setDirectives(this.getDirectives());
            XMLReader reader = this.getXMLReader();
            reader.setContentHandler(handler);
            reader.setEntityResolver(handler);
            reader.setErrorHandler(handler);
            reader.setDTDHandler(handler);
            reader.setFeature(SAX_FEATURES_INCLUDE_XMLNS_ATTRIBUTE, this.getDirective(ElementBuilderDirectives.INCLUDE_XMLNS_ATTRIBUTE) != null);
            this.enableValidation(this.getDirective(ElementBuilderDirectives.USE_SCHEMA) != null, reader, (String)this.getDirective(ElementBuilderDirectives.USE_SCHEMA));
            reader.parse(inputSource);
        }
        catch (SAXException x) {
            this.getProcessModel().error(x);
        }
        catch (UnsupportedEncodingException x) {
            this.getProcessModel().error(x);
        }
        catch (IOException x) {
            this.getProcessModel().error(x);
        }
    }

    private void enableValidation(boolean enable, XMLReader parser, String schemaLocations) throws SAXNotRecognizedException, SAXNotSupportedException {
        parser.setFeature(SAX_FEATURES_VALIDATION, enable);
        try {
            parser.setFeature(SAX_FEATURES_VALIDATION_SCHEMA, enable);
            if (enable) {
                parser.setProperty(SAX_PROPERTIES_SCHEMA_LOCATION, schemaLocations);
            } else {
                parser.setProperty(SAX_PROPERTIES_SCHEMA_LOCATION, null);
            }
        }
        catch (SAXNotRecognizedException e) {
            parser.setFeature(SAX_FEATURES_VALIDATION, false);
        }
    }

    private AbstractModel getProcessModel() {
        return this.fModel;
    }

    private XMLReader getXMLReader() {
        try {
            SAXParserFactory nsParserFactory = SAXParserFactory.newInstance();
            nsParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            nsParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            nsParserFactory.setNamespaceAware(true);
            return nsParserFactory.newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return null;
    }
}

