/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.internal.common.ITeamConfiguration;
import com.ibm.team.process.internal.common.ProcessModelUtilities;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.IIterationParent;
import com.ibm.team.process.internal.common.model.Messages;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.ProcessModelChange;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationElement;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.BehaviorRoleElement;
import com.ibm.team.process.internal.common.model.settings.IPermissionActionParent;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsRoleElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.settings.RoleDefinition;
import com.ibm.team.process.internal.common.model.settings.RoleDefinitions;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.rest.ExtensionDTO;
import com.ibm.team.process.internal.common.util.ConfigurationPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractModel
extends AbstractElement {
    public static final String XMLNS = "xmlns";
    public static final String EMPTY = "";
    private Exception fException = null;
    protected ModelGenerator fModelGenerator = null;
    private IDocument fCurrentDocument;
    private ExtensionDTO[] fProjectPermissions;
    private ExtensionDTO[] fTeamPermissions;
    private boolean fIsReadOnly = true;

    protected AbstractModel() {
        super(null, null, EMPTY, null);
    }

    public Exception initialize(String xmlData) {
        if (this.fModelGenerator == null) {
            if (xmlData != null && xmlData.trim().length() > 0) {
                try {
                    this.fModelGenerator = this.createModelGenerator();
                    if (this.fModelGenerator.getDirective(ElementBuilderDirectives.COMPUTE_ELEMENT_OFFSETS) != null) {
                        this.fCurrentDocument = new Document(xmlData);
                    }
                    this.fModelGenerator.generate(xmlData);
                }
                catch (RuntimeException e) {
                    this.fException = e;
                }
            }
            return this.fException;
        }
        this.fException = new Exception(Messages.getCommonString("AbstractModel.1"));
        return this.fException;
    }

    public Exception initialize(IDocument xmlDocument) {
        if (this.fModelGenerator == null) {
            this.fCurrentDocument = xmlDocument;
            String xmlData = xmlDocument.get();
            if (xmlData != null && xmlData.trim().length() > 0) {
                try {
                    this.fModelGenerator = this.createModelGenerator();
                    this.fModelGenerator.generate(xmlData);
                }
                catch (RuntimeException e) {
                    this.fException = e;
                }
            }
            return this.fException;
        }
        this.fException = new Exception(Messages.getCommonString("AbstractModel.2"));
        return this.fException;
    }

    protected ModelGenerator createModelGenerator() {
        return new ModelGenerator(this);
    }

    public abstract AbstractElementBuilder getRootBuilder();

    public void dispose() {
        this.fCurrentDocument = null;
        this.clearChildElements();
    }

    public void warning(Exception x) {
    }

    public void error(Exception x) {
        this.fException = x;
    }

    public void fatalError(Exception x) {
        this.fException = x;
    }

    public static String serializeDocument(org.w3c.dom.Document doc) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(new OutputStreamWriter((OutputStream)s, "UTF-8"));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public IDocument getCurrentDocument() {
        return this.fCurrentDocument;
    }

    @Override
    protected void toXML(String prefix, String lineDelimiter, StringBuilder sb, boolean appendPrefix) {
        if (this.getChildElements().size() > 0) {
            AbstractElement mainElement = (AbstractElement)this.getChildElements().get(0);
            if (this.getCurrentDocument() != null && mainElement.getStartOffset() > 0) {
                try {
                    sb.append(this.getCurrentDocument().get(0, mainElement.getStartOffset()));
                }
                catch (Exception exception) {}
            } else {
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(lineDelimiter);
            }
            mainElement.toXML(prefix, lineDelimiter, sb);
        }
    }

    public ITeamConfiguration getTeamConfiguration() {
        AbstractElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return ((ProcessSpecificationElement)root).getTeamConfiguration();
        }
        return null;
    }

    public abstract AbstractElement getRoot();

    public IRole2[] getRoleDefinitions() {
        AbstractElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return ((ProcessSpecificationElement)root).getRoleDefinitions();
        }
        if (root instanceof TeamCustomizationElement) {
            return ((TeamCustomizationElement)root).getRoleDefinitions();
        }
        return new IRole2[0];
    }

    public Map<String, IRole2> getRoleDefinitionsMap() {
        AbstractElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return ((ProcessSpecificationElement)root).getRoleDefinitionsMap();
        }
        if (root instanceof TeamCustomizationElement) {
            return ((TeamCustomizationElement)root).getRoleDefinitionsMap();
        }
        return new HashMap<String, IRole2>();
    }

    public IRole2 getRoleDefinition(String id) {
        if (id == null) {
            return null;
        }
        AbstractElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return ((ProcessSpecificationElement)root).getRoleDefinition(id);
        }
        if (root instanceof TeamCustomizationElement) {
            return ((TeamCustomizationElement)root).getRoleDefinition(id);
        }
        return null;
    }

    protected ProcessModelChange[] revokePermissions(String roleId, ConfigurationPath[] paths, boolean clearOverride, PermissionsElement permissions) {
        ProcessModelChange[] changes = new ProcessModelChange[paths.length];
        int i = 0;
        while (i < paths.length) {
            ConfigurationPath path = paths[i];
            String operationId = path.segments()[0];
            String actionPath = null;
            if (path.segmentCount() > 1) {
                actionPath = path.removeFirstSegments(1).toString();
            }
            changes[i] = this.revokePermission(roleId, operationId, actionPath, clearOverride, permissions);
            ++i;
        }
        return changes;
    }

    private ProcessModelChange revokePermission(String roleId, String operationId, String actionPath, boolean clearOverride, PermissionsElement permissions) {
        if (permissions == null) {
            return null;
        }
        PermissionsRoleElement roleElement = permissions.getRoleElement(roleId);
        if (roleElement == null) {
            return null;
        }
        AbstractElement changedElement = null;
        OperationPermissionsConfiguration operation = roleElement.getOperation(operationId);
        if (operation == null) {
            return null;
        }
        if (actionPath == null) {
            if (operation.isFinal() && !clearOverride) {
                operation.clearChildElements();
                changedElement = operation;
            } else {
                roleElement.removeOperation(operation.getId());
                if (roleElement.getOperations().length == 0) {
                    permissions.removeRoleElement(roleElement.getId());
                    changedElement = permissions;
                } else {
                    changedElement = roleElement;
                }
            }
        } else {
            ConfigurationPath path = new ConfigurationPath(actionPath);
            changedElement = this.removeAction(path, operation, null);
        }
        if (changedElement != null) {
            return this.generateProcessModelChangeToReplaceElement(changedElement);
        }
        return null;
    }

    private List getPermittedActions(AbstractElement element) {
        String operationId = this.getOperationId(element);
        String id = EMPTY;
        id = element instanceof PermissionActionElement ? ((PermissionActionElement)element).getId() : ((OperationPermissionsConfiguration)element).getId();
        boolean isProjectPermission = this.isProjectPermission(element);
        ExtensionDTO[] permissions = isProjectPermission ? this.fProjectPermissions : this.fTeamPermissions;
        ExtensionDTO operationPermissionDTO = null;
        int i = 0;
        while (i < permissions.length) {
            ExtensionDTO category = permissions[i];
            operationPermissionDTO = this.getPermissionDTO(operationId, category);
            if (operationPermissionDTO != null) break;
            ++i;
        }
        if (operationPermissionDTO != null) {
            if (id.equals(operationId)) {
                return operationPermissionDTO.getItems();
            }
            ExtensionDTO parent = operationPermissionDTO;
            ArrayList<AbstractElement> parents = new ArrayList<AbstractElement>();
            AbstractElement parentElement = element.getParentElement();
            while (!(parentElement instanceof OperationPermissionsConfiguration)) {
                parents.add(parentElement);
                parentElement = parentElement.getParentElement();
            }
            int i2 = parents.size() - 1;
            while (i2 > -1) {
                parentElement = (AbstractElement)parents.get(i2);
                String parentElementId = parentElement instanceof PermissionActionElement ? ((PermissionActionElement)parentElement).getId() : ((OperationPermissionsConfiguration)parentElement).getId();
                parent = this.getPermissionDTO(parentElementId, parent);
                --i2;
            }
            ExtensionDTO permissionDTO = this.getPermissionDTO(id, parent);
            if (permissionDTO != null) {
                return permissionDTO.getItems();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isProjectPermission(AbstractElement element) {
        AbstractElement parent = element.getParentElement();
        if (parent instanceof ProjectConfigurationElement) {
            return true;
        }
        if (parent instanceof TeamConfigurationElement) {
            return false;
        }
        if (parent instanceof TeamCustomizationElement) {
            return false;
        }
        return this.isProjectPermission(parent);
    }

    private ExtensionDTO getPermissionDTO(String id, ExtensionDTO parent) {
        if (parent == null) {
            return null;
        }
        Iterator children = parent.getItems().iterator();
        ExtensionDTO permissionDTO = null;
        while (children.hasNext()) {
            ExtensionDTO permission = (ExtensionDTO)children.next();
            String permissionId = new ConfigurationPath(permission.getId()).lastSegment();
            if (!permissionId.equals(id)) continue;
            permissionDTO = permission;
            break;
        }
        return permissionDTO;
    }

    private AbstractElement removeAction(ConfigurationPath actionPath, IPermissionActionParent parent, AbstractElement changedElement) {
        if (parent == null) {
            return null;
        }
        String actionId = actionPath.segment(0);
        if (actionPath.segmentCount() == 1) {
            if (!actionId.equals("any") && parent.getAction("any") != null) {
                parent.clearChildElements();
                this.createPermittedActions((AbstractElement)((Object)parent));
                if (changedElement == null) {
                    changedElement = (AbstractElement)((Object)parent);
                }
            }
            if (parent.removeAction(actionId) != null && changedElement == null && (changedElement = this.cleanupHierarchy((AbstractElement)((Object)parent))) == null) {
                changedElement = (AbstractElement)((Object)parent);
            }
            return changedElement;
        }
        if (parent.getAction("any") != null) {
            parent.clearChildElements();
            this.createPermittedActions((AbstractElement)((Object)parent));
            if (parent.getStartOffset() != -1) {
                changedElement = (AbstractElement)((Object)parent);
            }
        }
        return this.removeAction(actionPath.removeFirstSegments(1), parent.getAction(actionId), changedElement);
    }

    private void createPermittedActions(AbstractElement parent) {
        List permittedActions = this.getPermittedActions(parent);
        for (ExtensionDTO action : permittedActions) {
            String permissionId = new ConfigurationPath(action.getId()).lastSegment();
            PermissionActionElement createdAction = this.createPermissionAction(parent, permissionId);
            if (action.getItems().size() <= 0) continue;
            this.createAnyPermissionAction(createdAction);
        }
    }

    private AbstractElement cleanupHierarchy(AbstractElement element) {
        PermissionsRoleElement roleElement;
        AbstractElement parentElement = element.getParentElement();
        if (element instanceof IPermissionActionParent) {
            IPermissionActionParent actionParent = (IPermissionActionParent)((Object)element);
            if (actionParent.getActions().length == 0) {
                AbstractElement changedElement;
                if (parentElement instanceof PermissionsRoleElement) {
                    OperationPermissionsConfiguration operation = (OperationPermissionsConfiguration)element;
                    if (!operation.isFinal()) {
                        ((PermissionsRoleElement)parentElement).removeOperation(actionParent.getId());
                    }
                } else {
                    ((IPermissionActionParent)((Object)parentElement)).removeAction(actionParent.getId());
                }
                if ((changedElement = this.cleanupHierarchy(parentElement)) == null) {
                    changedElement = parentElement;
                }
                return changedElement;
            }
        } else if (element instanceof PermissionsRoleElement && (roleElement = (PermissionsRoleElement)element).getOperations().length == 0) {
            ((PermissionsElement)parentElement).removeRoleElement(roleElement.getId());
            return parentElement;
        }
        return null;
    }

    public ProcessModelChange[] revokeTeamConfigurationPermissions(String roleId, ConfigurationPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        if (teamConfiguration == null) {
            return new ProcessModelChange[1];
        }
        PermissionsElement permissions = teamConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] grantTeamConfigurationPermissions(String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ProcessModelChange[] changes = this.grantConfigurationPermissions(roleId, paths, (AbstractElement)teamConfiguration.getElement(), teamConfiguration.getTeamConfiguration().getPermissions());
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        }
        return changes;
    }

    protected ProcessModelChange[] grantConfigurationPermissions(String roleId, ConfigurationPath[] paths, AbstractElement configuration, PermissionsElement permissions) {
        boolean newPermissions = false;
        if (permissions == null) {
            permissions = this.createPermissionsElement(configuration);
            this.createRoleElement(roleId, permissions);
            newPermissions = true;
        }
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (newPermissions) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    public ProcessModelChange[] grantDevelopmentLinePermissions(String developmentLineId, String roleId, ConfigurationPath[] paths) {
        PermissionsElement permissions;
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ElementHolder<DevelopmentLineConfiguration> developmentLineConfiguration = this.getOrCreateDevelopmentLineConfiguration(developmentLineId, teamConfiguration);
        if (developmentLineConfiguration.isNew()) {
            permissions = this.createPermissionsElement(developmentLineConfiguration.getElement());
            this.createRoleElement(roleId, permissions);
        }
        permissions = developmentLineConfiguration.getElement().getPermissions();
        boolean newPermissions = false;
        if (permissions == null) {
            permissions = this.createPermissionsElement(developmentLineConfiguration.getElement());
            this.createRoleElement(roleId, permissions);
            newPermissions = true;
        }
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        } else if (developmentLineConfiguration.isNew()) {
            changes = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration.getElement());
        } else if (newPermissions) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    public ProcessModelChange[] grantIterationTypePermissions(String iterationTypeId, String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        IterationTypeConfiguration[] iterationTypeConfigurations = this.getIterationTypeConfigurations(teamConfiguration, iterationTypeId, roleId);
        IterationTypeConfiguration newIterationTypeConfiguration = iterationTypeConfigurations[0];
        IterationTypeConfiguration iterationTypeConfiguration = iterationTypeConfigurations[1];
        PermissionsElement permissions = this.getPermissions(iterationTypeConfiguration, roleId);
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        } else if (newIterationTypeConfiguration != null) {
            changes = this.generateChangesForNewIterationType(newIterationTypeConfiguration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    protected ProcessModelChange[] generateChangesForNewDevelopmentLine(DevelopmentLineConfiguration developmentLineConfiguration) {
        IterationTypeConfiguration[] iterationTypes;
        TeamConfigurationElement parentElement = (TeamConfigurationElement)developmentLineConfiguration.getParentElement();
        AbstractElement previousSibling = null;
        DevelopmentLineConfiguration[] devLines = parentElement.getDevelopmentLineConfigurations();
        if (devLines.length > 1) {
            previousSibling = devLines[devLines.length - 2];
        }
        if (previousSibling == null && (iterationTypes = parentElement.getIterationTypeConfigurations()) != null && iterationTypes.length > 0) {
            previousSibling = iterationTypes[iterationTypes.length - 1];
        }
        if (previousSibling == null) {
            previousSibling = parentElement.getBehavior();
        }
        if (previousSibling == null) {
            previousSibling = parentElement.getPermissions();
        }
        return this.generateChangesForNewConfiguration(developmentLineConfiguration, parentElement, previousSibling);
    }

    private ProcessModelChange[] generateChangesForNewIterationType(IterationTypeConfiguration iterationTypeConfiguration) {
        ITeamConfiguration parentElement = (ITeamConfiguration)((Object)iterationTypeConfiguration.getParentElement());
        AbstractElement previousSibling = null;
        IterationTypeConfiguration[] iterationTypes = parentElement.getIterationTypeConfigurations();
        if (iterationTypes.length > 1) {
            previousSibling = iterationTypes[iterationTypes.length - 2];
        }
        if (previousSibling == null) {
            previousSibling = parentElement.getBehavior();
        }
        if (previousSibling == null) {
            previousSibling = parentElement.getPermissions();
        }
        if (previousSibling == null && parentElement instanceof TeamCustomizationElement) {
            previousSibling = ((TeamCustomizationElement)parentElement).getRoleDefinitionsElement();
        }
        return this.generateChangesForNewConfiguration(iterationTypeConfiguration, (AbstractElement)((Object)parentElement), previousSibling);
    }

    protected ProcessModelChange[] generateChangesForNewIteration(IterationConfiguration iterationConfiguration) {
        IterationTypeConfiguration[] iterationTypes;
        IIterationParent parentElement = (IIterationParent)((Object)iterationConfiguration.getParentElement());
        AbstractElement previousSibling = null;
        IterationConfiguration[] iterations = parentElement.getIterationConfigurations();
        if (iterations.length > 1) {
            previousSibling = iterations[iterations.length - 2];
        }
        if (previousSibling == null && parentElement instanceof TeamCustomizationElement && (iterationTypes = ((TeamCustomizationElement)parentElement).getIterationTypeConfigurations()) != null && iterationTypes.length > 0) {
            previousSibling = iterationTypes[iterationTypes.length - 1];
        }
        if (previousSibling == null) {
            previousSibling = parentElement.getBehavior();
        }
        if (previousSibling == null) {
            previousSibling = parentElement.getPermissions();
        }
        if (previousSibling == null && parentElement instanceof TeamCustomizationElement) {
            previousSibling = ((TeamCustomizationElement)parentElement).getRoleDefinitionsElement();
        }
        return this.generateChangesForNewConfiguration(iterationConfiguration, (AbstractElement)((Object)parentElement), previousSibling);
    }

    protected ProcessModelChange[] generateChangesForNewPermissions(PermissionsElement permissions) {
        AbstractElement parentElement = permissions.getParentElement();
        AbstractElement previousSibling = null;
        if (parentElement instanceof ProjectConfigurationElement) {
            previousSibling = ((ProjectConfigurationElement)parentElement).getInitialization();
        }
        if (parentElement instanceof TeamCustomizationElement) {
            previousSibling = ((TeamCustomizationElement)parentElement).getRoleDefinitionsElement();
        }
        return this.generateChangesForNewConfiguration(permissions, parentElement, previousSibling);
    }

    protected ProcessModelChange[] generateChangesForNewTeamConfiguration(TeamConfigurationElement teamConfiguration) {
        if (teamConfiguration == null) {
            return new ProcessModelChange[1];
        }
        ProcessSpecificationElement parentElement = (ProcessSpecificationElement)teamConfiguration.getParentElement();
        AbstractElement previousSibling = parentElement.getProjectConfiguration();
        if (previousSibling == null) {
            previousSibling = parentElement.getRoleDefinitionsElement();
        }
        return this.generateChangesForNewConfiguration(teamConfiguration, parentElement, previousSibling);
    }

    private ProcessModelChange[] generateChangesForNewConfiguration(AbstractElement configuration, AbstractElement parentElement, AbstractElement previousSibling) {
        int startOffset;
        StringBuilder changedXML = new StringBuilder();
        if (previousSibling == null) {
            startOffset = parentElement.getStartTagEndOffset() + 1;
            configuration.toXML(this.computeLineIndent(this.getCurrentDocument(), parentElement.getStartOffset()), this.getLineDelimiter(), changedXML);
        } else {
            startOffset = previousSibling.getEndOffset();
            configuration.toXML(this.computeLineIndent(this.getCurrentDocument(), parentElement.getStartOffset()), this.getLineDelimiter(), changedXML);
        }
        startOffset += this.getLineDelimiterLength(startOffset);
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, changedXML.toString());
        return new ProcessModelChange[]{change};
    }

    private int getLineDelimiterLength(int offset) {
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getCurrentDocument().getLineDelimiter(this.getCurrentDocument().getLineOfOffset(offset));
            if (lineDelimiter != null && this.getCurrentDocument().get(offset, lineDelimiter.length()).equals(lineDelimiter)) {
                return lineDelimiter.length();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private ProcessModelChange generateProcessModelChangeToReplaceElement(AbstractElement changedElement) {
        String changedXML = changedElement.toXML(this.computeLineIndent(this.getCurrentDocument(), changedElement.getParentElement().getStartOffset()), this.getLineDelimiter());
        int endOffset = changedElement.getEndOffset() + this.getLineDelimiterLength(changedElement.getEndOffset());
        return new ProcessModelChange(changedElement.getStartOffset(), endOffset, changedXML);
    }

    public ProcessModelChange[] grantIterationPermissions(String developmentLineId, ConfigurationPath iterationPath, String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ElementHolder<DevelopmentLineConfiguration> developmentLineConfiguration = this.getOrCreateDevelopmentLineConfiguration(developmentLineId, teamConfiguration);
        ProcessModelChange[] changes = this.grantIterationPermissions(iterationPath, roleId, paths, developmentLineConfiguration.getElement());
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        } else if (developmentLineConfiguration.isNew()) {
            changes = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration.getElement());
        }
        return changes;
    }

    protected ProcessModelChange[] grantIterationPermissions(ConfigurationPath iterationPath, String roleId, ConfigurationPath[] paths, IIterationParent iterationParent) {
        IterationConfiguration[] configurations = this.getIterationConfigurations(iterationParent, iterationPath.segments());
        IterationConfiguration newIteration = configurations[0];
        IterationConfiguration iterationConfiguration = configurations[1];
        PermissionsElement permissions = this.getPermissions(iterationConfiguration, roleId);
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (newIteration != null) {
            changes = this.generateChangesForNewIteration(newIteration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    public ProcessModelChange[] grantIterationPermissions(String developmentLineId, String iterationId, String roleId, ConfigurationPath[] paths) {
        this.assertNotReadOnly();
        return this.grantIterationPermissions(developmentLineId, new ConfigurationPath(iterationId), roleId, paths);
    }

    protected IterationConfiguration createIterationConfiguration(String iterationId, AbstractElement parentConfiguration) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, iterationId);
        IterationConfiguration iteration = new IterationConfiguration(parentConfiguration, parentConfiguration.getNamespaceURI(), "iteration", attributes);
        parentConfiguration.addChildElement(iteration);
        return iteration;
    }

    public ProcessModelChange[] revokeDevelopmentLinePermissions(String developmentLineId, String roleId, ConfigurationPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        DevelopmentLineConfiguration devLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        if (devLineConfiguration == null) {
            return new ProcessModelChange[1];
        }
        PermissionsElement permissions = devLineConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] revokeIterationTypePermissions(String iterationTypeId, String roleId, ConfigurationPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        IterationTypeConfiguration iterationTypeConfiguration = this.getIterationTypeConfiguration(iterationTypeId);
        if (iterationTypeConfiguration == null) {
            return new ProcessModelChange[1];
        }
        PermissionsElement permissions = iterationTypeConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] revokeIterationPermissions(String developmentLineId, ConfigurationPath iterationPath, String roleId, ConfigurationPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        DevelopmentLineConfiguration devLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        return this.revokeIterationPermissions(iterationPath, roleId, paths, devLineConfiguration, clearOverride);
    }

    protected ProcessModelChange[] revokeIterationPermissions(ConfigurationPath iterationPath, String roleId, ConfigurationPath[] paths, IIterationParent iterationParent, boolean clearOverride) {
        if (iterationParent == null) {
            return new ProcessModelChange[1];
        }
        String[] iterationIds = iterationPath.segments();
        IterationConfiguration iteration = iterationParent.getIterationConfiguration(iterationIds[0]);
        if (iteration == null) {
            return new ProcessModelChange[1];
        }
        int i = 1;
        while (i < iterationIds.length) {
            String iterationId = iterationIds[i];
            if ((iteration = iteration.getIteration(iterationId)) == null) {
                return new ProcessModelChange[1];
            }
            ++i;
        }
        PermissionsElement permissions = iteration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] revokeIterationPermissions(String developmentLineId, String iterationId, String roleId, ConfigurationPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        return this.revokeIterationPermissions(developmentLineId, new ConfigurationPath(iterationId), roleId, paths, clearOverride);
    }

    protected DevelopmentLineConfiguration getDevelopmentLineConfiguration(String developmentLineId) {
        if (this instanceof TeamCustomizationModel) {
            return null;
        }
        TeamConfigurationElement teamConfiguration = (TeamConfigurationElement)this.getTeamConfiguration();
        if (teamConfiguration != null) {
            return teamConfiguration.getDevelopmentLineConfiguration(developmentLineId);
        }
        return null;
    }

    public IterationConfiguration getIterationConfiguration(ConfigurationPath iterationPath) {
        IterationConfiguration iterationConfiguration = null;
        DevelopmentLineConfiguration timelineConfiguration = this.getDevelopmentLineConfiguration(iterationPath.segment(0));
        if (timelineConfiguration != null && iterationPath.segmentCount() > 1 && (iterationConfiguration = timelineConfiguration.getIterationConfiguration(iterationPath.segment(1))) != null) {
            String[] segments = iterationPath.segments();
            int i = 2;
            while (i < segments.length) {
                if ((iterationConfiguration = iterationConfiguration.getIteration(segments[i])) == null) break;
                ++i;
            }
        }
        return iterationConfiguration;
    }

    private IterationTypeConfiguration getIterationTypeConfiguration(String iterationTypeId) {
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        return teamConfiguration == null ? null : teamConfiguration.getIterationTypeConfiguration(iterationTypeId);
    }

    protected ProcessModelChange[] grantPermissions(String roleId, ConfigurationPath[] paths, PermissionsElement permissions) {
        ProcessModelChange[] changes = new ProcessModelChange[paths.length];
        int i = 0;
        while (i < paths.length) {
            ConfigurationPath path = paths[i];
            String operationId = path.segments()[0];
            String actionPath = null;
            if (path.segmentCount() > 1) {
                actionPath = path.removeFirstSegments(1).toString();
            }
            changes[i] = this.grantPermission(roleId, operationId, actionPath, permissions);
            ++i;
        }
        return changes;
    }

    private ProcessModelChange grantPermission(String roleId, String operationId, String actionPath, PermissionsElement permissions) {
        PermissionsRoleElement roleElement = permissions.getRoleElement(roleId);
        if (roleElement == null) {
            roleElement = this.createRoleElement(roleId, permissions);
            if (actionPath == null || actionPath.equals("any")) {
                this.createOperationPermissionConfigurationWithAnyPermissionAction(roleElement, operationId);
            } else {
                OperationPermissionsConfiguration operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
                this.createPermissionActions(operation, actionPath);
            }
            return this.generateProcessModelChangeToReplaceElement(permissions);
        }
        AbstractElement changedElement = null;
        if (actionPath == null || actionPath.equals("any")) {
            OperationPermissionsConfiguration operation = roleElement.getOperation(operationId);
            if (operation == null) {
                this.createOperationPermissionConfigurationWithAnyPermissionAction(roleElement, operationId);
                changedElement = roleElement;
            } else {
                this.createAnyPermissionAction(operation);
                changedElement = operation;
            }
        } else {
            OperationPermissionsConfiguration operation = roleElement.getOperation(operationId);
            if (operation == null) {
                operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
                this.createPermissionActions(operation, actionPath);
                changedElement = roleElement;
            } else {
                ConfigurationPath path = new ConfigurationPath(actionPath);
                String actionId = path.segment(0);
                PermissionActionElement action = operation.getAction(actionId);
                if (action == null) {
                    action = operation.getAction("any");
                    if (action == null) {
                        this.createPermissionActions(operation, actionPath);
                        changedElement = operation;
                    }
                } else if (path.segmentCount() > 1) {
                    String[] segments = path.segments();
                    int i = 1;
                    while (i < segments.length) {
                        actionId = segments[i];
                        boolean isAnyAction = actionId.equals("any");
                        PermissionActionElement childAction = action.getAction(actionId);
                        if (childAction == null) {
                            childAction = action.getAction("any");
                            if (childAction == null) {
                                if (isAnyAction) {
                                    action.clearChildElements();
                                }
                                if ((changedElement = this.createPermissionActions(action, path.removeFirstSegments(i).toString())) == null) {
                                    changedElement = action;
                                }
                            }
                            break;
                        }
                        action = childAction;
                        ++i;
                    }
                } else if (action.getChildElements().size() > 1 || action.getAction("any") == null) {
                    this.createAnyPermissionAction(action);
                    changedElement = action;
                }
            }
        }
        if (changedElement != null) {
            return this.generateProcessModelChangeToReplaceElement(changedElement);
        }
        return null;
    }

    protected String getLineDelimiter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.getCurrentDocument());
    }

    protected String computeLineIndent(IDocument document, int offset) {
        String indent = EMPTY;
        try {
            int lineOffset = document.getLineOffset(document.getLineOfOffset(offset));
            indent = document.get(lineOffset, offset - lineOffset);
            if (indent.trim().length() != 0) {
                indent = EMPTY;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        indent = String.valueOf(indent) + "\t";
        return indent;
    }

    protected TeamConfigurationElement createTeamConfigurationElement(AbstractElement parent) {
        TeamConfigurationElement teamConfigurationElement = new TeamConfigurationElement(parent, parent.getNamespaceURI(), "team-configuration", null);
        parent.addChildElement(teamConfigurationElement);
        return teamConfigurationElement;
    }

    protected PermissionsElement createPermissionsElement(AbstractElement permissionsParent) {
        PermissionsElement permissions = new PermissionsElement(permissionsParent, permissionsParent.getNamespaceURI(), "permissions", null);
        permissionsParent.addChildElement(permissions);
        return permissions;
    }

    protected PermissionsRoleElement createRoleElement(String roleId, PermissionsElement permissions) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, roleId);
        PermissionsRoleElement roleElement = new PermissionsRoleElement((AbstractElement)permissions, permissions.getNamespaceURI(), "role", attributes);
        permissions.addChildElement(roleElement);
        return roleElement;
    }

    protected DevelopmentLineConfiguration createDevelopmentLineConfiguration(String developmentLineId, TeamConfigurationElement teamConfiguration) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, developmentLineId);
        DevelopmentLineConfiguration developmentLine = new DevelopmentLineConfiguration((AbstractElement)teamConfiguration, teamConfiguration.getNamespaceURI(), "timeline", attributes);
        teamConfiguration.addChildElement(developmentLine);
        return developmentLine;
    }

    private IterationTypeConfiguration createIterationTypeConfiguration(String iterationTypeId, ITeamConfiguration teamConfiguration) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, iterationTypeId);
        IterationTypeConfiguration iterationTypeConfiguration = new IterationTypeConfiguration((AbstractElement)((Object)teamConfiguration), teamConfiguration.getNamespaceURI(), "iteration-type", attributes);
        teamConfiguration.addChildElement(iterationTypeConfiguration);
        return iterationTypeConfiguration;
    }

    private OperationPermissionsConfiguration createOperationPermissionConfigurationWithAnyPermissionAction(AbstractElement parent, String operationId) {
        OperationPermissionsConfiguration anyConfig = this.createOperationPermissionsConfiguration(parent, operationId);
        this.createAnyPermissionAction(anyConfig);
        return anyConfig;
    }

    private OperationPermissionsConfiguration createOperationPermissionsConfiguration(AbstractElement parent, String operationId) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, operationId);
        String name = this.getOperationName(parent);
        OperationPermissionsConfiguration anyConfig = new OperationPermissionsConfiguration(parent, parent.getNamespaceURI(), name, attributes);
        parent.addChildElement(anyConfig);
        return anyConfig;
    }

    private String getOperationName(AbstractElement parent) {
        AbstractElement configuration = parent.getParentElement().getParentElement();
        if (configuration instanceof ProjectConfigurationElement) {
            return "project-operation";
        }
        return "operation";
    }

    private void createAnyPermissionAction(AbstractElement parent) {
        parent.clearChildElements();
        this.createPermissionAction(parent, "any");
    }

    private AbstractElement createPermissionActions(AbstractElement parent, String actionPath) {
        AbstractElement changedElement;
        ConfigurationPath path = new ConfigurationPath(actionPath);
        String[] actionIds = path.segments();
        PermissionActionElement parentAction = this.createPermissionAction(parent, actionIds[0]);
        int i = 1;
        while (i < actionIds.length) {
            parentAction = this.createPermissionAction(parentAction, actionIds[i]);
            ++i;
        }
        List permittedActions = this.getPermittedActions(parentAction);
        if (permittedActions.size() > 0) {
            this.createAnyPermissionAction(parentAction);
        }
        if ((changedElement = this.injectAnyActionsAsRequiredInHierarchy(parentAction, null)) != null) {
            return changedElement;
        }
        return null;
    }

    private AbstractElement injectAnyActionsAsRequiredInHierarchy(AbstractElement parentAction, AbstractElement changedElement) {
        AbstractElement parentElement = parentAction.getParentElement();
        List permittedActions = this.getPermittedActions(parentElement);
        List childElements = parentElement.getChildElements();
        if (permittedActions.size() == childElements.size()) {
            boolean allChildrenGranted = true;
            for (PermissionActionElement childAction : childElements) {
                if (childAction.getAction("any") != null || this.getPermittedActions(childAction).isEmpty()) continue;
                allChildrenGranted = false;
                break;
            }
            if (allChildrenGranted) {
                this.createAnyPermissionAction(parentElement);
                changedElement = parentElement;
            }
        }
        if (!(parentElement instanceof OperationPermissionsConfiguration)) {
            return this.injectAnyActionsAsRequiredInHierarchy(parentElement, changedElement);
        }
        return changedElement;
    }

    private String getOperationId(AbstractElement element) {
        if (element instanceof OperationPermissionsConfiguration) {
            return ((OperationPermissionsConfiguration)element).getId();
        }
        return this.getOperationId(element.getParentElement());
    }

    private PermissionActionElement createPermissionAction(AbstractElement parent, String actionId) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, actionId);
        PermissionActionElement permissionActionElement = new PermissionActionElement(parent, parent.getNamespaceURI(), "action", attributes);
        parent.addChildElement(permissionActionElement);
        return permissionActionElement;
    }

    public void setProjectPermissions(ExtensionDTO[] permissions) {
        this.fProjectPermissions = permissions;
    }

    public void setTeamPermissions(ExtensionDTO[] permissions) {
        this.fTeamPermissions = permissions;
    }

    public ProcessModelChange[] changeTeamConfigurationOperation(String roleId, String operationId, Boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ProcessModelChange[] changes = this.changeOperation(roleId, operationId, isFinal, explanation, (AbstractElement)teamConfiguration.getElement(), teamConfiguration.getTeamConfiguration().getPermissions());
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration((TeamConfigurationElement)teamConfiguration.getElement());
        }
        return changes;
    }

    public ProcessModelChange[] changeDevelopmentLineOperation(String developmentLineId, String roleId, String operationId, Boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ElementHolder<DevelopmentLineConfiguration> developmentLineConfiguration = this.getOrCreateDevelopmentLineConfiguration(developmentLineId, teamConfiguration);
        ProcessModelChange[] changes = this.changeOperation(roleId, operationId, isFinal, explanation, developmentLineConfiguration.getElement(), developmentLineConfiguration.getElement().getPermissions());
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        } else if (developmentLineConfiguration.isNew()) {
            changes = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration.getElement());
        }
        return changes;
    }

    public ProcessModelChange[] changeIterationTypeOperation(String iterationTypeId, String roleId, String operationId, Boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        IterationTypeConfiguration[] iterationTypeConfigurations = this.getIterationTypeConfigurations(teamConfiguration, iterationTypeId, roleId);
        IterationTypeConfiguration newIterationTypeConfiguration = iterationTypeConfigurations[0];
        IterationTypeConfiguration iterationTypeConfiguration = iterationTypeConfigurations[1];
        PermissionsElement permissions = this.getPermissions(iterationTypeConfiguration, roleId);
        ProcessModelChange[] changes = this.changeOperation(roleId, operationId, isFinal, explanation, iterationTypeConfiguration, iterationTypeConfiguration.getPermissions());
        if (teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        } else if (newIterationTypeConfiguration != null) {
            changes = this.generateChangesForNewIterationType(newIterationTypeConfiguration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    private IterationTypeConfiguration[] getIterationTypeConfigurations(TeamConfigurationHolder teamConfiguration, String iterationTypeId, String roleId) {
        ElementHolder<IterationTypeConfiguration> iterationTypeConfiguration = this.getOrCreateIterationTypeConfiguration(iterationTypeId, teamConfiguration);
        if (iterationTypeConfiguration.isNew()) {
            PermissionsElement permissions = this.createPermissionsElement(iterationTypeConfiguration.getElement());
            this.createRoleElement(roleId, permissions);
            return new IterationTypeConfiguration[]{iterationTypeConfiguration.getElement(), iterationTypeConfiguration.getElement()};
        }
        IterationTypeConfiguration[] iterationTypeConfigurationArray = new IterationTypeConfiguration[2];
        iterationTypeConfigurationArray[1] = iterationTypeConfiguration.getElement();
        return iterationTypeConfigurationArray;
    }

    private PermissionsElement getPermissions(IterationTypeConfiguration iterationTypeConfiguration, String roleId) {
        PermissionsElement permissions = iterationTypeConfiguration.getPermissions();
        if (permissions == null) {
            permissions = this.createPermissionsElement(iterationTypeConfiguration);
            this.createRoleElement(roleId, permissions);
        }
        return permissions;
    }

    public ProcessModelChange[] changeIterationOperation(String developmentLineId, ConfigurationPath iterationPath, String roleId, String operationId, Boolean isFinal, String explanation) {
        OperationPermissionsConfiguration operation;
        AbstractElement parentElement;
        this.assertNotReadOnly();
        String[] iterationIds = iterationPath.segments();
        TeamConfigurationHolder teamConfiguration = null;
        ElementHolder<DevelopmentLineConfiguration> developmentLineConfiguration = null;
        if (this instanceof ProcessSpecificationModel) {
            teamConfiguration = this.getOrCreateTeamConfiguration();
            developmentLineConfiguration = this.getOrCreateDevelopmentLineConfiguration(developmentLineId, teamConfiguration);
            parentElement = developmentLineConfiguration.getElement();
        } else {
            parentElement = this.getRoot();
        }
        IterationConfiguration[] configurations = this.getIterationConfigurations((IIterationParent)((Object)parentElement), iterationIds);
        IterationConfiguration newIteration = configurations[0];
        IterationConfiguration iterationConfiguration = configurations[1];
        PermissionsElement permissions = this.getPermissions(iterationConfiguration, roleId);
        AbstractElement changedElement = null;
        PermissionsRoleElement roleElement = permissions.getRoleElement(roleId);
        if (roleElement == null) {
            roleElement = this.createRoleElement(roleId, permissions);
            changedElement = permissions;
        }
        if ((operation = roleElement.getOperation(operationId)) == null) {
            operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
            if (changedElement == null) {
                changedElement = roleElement;
            }
        }
        if (isFinal != null && operation.isFinal() != isFinal.booleanValue()) {
            operation.setIsFinal(isFinal);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (explanation != null && !explanation.equals(operation.getDescription())) {
            operation.setDescription(explanation);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (changedElement == null) {
            return new ProcessModelChange[1];
        }
        ProcessModelChange change = this.generateProcessModelChangeToReplaceElement(changedElement);
        ProcessModelChange[] changes = new ProcessModelChange[]{change};
        if (teamConfiguration != null && teamConfiguration.isNew()) {
            changes = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement());
        } else if (developmentLineConfiguration != null && developmentLineConfiguration.isNew()) {
            changes = this.generateChangesForNewDevelopmentLine((DevelopmentLineConfiguration)parentElement);
        } else if (newIteration != null) {
            changes = this.generateChangesForNewIteration(newIteration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    private PermissionsElement getPermissions(IterationConfiguration iterationConfiguration, String roleId) {
        PermissionsElement permissions = iterationConfiguration.getPermissions();
        if (permissions == null) {
            permissions = this.createPermissionsElement(iterationConfiguration);
            this.createRoleElement(roleId, permissions);
        }
        return permissions;
    }

    protected IterationConfiguration[] getIterationConfigurations(IIterationParent parentElement, String[] iterationIds) {
        IterationConfiguration newIterationConfiguration = null;
        IterationConfiguration iterationConfiguration = parentElement.getIterationConfiguration(iterationIds[0]);
        if (iterationConfiguration == null) {
            newIterationConfiguration = iterationConfiguration = this.createIterationConfiguration(iterationIds[0], (AbstractElement)((Object)parentElement));
        }
        int i = 1;
        while (i < iterationIds.length) {
            IterationConfiguration parentIteration = iterationConfiguration;
            String iterationId = iterationIds[i];
            if ((iterationConfiguration = parentIteration.getIteration(iterationId)) == null) {
                iterationConfiguration = this.createIterationConfiguration(iterationId, parentIteration);
                if (newIterationConfiguration == null) {
                    newIterationConfiguration = iterationConfiguration;
                }
            }
            ++i;
        }
        return new IterationConfiguration[]{newIterationConfiguration, iterationConfiguration};
    }

    protected ProcessModelChange[] changeOperation(String roleId, String operationId, Boolean isFinal, String explanation, AbstractElement parentElement, PermissionsElement permissions) {
        OperationPermissionsConfiguration operation;
        PermissionsRoleElement roleElement;
        AbstractElement changedElement = null;
        boolean newPermissions = false;
        if (permissions == null) {
            permissions = this.createPermissionsElement(parentElement);
            changedElement = parentElement;
            newPermissions = true;
        }
        if ((roleElement = permissions.getRoleElement(roleId)) == null) {
            roleElement = this.createRoleElement(roleId, permissions);
            if (changedElement == null) {
                changedElement = permissions;
            }
        }
        if ((operation = roleElement.getOperation(operationId)) == null) {
            operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
            if (changedElement == null) {
                changedElement = roleElement;
            }
        }
        if (isFinal != null && operation.isFinal() != isFinal.booleanValue()) {
            operation.setIsFinal(isFinal);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (explanation != null && !explanation.equals(operation.getDescription())) {
            operation.setDescription(explanation);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (changedElement == null) {
            return new ProcessModelChange[1];
        }
        ProcessModelChange change = this.generateProcessModelChangeToReplaceElement(changedElement);
        ProcessModelChange[] changes = new ProcessModelChange[]{change};
        if (newPermissions) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    protected void setIsReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    protected void assertNotReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(Messages.getCommonString("AbstractModel.0"));
        }
    }

    protected ProcessModelChange[] createRoleDefinitions(String[] roleIds, String[] names, String[] descriptions, boolean[] singleCardinality, RoleDefinitions roleDefinitionsElement) {
        this.assertNotReadOnly();
        ProcessModelChange[] changes = new ProcessModelChange[roleIds.length];
        if (roleDefinitionsElement == null) {
            roleDefinitionsElement = this.createRoleDefinitionsElement(this.getRoot());
        }
        int i = 0;
        while (i < roleIds.length) {
            String roleId = roleIds[i];
            IRole[] roleDefinitions = roleDefinitionsElement.getRoleDefinitions();
            IRole existingRole = this.getRole(roleId, roleDefinitions);
            if (existingRole == null) {
                String name = EMPTY;
                if (names.length > 0) {
                    name = names[i];
                }
                String description = EMPTY;
                if (descriptions.length > 0) {
                    description = descriptions[i];
                }
                boolean single = false;
                if (singleCardinality.length > 0) {
                    single = singleCardinality[i];
                }
                this.createRoleDefinition(roleId, name, description, single, roleDefinitionsElement);
                changes[i] = roleDefinitionsElement.getStartOffset() == -1 ? this.generateChangesForNewRoleDefinitions(roleDefinitionsElement) : this.generateProcessModelChangeToReplaceElement(roleDefinitionsElement);
            } else {
                changes[i] = null;
            }
            ++i;
        }
        return changes;
    }

    protected ProcessModelChange generateChangesForNewRoleDefinitions(RoleDefinitions roleDefinitions) {
        AbstractElement parentElement = roleDefinitions.getParentElement();
        return this.generateChangesForNewConfiguration(roleDefinitions, parentElement, null)[0];
    }

    private IRole getRole(String roleId, IRole[] roleDefinitions) {
        int i = 0;
        while (i < roleDefinitions.length) {
            IRole role = roleDefinitions[i];
            if (role.getId().equals(roleId)) {
                return role;
            }
            ++i;
        }
        return null;
    }

    private RoleDefinitions createRoleDefinitionsElement(AbstractElement parent) {
        RoleDefinitions roleDefinitions = new RoleDefinitions(parent, parent.getNamespaceURI(), "role-definitions", null);
        parent.addChildElement(roleDefinitions);
        return roleDefinitions;
    }

    private RoleDefinition createRoleDefinition(String roleId, String name, String description, boolean singleCardinality, RoleDefinitions roleDefinitions) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "role-id", "role-id", EMPTY, roleId);
        String stringCardinality = "single";
        if (!singleCardinality) {
            stringCardinality = "many";
        }
        attributes.addAttribute(EMPTY, "cardinality", "cardinality", EMPTY, stringCardinality);
        attributes.addAttribute(EMPTY, "description", "description", EMPTY, description);
        attributes.addAttribute(EMPTY, "name", "name", EMPTY, name);
        RoleDefinition roleDefinition = new RoleDefinition(roleDefinitions, roleDefinitions.getNamespaceURI(), "role-definition", attributes);
        roleDefinitions.addChildElement(roleDefinition);
        return roleDefinition;
    }

    protected ProcessModelChange[] removeRoleDefinitions(String[] roleIds, RoleDefinitions roleDefinitionsElement) {
        boolean changed = false;
        if (roleDefinitionsElement != null) {
            int i = 0;
            while (i < roleIds.length) {
                String roleId = roleIds[i];
                if (roleDefinitionsElement.removeRoleDefinition(roleId) != null) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                return new ProcessModelChange[]{this.generateProcessModelChangeToReplaceElement(roleDefinitionsElement)};
            }
        }
        return new ProcessModelChange[1];
    }

    protected ProcessModelChange[] removeRolePermission(String[] roleIds, PermissionsElement permissionsElement) {
        boolean changed = false;
        if (permissionsElement != null) {
            int i = 0;
            while (i < roleIds.length) {
                String roleId = roleIds[i];
                if (permissionsElement.removeRoleElement(roleId) != null) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                return new ProcessModelChange[]{this.generateProcessModelChangeToReplaceElement(permissionsElement)};
            }
        }
        return new ProcessModelChange[1];
    }

    public ProcessModelChange[] updateTeamConfigurationBehavior(String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents) {
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ProcessModelChange change = this.updateConfigurationBehavior(roleId, paths, enabled, isFinal, names, descriptions, optionals, namespaces, xmlContents, (AbstractElement)teamConfiguration.getElement(), teamConfiguration.getTeamConfiguration().getBehavior());
        if (teamConfiguration.isNew()) {
            change = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement())[0];
        }
        return new ProcessModelChange[]{change};
    }

    public ProcessModelChange[] updateDevelopmentLineBehavior(String developmentLineId, String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents) {
        BehaviorElement behavior;
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ElementHolder<DevelopmentLineConfiguration> developmentLineConfiguration = this.getOrCreateDevelopmentLineConfiguration(developmentLineId, teamConfiguration);
        if (developmentLineConfiguration.isNew()) {
            behavior = this.createBehaviorElement(developmentLineConfiguration.getElement());
            this.createRoleElement(roleId, behavior);
        }
        behavior = developmentLineConfiguration.getElement().getBehavior();
        ProcessModelChange change = this.updateConfigurationBehavior(roleId, paths, enabled, isFinal, names, descriptions, optionals, namespaces, xmlContents, developmentLineConfiguration.getElement(), behavior);
        if (teamConfiguration.isNew()) {
            change = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement())[0];
        } else if (developmentLineConfiguration.isNew()) {
            change = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration.getElement())[0];
        }
        return new ProcessModelChange[]{change};
    }

    public ProcessModelChange[] updateIterationTypeBehavior(String iterationTypeId, String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents) {
        BehaviorElement behavior;
        this.assertNotReadOnly();
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ElementHolder<IterationTypeConfiguration> iterationTypeConfiguration = this.getOrCreateIterationTypeConfiguration(iterationTypeId, teamConfiguration);
        if (iterationTypeConfiguration.isNew()) {
            behavior = this.createBehaviorElement(iterationTypeConfiguration.getElement());
            this.createRoleElement(roleId, behavior);
        }
        behavior = iterationTypeConfiguration.getElement().getBehavior();
        ProcessModelChange change = this.updateConfigurationBehavior(roleId, paths, enabled, isFinal, names, descriptions, optionals, namespaces, xmlContents, iterationTypeConfiguration.getElement(), behavior);
        if (teamConfiguration.isNew()) {
            change = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement())[0];
        } else if (iterationTypeConfiguration.isNew()) {
            change = this.generateChangesForNewIterationType(iterationTypeConfiguration.getElement())[0];
        }
        return new ProcessModelChange[]{change};
    }

    public ProcessModelChange[] updateIterationBehavior(String iterationIds, String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents) {
        IIterationParent iterationParent;
        this.assertNotReadOnly();
        ConfigurationPath iterationPath = new ConfigurationPath(iterationIds);
        TeamConfigurationHolder teamConfiguration = this.getOrCreateTeamConfiguration();
        ElementHolder<DevelopmentLineConfiguration> developmentLineConfiguration = null;
        if (this instanceof ProcessSpecificationModel) {
            String developmentLineId = iterationPath.segment(0);
            iterationPath = iterationPath.removeFirstSegments(1);
            developmentLineConfiguration = this.getOrCreateDevelopmentLineConfiguration(developmentLineId, teamConfiguration);
            iterationParent = developmentLineConfiguration.getElement();
        } else {
            iterationParent = teamConfiguration.getTeamCustomizationElement();
        }
        IterationConfiguration[] configurations = this.getIterationConfigurations(iterationParent, iterationPath.segments());
        IterationConfiguration newIteration = configurations[0];
        IterationConfiguration iterationConfiguration = configurations[1];
        BehaviorElement behavior = iterationConfiguration.getBehavior();
        ProcessModelChange change = this.updateConfigurationBehavior(roleId, paths, enabled, isFinal, names, descriptions, optionals, namespaces, xmlContents, iterationConfiguration, behavior);
        if (teamConfiguration.isNew()) {
            change = this.generateChangesForNewTeamConfiguration(teamConfiguration.getTeamConfigurationElement())[0];
        } else if (developmentLineConfiguration != null && developmentLineConfiguration.isNew()) {
            change = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration.getElement())[0];
        } else if (newIteration != null) {
            change = this.generateChangesForNewIteration(newIteration)[0];
        }
        return new ProcessModelChange[]{change};
    }

    protected ProcessModelChange updateConfigurationBehavior(String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents, AbstractElement configuration, BehaviorElement behavior) {
        boolean newBehavior = false;
        if (behavior == null) {
            behavior = this.createBehaviorElement(configuration);
            this.createRoleElement(roleId, behavior);
            newBehavior = true;
        }
        ProcessModelChange change = this.updateBehavior(roleId, paths, enabled, isFinal, names, descriptions, optionals, namespaces, xmlContents, behavior);
        if (newBehavior) {
            change = this.generateChangeForNewBehavior(behavior);
        }
        return change;
    }

    private ProcessModelChange updateBehavior(String roleId, ConfigurationPath[] paths, Boolean enabled, Boolean isFinal, String[] names, String[] descriptions, Boolean[] optionals, String[] namespaces, String[] xmlContents, BehaviorElement behavior) {
        BehaviorElement changedElement = null;
        BehaviorRoleElement roleElement = behavior.getRoleElement(roleId);
        if (roleElement == null) {
            roleElement = this.createRoleElement(roleId, behavior);
            changedElement = behavior;
        }
        String operationId = paths[0].segment(0);
        OperationBehaviorConfiguration operation = roleElement.getOperation(operationId);
        if (enabled != null && !enabled.booleanValue()) {
            if (operation != null) {
                roleElement.getChildElements().remove(operation);
                if (!roleElement.getChildElements().isEmpty()) {
                    changedElement = changedElement != null ? changedElement : roleElement;
                } else {
                    behavior.getChildElements().remove(roleElement);
                    changedElement = behavior;
                }
            }
        } else {
            if (operation == null) {
                operation = this.createOperationBehaviorConfiguration(roleElement, operationId);
                AbstractElement abstractElement = changedElement = changedElement != null ? changedElement : roleElement;
            }
            if (isFinal != null && operation.isFinal() != isFinal.booleanValue()) {
                operation.setIsFinal(isFinal);
                AbstractElement abstractElement = changedElement = changedElement != null ? changedElement : operation;
            }
        }
        if (enabled == null || enabled.booleanValue()) {
            AbstractElement preconditions = null;
            AbstractElement followups = null;
            int i = 0;
            while (i < paths.length) {
                String id;
                String configuration = paths[i].segment(1);
                if (configuration != null) {
                    if (configuration.equals("preconditions") && preconditions == null) {
                        this.deleteBehaviorSubConfiguration(operation, configuration);
                        preconditions = this.createBehaviorSubConfiguration(operation, configuration);
                    } else if (configuration.equals("followup-actions") && followups == null) {
                        this.deleteBehaviorSubConfiguration(operation, configuration);
                        followups = this.createBehaviorSubConfiguration(operation, configuration);
                    }
                }
                if ((id = paths[i].segment(2)) != null) {
                    String xmlContent;
                    String description = descriptions == null ? null : descriptions[i];
                    Boolean optional = optionals == null ? null : optionals[i];
                    String namespace = namespaces == null ? null : namespaces[i];
                    String string = xmlContent = xmlContents == null ? null : xmlContents[i];
                    if (configuration.equals("preconditions")) {
                        this.createPrecondition(preconditions, id, names[i], description, optional, namespace, xmlContent);
                    } else if (configuration.equals("followup-actions")) {
                        this.createFollowupAction(followups, id, names[i], description, optional, namespace, xmlContent);
                    }
                }
                ++i;
            }
            if (preconditions != null && preconditions.getChildElements().isEmpty()) {
                operation.getChildElements().remove(preconditions);
            }
            if (followups != null && followups.getChildElements().isEmpty()) {
                operation.getChildElements().remove(followups);
            }
            if (preconditions != null || followups != null) {
                AbstractElement abstractElement = changedElement = changedElement != null ? changedElement : operation;
            }
        }
        if (changedElement != null) {
            return this.generateProcessModelChangeToReplaceElement(changedElement);
        }
        return null;
    }

    protected ProcessModelChange generateChangeForNewBehavior(BehaviorElement behavior) {
        AbstractElement parentElement = behavior.getParentElement();
        AbstractElement previousSibling = null;
        if (parentElement instanceof ProjectConfigurationElement && (previousSibling = ((ProjectConfigurationElement)parentElement).getPermissions()) == null) {
            previousSibling = ((ProjectConfigurationElement)parentElement).getInitialization();
        }
        if (parentElement instanceof ITeamConfiguration && (previousSibling = ((ITeamConfiguration)((Object)parentElement)).getPermissions()) == null && parentElement instanceof TeamCustomizationElement) {
            previousSibling = ((TeamCustomizationElement)parentElement).getRoleDefinitionsElement();
        }
        if (parentElement instanceof DevelopmentLineConfiguration) {
            previousSibling = ((DevelopmentLineConfiguration)parentElement).getPermissions();
        }
        if (parentElement instanceof IterationTypeConfiguration) {
            previousSibling = ((IterationTypeConfiguration)parentElement).getPermissions();
        }
        if (parentElement instanceof IterationConfiguration) {
            previousSibling = ((IterationConfiguration)parentElement).getPermissions();
        }
        return this.generateChangesForNewConfiguration(behavior, parentElement, previousSibling)[0];
    }

    protected BehaviorElement createBehaviorElement(AbstractElement behaviorParent) {
        BehaviorElement behavior = new BehaviorElement(behaviorParent, behaviorParent.getNamespaceURI(), "behavior", null);
        behaviorParent.addChildElement(behavior);
        return behavior;
    }

    protected BehaviorRoleElement createRoleElement(String roleId, BehaviorElement behavior) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, roleId);
        BehaviorRoleElement roleElement = new BehaviorRoleElement((AbstractElement)behavior, behavior.getNamespaceURI(), "role", attributes);
        int index = 0;
        for (Object element : behavior.getChildElements()) {
            if (!(element instanceof BehaviorRoleElement)) continue;
            ++index;
        }
        behavior.getChildElements().add(index, roleElement);
        return roleElement;
    }

    private OperationBehaviorConfiguration createOperationBehaviorConfiguration(AbstractElement parent, String operationId) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, operationId);
        String name = this.getOperationName(parent);
        OperationBehaviorConfiguration operation = new OperationBehaviorConfiguration(parent, parent.getNamespaceURI(), name, attributes);
        parent.addChildElement(operation);
        return operation;
    }

    private void deleteBehaviorSubConfiguration(OperationBehaviorConfiguration operation, String name) {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = operation.getElements();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
            if (child.getName().equals(name)) {
                operation.getChildElements().remove(child);
                return;
            }
            ++n2;
        }
    }

    private ProcessConfigurationElement createBehaviorSubConfiguration(OperationBehaviorConfiguration operation, String name) {
        ProcessConfigurationElement element = new ProcessConfigurationElement(operation, operation.getNamespaceURI(), name, null);
        if (name.equals("preconditions")) {
            operation.getChildElements().add(0, element);
        } else {
            operation.addChildElement(element);
        }
        return element;
    }

    private void createPrecondition(AbstractElement parent, String id, String name, String description, Boolean optional, String namespace, String xmlContent) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, id);
        attributes.addAttribute(EMPTY, "name", "name", EMPTY, name);
        if (description != null) {
            attributes.addAttribute(EMPTY, "description", "description", EMPTY, description);
        }
        if (optional != null && !optional.booleanValue()) {
            attributes.addAttribute(EMPTY, "optional", "optional", EMPTY, optional.toString());
        }
        AbstractElement contentElement = this.parseXMLContent(xmlContent);
        String namespaceURI = this.getNamespaceURI(contentElement, namespace, parent, attributes);
        ProcessConfigurationElement element = new ProcessConfigurationElement(parent, namespaceURI, "precondition", attributes);
        parent.addChildElement(element);
        this.addInnerXMLElements(element, contentElement);
    }

    private void createFollowupAction(AbstractElement parent, String id, String name, String description, Boolean optional, String namespace, String xmlContent) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, id);
        attributes.addAttribute(EMPTY, "name", "name", EMPTY, name);
        if (description != null) {
            attributes.addAttribute(EMPTY, "description", "description", EMPTY, description);
        }
        if (optional != null && !optional.booleanValue()) {
            attributes.addAttribute(EMPTY, "optional", "optional", EMPTY, optional.toString());
        }
        AbstractElement contentElement = this.parseXMLContent(xmlContent);
        String namespaceURI = this.getNamespaceURI(contentElement, namespace, parent, attributes);
        ProcessConfigurationElement element = new ProcessConfigurationElement(parent, namespaceURI, "followup-action", attributes);
        parent.addChildElement(element);
        this.addInnerXMLElements(element, contentElement);
    }

    private AbstractElement parseXMLContent(String xmlContent) {
        if (xmlContent != null && !xmlContent.trim().isEmpty()) {
            return (ProcessConfigurationElement)ProcessModelUtilities.createConfigurationElement(xmlContent, null);
        }
        return null;
    }

    private String getNamespaceURI(AbstractElement contentElement, String previousNamespace, AbstractElement parent, AttributesImpl attributes) {
        String namespaceURI = contentElement != null && contentElement.getNamespaceURI() != null && contentElement.getNamespaceURI().trim().length() > 0 ? contentElement.getNamespaceURI() : previousNamespace;
        if (namespaceURI != null) {
            attributes.addAttribute(EMPTY, XMLNS, XMLNS, EMPTY, namespaceURI);
        } else {
            namespaceURI = parent.getNamespaceURI();
        }
        return namespaceURI;
    }

    private void addInnerXMLElements(ProcessConfigurationElement element, AbstractElement contentElement) {
        if (contentElement != null) {
            element.getChildElements().addAll(contentElement.getChildElements());
        }
    }

    private TeamConfigurationHolder getOrCreateTeamConfiguration() {
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        boolean newConfiguration = false;
        if (teamConfiguration == null) {
            teamConfiguration = this.createTeamConfigurationElement(this.getRoot());
            newConfiguration = true;
        }
        return new TeamConfigurationHolder(teamConfiguration, newConfiguration);
    }

    private ElementHolder<IterationTypeConfiguration> getOrCreateIterationTypeConfiguration(String iterationTypeId, TeamConfigurationHolder teamConfiguration) {
        IterationTypeConfiguration iterationTypeConfiguration = this.getIterationTypeConfiguration(iterationTypeId);
        boolean newIterationType = false;
        if (iterationTypeConfiguration == null) {
            newIterationType = true;
            iterationTypeConfiguration = this.createIterationTypeConfiguration(iterationTypeId, teamConfiguration.getTeamConfiguration());
        }
        return new ElementHolder(this, (AbstractElement)iterationTypeConfiguration, newIterationType);
    }

    private ElementHolder<DevelopmentLineConfiguration> getOrCreateDevelopmentLineConfiguration(String developmentLineId, TeamConfigurationHolder teamConfiguration) {
        DevelopmentLineConfiguration developmentLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        boolean newDevLine = false;
        if (developmentLineConfiguration == null) {
            newDevLine = true;
            developmentLineConfiguration = this.createDevelopmentLineConfiguration(developmentLineId, teamConfiguration.getTeamConfigurationElement());
        }
        return new ElementHolder(this, (AbstractElement)developmentLineConfiguration, newDevLine);
    }

    class ElementHolder<T extends AbstractElement> {
        private boolean isNew;
        private T element;
        final /* synthetic */ AbstractModel this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ElementHolder(T elem, boolean newElem) {
            this.this$0 = (AbstractModel)n;
            this.element = elem;
            this.isNew = newElem;
        }

        boolean isNew() {
            return this.isNew;
        }

        T getElement() {
            return this.element;
        }

        public String toString() {
            return this.isNew ? "NEW " : "NOT_NEW " + ((AbstractElement)this.element).toString();
        }
    }

    class TeamConfigurationHolder
    extends ElementHolder {
        TeamConfigurationHolder(ITeamConfiguration elem, boolean newElem) {
            super(AbstractModel.this, (AbstractElement)((Object)elem), newElem);
        }

        ITeamConfiguration getTeamConfiguration() {
            return (ITeamConfiguration)this.getElement();
        }

        TeamConfigurationElement getTeamConfigurationElement() {
            return this.getElement() instanceof TeamConfigurationElement ? (TeamConfigurationElement)this.getElement() : null;
        }

        TeamCustomizationElement getTeamCustomizationElement() {
            return this.getElement() instanceof TeamCustomizationElement ? (TeamCustomizationElement)this.getElement() : null;
        }
    }
}

