/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.internal.common.advice.runtime.AbstractProcessDeclaration;

public class AdvisorDeclaration
extends AbstractProcessDeclaration
implements IAdvisorDeclaration {
    private boolean fOverrulable;

    public static AdvisorDeclaration newAdvisorDeclaration(IProcessConfigurationElement configElement) {
        String advisorId = configElement.getAttribute("id");
        String name = configElement.getAttribute("name");
        if (advisorId != null && name != null) {
            String description = configElement.getAttribute("description");
            boolean overrulable = false;
            String overrulableString = configElement.getAttribute("overrulable");
            if (overrulableString != null) {
                overrulable = Boolean.parseBoolean(overrulableString);
            }
            boolean optional = true;
            String optionalString = configElement.getAttribute("optional");
            if (optionalString != null) {
                optional = Boolean.parseBoolean(optionalString);
            }
            return new AdvisorDeclaration(configElement, advisorId, name, overrulable, optional, description);
        }
        return null;
    }

    private AdvisorDeclaration(IProcessConfigurationElement configElement, String advisorId, String name, boolean overrulable, boolean optional, String description) {
        super(configElement, advisorId, name, optional, description);
        this.fOverrulable = overrulable;
    }

    @Override
    public boolean isOverrulable() {
        return this.fOverrulable;
    }
}

