/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common;

import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ItemHandleAwareHashMap
implements ISimpleMap,
Map {
    private HashMap fInternalMap;
    private Key fReusableKey = new Key();

    public ItemHandleAwareHashMap() {
        this.fInternalMap = new HashMap();
    }

    public ItemHandleAwareHashMap(int initialCapacity) {
        this.fInternalMap = new HashMap(initialCapacity);
    }

    public ItemHandleAwareHashMap(int initialCapacity, float loadFactor) {
        this.fInternalMap = new HashMap(initialCapacity, loadFactor);
    }

    public ItemHandleAwareHashMap(Map m) {
        if (m == null) {
            this.fInternalMap = new HashMap();
        } else {
            this.fInternalMap = new HashMap(m.size());
            this.putAll(m);
        }
    }

    @Override
    public int size() {
        return this.fInternalMap.size();
    }

    @Override
    public void clear() {
        this.fInternalMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fInternalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof IItemHandle) {
            this.fReusableKey.handle = (IItemHandle)key;
            return this.fInternalMap.containsKey(this.fReusableKey);
        }
        return this.fInternalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fInternalMap.containsValue(value);
    }

    public Collection values() {
        return this.fInternalMap.values();
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set keySet() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object element : this.fInternalMap.keySet()) {
            if (element instanceof Key) {
                Key key = (Key)element;
                result.add(key.handle);
                continue;
            }
            result.add(element);
        }
        return result;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof IItemHandle) {
            this.fReusableKey.handle = (IItemHandle)key;
            return this.fInternalMap.get(this.fReusableKey);
        }
        return this.fInternalMap.get(key);
    }

    public Object remove(Object key) {
        if (key instanceof IItemHandle) {
            this.fReusableKey.handle = (IItemHandle)key;
            return this.fInternalMap.remove(this.fReusableKey);
        }
        return this.fInternalMap.remove(key);
    }

    public Object put(Object key, Object value) {
        if (key instanceof IItemHandle) {
            return this.fInternalMap.put(new Key((IItemHandle)key), value);
        }
        return this.fInternalMap.put(key, value);
    }

    public ItemHandleAwareHashMap createItemHandleAwareHashMapCopy() {
        ItemHandleAwareHashMap result = new ItemHandleAwareHashMap(this.size());
        for (Object element : this.fInternalMap.keySet()) {
            if (element instanceof Key) {
                Key key = (Key)element;
                result.put(key.handle, this.get(key.handle));
                continue;
            }
            result.put(element, this.get(element));
        }
        return result;
    }

    public Set<Map.Entry> entrySet() {
        return this.fInternalMap.entrySet();
    }

    private static class Key {
        public IItemHandle handle;

        public Key() {
        }

        public Key(IItemHandle handle) {
            this.handle = handle;
        }

        public int hashCode() {
            return this.handle.getItemId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            return this.handle.sameItemId(((Key)obj).handle);
        }
    }
}

