/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IReadAccessList;
import com.ibm.team.process.common.IReadAccessListHandle;
import com.ibm.team.process.internal.client.workingcopies.ProjectAreaWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectAreaAccessControlWorkingCopy
extends PropertyWorkingCopy {
    public static String ACCESS_CONTROL_EVENT_PROPERTY = "ProjectAreaAccessControl";
    public static String IS_PUBLIC_EVENT_PROPERTY = "ProjectAreaIsPublic";
    public static String IS_VISIBLE_TO_MEMBERS_PROPERTY = "ProjectAreaIsVisibleToMembers";
    public static String IS_VISIBLE_TO_ACCESS_LIST_PROPERTY = "ProjectAreaIsVisibleToAccessList";
    public static String ACCESS_LIST_PROPERTY = "ProjectAreaAccessList";
    private Boolean fIsVisibleToEveryone;
    private Boolean fIsVisibleToMembers;
    private Boolean fIsVisibleToAccessList;
    private final ItemHandleAwareHashSet fContributorsToAdd = new ItemHandleAwareHashSet();
    private final ItemHandleAwareHashSet fContributorsToRemove = new ItemHandleAwareHashSet();
    private int fLastAdded;
    private int fLastRemoved;
    private ProjectAreaWorkingCopy fProjectAreaWorkingCopy;
    private IWorkingCopyListener fWorkingCopyListener = new IWorkingCopyListener(){

        @Override
        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            if ("dirtyState".equals(event.getProperty()) && ((Boolean)event.getNewValue()).booleanValue()) {
                ProjectAreaAccessControlWorkingCopy.this.clearLastSaveData();
            }
        }
    };

    public ProjectAreaAccessControlWorkingCopy(ProjectAreaWorkingCopy projectAreaWorkingCopy) {
        this.fProjectAreaWorkingCopy = projectAreaWorkingCopy;
        this.fProjectAreaWorkingCopy.addWorkingCopyListener(this.fWorkingCopyListener);
        ProjectArea area = (ProjectArea)this.fProjectAreaWorkingCopy.getUnderlyingProcessArea();
        this.fIsVisibleToEveryone = area.isInternalPublic();
        this.fIsVisibleToMembers = area.isInternalVisibleToMembers();
        this.fIsVisibleToAccessList = area.isInternalVisibleToAccessList();
    }

    public void syncUpdate(IProjectArea projectArea, IUpdateContext context) {
        ProjectArea area = (ProjectArea)projectArea;
        this.fIsVisibleToEveryone = area.isInternalPublic();
        this.fIsVisibleToMembers = area.isInternalVisibleToMembers();
        this.fIsVisibleToAccessList = area.isInternalVisibleToAccessList();
        this.fContributorsToAdd.clear();
        this.fContributorsToRemove.clear();
        this.fLastAdded = 0;
        this.fLastRemoved = 0;
        this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_CONTROL_EVENT_PROPERTY, null, null));
    }

    public void clearLastSaveData() {
        if (this.fLastAdded > 0 || this.fLastRemoved > 0) {
            this.fLastAdded = 0;
            this.fLastRemoved = 0;
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public void syncSave(IProjectArea mutableProjectArea, List itemsToSave, IProgressMonitor monitor) throws TeamRepositoryException {
        ProjectArea projectArea = (ProjectArea)mutableProjectArea;
        projectArea.setInternalPublic(this.fIsVisibleToEveryone.booleanValue());
        projectArea.setInternalVisibleToMembers(this.fIsVisibleToMembers.booleanValue());
        projectArea.setInternalVisibleToAccessList(this.fIsVisibleToAccessList.booleanValue());
        if (this.fContributorsToAdd.size() > 0 || this.fContributorsToRemove.size() > 0) {
            IReadAccessList accessList;
            IReadAccessListHandle accessHandle = mutableProjectArea.getReadAccessList();
            if (accessHandle != null) {
                ITeamRepository repo = (ITeamRepository)mutableProjectArea.getOrigin();
                accessList = (IReadAccessList)repo.itemManager().fetchCompleteItem((IItemHandle)accessHandle, 0, monitor).getWorkingCopy();
            } else {
                accessList = (IReadAccessList)IReadAccessList.ITEM_TYPE.createItem();
                accessList.setProjectArea((IProjectAreaHandle)mutableProjectArea);
                projectArea.setReadAccessList((IReadAccessListHandle)accessList);
            }
            accessList.addContributors((IContributorHandle[])((IContributor[])this.fContributorsToAdd.toArray((Object[])new IContributor[this.fContributorsToAdd.size()])));
            accessList.removeContributors((IContributorHandle[])((IContributor[])this.fContributorsToRemove.toArray((Object[])new IContributor[this.fContributorsToRemove.size()])));
            itemsToSave.add(accessList);
        }
    }

    @Override
    protected void setDirty(boolean isDirty, boolean fireEvent) {
        super.setDirty(isDirty, fireEvent);
        if (!isDirty) {
            this.fLastAdded = this.fContributorsToAdd.size();
            this.fLastRemoved = this.fContributorsToRemove.size();
            this.fContributorsToAdd.clear();
            this.fContributorsToRemove.clear();
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public int getLastAdded() {
        return this.fLastAdded;
    }

    public int getLastRemoved() {
        return this.fLastRemoved;
    }

    public boolean isVisibleToEveryone() {
        return this.fIsVisibleToEveryone;
    }

    public void setVisibleToEveryone(boolean visible) {
        if (visible != this.fIsVisibleToEveryone) {
            this.fIsVisibleToEveryone = visible;
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, IS_PUBLIC_EVENT_PROPERTY, null, null));
        }
    }

    public boolean isVisibleToMembers() {
        return this.fIsVisibleToMembers;
    }

    public void setVisibleToMembers(boolean visible) {
        if (visible != this.fIsVisibleToMembers) {
            this.fIsVisibleToMembers = visible;
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, IS_VISIBLE_TO_MEMBERS_PROPERTY, null, null));
        }
    }

    public boolean isVisibleToAccessList() {
        return this.fIsVisibleToAccessList;
    }

    public void setVisibleToAccessList(boolean visible) {
        if (visible != this.isVisibleToAccessList()) {
            this.fIsVisibleToAccessList = visible;
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, IS_VISIBLE_TO_ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public IContributor[] getAddedContributors() {
        return (IContributor[])this.fContributorsToAdd.toArray((Object[])new IContributor[this.fContributorsToAdd.size()]);
    }

    public void addContributor(IContributor contributor) {
        this.fContributorsToAdd.add((Object)contributor);
        this.fContributorsToRemove.remove((Object)contributor);
        this.setDirty(true, true);
        this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
    }

    public void addContributors(IContributor[] contributors) {
        if (contributors != null) {
            int i = 0;
            while (i < contributors.length) {
                IContributor contributor = contributors[i];
                this.fContributorsToAdd.add((Object)contributor);
                this.fContributorsToRemove.remove((Object)contributor);
                ++i;
            }
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public void undoContributorChanges(IContributor contributor) {
        if (contributor != null) {
            this.fContributorsToAdd.remove((Object)contributor);
            this.fContributorsToRemove.remove((Object)contributor);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public void undoContributorChanges(IContributor[] contributors) {
        if (contributors != null && contributors.length > 0) {
            int i = 0;
            while (i < contributors.length) {
                IContributor contributor = contributors[i];
                this.fContributorsToAdd.remove((Object)contributor);
                this.fContributorsToRemove.remove((Object)contributor);
                ++i;
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public IContributor[] getRemovedContributors() {
        return (IContributor[])this.fContributorsToRemove.toArray((Object[])new IContributor[this.fContributorsToRemove.size()]);
    }

    public void removeContributor(IContributor contributor) {
        if (contributor != null) {
            this.fContributorsToRemove.add((Object)contributor);
            this.fContributorsToAdd.remove((Object)contributor);
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    public void removeContributors(IContributor[] contributors) {
        if (contributors != null && contributors.length > 0) {
            int i = 0;
            while (i < contributors.length) {
                IContributor contributor = contributors[i];
                this.fContributorsToRemove.add((Object)contributor);
                this.fContributorsToAdd.remove((Object)contributor);
                ++i;
            }
            this.setDirty(true, true);
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, ACCESS_LIST_PROPERTY, null, null));
        }
    }

    @Override
    public boolean isDisposed() {
        return this.fIsVisibleToEveryone == null || this.fIsVisibleToMembers == null;
    }

    @Override
    public void dispose() {
        this.fIsVisibleToEveryone = null;
        this.fIsVisibleToMembers = null;
        this.fContributorsToAdd.clear();
        this.fContributorsToRemove.clear();
        this.fProjectAreaWorkingCopy.removeWorkingCopyListener(this.fWorkingCopyListener);
        super.dispose();
    }
}

