/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IProcessDefinitionWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessStateModelHandle;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.client.workingcopies.IProblem;
import com.ibm.team.process.internal.client.workingcopies.IProblemRequestor;
import com.ibm.team.process.internal.client.workingcopies.IProcessModelChangeListener;
import com.ibm.team.process.internal.client.workingcopies.ProcessModelChangeEvent;
import com.ibm.team.process.internal.client.workingcopies.ProcessModelHandle;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.ModelParsingException;
import com.ibm.team.process.internal.common.model.state.ProcessStateModel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ProcessStateModelHandle
extends ProcessModelHandle
implements IProcessStateModelHandle {
    ErrorForwardingModel fModel;
    IProcessDefinitionWorkingCopy fProcessDefinitionWorkingCopy;
    IProblemRequestor fProblemRequestor;
    CopyOnWriteArrayList fModelChangeListeners = new CopyOnWriteArrayList();

    public ProcessStateModelHandle(IProcessDefinitionWorkingCopy workingCopy) {
        this.fProcessDefinitionWorkingCopy = workingCopy;
    }

    @Override
    public ProcessStateModel resolve(boolean reconcile) {
        if (reconcile || this.fModel == null) {
            this.reconcile();
        }
        return this.fModel;
    }

    @Override
    public void setProblemRequestor(IProblemRequestor problemRequestor) {
        this.fProblemRequestor = problemRequestor;
    }

    @Override
    public void reconcile() {
        ErrorForwardingModel model = new ErrorForwardingModel();
        try {
            IDocument document;
            if (this.fProblemRequestor != null) {
                this.fProblemRequestor.beginReporting();
            }
            if ((document = this.getDocument()) != null) {
                model.initialize(document);
            }
        }
        finally {
            if (this.fProblemRequestor != null) {
                this.fProblemRequestor.endReporting();
            }
            this.fModel = model;
            this.notifyModelChangeListeners(new ProcessModelChangeEvent(this));
        }
    }

    @Override
    public void initialReconcile() {
        this.reconcile();
    }

    @Override
    public IDocument getDocument() {
        return this.fProcessDefinitionWorkingCopy.getProcessState();
    }

    @Override
    public AbstractModel getModel() {
        return this.fModel;
    }

    public ProcessStateModel getProcessStateModel() {
        return this.fModel;
    }

    @Override
    public AbstractElement getModelRoot() {
        if (this.fModel != null) {
            return this.fModel.getRoot();
        }
        return null;
    }

    private void notifyModelChangeListeners(ProcessModelChangeEvent event) {
        for (IProcessModelChangeListener listener : this.fModelChangeListeners) {
            SafeRunner.run((ISafeRunnable)new ListenerRunner(listener, event));
        }
    }

    @Override
    public void addModelChangeListener(IProcessModelChangeListener listener) {
        if (listener != null) {
            this.fModelChangeListeners.addIfAbsent(listener);
        }
    }

    @Override
    public void removeModelChangeListener(IProcessModelChangeListener listener) {
        if (listener != null) {
            this.fModelChangeListeners.remove(listener);
        }
    }

    protected AbstractElement getElementForOffset(AbstractElement containingElement, int offset) {
        int end;
        int start;
        if (containingElement != null && (start = containingElement.getStartOffset()) != -1 && start < offset && ((end = containingElement.getEndOffset()) == -1 || end > offset)) {
            List childElements = containingElement.getChildElements();
            for (AbstractElement child : childElements) {
                AbstractElement childContainer = this.getElementForOffset(child, offset);
                if (childContainer == null) continue;
                return childContainer;
            }
            return containingElement;
        }
        return null;
    }

    @Override
    public AbstractElement getElementForOffset(int offset) {
        return this.getElementForOffset(this.getModelRoot(), offset);
    }

    final class ErrorForwardingModel
    extends ProcessStateModel {
        ErrorForwardingModel() {
        }

        public void error(Exception x) {
            if (x instanceof ModelParsingException) {
                this.handleParsingError((ModelParsingException)x);
            }
            super.error(x);
        }

        public void fatalError(Exception x) {
            if (x instanceof ModelParsingException) {
                this.handleParsingError((ModelParsingException)x);
            }
            super.fatalError(x);
        }

        public void warning(Exception x) {
            super.warning(x);
        }

        private void handleParsingError(ModelParsingException e) {
            if (ProcessStateModelHandle.this.fProblemRequestor != null) {
                ProcessStateModelHandle.this.fProblemRequestor.acceptProblem(new ModelParsingProblem(e, ProcessStateModelHandle.this.getDocument()));
            }
        }

        protected ModelGenerator createModelGenerator() {
            ModelGenerator generator = new ModelGenerator((AbstractModel)this);
            generator.setDirective(ElementBuilderDirectives.USE_SCHEMA, (Object)"http://com.ibm.team.process platform:/plugin/com.ibm.team.process.common/schema/ProcessState.xsd");
            generator.setDirective(ElementBuilderDirectives.COMPUTE_ELEMENT_OFFSETS, (Object)Boolean.TRUE);
            return generator;
        }
    }

    private static final class ListenerRunner
    implements ISafeRunnable {
        private final IProcessModelChangeListener fListener;
        private final ProcessModelChangeEvent fEvent;

        public ListenerRunner(IProcessModelChangeListener listener, ProcessModelChangeEvent event) {
            this.fListener = listener;
            this.fEvent = event;
        }

        public void handleException(Throwable exception) {
        }

        public void run() throws Exception {
            if (this.fListener != null) {
                this.fListener.modelChanged(this.fEvent);
            }
        }
    }

    private static final class ModelParsingProblem
    implements IProblem {
        private final ModelParsingException fException;
        private final IDocument fDocument;
        private Integer fOffset;
        private Integer fLength;
        private static final int TRIM_LEADING = 1;
        private static final int TRIM_TRAILING = -1;

        private ModelParsingProblem(ModelParsingException e, IDocument document) {
            this.fException = e;
            this.fDocument = document;
        }

        @Override
        public int getLineNumber() {
            return this.fException.getLineNumber() > 0 ? this.fException.getLineNumber() - 1 : 0;
        }

        @Override
        public String getMessage() {
            return this.fException.getMessage();
        }

        @Override
        public String getUnmodifiedMessage() {
            return this.fException.getMessage();
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        public boolean isWarning() {
            return false;
        }

        public int getLength() {
            if (this.fLength == null) {
                try {
                    this.fLength = this.getDocumentOffset(this.getLineNumber(), this.fException.getColumnNumber()) - this.getOffset();
                }
                catch (BadLocationException e) {
                    InternalProcessClient.log(e);
                    this.fLength = 0;
                }
            }
            return this.fLength;
        }

        public int getOffset() {
            if (this.fOffset == null) {
                try {
                    int offset = this.getProblemStartOffset(this.fException.getElement(), this.trimWhitespace(this.getDocumentOffset(this.getLineNumber(), this.fException.getColumnNumber()), -1));
                    if (offset != -1) {
                        offset = this.trimWhitespace(offset, 1);
                    } else if (this.fDocument != null) {
                        offset = this.trimWhitespace(this.fDocument.getLineOffset(this.getLineNumber()), 1);
                    }
                    this.fOffset = offset;
                }
                catch (BadLocationException e) {
                    InternalProcessClient.log(e);
                    this.fOffset = 0;
                }
            }
            return this.fOffset;
        }

        private int trimWhitespace(int offset, int direction) {
            try {
                if (this.fDocument != null) {
                    char c = this.fDocument.getChar(offset);
                    while (Character.isWhitespace(c)) {
                        c = this.fDocument.getChar(offset += direction);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return offset;
        }

        private boolean containsOffset(AbstractElement element, int offset) {
            if (element != null) {
                int start = element.getStartOffset();
                int end = element.getEndOffset();
                return start != -1 && start <= offset && (end == -1 || end > offset);
            }
            return false;
        }

        private int getProblemStartOffset(AbstractElement containingElement, int offset) {
            if (containingElement != null) {
                int startTagEnd = containingElement.getStartTagEndOffset();
                int startOffset = startTagEnd != -1 && offset > startTagEnd ? startTagEnd + 1 : containingElement.getStartOffset();
                List childElements = containingElement.getChildElements();
                for (AbstractElement child : childElements) {
                    if (this.containsOffset(child, offset)) {
                        startOffset = this.getProblemStartOffset(child, offset);
                        break;
                    }
                    int endOffset = child.getEndOffset();
                    if (endOffset <= startOffset || offset <= endOffset) continue;
                    startOffset = endOffset + 1;
                }
                return startOffset;
            }
            return -1;
        }

        private int getDocumentOffset(int lineNumber, int columnNumber) throws BadLocationException {
            if (this.fDocument != null) {
                int lineOffset = this.fDocument.getLineOffset(lineNumber);
                int maxColumnOffset = this.fDocument.getLineLength(lineNumber);
                int columnOffset = columnNumber > maxColumnOffset ? maxColumnOffset : columnNumber;
                return lineOffset + columnOffset;
            }
            return -1;
        }
    }
}

