/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IProcessItemWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.internal.client.workingcopies.ContentWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.IPropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.ServerRequest;
import com.ibm.team.process.internal.client.workingcopies.StringWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;

public abstract class ProcessItemWorkingCopy
implements IProcessItemWorkingCopy {
    protected ITeamRepository fCachedTeamRepository;
    protected IProcessItemService fCachedService;
    private IProcessItem fProcessItemState;
    private StringWorkingCopy fName;
    private StringWorkingCopy fSummary;
    private ContentWorkingCopy fDescription;
    private int fUpdateContextRequested;
    private boolean fIsDirty = false;
    private boolean fDerivedIsDirty = false;
    private ListenerList fListenerList = new ListenerList();
    private WorkingCopyListener fWorkingCopyListener = new WorkingCopyListener();
    private Set fPropertyWorkingCopies = new HashSet();
    private SharedItemChangeListener fSharedItemChangeListener = new SharedItemChangeListener();
    private Object fSaveMutex = new Object();

    protected ProcessItemWorkingCopy(IProcessItem processItem, IItemType[] typeInterest) {
        if (processItem == null) {
            throw new IllegalArgumentException(Messages.getString("ProcessItemWorkingCopy.0"));
        }
        if (processItem.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ProcessItemWorkingCopy.1"));
        }
        this.fCachedTeamRepository = (ITeamRepository)processItem.getOrigin();
        this.fCachedService = (IProcessItemService)this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
        IItemManager itemManager = this.fCachedTeamRepository.itemManager();
        this.fProcessItemState = (IProcessItem)itemManager.getImmutableState((IItem)processItem);
        if (this.fProcessItemState != null) {
            itemManager.addItemChangeListener((IItem)processItem, (ISharedItemChangeListener)this.fSharedItemChangeListener);
            if (typeInterest != null) {
                int i = 0;
                while (i < typeInterest.length) {
                    itemManager.addItemChangeListener(typeInterest[i], (ISharedItemChangeListener)this.fSharedItemChangeListener);
                    ++i;
                }
            }
        } else {
            this.fProcessItemState = processItem;
        }
    }

    @Override
    public final void requestUpdateContext() {
        ++this.fUpdateContextRequested;
    }

    @Override
    public final void releaseUpdateContext() {
        --this.fUpdateContextRequested;
    }

    protected final IUpdateContext getUpdateContext() {
        if (this.fUpdateContextRequested > 0) {
            IWorkingCopyManager manager = this.fCachedService.getWorkingCopyManager();
            return manager.getUpdateContext();
        }
        return null;
    }

    @Override
    public final void addWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListenerList.add((Object)listener);
    }

    @Override
    public final void removeWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    @Override
    public final IProcessItem getUnderlyingProcessItem() {
        return this.fProcessItemState;
    }

    @Override
    public void asyncInitialize(Collection propertyIds) {
        if (propertyIds == null) {
            this.getDescription();
        } else if (propertyIds.contains("descriptionDetails")) {
            this.getDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocument getName() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fName == null) {
            ProcessItemWorkingCopy processItemWorkingCopy = this;
            synchronized (processItemWorkingCopy) {
                if (this.fName == null) {
                    this.fName = new StringWorkingCopy(this.fProcessItemState.getName());
                    this.addPropertyWorkingCopy(this.fName);
                }
            }
        }
        return this.fName == null ? null : this.fName.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocument getSummary() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fSummary == null) {
            ProcessItemWorkingCopy processItemWorkingCopy = this;
            synchronized (processItemWorkingCopy) {
                if (this.fSummary == null) {
                    this.fSummary = new StringWorkingCopy(this.fProcessItemState.getDescription().getSummary());
                    this.addPropertyWorkingCopy(this.fSummary);
                }
            }
        }
        return this.fSummary == null ? null : this.fSummary.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocument getDescription() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fDescription == null) {
            ProcessItemWorkingCopy processItemWorkingCopy = this;
            synchronized (processItemWorkingCopy) {
                if (this.fDescription == null) {
                    ContentWorkingCopy description = new ContentWorkingCopy(this.fCachedTeamRepository, "text/xml", "UTF-8");
                    this.addPropertyWorkingCopy(description);
                    description.asyncUpdate(this.fProcessItemState.getDescription().getDetails(), 1, this.getUpdateContext(), null);
                    this.fDescription = description;
                }
            }
        }
        return this.fDescription == null ? null : this.fDescription.getDocument();
    }

    @Override
    public final boolean isDirty() {
        if (!this.isDisposed()) {
            return this.fDerivedIsDirty || this.fIsDirty;
        }
        return false;
    }

    private final void handlePropertyMarkedAsDirty() {
        if (!this.isDirty()) {
            this.fDerivedIsDirty = true;
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", Boolean.FALSE, Boolean.TRUE));
        } else {
            this.fDerivedIsDirty = true;
        }
    }

    protected final void markDirty(boolean markDrivedIsDirty) {
        if (!this.isDirty()) {
            this.fIsDirty = true;
            if (markDrivedIsDirty) {
                this.fDerivedIsDirty = true;
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", Boolean.FALSE, Boolean.TRUE));
        } else {
            this.fIsDirty = true;
            if (markDrivedIsDirty) {
                this.fDerivedIsDirty = true;
            }
        }
    }

    private final void markNotDirty() {
        if (this.isDirty()) {
            this.fIsDirty = false;
            if (this.fDerivedIsDirty) {
                for (IPropertyWorkingCopy wc : this.fPropertyWorkingCopies) {
                    wc.setDirty(false);
                }
                this.fDerivedIsDirty = false;
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", Boolean.TRUE, Boolean.FALSE));
        }
    }

    protected final void updateDirtyState() {
        boolean wasDirty = this.isDirty();
        this.fDerivedIsDirty = this.computeDerivedDirtyState();
        boolean isDirty = this.isDirty();
        if (wasDirty != this.isDirty()) {
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", wasDirty, isDirty));
        }
    }

    private boolean computeDerivedDirtyState() {
        for (IPropertyWorkingCopy wc : this.fPropertyWorkingCopies) {
            if (!wc.isDirty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ProcessItemWorkingCopy processItemWorkingCopy = this;
        synchronized (processItemWorkingCopy) {
            this.fCachedTeamRepository.itemManager().purgeItemChangeListener((ISharedItemChangeListener)this.fSharedItemChangeListener);
            Iterator e = this.fPropertyWorkingCopies.iterator();
            while (e.hasNext()) {
                IPropertyWorkingCopy wc = (IPropertyWorkingCopy)e.next();
                wc.removeWorkingCopyListener(this.fWorkingCopyListener);
                wc.dispose();
                e.remove();
            }
            this.fProcessItemState = null;
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.fProcessItemState == null;
    }

    protected final void fireWorkingCopyChanged(WorkingCopyChangeEvent event) {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IWorkingCopyListener listener = (IWorkingCopyListener)listeners[i];
            listener.workingCopyChanged(event);
            ++i;
        }
    }

    protected final void addPropertyWorkingCopy(IPropertyWorkingCopy workingCopy) {
        this.fPropertyWorkingCopies.add(workingCopy);
        workingCopy.addWorkingCopyListener(this.fWorkingCopyListener);
    }

    protected final void removePropertyWorkingCopy(IPropertyWorkingCopy workingCopy) {
        if (this.fPropertyWorkingCopies.remove(workingCopy)) {
            workingCopy.removeWorkingCopyListener(this.fWorkingCopyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isDirty()) {
            return;
        }
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getString("ProcessItemWorkingCopy.4"), 1200);
        try {
            boolean saveProcessItem = false;
            IProcessItem mutableProcessItem = this.fCachedService.getMutableCopy(this.fProcessItemState);
            final ArrayList<IProcessItem> itemsToSave = new ArrayList<IProcessItem>();
            if (this.fDerivedIsDirty) {
                if (this.fName != null && this.fName.isDirty()) {
                    mutableProcessItem.setName(this.fName.getDocument().get());
                    saveProcessItem = true;
                }
                if (this.fSummary != null && this.fSummary.isDirty()) {
                    mutableProcessItem.getDescription().setSummary(this.fSummary.getDocument().get());
                    saveProcessItem = true;
                }
                if (this.fDescription != null && this.fDescription.isDirty()) {
                    SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
                    IContent content = this.fDescription.syncSave((IProgressMonitor)sub);
                    mutableProcessItem.getDescription().setDetails(content);
                    saveProcessItem = true;
                    sub.done();
                } else {
                    monitor.worked(100);
                }
                if (this.doSavePropertyWorkingCopies(mutableProcessItem, itemsToSave, (IProgressMonitor)new SubProgressMonitor(monitor, 600))) {
                    saveProcessItem = true;
                }
            } else {
                monitor.worked(600);
            }
            if (this.doCleanupProcessItem(mutableProcessItem, (IProgressMonitor)new SubProgressMonitor(monitor, 200))) {
                saveProcessItem = true;
            }
            if (saveProcessItem || this.fIsDirty) {
                itemsToSave.add(mutableProcessItem);
            }
            final ArrayList savedItemTrap = new ArrayList();
            Object object = this.fSaveMutex;
            synchronized (object) {
                if (!itemsToSave.isEmpty()) {
                    ServerRequest saveRequest = new ServerRequest(Messages.getString("ProcessItemWorkingCopy.5")){

                        @Override
                        public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                            if (itemsToSave.size() == 1) {
                                IProcessItem savedItem = ProcessItemWorkingCopy.this.fCachedService.save((IProcessItem)itemsToSave.get(0), monitor);
                                savedItemTrap.add(savedItem);
                            } else {
                                IProcessItem[] savedItems = ProcessItemWorkingCopy.this.fCachedService.save(itemsToSave.toArray(new IProcessItem[itemsToSave.size()]), monitor);
                                savedItemTrap.addAll(Arrays.asList(savedItems));
                            }
                        }
                    };
                    ExecUtil.syncExec(saveRequest, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                } else {
                    monitor.worked(400);
                }
                for (IProcessItem processItem : savedItemTrap) {
                    if (!mutableProcessItem.sameItemId((IItemHandle)processItem)) continue;
                    this.fProcessItemState = (IProcessItem)this.fCachedTeamRepository.itemManager().getImmutableState((IItem)processItem);
                    this.reinitializeFromProcessItem(this.fProcessItemState, 0);
                    break;
                }
                this.markNotDirty();
            }
            savedItemTrap.clear();
        }
        finally {
            monitor.done();
        }
    }

    protected boolean doSavePropertyWorkingCopies(IProcessItem mutableProcessItem, List processItemsToSaveCollector, IProgressMonitor monitor) throws TeamRepositoryException {
        return false;
    }

    protected boolean doCleanupProcessItem(IProcessItem mutableProcessItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return false;
    }

    protected void handleWorkingCopyChanged(WorkingCopyChangeEvent event) {
        Boolean newValue;
        if ("dirtyState".equals(event.getProperty()) && (newValue = (Boolean)event.getNewValue()).booleanValue()) {
            this.handlePropertyMarkedAsDirty();
        }
    }

    protected void handleSharedItemChanged(ISharedItemChangeEvent event) {
        IItem sharedItem = event.getSharedItem();
        if (sharedItem instanceof IProcessItem) {
            IProcessItem before = (IProcessItem)event.getBeforeState();
            IProcessItem after = (IProcessItem)event.getAfterState();
            if (after != null && !ProcessCommon.requiredPropertiesSet((IProcessItem)after, (int)0)) {
                return;
            }
            IProcessItem shared = (IProcessItem)event.getSharedItem();
            this.handleProcessItemChanged(before, after, shared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessItemChanged(IProcessItem before, IProcessItem after, IProcessItem shared) {
        if (after == null) {
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "underlyingObject", before, null));
            return;
        }
        if (!this.isDirty()) {
            Object object = this.fSaveMutex;
            synchronized (object) {
                IProcessItem current = (IProcessItem)this.fCachedTeamRepository.itemManager().getImmutableState((IItem)shared);
                if (!this.fProcessItemState.sameStateId((IItemHandle)current)) {
                    this.fProcessItemState = current;
                    this.reinitializeFromProcessItem(this.fProcessItemState, 0);
                }
            }
        }
    }

    private void reinitializeFromProcessItem(IProcessItem processItem, int flags) {
        if (this.fName != null) {
            this.fName.asyncUpdate(processItem.getName(), this.getUpdateContext());
        }
        if (this.fSummary != null) {
            this.fSummary.asyncUpdate(processItem.getDescription().getSummary(), this.getUpdateContext());
        }
        if (this.fDescription != null) {
            this.fDescription.asyncUpdate(processItem.getDescription().getDetails(), flags, this.getUpdateContext(), null);
        }
        this.doReinitializeFromProcessItem(processItem, flags);
    }

    protected void doReinitializeFromProcessItem(IProcessItem processItem, int flags) {
    }

    @Override
    public void asyncRefresh() {
        UpdateRequest request = new UpdateRequest(Messages.getString("ProcessItemWorkingCopy.6")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                try {
                    IProcessItem fetchedItem = (IProcessItem)ProcessItemWorkingCopy.this.fCachedTeamRepository.itemManager().fetchCompleteItem((IItemHandle)ProcessItemWorkingCopy.this.getUnderlyingProcessItem(), 1, monitor);
                    Object object = ProcessItemWorkingCopy.this.fSaveMutex;
                    synchronized (object) {
                        ProcessItemWorkingCopy.this.fProcessItemState = (IProcessItem)ProcessItemWorkingCopy.this.fCachedTeamRepository.itemManager().getImmutableState((IItem)fetchedItem);
                        ProcessItemWorkingCopy.this.markNotDirty();
                        ProcessItemWorkingCopy.this.reinitializeFromProcessItem(ProcessItemWorkingCopy.this.fProcessItemState, 1);
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException x) {
                    if (ProcessItemWorkingCopy.this.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.ibm.team.process.client", 0, x.getMessage(), (Throwable)x);
                }
            }
        };
        ExecUtil.asyncExec(request, this.getUpdateContext(), null);
    }

    private IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    private class SharedItemChangeListener
    implements ISharedItemChangeListener {
        private SharedItemChangeListener() {
        }

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                ProcessItemWorkingCopy.this.handleSharedItemChanged(event);
            }
        }
    }

    private class WorkingCopyListener
    implements IWorkingCopyListener {
        private WorkingCopyListener() {
        }

        @Override
        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            ProcessItemWorkingCopy.this.handleWorkingCopyChanged(event);
        }
    }
}

