/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.ProcessClient;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProjectOperation;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.internal.client.ConfigurationDataCache;
import com.ibm.team.process.internal.client.HttpClientUtil;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.client.Messages;
import com.ibm.team.process.internal.client.RepresentationConversionUtil;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ProcessModelUtilities;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.advice.runtime.AdvisorDeclaration;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataBuilder;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.rest.representations.AbstractRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.AvailableRolesRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.BehaviorRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.ConfigurationDataRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.PermissionRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.ProcessRuntimeRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.RuntimeAttachmentsRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.RuntimeOperationReportRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.RuntimeRoleAssignmentsRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.RuntimeRoleRepresentation;
import com.ibm.team.process.internal.common.util.XMLUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

public class ThinClientProcess
implements IClientProcess {
    private static final String RUNTIME_SERVICE_NAME = "processRuntime";
    private static final String RUNTIME_SERVICE_NS = "jp";
    private static final String PARAM_OPERATION_ID = "operationId";
    private static final String PARAM_CONTEXT = "context";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_ACTION = "action";
    private static final String PARAM_IS_PROJECT_OPERATION = "isProjectOperation";
    private static final String PARAM_ATTACHMENT_PATH = "attachmentPath";
    private static final String PARAM_CONFIGURATION_DATA_ID = "configDataId";
    private final IProjectArea fProjectArea;
    private final ITeamRepository fRepo;
    private final IClientLibraryContext fContext;
    private final IProcessItemService fProcessClient;
    private URI fRuntimeServiceUrl;
    private String fOperationReportsUrl;
    private String fAttachmentsUrl;
    public static final String SP_DISABLE_DATA_CACHING = "com.ibm.team.process.ThinClientProcess.disableConfigDataCaching";
    public static final String SP_DATA_CACHE_MAX_SIZE = "com.ibm.team.process.ThinClientProcess.dataCache.maxSize";
    public static final String SP_DATA_CACHE_HOLD_TIME = "com.ibm.team.process.ThinClientProcess.dataCache.holdTime";
    protected static final ConfigurationDataCache fgConfigDataCache = new ConfigurationDataCache(ThinClientProcess.maxCacheSize(), ThinClientProcess.maxHoldTime());

    public ThinClientProcess(IProjectArea projectArea, IClientLibraryContext context, IProcessItemService processClient) {
        this.fProjectArea = projectArea;
        this.fContext = context;
        this.fProcessClient = processClient;
        this.fRepo = this.fContext.teamRepository();
    }

    private static int maxHoldTime() {
        return ThinClientProcess.getIntSystemProperty(SP_DATA_CACHE_HOLD_TIME, 180000);
    }

    private static int maxCacheSize() {
        return ThinClientProcess.getIntSystemProperty(SP_DATA_CACHE_MAX_SIZE, 100);
    }

    private static int getIntSystemProperty(String key, int defaultValue) {
        Integer val = Integer.getInteger(key);
        if (val != null) {
            return val;
        }
        return defaultValue;
    }

    private static String encodeString(String name) throws TeamRepositoryException {
        try {
            return URLEncoder.encode(name, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    @Override
    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    public IRole2[] getRoles(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask("", 1000);
            String contextUri = this.fProcessClient.getURIForProcessArea(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            URI runtimeServiceUrl = this.getRuntimeServiceUrl((IProgressMonitor)new SubProgressMonitor(monitor, 250));
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response = this.get(runtimeServiceUrl, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            ProcessRuntimeRepresentation processRuntimeRepresentation = this.createRepresentation(response, ProcessRuntimeRepresentation.class);
            String availableRolesUrl = processRuntimeRepresentation.availableRolesUrl;
            availableRolesUrl = this.appendParameter(availableRolesUrl, PARAM_CONTEXT, contextUri);
            response = this.get(this.asUri(availableRolesUrl), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            AvailableRolesRepresentation availableRolesRepresentation = this.createRepresentation(response, AvailableRolesRepresentation.class);
            RuntimeRoleRepresentation[] availableRoles = availableRolesRepresentation.availableRoles;
            IRole2[] roles = new IRole2[availableRoles.length];
            int i = 0;
            while (i < roles.length) {
                IRole2 role;
                roles[i] = role = RepresentationConversionUtil.createRoleFromRepresentation(availableRoles[i]);
                ++i;
            }
            IRole2[] iRole2Array = roles;
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    public IRole2[] getContributorRoles(IContributorHandle contributorHandle, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            monitor.beginTask("", 1000);
            IContributor contributor = (IContributor)this.fContext.teamRepository().itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            String contextUri = this.fProcessClient.getURIForProcessArea(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            URI runtimeServiceUrl = this.getRuntimeServiceUrl((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response = this.get(runtimeServiceUrl, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            ProcessRuntimeRepresentation runtimeRepresentation = this.createRepresentation(response, ProcessRuntimeRepresentation.class);
            String roleAssignmentsUrl = runtimeRepresentation.roleAssignmentsUrl;
            roleAssignmentsUrl = this.appendParameter(roleAssignmentsUrl, PARAM_CONTEXT, contextUri);
            roleAssignmentsUrl = this.appendParameter(roleAssignmentsUrl, PARAM_USER_ID, contributor.getUserId());
            response = this.get(this.asUri(roleAssignmentsUrl), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            RuntimeRoleAssignmentsRepresentation assignmentsRepresentation = this.createRepresentation(response, RuntimeRoleAssignmentsRepresentation.class);
            RuntimeRoleRepresentation[] assignments = assignmentsRepresentation.assignments;
            if (assignments != null) {
                IRole2[] roles = new IRole2[assignments.length];
                int i = 0;
                while (i < assignments.length) {
                    RuntimeRoleRepresentation assignment = assignments[i];
                    roles[i] = RepresentationConversionUtil.createRoleFromRepresentation(assignment);
                    ++i;
                }
                IRole2[] iRole2Array = roles;
                return iRole2Array;
            }
            IRole2[] iRole2Array = new IRole2[]{};
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProcessConfigurationData getProjectConfigurationData(String configDataId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            if (configDataId == null) {
                return null;
            }
            ConfigurationDataRepresentation configData = this.getConfigurationData(configDataId, monitor);
            if (configData != null && configData.configurationXml != null) {
                IProcessConfigurationData configurationData = this.createConfigurationData(configData.configurationXml);
                ((ConfigurationDataElement)configurationData).setIsInheritedFromProcessProvider(configData.isInheritedFromProcessProvider);
                IProcessConfigurationData iProcessConfigurationData = configurationData;
                return iProcessConfigurationData;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    protected ConfigurationDataRepresentation getConfigurationData(String configDataId, IProgressMonitor monitor) throws TeamRepositoryException {
        ConfigurationDataRepresentation representation = null;
        if (!Boolean.getBoolean(SP_DISABLE_DATA_CACHING)) {
            representation = fgConfigDataCache.get((IProjectAreaHandle)this.fProjectArea, configDataId);
        }
        if (representation == null) {
            representation = this.fetchConfigurationData(configDataId, monitor);
        }
        return representation;
    }

    protected ConfigurationDataRepresentation fetchConfigurationData(String configDataId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        URI runtimeServiceUrl = this.getRuntimeServiceUrl((IProgressMonitor)new SubProgressMonitor(monitor, 250));
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = this.get(runtimeServiceUrl, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        ProcessRuntimeRepresentation runtime = this.createRepresentation(response, ProcessRuntimeRepresentation.class);
        String configDataUrl = runtime.configDataUrl;
        IProcessItemService processClient = (IProcessItemService)this.fRepo.getClientLibrary(IProcessItemService.class);
        String contextURI = processClient.getURIForProcessArea((IProcessArea)this.fProjectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        configDataUrl = this.appendParameter(configDataUrl, PARAM_CONTEXT, contextURI);
        configDataUrl = this.appendParameter(configDataUrl, PARAM_CONFIGURATION_DATA_ID, configDataId);
        response = this.get(this.asUri(configDataUrl), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        ConfigurationDataRepresentation representation = this.createRepresentation(response, ConfigurationDataRepresentation.class);
        if (!Boolean.getBoolean(SP_DISABLE_DATA_CACHING)) {
            fgConfigDataCache.put((IProjectAreaHandle)this.fProjectArea, configDataId, representation);
        }
        return representation;
    }

    private IProcessConfigurationData createConfigurationData(String configurationXml) {
        AbstractModel dummyModel = new AbstractModel(){

            public AbstractElementBuilder getRootBuilder() {
                return new ConfigurationDataBuilder();
            }

            public AbstractElement getRoot() {
                List childElements = this.getChildElements();
                if (childElements.size() > 0) {
                    return (AbstractElement)childElements.get(0);
                }
                return null;
            }
        };
        ModelGenerator generator = new ModelGenerator(dummyModel);
        generator.generate(configurationXml);
        return (IProcessConfigurationData)dummyModel.getRoot();
    }

    @Override
    public IAdvisorDeclaration[] getAdvisorDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.doGetAdvisorDeclarations(processArea, operationId, false, monitor);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IAdvisorDeclaration[] getAdvisorDeclarations(String projectOperationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.doGetAdvisorDeclarations((IProcessArea)this.fProjectArea, projectOperationId, true, monitor);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    private IAdvisorDeclaration[] doGetAdvisorDeclarations(IProcessArea processArea, String operationId, boolean isProjectOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        RuntimeOperationReportRepresentation operationReport = this.fetchOperationReport(operationId, processArea, null, isProjectOperation, monitor);
        BehaviorRepresentation.PreconditionRepresentation[] preconditions = operationReport.behavior.preconditions;
        if (preconditions == null) {
            return new IAdvisorDeclaration[0];
        }
        ProcessConfigurationElement preconditionsElement = new ProcessConfigurationElement(null, "http://com.ibm.team.process", "preconditions", null);
        IAdvisorDeclaration[] declarations = new IAdvisorDeclaration[preconditions.length];
        int i = 0;
        while (i < preconditions.length) {
            BehaviorRepresentation.PreconditionRepresentation preconditionRepresentation = preconditions[i];
            IProcessConfigurationElement advisorElement = ProcessModelUtilities.createConfigurationElement((String)preconditionRepresentation.configurationXML, (AbstractElement)preconditionsElement);
            declarations[i] = AdvisorDeclaration.newAdvisorDeclaration((IProcessConfigurationElement)advisorElement);
            ++i;
        }
        return declarations;
    }

    @Override
    public boolean[] getPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            boolean[] blArray = this.doGetPermittedActions(processArea, operationId, actions, false, monitor);
            return blArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean[] getPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            boolean[] blArray = this.doGetPermittedActions((IProcessArea)this.fProjectArea, projectOperationId, actions, true, monitor);
            return blArray;
        }
        finally {
            monitor.done();
        }
    }

    private boolean[] doGetPermittedActions(IProcessArea processArea, String operationId, String[] actions, boolean isProjectOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        RuntimeOperationReportRepresentation operationReport = this.fetchOperationReport(operationId, processArea, actions, isProjectOperation, monitor);
        PermissionRepresentation[] permissions = operationReport.permissions;
        boolean[] results = new boolean[actions.length];
        if (permissions != null) {
            HashSet<String> permitted = new HashSet<String>();
            int i = 0;
            while (i < permissions.length) {
                PermissionRepresentation.Action[] permittedActions = permissions[i].permittedActions;
                int j = 0;
                while (j < permittedActions.length) {
                    permitted.add(permittedActions[j].actionId);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                results[i] = permitted.contains(actions[i]);
                ++i;
            }
        }
        return results;
    }

    protected RuntimeOperationReportRepresentation getOperationReport(String operationId, IProcessArea processArea, String[] actions, boolean isProjectOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        RuntimeOperationReportRepresentation operationReport = this.fetchOperationReport(operationId, processArea, actions, isProjectOperation, monitor);
        return operationReport;
    }

    protected RuntimeOperationReportRepresentation fetchOperationReport(String operationId, IProcessArea processArea, String[] actions, boolean isProjectOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        try {
            RuntimeOperationReportRepresentation operationReport;
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response;
            String context = this.fProcessClient.getURIForProcessArea(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (this.fOperationReportsUrl == null) {
                URI runtimeServiceUrl = this.getRuntimeServiceUrl((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (runtimeServiceUrl == null) {
                    throw new TeamRepositoryException(Messages.getString("ThinClientProcess.0"));
                }
                response = this.get(runtimeServiceUrl, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ProcessRuntimeRepresentation runtime = this.createRepresentation(response, ProcessRuntimeRepresentation.class);
                String operationReportsUrl = runtime.operationReportsUrl;
                if (operationReportsUrl == null) {
                    throw new TeamRepositoryException(Messages.getString("ThinClientProcess.1"));
                }
                this.fOperationReportsUrl = operationReportsUrl;
            }
            String reportUri = this.fOperationReportsUrl;
            reportUri = this.appendParameter(reportUri, PARAM_OPERATION_ID, operationId);
            reportUri = this.appendParameter(reportUri, PARAM_CONTEXT, context);
            if (actions != null) {
                int i = 0;
                while (i < actions.length) {
                    reportUri = this.appendParameter(reportUri, PARAM_ACTION, actions[i]);
                    ++i;
                }
            }
            if (isProjectOperation) {
                reportUri = this.appendParameter(reportUri, PARAM_IS_PROJECT_OPERATION, Boolean.TRUE.toString());
            }
            response = this.get(this.asUri(reportUri), (IProgressMonitor)new SubProgressMonitor(monitor, 800));
            RuntimeOperationReportRepresentation runtimeOperationReportRepresentation = operationReport = this.createRepresentation(response, RuntimeOperationReportRepresentation.class);
            return runtimeOperationReportRepresentation;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IOperationReport advise(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 0, null, this.getProgressMonitor(monitor));
    }

    @Override
    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 1, null, this.getProgressMonitor(monitor));
    }

    @Override
    public IOperationReport reAdviseAndExecute(AdvisableOperation operation, IOperationReport report, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 2, report, this.getProgressMonitor(monitor));
    }

    @Override
    public IOperationReport executeInitializer(ProjectOperation initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IProcessArea processArea = initializer.getProcessArea();
            String operationId = initializer.getOperationIdentifier();
            RuntimeOperationReportRepresentation operationReport = this.fetchOperationReport(operationId, processArea, initializer.getActions(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            ItemHandleAwareHashMap permissionsMap = new ItemHandleAwareHashMap();
            OperationBehaviorConfiguration behavior = RepresentationConversionUtil.createBehaviorConfiguration(operationReport, operationId, "initialization", this.fRepo, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise((AdvisableOperation)initializer, 1, (ISimpleMap)permissionsMap, behavior, null, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 500), null, this.isPremiumProjectArea(processArea));
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    protected IOperationReport doAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        IProcessArea processArea = operation.getProcessArea();
        String operationId = operation.getOperationIdentifier();
        boolean isProjectOperation = operation instanceof ProjectOperation;
        RuntimeOperationReportRepresentation operationReport = null;
        try {
            operationReport = this.getOperationReport(operationId, processArea, operation.getActions(), isProjectOperation, (IProgressMonitor)new SubProgressMonitor(monitor, 389));
            ItemHandleAwareHashMap permissionsMap = this.createPermissionsConfigurationMap(operationReport, processArea, operationId, isProjectOperation, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            this.addSecondaryAreaPermissions(operation, permissionsMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            OperationBehaviorConfiguration behavior = RepresentationConversionUtil.createBehaviorConfiguration(operationReport, operationId, isProjectOperation, this.fRepo, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IDevelopmentLine line = this.getOperationDevelopmentLine(operation.getProcessArea(), operation.getDevelopmentLine(), (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            operation.setDevelopmentLine(line);
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, mode, (ISimpleMap)permissionsMap, behavior, oldReport, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 500), null, this.isPremiumProjectArea(processArea));
            return iOperationReport;
        }
        catch (TeamOperationCanceledException e) {
            if (operationReport != null && mode == 1 && operation.canReRun()) {
                RuntimeOperationReportRepresentation newReport = this.fetchOperationReport(operationId, processArea, operation.getActions(), isProjectOperation, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                if (!operationReport.toXmlString().equals(newReport.toXmlString())) {
                    ItemHandleAwareHashMap permissionsMap = this.createPermissionsConfigurationMap(newReport, processArea, operationId, isProjectOperation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.addSecondaryAreaPermissions(operation, permissionsMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    OperationBehaviorConfiguration behavior = RepresentationConversionUtil.createBehaviorConfiguration(newReport, operationId, isProjectOperation, this.fRepo, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, 2, (ISimpleMap)permissionsMap, behavior, oldReport, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 3), null, this.isPremiumProjectArea(processArea));
                    return iOperationReport;
                }
            }
            throw e;
        }
        finally {
            monitor.done();
        }
    }

    protected IDevelopmentLine getOperationDevelopmentLine(IProcessArea processArea, IDevelopmentLine operationLine, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea instanceof ITeamArea) {
            return this.fProcessClient.getDevelopmentLine(processArea, monitor);
        }
        IDevelopmentLine line = this.fProcessClient.getDevelopmentLine(processArea, monitor);
        if (line != null) {
            return line;
        }
        return operationLine;
    }

    private void addSecondaryAreaPermissions(AdvisableOperation operation, ItemHandleAwareHashMap permissionsMap, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
        if (secondaryAreas.length > 0) {
            SubProgressMonitor secondaryMonitor = new SubProgressMonitor(monitor, 1000 * secondaryAreas.length);
            String operationId = operation.getOperationIdentifier();
            boolean isProjectOperation = operation instanceof ProjectOperation;
            int i = 0;
            while (i < secondaryAreas.length) {
                IProcessArea secondaryArea = secondaryAreas[i];
                RuntimeOperationReportRepresentation secondaryReport = this.fetchOperationReport(operationId, secondaryArea, operation.getSecondaryActions(secondaryArea), isProjectOperation, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)secondaryMonitor, 900));
                ItemHandleAwareHashMap secondaryMap = this.createPermissionsConfigurationMap(secondaryReport, secondaryArea, operationId, isProjectOperation, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                Set keys = secondaryMap.keySet();
                for (Object key : keys) {
                    permissionsMap.put(key, secondaryMap.get(key));
                }
                ++i;
            }
        }
        monitor.done();
    }

    private ItemHandleAwareHashMap createPermissionsConfigurationMap(RuntimeOperationReportRepresentation operationReport, IProcessArea processArea, String operationId, boolean isProjectOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemHandleAwareHashMap map = new ItemHandleAwareHashMap();
        PermissionRepresentation[] permissions = operationReport.permissions;
        if (permissions != null) {
            OperationPermissionsConfiguration[] configurations = new OperationPermissionsConfiguration[permissions.length];
            int i = 0;
            while (i < permissions.length) {
                configurations[i] = RepresentationConversionUtil.createPermissionConfiguration(permissions[i], operationId, isProjectOperation, this.fRepo, monitor);
                ++i;
            }
            map.put((Object)processArea, (Object)configurations);
        }
        return map;
    }

    @Override
    public IProcessAttachment getProcessAttachment(IProcessArea processArea, String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            IProcessAttachment[] attachments = this.doGetAttachments(processArea, attachmentPath, monitor);
            if (attachments.length > 0) {
                IProcessAttachment iProcessAttachment = attachments[0];
                return iProcessAttachment;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProcessAttachment[] getProcessAttachments(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        try {
            IProcessAttachment[] iProcessAttachmentArray = this.doGetAttachments(processArea, null, monitor);
            return iProcessAttachmentArray;
        }
        finally {
            monitor.done();
        }
    }

    private IProcessAttachment[] doGetAttachments(IProcessArea processArea, String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        RuntimeAttachmentsRepresentation attachmentsRepresentation = this.fetchAttachments(processArea, attachmentPath, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        RuntimeAttachmentsRepresentation.Attachment[] attachmentRepresentations = attachmentsRepresentation.attachments;
        if (attachmentRepresentations != null) {
            ArrayList<IProcessAttachmentHandle> attachmentHandles = new ArrayList<IProcessAttachmentHandle>();
            int i = 0;
            while (i < attachmentRepresentations.length) {
                String itemId = attachmentRepresentations[i].itemId;
                IProcessAttachmentHandle handle = (IProcessAttachmentHandle)IProcessAttachment.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null);
                attachmentHandles.add(handle);
                ++i;
            }
            List attachments = this.fRepo.itemManager().fetchCompleteItems(attachmentHandles, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            return attachments.toArray(new IProcessAttachment[attachments.size()]);
        }
        return new IProcessAttachment[0];
    }

    private RuntimeAttachmentsRepresentation fetchAttachments(IProcessArea processArea, String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        if (this.fAttachmentsUrl == null) {
            URI runtimeServiceURI = this.getRuntimeServiceUrl((IProgressMonitor)new SubProgressMonitor(monitor, 250));
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response = this.get(runtimeServiceURI, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            ProcessRuntimeRepresentation runtime = this.createRepresentation(response, ProcessRuntimeRepresentation.class);
            this.fAttachmentsUrl = runtime.attachmentsUrl;
        }
        String attachmentsUrl = this.fAttachmentsUrl;
        String contextUri = this.fProcessClient.getURIForProcessArea(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        attachmentsUrl = this.appendParameter(attachmentsUrl, PARAM_CONTEXT, contextUri);
        if (attachmentPath != null) {
            attachmentsUrl = this.appendParameter(attachmentsUrl, PARAM_ATTACHMENT_PATH, attachmentPath);
        }
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = this.get(this.asUri(attachmentsUrl), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
        RuntimeAttachmentsRepresentation attachmentsRepresentation = this.createRepresentation(response, RuntimeAttachmentsRepresentation.class);
        return attachmentsRepresentation;
    }

    protected ITeamRawRestServiceClient.IRawRestClientConnection.Response get(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        return HttpClientUtil.get(uri, this.fRepo, this.fContext, monitor);
    }

    private String appendParameter(String uri, String parameterName, String parameterValue) throws TeamRepositoryException {
        uri = uri.indexOf(63) == -1 ? String.valueOf(uri) + '?' : String.valueOf(uri) + '&';
        parameterName = String.valueOf(parameterName) + '=';
        uri = String.valueOf(uri) + parameterName;
        uri = String.valueOf(uri) + ThinClientProcess.encodeString(parameterValue);
        return uri;
    }

    private <T extends AbstractRepresentation> T createRepresentation(ITeamRawRestServiceClient.IRawRestClientConnection.Response response, Class<T> representationClass) throws TeamRepositoryException {
        AbstractRepresentation representation;
        try {
            representation = (AbstractRepresentation)representationClass.newInstance();
        }
        catch (IllegalAccessException e) {
            InternalProcessClient.log(e);
            return null;
        }
        catch (InstantiationException e) {
            InternalProcessClient.log(e);
            return null;
        }
        Document xmlDocument = XMLUtil.getXmlDocument((InputStream)response.getResponseStream());
        representation.fromXml(xmlDocument.getDocumentElement());
        return (T)representation;
    }

    private URI getRuntimeServiceUrl(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fRuntimeServiceUrl == null) {
            this.fRuntimeServiceUrl = this.getServiceFromRootServices(RUNTIME_SERVICE_NAME, RUNTIME_SERVICE_NS, monitor);
        }
        return this.fRuntimeServiceUrl;
    }

    private URI getServiceFromRootServices(String name, String namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        try {
            if (RUNTIME_SERVICE_NAME.equals(name) && RUNTIME_SERVICE_NS.equals(namespace)) {
                String repositoryURI = this.fRepo.getRepositoryURI();
                if (!repositoryURI.endsWith("/")) {
                    repositoryURI = String.valueOf(repositoryURI) + '/';
                }
                URI uRI = this.asUri(String.valueOf(repositoryURI) + "process-runtime");
                return uRI;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private URI asUri(String uri) throws TeamRepositoryException {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException(NLS.bind((String)"Invalid URI encountered: {0}. This is an irrecoverable error.", (Object)uri), (Throwable)e);
        }
    }

    protected OperationAdviceManager getOperationAdviceManager() {
        return (OperationAdviceManager)ProcessClient.getOperationAdviceManager();
    }

    protected IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    public static void clearCache() {
        if (fgConfigDataCache != null) {
            fgConfigDataCache.clear();
        }
    }

    private boolean isPremiumProjectArea(IProcessArea processArea) {
        boolean isPremiumProject = false;
        if (processArea instanceof ProjectArea) {
            isPremiumProject = ((ProjectArea)processArea).isPremiumProject();
        }
        return isPremiumProject;
    }
}

