/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.rest.representations.AbstractRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.ConfigurationDataRepresentation;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationDataCache {
    private volatile HashMap<String, Value> fMap = new HashMap();
    private int fMaxSize;
    private long fMaxHoldTime;
    private final Object fMutex = new Object();

    public ConfigurationDataCache(int maxSize, int maxHoldTime) {
        this.fMaxSize = maxSize;
        this.fMaxHoldTime = maxHoldTime;
    }

    public ConfigurationDataRepresentation get(IProjectAreaHandle projectAreaHandle, String configDataId) {
        ConfigurationDataRepresentation representation = null;
        String key = this.createEntryKey(projectAreaHandle, configDataId);
        Value value = this.fMap.get(key);
        if (value != null && !value.expired()) {
            representation = value.representation.get();
            value.lastHitTime = System.currentTimeMillis();
        }
        return representation;
    }

    private String createEntryKey(IProjectAreaHandle projectAreaHandle, String configDataId) {
        return String.valueOf(projectAreaHandle.getItemId().getUuidValue()) + configDataId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(IProjectAreaHandle projectAreaHandle, String configDataId, ConfigurationDataRepresentation representation) {
        Object object = this.fMutex;
        synchronized (object) {
            boolean newEntry;
            HashMap<String, Value> newMap = new HashMap<String, Value>();
            newMap.putAll(this.fMap);
            String key = this.createEntryKey(projectAreaHandle, configDataId);
            boolean bl = newEntry = this.fMap.get(key) == null;
            if (newEntry && this.fMap.size() == this.fMaxSize) {
                Map.Entry<String, Value> oldestEntry = null;
                long oldestEntryTime = System.currentTimeMillis();
                boolean searchForOldest = true;
                for (Map.Entry<String, Value> entry : this.fMap.entrySet()) {
                    long lastHitTime;
                    Value value = entry.getValue();
                    if (value.expired()) {
                        newMap.remove(entry.getKey());
                        searchForOldest = false;
                        continue;
                    }
                    if (!searchForOldest || (lastHitTime = value.lastHitTime) >= oldestEntryTime) continue;
                    oldestEntryTime = lastHitTime;
                    oldestEntry = entry;
                }
                if (searchForOldest && oldestEntry != null) {
                    newMap.remove(oldestEntry.getKey());
                }
            }
            Value value = new Value((AbstractRepresentation)representation);
            newMap.put(key, value);
            this.fMap = newMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.fMutex;
        synchronized (object) {
            this.fMap = new HashMap();
        }
    }

    public int getMaxSize() {
        return this.fMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        Object object = this.fMutex;
        synchronized (object) {
            if (this.fMap.size() > maxSize) {
                this.clear();
            }
            this.fMaxSize = maxSize;
        }
    }

    public int getMaxHoldTime() {
        return (int)this.fMaxHoldTime;
    }

    public void setMaxHoldTime(int maxHoldTime) {
        this.fMaxHoldTime = maxHoldTime;
    }

    public String toString() {
        return "size:" + this.fMap.size() + ", maxSize:" + this.fMaxSize + ", maxHoldTime:" + this.fMaxHoldTime + "\n" + this.fMap;
    }

    private class Value {
        long lastHitTime = System.currentTimeMillis();
        SoftReference<ConfigurationDataRepresentation> representation;
        private long fExpirationTime;

        Value(AbstractRepresentation rep) {
            this.fExpirationTime = this.lastHitTime + ConfigurationDataCache.this.fMaxHoldTime;
            this.representation = new SoftReference<AbstractRepresentation>(rep);
        }

        boolean expired() {
            return this.representation == null || System.currentTimeMillis() >= this.fExpirationTime;
        }

        public String toString() {
            return "l:" + this.lastHitTime + ", e:" + this.fExpirationTime + ", r:" + (this.representation.get() == null ? "null" : this.representation.get().toString());
        }
    }
}

