/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.metronome.traffic;

import com.ibm.team.metronome.internal.Messages;
import com.ibm.team.metronome.traffic.TrafficModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TrafficControl
extends Composite {
    CLabel label;
    TrafficModel traffic;
    int lastHits = -1;

    public TrafficControl(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 5;
        this.setLayout((Layout)layout);
        this.label = new CLabel((Composite)this, 0x1000000);
        this.label.setText(Messages.TrafficControl_serverHits);
        this.label.setToolTipText(Messages.TrafficControl_serverHitsTooltip);
        this.label.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TrafficControl.this.lastHits = -1;
                TrafficControl.this.label.setText(Messages.TrafficControl_recentlyClearedMessage);
                TrafficControl.this.traffic.clear();
            }
        });
        this.label.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TrafficControl.this.label.setText(Messages.TrafficControl_stats);
            }
        });
        GridData layoutData = new GridData(4, 0x1000000, true, true);
        GC gc = new GC((Drawable)this.label);
        layoutData.minimumWidth = gc.textExtent((String)"88888 Hits").x;
        layoutData.verticalAlignment = 4;
        gc.dispose();
        this.label.setLayoutData((Object)layoutData);
        this.traffic = new TrafficModel();
        final Display display = this.getDisplay();
        display.timerExec(1000, new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed() || TrafficControl.this.label.isDisposed()) {
                    return;
                }
                try {
                    int hits = TrafficControl.this.traffic.getHits();
                    if (TrafficControl.this.lastHits != hits) {
                        TrafficControl.this.lastHits = hits;
                        String format = "{0}";
                        if (hits == 1) {
                            format = Messages.TrafficControl_hitSingular;
                        } else if (hits < 100000) {
                            format = Messages.TrafficControl_hitPlural;
                        }
                        TrafficControl.this.label.setText(NLS.bind((String)format, (Object)hits));
                    }
                }
                catch (Exception e) {
                    TrafficControl.this.label.setText(Messages.TrafficControl_hitError);
                    return;
                }
                display.timerExec(1000, (Runnable)this);
            }
        });
    }
}

