/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.metronome;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.metronome.internal.MetronomeControl;
import com.ibm.team.metronome.traffic.TrafficControl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MetronomePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.metronome";
    public static final String METRONOME_TRIM_GROUP = "com.ibm.team.metronome.group";
    private static MetronomePlugin plugin;
    private Set<MetronomeControl> fMetronomeTrimWidgets = new HashSet<MetronomeControl>();
    private Set<TrafficControl> fTrafficTrimWidgets = new HashSet<TrafficControl>();
    IEclipsePreferences.IPreferenceChangeListener listener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("prefs_show_metronome_trim".equals(event.getKey())) {
                MetronomePlugin.this.setTrimWidgetVisibility(UiPlugin.getBooleanPreference((String)"prefs_show_metronome_trim"));
            }
        }
    };

    public void setTrimWidgetVisibility(boolean visible) {
        Composite statusBar;
        Shell shell;
        HashSet<Shell> toLayout = new HashSet<Shell>(this.fMetronomeTrimWidgets.size());
        for (MetronomeControl metronomeWidget : this.fMetronomeTrimWidgets) {
            if (metronomeWidget.isDisposed()) continue;
            metronomeWidget.setVisible(visible);
            shell = metronomeWidget.getShell();
            statusBar = metronomeWidget.getParent();
            while (statusBar.getParent() != shell) {
                statusBar = statusBar.getParent();
            }
            statusBar.computeSize(-1, -1, true);
            toLayout.add(shell);
        }
        for (TrafficControl trafficWidget : this.fTrafficTrimWidgets) {
            if (trafficWidget.isDisposed()) continue;
            trafficWidget.setVisible(visible);
            shell = trafficWidget.getShell();
            statusBar = trafficWidget.getParent();
            while (statusBar.getParent() != shell) {
                statusBar = statusBar.getParent();
            }
            statusBar.computeSize(-1, -1, true);
            toLayout.add(shell);
        }
        for (Shell shell2 : toLayout) {
            shell2.layout();
        }
    }

    private IEclipsePreferences getUiPreferences() {
        return new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getUiPreferences().addPreferenceChangeListener(this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        this.getUiPreferences().removePreferenceChangeListener(this.listener);
        plugin = null;
        super.stop(context);
    }

    public static MetronomePlugin getDefault() {
        return plugin;
    }

    public void addMetronomeTrimWidget(MetronomeControl control) {
        this.fMetronomeTrimWidgets.add(control);
    }

    public void removeMetronomeTrimWidget(MetronomeControl control) {
        this.fMetronomeTrimWidgets.remove((Object)control);
    }

    public void addTrafficTrimWidget(TrafficControl control) {
        this.fTrafficTrimWidgets.add(control);
    }

    public void removeTrafficTrimWidget(TrafficControl control) {
        this.fTrafficTrimWidgets.remove((Object)control);
    }
}

