/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormPartSite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public abstract class TeamFormPartContainer
extends AbstractFormPart {
    private ITeamFormPartSite fSite = new TeamFormPartSite(this);
    private TeamFormPart[] fParts;
    private Control fLastFocusControl = null;
    private Listener fFocusTracker;

    public static Control setup(TeamFormPartContainer partContainer, IManagedForm managedForm, Composite parent) {
        partContainer.initialize(managedForm);
        Composite container = managedForm.getToolkit().createComposite(parent);
        container.setLayout((Layout)new FillLayout());
        partContainer.createContent(container);
        return container;
    }

    public abstract void createContent(Composite var1);

    protected Control createPartContent(Composite parent, TeamFormPart part) {
        part.init(this.fSite);
        ITeamFormLayout formLayout = TeamFormLayouts.getLayout(parent);
        if (formLayout != null) {
            part.createContent(formLayout);
            formLayout.nextGuide();
            return null;
        }
        Composite container = this.getManagedForm().getToolkit().createComposite(parent);
        container.setLayout((Layout)new FillLayout());
        part.createContent(container);
        return container;
    }

    protected void installFocusTracking(Control control) {
        if (this.fFocusTracker == null) {
            this.fFocusTracker = new FocusTracker();
        }
        control.addListener(27, this.fFocusTracker);
    }

    public void setFocus() {
        Control lastFocusControl = this.getLastFocusControl();
        if (lastFocusControl != null) {
            lastFocusControl.setFocus();
        } else {
            super.setFocus();
        }
    }

    protected Control getLastFocusControl() {
        if (this.fLastFocusControl != null && this.fLastFocusControl.isDisposed()) {
            this.fLastFocusControl = null;
        }
        return this.fLastFocusControl;
    }

    protected ITeamFormPartSite getSite() {
        return this.fSite;
    }

    public void passFocus(TeamFormPart part) {
        TeamFormPart[] subSections = this.getParts();
        int i = 0;
        while (i < subSections.length) {
            if (part == subSections[i]) {
                if (i + 1 >= subSections.length && this.getManagedForm().getContainer() instanceof TeamFormPage) {
                    ((TeamFormPage)((Object)this.getManagedForm().getContainer())).passFocus((IFormPart)this);
                    break;
                }
                subSections[(i + 1) % subSections.length].setFocus();
                break;
            }
            ++i;
        }
    }

    public boolean setFormInput(Object input) {
        TeamFormPart[] sections = this.getParts();
        int i = 0;
        while (i < sections.length) {
            sections[i].setInput(input);
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        TeamFormPart[] sections = this.getParts();
        int i = 0;
        while (i < sections.length) {
            sections[i].commit();
            ++i;
        }
        super.commit(onSave);
    }

    public void dispose() {
        TeamFormPart[] sections = this.getParts();
        int i = 0;
        while (i < sections.length) {
            sections[i].dispose();
            ++i;
        }
        this.fFocusTracker = null;
        super.dispose();
    }

    protected TeamFormPart[] getParts() {
        if (this.fParts == null) {
            this.fParts = this.createParts();
        }
        return this.fParts;
    }

    protected abstract TeamFormPart[] createParts();

    private class FocusTracker
    implements Listener {
        private FocusTracker() {
        }

        public void handleEvent(Event event) {
            Display display = event.widget.getDisplay();
            Control focusControl = display.getFocusControl();
            if (this.isParent((Control)event.widget, focusControl)) {
                TeamFormPartContainer.this.fLastFocusControl = focusControl;
            }
        }

        private boolean isParent(Control parent, Control child) {
            while (parent != child && child != null) {
                child = child.getParent();
            }
            return parent == child;
        }
    }
}

