/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.tooltip;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.tooltip.FocusTooltip;
import com.ibm.team.jface.internal.tooltip.HoverTooltip;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import com.ibm.team.jface.internal.tooltip.MarkupJob;
import com.ibm.team.jface.internal.tooltip.NavigatorFocusTooltip;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.internal.tooltip.TooltipUtils;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.INavigatorContent;
import com.ibm.team.jface.tooltip.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TooltipSupport {
    public static final int PREFERRED_HEIGHT = 70;
    public static final int PREFERRED_WIDTH = 240;
    public static final Point PREFERRED_SIZE = Tooltip.PREFERRED_SIZE;
    private static final int[] LISTENER_TYPES = new int[]{37, 5, 7, 3, 32};
    static final int DEFAULT_MARK_READ_AFTER = 2000;
    static final int OPEN_MODIFY_KEY = SWT.MOD1 + 65536;
    static final boolean fgIsLinux = "gtk".equals(SWT.getPlatform());
    private boolean fIsHoverHospotReduced;
    private Control fControl;
    private Object fElement;
    private IHoverSite fHoverSite = new IHoverSite(){

        @Override
        public void closeRequested() {
            TooltipSupport.this.updateReadState();
            Job.getJobManager().cancel(MarkupJob.MarkupJobIdentifier.class);
            TooltipSupport.this.hoverToolTipClosed();
        }

        @Override
        public void focusRequested() {
            TooltipSupport.this.showFocusToolTip(TooltipSupport.this.fElement, TooltipSupport.this.fControl.getDisplay().getCursorLocation());
        }

        @Override
        public void navigatedToNext(Tooltip tooltip) {
            TooltipSupport.this.navigated(tooltip, true);
        }

        @Override
        public void navigatedToPrevious(Tooltip tooltip) {
            TooltipSupport.this.navigated(tooltip, false);
        }

        @Override
        public void openRequested() {
            TooltipSupport.this.openRequested(TooltipSupport.this.fElement);
        }
    };
    private boolean fIsFocusable;
    private boolean fIsOpenable;
    private boolean fUseBrowser = true;
    private Rectangle fItemBounds;
    private Listener fListener;
    private Tooltip fHoverTooltip;
    private FocusTooltip fFocusToolTip;
    private Tooltip fToolTip;
    private MarkupJob fMarkupJob;
    private Point fPreferredFocusSize = FocusTooltip.PREFERRED_SIZE;
    private Point fPreferredHoverSize = Tooltip.PREFERRED_SIZE;
    private boolean fEnableMarkReadOnFocus;
    private boolean fEnableMarkReadOnHover;
    private long fMarkReadAfter = 2000L;

    public TooltipSupport(Control control, boolean isFocusable, boolean isOpenable) {
        this(control, isFocusable, isOpenable, true);
    }

    public TooltipSupport(Control control, boolean isFocusable, boolean isOpenable, boolean disableNativeTooltip) {
        this.fIsFocusable = isFocusable;
        this.fIsOpenable = isOpenable;
        this.installHover(control, disableNativeTooltip);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TooltipSupport.this.dispose();
            }
        });
    }

    public void dispose() {
        if (!this.fControl.isDisposed() && this.fListener != null) {
            int i = 0;
            while (i < LISTENER_TYPES.length) {
                this.fControl.removeListener(LISTENER_TYPES[i], this.fListener);
                ++i;
            }
            if (fgIsLinux && this.fControl instanceof Browser) {
                this.fControl.getShell().removeListener(27, this.fListener);
            }
        }
        if (this.fHoverTooltip != null) {
            this.fHoverTooltip.close();
        }
        Job.getJobManager().cancel(MarkupJob.MarkupJobIdentifier.class);
        this.fMarkupJob = null;
        this.fHoverTooltip = null;
        this.fHoverSite = null;
        this.fListener = null;
    }

    public void setEnableMarkReadOnFocus(boolean enableMarkReadOnFocus) {
        this.fEnableMarkReadOnFocus = enableMarkReadOnFocus;
    }

    public void setEnableMarkReadOnHover(boolean enableMarkReadOnHover) {
        this.fEnableMarkReadOnHover = enableMarkReadOnHover;
    }

    public void setMarkReadAfter(int markReadAfter) {
        this.fMarkReadAfter = markReadAfter;
    }

    public void setPreferredFocusSize(Point size) {
        this.fPreferredFocusSize = size;
    }

    public void setPreferredHoverSize(Point size) {
        this.fPreferredHoverSize = size;
    }

    public void setFocusable(boolean isFocusable) {
        this.fIsFocusable = isFocusable;
    }

    public void setOpenable(boolean isOpenable) {
        this.fIsOpenable = isOpenable;
    }

    public void setUseBrowser(boolean useBrowser) {
        this.fUseBrowser = useBrowser;
    }

    public void setMarkupJob(MarkupJob markupJob) {
        this.fMarkupJob = markupJob;
    }

    public boolean isBlockHoverEvent() {
        return false;
    }

    public boolean isHoverHotspotReduced() {
        return this.fIsHoverHospotReduced;
    }

    protected void updateReadState() {
        boolean isFocus = this.fToolTip instanceof FocusTooltip;
        if (this.fElement == null || this.fToolTip == null || !isFocus && System.currentTimeMillis() - this.fToolTip.getTextTimestamp() < this.fMarkReadAfter) {
            return;
        }
        if (!(isFocus && this.fEnableMarkReadOnFocus || !isFocus && this.fEnableMarkReadOnHover)) {
            return;
        }
        Object element = this.fElement instanceof INavigatorContent ? ((INavigatorContent)this.fElement).current() : this.fElement;
        IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter(element);
        if (adapter != null) {
            adapter.markAsRead(element, 0);
        }
    }

    protected final Object getElement() {
        return this.fElement;
    }

    public Object getElement(Control control, int x, int y) {
        if (control instanceof Tree) {
            TreeItem item = ((Tree)control).getItem(new Point(x, y));
            if (this.isHoverHotspotReduced()) {
                return item != null && (item.getImage(0) == null || item.getImageBounds(0).contains(x, y)) ? item.getData() : null;
            }
            return item != null ? item.getData() : null;
        }
        if (control instanceof Table) {
            TableItem item = ((Table)control).getItem(new Point(x, y));
            if (this.isHoverHotspotReduced()) {
                return item != null && (item.getImage(0) == null || item.getImageBounds(0).contains(x, y)) ? item.getData() : null;
            }
            return item != null ? item.getData() : null;
        }
        return null;
    }

    public Rectangle getElementBounds(Control control, int x, int y) {
        if (control instanceof Table) {
            Table table = (Table)control;
            TableItem item = table.getItem(new Point(x, y));
            if (item != null) {
                int columnCount = table.getColumnCount();
                if (columnCount > 0) {
                    int i = 0;
                    while (i < columnCount) {
                        Rectangle bounds = item.getBounds(i);
                        if (bounds.contains(x, y)) {
                            return this.isHoverHotspotReduced() && item.getImage(i) != null ? item.getImageBounds(i) : bounds;
                        }
                        ++i;
                    }
                } else {
                    return this.isHoverHotspotReduced() && item.getImage(0) != null ? item.getImageBounds(0) : item.getBounds(0);
                }
            }
            return new Rectangle(0, 0, 0, 0);
        }
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            TreeItem item = tree.getItem(new Point(x, y));
            if (item != null) {
                int columnCount = tree.getColumnCount();
                if (columnCount > 0) {
                    int i = 0;
                    while (i < columnCount) {
                        Rectangle bounds = item.getBounds(i);
                        if (bounds.contains(x, y)) {
                            return this.isHoverHotspotReduced() && item.getImage(i) != null ? item.getImageBounds(i) : bounds;
                        }
                        ++i;
                    }
                } else {
                    return this.isHoverHotspotReduced() && item.getImage(0) != null ? item.getImageBounds(0) : item.getBounds(0);
                }
            }
            return new Rectangle(0, 0, 0, 0);
        }
        Point e = control.getSize();
        return new Rectangle(0, 0, e.x, e.y);
    }

    protected String getMarkup(Object element, boolean isFocus) {
        String jobInfo;
        IDomainAdapter adapter;
        if (element == null) {
            return null;
        }
        final Object finalElem = this.doResolve(element);
        if (finalElem == null) {
            return null;
        }
        if (this.useDomainAdapter(element)) {
            adapter = DomainAdapterUtils.getDomainAdapter(finalElem);
            if (adapter == null) {
                return null;
            }
        } else {
            adapter = null;
        }
        final IDomainAdapter.Info info = new IDomainAdapter.Info();
        info.isHoverTooltip = !isFocus;
        info.isFocusTooltip = isFocus;
        String string = jobInfo = adapter != null ? adapter.generateJobInfo(finalElem, info) : null;
        if ("__do--not__show//".equals(jobInfo)) {
            return null;
        }
        if (jobInfo == null) {
            jobInfo = Messages.TooltipSupport_PROCESSING;
        }
        this.fMarkupJob = new MarkupJob(new MarkupJob.MarkupJobIdentifier(finalElem, info), jobInfo){

            @Override
            protected String doRun(IProgressMonitor monitor) {
                return TooltipSupport.this.getMarkupInBackground(adapter, finalElem, info, monitor);
            }
        };
        return XMLString.createFromPlainText((String)jobInfo).getXMLText();
    }

    protected boolean useDomainAdapter(Object element) {
        return true;
    }

    protected String getMarkupInBackground(IDomainAdapter adapter, Object element, IDomainAdapter.Info info, IProgressMonitor monitor) {
        if (adapter != null) {
            return DomainAdapterUtils.generateContentAsHTML(adapter, element, info, monitor);
        }
        return null;
    }

    protected Object doResolve(Object element) {
        return element;
    }

    protected Object mapElement(int x, int y) {
        return this.getElement(this.fControl, x, y);
    }

    protected void openRequested(Object element) {
    }

    protected void showFocusToolTip(Object element, Point location) {
        Assert.isTrue((element == this.fElement ? 1 : 0) != 0);
        this.fMarkupJob = null;
        this.openFocusToolTip(element, location, this.createMarkup(element, false), null);
    }

    protected void showHoverToolTip(Object element, Point location) {
        Assert.isTrue((element == this.fElement ? 1 : 0) != 0);
        this.fMarkupJob = null;
        this.openHoverToolTip(location, this.createMarkup(element, true), null);
    }

    private void installHover(Control control, boolean disableNativeToolTip) {
        this.fControl = control;
        if (disableNativeToolTip) {
            this.fControl.setToolTipText("");
        }
        this.fListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        if (event.stateMask != 0) {
                            return;
                        }
                        if (Tooltip.isBlocked()) {
                            return;
                        }
                        TooltipSupport.this.fIsHoverHospotReduced = true;
                        TooltipSupport.this.fElement = TooltipSupport.this.mapElement(event.x, event.y);
                        TooltipSupport.this.fItemBounds = TooltipSupport.this.getElementBounds(TooltipSupport.this.fControl, event.x, event.y);
                        if (TooltipSupport.this.fElement == null || ((TooltipSupport)TooltipSupport.this).fItemBounds.x == 0 && ((TooltipSupport)TooltipSupport.this).fItemBounds.y == 0 && ((TooltipSupport)TooltipSupport.this).fItemBounds.height == 0 && ((TooltipSupport)TooltipSupport.this).fItemBounds.width == 0) break;
                        TooltipSupport.this.closeCurrentHover();
                        Point location = this.computeHoverLocation(event);
                        TooltipSupport.this.showHoverToolTip(TooltipSupport.this.fElement, location);
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 27: 
                    case 37: {
                        TooltipSupport.this.closeCurrentHover();
                        break;
                    }
                    case 5: {
                        if (TooltipSupport.this.fHoverTooltip != null && !TooltipSupport.this.fHoverTooltip.isDisposed() && TooltipSupport.this.fHoverTooltip.isVisible()) {
                            if (TooltipSupport.this.fItemBounds != null && TooltipSupport.this.fItemBounds.contains(event.x, event.y)) {
                                return;
                            }
                            TooltipSupport.this.closeCurrentHover();
                            break;
                        }
                        if ((event.stateMask & OPEN_MODIFY_KEY) != OPEN_MODIFY_KEY) break;
                        if (Tooltip.isBlocked()) {
                            return;
                        }
                        TooltipSupport.this.fIsHoverHospotReduced = false;
                        TooltipSupport.this.fElement = TooltipSupport.this.mapElement(event.x, event.y);
                        TooltipSupport.this.fItemBounds = TooltipSupport.this.getElementBounds(TooltipSupport.this.fControl, event.x, event.y);
                        if (TooltipSupport.this.fElement == null || ((TooltipSupport)TooltipSupport.this).fItemBounds.x == 0 && ((TooltipSupport)TooltipSupport.this).fItemBounds.y == 0 && ((TooltipSupport)TooltipSupport.this).fItemBounds.height == 0 && ((TooltipSupport)TooltipSupport.this).fItemBounds.width == 0) break;
                        TooltipSupport.this.closeCurrentHover();
                        Point location2 = this.computeHoverLocation(event);
                        TooltipSupport.this.showHoverToolTip(TooltipSupport.this.fElement, location2);
                    }
                }
            }

            private Point computeHoverLocation(Event event) {
                Point location = TooltipSupport.this.fControl.getDisplay().getCursorLocation();
                location.y = ((TooltipSupport)TooltipSupport.this).fControl.getDisplay().map((Control)((TooltipSupport)TooltipSupport.this).fControl, null, (int)event.x, (int)((TooltipSupport)TooltipSupport.this).fItemBounds.y).y;
                return location;
            }
        };
        int i = 0;
        while (i < LISTENER_TYPES.length) {
            this.fControl.addListener(LISTENER_TYPES[i], this.fListener);
            ++i;
        }
        if (fgIsLinux && this.fControl instanceof Browser) {
            this.fControl.getShell().addListener(27, this.fListener);
        }
    }

    private void openHoverToolTip(Point location, String markup, URIReference context) {
        if (markup == null) {
            return;
        }
        this.fHoverTooltip = HoverTooltip.createTooltip(this.fControl.getShell(), this.fHoverSite, this.fIsFocusable, this.fUseBrowser, this.fPreferredHoverSize);
        this.setMarkup(this.fHoverTooltip, markup, context);
        this.fHoverTooltip.open(location, this.fItemBounds.height);
        this.fToolTip = this.fHoverTooltip;
        this.hoverToolTipOpened();
    }

    protected void hoverToolTipOpened() {
    }

    protected void hoverToolTipClosed() {
    }

    private void openFocusToolTip(Object element, Point location, String markup, URIReference context) {
        this.fFocusToolTip = element instanceof INavigatorContent ? NavigatorFocusTooltip.createTooltip(this.fControl.getShell(), this.fHoverSite, this.fIsOpenable, this.fPreferredFocusSize) : FocusTooltip.createTooltip(this.fControl.getShell(), this.fHoverSite, this.fIsOpenable, this.fPreferredFocusSize);
        this.fToolTip = this.fFocusToolTip;
        this.fFocusToolTip.setText(markup);
        this.fFocusToolTip.setContext(context);
        TooltipUtils.updateTooltipTitle(element, this.fFocusToolTip);
        if (this.fFocusToolTip instanceof NavigatorFocusTooltip) {
            NavigatorFocusTooltip navTooltip = (NavigatorFocusTooltip)this.fFocusToolTip;
            INavigatorContent content = (INavigatorContent)element;
            navTooltip.setNextEnabled(content.hasNext());
            navTooltip.setPrevEnabled(content.hasPrevious());
            navTooltip.setTitle(NLS.bind((String)Messages.TooltipSupport_N_OF_M, (Object)(content.getPosition() + 1), (Object)content.size()));
        }
        this.setMarkup(this.fFocusToolTip, markup, context);
        this.fFocusToolTip.open(location);
    }

    private void closeCurrentHover() {
        if (this.fHoverTooltip != null && !this.fHoverTooltip.isDisposed() && this.fHoverTooltip.isVisible()) {
            this.fHoverTooltip.close();
        }
        this.fMarkupJob = null;
    }

    private void navigated(Tooltip navTooltip, boolean next) {
        if (this.fElement instanceof INavigatorContent && navTooltip instanceof NavigatorFocusTooltip) {
            this.fMarkupJob = null;
            this.updateReadState();
            INavigatorContent content = (INavigatorContent)this.fElement;
            NavigatorFocusTooltip tooltip = (NavigatorFocusTooltip)navTooltip;
            Object element = next ? content.next() : content.previous();
            tooltip.setNextEnabled(content.hasNext());
            tooltip.setPrevEnabled(content.hasPrevious());
            tooltip.setTitle(NLS.bind((String)Messages.TooltipSupport_N_OF_M, (Object)(content.getPosition() + 1), (Object)content.size()));
            this.setMarkup(navTooltip, this.getMarkup(element, true), null);
        }
    }

    private void setMarkup(Tooltip toolTip, String markup, URIReference context) {
        if (this.fMarkupJob != null) {
            Job[] job = Job.getJobManager().find(this.fMarkupJob.getJobIdentifier());
            MarkupJob existingMarkupJob = null;
            int i = 0;
            while (i < job.length) {
                if (job[i] instanceof MarkupJob) {
                    existingMarkupJob = (MarkupJob)job[i];
                    break;
                }
                ++i;
            }
            if (existingMarkupJob == null) {
                this.fMarkupJob.init(toolTip);
                this.fMarkupJob.schedule();
            } else {
                this.fMarkupJob = existingMarkupJob;
                existingMarkupJob.init(toolTip);
            }
            try {
                i = 0;
                while (this.fMarkupJob.getMarkup() == null && i < 5) {
                    Thread.sleep(30L);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                JFacePlugin.log(e);
            }
            if (this.fMarkupJob.getMarkup() == null) {
                toolTip.setText(markup);
                toolTip.setContext(context);
            } else {
                toolTip.setText(this.fMarkupJob.getMarkup());
                toolTip.setContext(this.fMarkupJob.getContext());
            }
        } else {
            toolTip.setText(markup);
            toolTip.setContext(context);
        }
    }

    private String createMarkup(Object element, boolean isHover) {
        if (element instanceof INavigatorContent) {
            element = ((INavigatorContent)element).current();
        }
        return this.getMarkup(element, !isHover);
    }
}

