/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.tooltip;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import com.ibm.team.jface.internal.tooltip.Slideout;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.INavigatorContent;
import com.ibm.team.jface.tooltip.Messages;
import com.ibm.team.jface.tooltip.NavigatorContentAdapter;
import com.ibm.team.jface.util.UIUpdaterJob;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public abstract class SlideoutSupport {
    private static final int SPACING = 7;
    private static final String PREFERENCES_KEY = SlideoutSupport.class.getName();
    private static final String PREFERRED_WIDTH_KEY = String.valueOf(PREFERENCES_KEY) + "width";
    private static final String PREFERRED_HEIGHT_KEY = String.valueOf(PREFERENCES_KEY) + "height";
    private static final String MEMENTO_WRITE_TYPE = String.valueOf(PREFERENCES_KEY) + "writetype";
    private static final String ID_KEY = String.valueOf(PREFERENCES_KEY) + "id";
    private static final String CHILD_TYPE = String.valueOf(PREFERENCES_KEY) + "childtype";
    private Control fParent;
    private Shell fShell;
    private ISelectionProvider fSelectionProvider;
    private boolean fMarkReadOnOpen;
    private UIJob fShowSlideoutJob = new LoggingUIJob(Messages.SlideoutSupport_SHOW_SLIDEOUT){

        @Override
        public IStatus runProtectedInUI(IProgressMonitor monitor) {
            SlideoutSupport.this.fAwaitingDoubleclick = false;
            if (SlideoutSupport.this.fMouseDownDuringClose || SlideoutSupport.this.fIsNotLeftClick) {
                if (SlideoutSupport.this.fMouseDownDuringClose) {
                    SlideoutSupport.this.fMouseDownDuringClose = false;
                }
                if (SlideoutSupport.this.fIsNotLeftClick) {
                    SlideoutSupport.this.fIsNotLeftClick = false;
                }
                if (SlideoutSupport.this.fToolTip == null || SlideoutSupport.this.fToolTip.isDisposed()) {
                    return Status.OK_STATUS;
                }
            }
            SlideoutSupport.this.internalShowSlideout();
            return Status.OK_STATUS;
        }
    };
    private ISelection fCurrentSelection;
    private ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            INavigatorContent newContent = SlideoutSupport.this.convertSelectionToNavigatorContent(selection);
            if (newContent != null) {
                if (selection.equals(SlideoutSupport.this.fCurrentSelection) && SlideoutSupport.this.fToolTip != null && SlideoutSupport.this.fToolTip.isVisible()) {
                    return;
                }
                SlideoutSupport.this.fCurrentSelection = selection;
                SlideoutSupport.this.fCurrentContent = newContent;
                if (!SlideoutSupport.this.fAwaitingDoubleclick) {
                    if (SlideoutSupport.this.fMouseDownDuringClose) {
                        SlideoutSupport.this.fShowSlideoutJob.schedule((long)Display.getCurrent().getDoubleClickTime());
                        SlideoutSupport.this.fAwaitingDoubleclick = true;
                    } else {
                        SlideoutSupport.this.fShowSlideoutJob.schedule();
                    }
                    SlideoutSupport.this.fMouseDownDuringClose = false;
                }
            } else {
                SlideoutSupport.this.close();
            }
        }
    };
    private Point fInitialPreferredSizeInDLUs = new Point(300, 150);
    private Point fPreferredSize;
    private Slideout fToolTip;
    protected boolean fIsShowOnFocusRequest;
    private ISlideoutHoverSite fHoverSite;
    private INavigatorContent fCurrentContent;
    private ShellAdapter fParentShellListener;
    private FocusListener fParentFocusListener;
    private KeyListener fKeyListener;
    private TraverseListener fParentTraverseListener;
    protected boolean fAwaitingDoubleclick;
    protected boolean fMouseDownDuringClose;
    protected boolean fIsNotLeftClick;
    private MouseListener fMouseListener;
    private boolean fIsOpenable;
    private String fSlideoutSupportId;
    private boolean fWasResized;
    private final boolean fDisableNativeTooltip;

    public SlideoutSupport(Control parent, ISelectionProvider provider, String id, boolean isOpenable) {
        this(parent, provider, id, isOpenable, false);
    }

    public SlideoutSupport(Control parent, ISelectionProvider provider, String id, boolean isOpenable, boolean disableNativeTooltip) {
        this.fPreferredSize = new Point(this.fInitialPreferredSizeInDLUs.x, this.fInitialPreferredSizeInDLUs.y);
        this.fHoverSite = new ISlideoutHoverSite(){

            @Override
            public void closeRequested() {
                SlideoutSupport.this.slideoutCloseRequested();
            }

            @Override
            public void focusRequested() {
            }

            @Override
            public void navigatedToNext(Tooltip tooltip) {
                SlideoutSupport.this.navigateRight(1);
            }

            @Override
            public void navigatedToPrevious(Tooltip tooltip) {
                SlideoutSupport.this.navigateLeft(1);
            }

            @Override
            public void openRequested() {
                Object current = SlideoutSupport.this.fCurrentContent.current();
                SlideoutSupport.this.openRequested(current);
            }

            @Override
            public void parentFocusRequested(boolean showOnFocus) {
                SlideoutSupport.this.fIsShowOnFocusRequest = showOnFocus;
                if (SlideoutSupport.this.fSelectionProvider != null) {
                    SlideoutSupport.this.fSelectionProvider.setSelection(SlideoutSupport.this.fCurrentSelection);
                }
                if (SlideoutSupport.this.fParent != null) {
                    SlideoutSupport.this.fParent.setFocus();
                }
            }

            @Override
            public void slideoutResized() {
                if (SlideoutSupport.this.fToolTip != null && SlideoutSupport.this.fToolTip.getShell() != null && !SlideoutSupport.this.fToolTip.getShell().isDisposed()) {
                    ((SlideoutSupport)SlideoutSupport.this).fPreferredSize.x = SlideoutSupport.this.fToolTip.getPreferredWidth();
                    ((SlideoutSupport)SlideoutSupport.this).fPreferredSize.y = SlideoutSupport.this.fToolTip.getPreferredHeight();
                    SlideoutSupport.this.fWasResized = true;
                }
            }
        };
        this.fParentShellListener = new ShellAdapter(){

            public void shellDeactivated(final ShellEvent e) {
                LoggingUIJob job = new LoggingUIJob(Messages.SlideoutSupport_AWAIT_SHELL_DEACTIVATION){

                    @Override
                    public IStatus runProtectedInUI(IProgressMonitor arg0) {
                        if (SlideoutSupport.this.fToolTip != null && e.display.getActiveShell() != SlideoutSupport.this.fToolTip.getShell()) {
                            SlideoutSupport.this.close();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }

            public void shellClosed(ShellEvent e) {
                SlideoutSupport.this.close();
            }

            public void shellIconified(ShellEvent e) {
                SlideoutSupport.this.close();
            }
        };
        this.fParentFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (SlideoutSupport.this.fIsShowOnFocusRequest) {
                    SlideoutSupport.this.fIsShowOnFocusRequest = false;
                    SlideoutSupport.this.internalShowSlideout();
                }
            }

            public void focusLost(FocusEvent e) {
                Point cursorLocation = e.display.getCursorLocation();
                if (SlideoutSupport.this.fToolTip != null && !SlideoutSupport.this.fToolTip.isDisposed() && !SlideoutSupport.this.fToolTip.getShell().getBounds().contains(cursorLocation) && SlideoutSupport.this.fToolTip.getShell().getDisplay().getActiveShell() != SlideoutSupport.this.fToolTip.getShell()) {
                    SlideoutSupport.this.close();
                }
            }
        };
        this.fKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isMod1 = (e.stateMask & SWT.MOD1) == 0;
                boolean isLeft = false;
                switch (e.keyCode) {
                    case 27: {
                        SlideoutSupport.this.close();
                        break;
                    }
                    case 0x1000003: {
                        isLeft = true;
                    }
                    case 0x1000004: {
                        int steps;
                        e.doit = false;
                        int n = steps = isMod1 ? 1 : 10;
                        if (SlideoutSupport.this.fToolTip == null || !SlideoutSupport.this.fToolTip.isVisible()) {
                            SlideoutSupport.this.internalShowSlideout();
                            return;
                        }
                        SlideoutSupport.this.navigate(isLeft, steps);
                    }
                }
            }
        };
        this.fParentTraverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: {
                        if (SlideoutSupport.this.fToolTip == null || !SlideoutSupport.this.fToolTip.isVisible()) break;
                        SlideoutSupport.this.fToolTip.getShell().forceActive();
                        e.doit = false;
                        break;
                    }
                    case 4: {
                        SlideoutSupport.this.close();
                    }
                }
            }
        };
        this.fMouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean bl = SlideoutSupport.this.fIsNotLeftClick = e.button != 1;
                if (SlideoutSupport.this.fToolTip == null) {
                    SlideoutSupport.this.fMouseDownDuringClose = true;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                SlideoutSupport.this.close();
            }
        };
        this.fWasResized = false;
        this.fParent = parent;
        this.fSelectionProvider = provider;
        this.fDisableNativeTooltip = disableNativeTooltip;
        this.fSelectionProvider.addSelectionChangedListener(this.fSelectionChangedListener);
        this.fShell = this.fParent.getShell();
        this.fShell.addShellListener((ShellListener)this.fParentShellListener);
        this.fParent.addFocusListener(this.fParentFocusListener);
        this.fParent.addKeyListener(this.fKeyListener);
        this.fParent.addTraverseListener(this.fParentTraverseListener);
        this.fParent.addMouseListener(this.fMouseListener);
        this.fIsOpenable = isOpenable;
        this.fSlideoutSupportId = id;
        this.fShowSlideoutJob.setSystem(true);
        this.init();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SlideoutSupport.this.dispose();
            }
        });
        parent.setData("com.ibm.team.jface.internal.tooltip.Slideout#Marker", (Object)true);
    }

    public void setMarkReadOnOpen(boolean markReadOnOpen) {
        this.fMarkReadOnOpen = markReadOnOpen;
    }

    private void init() {
        IPreferenceStore preferenceStore = JFacePlugin.getDefault().getPreferenceStore();
        String mementoAsString = preferenceStore.getString(PREFERENCES_KEY);
        if (mementoAsString == null || mementoAsString.length() == 0) {
            return;
        }
        try {
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoAsString));
            IMemento[] children = memento.getChildren(CHILD_TYPE);
            if (children == null) {
                return;
            }
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                if (this.fSlideoutSupportId.equals(child.getString(ID_KEY))) {
                    Integer width = child.getInteger(PREFERRED_WIDTH_KEY);
                    Integer height = child.getInteger(PREFERRED_HEIGHT_KEY);
                    if (width != null && height != null) {
                        this.fPreferredSize = new Point(width.intValue(), height.intValue());
                        this.fWasResized = true;
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JFacePlugin.getDefault().log("Error reading preferred slideout size for slideout: " + this.fSlideoutSupportId, e);
        }
    }

    private void store() {
        if (!this.fWasResized) {
            return;
        }
        IPreferenceStore preferenceStore = JFacePlugin.getDefault().getPreferenceStore();
        String mementoAsString = preferenceStore.getString(PREFERENCES_KEY);
        XMLMemento memento = null;
        if (mementoAsString == null || mementoAsString.length() == 0) {
            memento = XMLMemento.createWriteRoot((String)MEMENTO_WRITE_TYPE);
        } else {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoAsString));
            }
            catch (CoreException e) {
                JFacePlugin.getDefault().log("Error reading preferred slidout sizes before storing: overwriting", e);
                memento = XMLMemento.createWriteRoot((String)MEMENTO_WRITE_TYPE);
            }
        }
        IMemento[] children = memento.getChildren(CHILD_TYPE);
        IMemento child = null;
        if (children != null) {
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento2 = iMementoArray[n2];
                if (this.fSlideoutSupportId.equals(memento2.getString(ID_KEY))) {
                    child = memento2;
                    break;
                }
                ++n2;
            }
        }
        if (child == null) {
            child = memento.createChild(CHILD_TYPE);
            child.putString(ID_KEY, this.fSlideoutSupportId);
        }
        child.putInteger(PREFERRED_HEIGHT_KEY, this.fPreferredSize.y);
        child.putInteger(PREFERRED_WIDTH_KEY, this.fPreferredSize.x);
        try {
            StringWriter writer = new StringWriter();
            memento.save((Writer)writer);
            preferenceStore.putValue(PREFERENCES_KEY, writer.toString());
        }
        catch (IOException e) {
            JFacePlugin.getDefault().log("Error saving preferred size of slideout: " + this.fSlideoutSupportId, e);
        }
    }

    private void internalShowSlideout() {
        if (this.fCurrentContent == null) {
            if (this.fToolTip != null && this.fToolTip.isVisible()) {
                this.close();
            }
            return;
        }
        if (this.fToolTip == null) {
            if (!this.fWasResized) {
                Shell parentShell = this.fParent.getShell();
                GC gc = new GC((Drawable)parentShell);
                FontMetrics fontMetrics = gc.getFontMetrics();
                gc.dispose();
                int width = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)this.fInitialPreferredSizeInDLUs.x);
                int height = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)this.fInitialPreferredSizeInDLUs.y);
                this.fPreferredSize = new Point(width, height);
            }
            this.fToolTip = Slideout.createSlideoutTooltip(this.fParent, this.fHoverSite, this.fIsOpenable, this.fPreferredSize, this.fKeyListener);
        }
        Object current = this.fCurrentContent.current();
        this.update(current);
        if (this.fToolTip.isDisposed() || this.fToolTip.getShell() == null || !this.fToolTip.getShell().isVisible()) {
            if (this.fDisableNativeTooltip && this.fParent != null && !this.fParent.isDisposed()) {
                this.fParent.setToolTipText("");
            }
            this.fToolTip.open(this.getLocation());
        }
    }

    private void update(final Object current) {
        String footerText = NLS.bind((String)Messages.SlideoutSupport_N_OF_M, (Object)(this.fCurrentContent.getPosition() + 1), (Object)this.fCurrentContent.size());
        this.fToolTip.setNumbersText(footerText);
        if (this.fCurrentContent instanceof NavigatorContentAdapter) {
            this.fToolTip.setUnreadCount(((NavigatorContentAdapter)this.fCurrentContent).getUnreadCount());
        }
        if (current instanceof String) {
            this.setText((String)current);
        } else {
            final IDomainAdapter domainAdapter = DomainAdapterUtils.getDomainAdapter(current);
            if (domainAdapter == null) {
                this.setText(Messages.SlideoutSupport_SELECTION_UNKNOWN_TYPE);
            } else {
                final IDomainAdapter.Info info = new IDomainAdapter.Info();
                String jobInfo = domainAdapter.generateJobInfo(current, info);
                if (jobInfo == null) {
                    jobInfo = Messages.SlideoutSupport_PROCESSING;
                }
                if ((jobInfo = XMLString.createFromPlainText((String)jobInfo).getXMLText()).length() > 0 || this.fToolTip.getText() == null) {
                    this.setText(jobInfo);
                }
                new UIUpdaterJob(Messages.SlideoutSupport_COMPUTING_SLIDEOUT_CONTENT){
                    private String fHtml;

                    @Override
                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.fHtml = DomainAdapterUtils.generateContentAsHTML(domainAdapter, current, info);
                        return super.runInBackground(monitor);
                    }

                    @Override
                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (SlideoutSupport.this.fToolTip != null && !SlideoutSupport.this.fToolTip.isDisposed()) {
                            SlideoutSupport.this.setText(this.fHtml);
                            SlideoutSupport.this.fToolTip.update();
                        }
                        return super.runInUI(monitor);
                    }
                }.schedule();
                if (this.fMarkReadOnOpen) {
                    domainAdapter.markAsRead(current, 0);
                }
            }
        }
        this.fToolTip.setLeftNavigationEnabled(this.fCurrentContent.hasPrevious());
        this.fToolTip.setRightNavigationEnabled(this.fCurrentContent.hasNext());
        this.fToolTip.update();
    }

    protected Point getLocation() {
        Shell parentShell = this.fParent.getShell();
        Rectangle usableArea = parentShell.getMonitor().getClientArea();
        Rectangle parentBoundsOnDisplay = this.getParentBounds();
        if (this.fPreferredSize.y > usableArea.height) {
            this.fPreferredSize.y = usableArea.height;
            this.fToolTip.setPreferredSizeInPixels(this.fPreferredSize);
        }
        int preferredX = this.fPreferredSize.x;
        int preferredY = this.fPreferredSize.y;
        boolean isRoomLeft = parentBoundsOnDisplay.x - preferredX - 7 >= usableArea.x;
        boolean isRoomRight = parentBoundsOnDisplay.x + parentBoundsOnDisplay.width + preferredX + 7 <= usableArea.x + usableArea.width;
        boolean isRoomAbove = parentBoundsOnDisplay.y - preferredY - 7 >= usableArea.y;
        Point locationOnDisplay = new Point(0, 0);
        if (isRoomRight || isRoomLeft) {
            boolean overlapsLowerBorder = parentBoundsOnDisplay.y + preferredY > usableArea.y + usableArea.height;
            locationOnDisplay.y = !overlapsLowerBorder ? parentBoundsOnDisplay.y : usableArea.y + usableArea.height - preferredY;
            locationOnDisplay.x = isRoomLeft ? parentBoundsOnDisplay.x - preferredX - 7 : parentBoundsOnDisplay.x + parentBoundsOnDisplay.width + 7;
        } else {
            locationOnDisplay.x = parentBoundsOnDisplay.x;
            locationOnDisplay.y = isRoomAbove ? parentBoundsOnDisplay.y - preferredY - 7 : parentBoundsOnDisplay.y + parentBoundsOnDisplay.height + 7;
        }
        return locationOnDisplay;
    }

    private void setText(String text) {
        this.fToolTip.setText(text);
    }

    private void navigate(boolean isLeft, int steps) {
        if (isLeft) {
            this.navigateLeft(steps);
        } else {
            this.navigateRight(steps);
        }
    }

    private void navigateLeft(int steps) {
        if (this.fToolTip == null || !this.fToolTip.isVisible()) {
            return;
        }
        if (this.fCurrentContent == null) {
            this.close();
            return;
        }
        Object previous = null;
        Object current = this.fCurrentContent.current();
        int i = 0;
        while (i < steps && this.fCurrentContent.hasPrevious()) {
            previous = this.fCurrentContent.previous();
            ++i;
        }
        if (previous == null) {
            previous = this.fCurrentContent.current();
        }
        if (current != previous) {
            this.update(previous);
        }
    }

    private void navigateRight(int steps) {
        if (this.fToolTip == null || !this.fToolTip.isVisible()) {
            return;
        }
        if (this.fCurrentContent == null) {
            this.close();
            return;
        }
        Object next = null;
        Object current = this.fCurrentContent.current();
        int i = 0;
        while (i < steps && this.fCurrentContent.hasNext()) {
            next = this.fCurrentContent.next();
            ++i;
        }
        if (next == null) {
            next = this.fCurrentContent.current();
        }
        if (current != next) {
            this.update(next);
        }
    }

    protected abstract INavigatorContent convertSelectionToNavigatorContent(ISelection var1);

    protected void openRequested(Object element) {
    }

    protected void slideoutCloseRequested() {
        if (this.fToolTip != null) {
            Slideout tooltip = this.fToolTip;
            if (!tooltip.getShell().isDisposed()) {
                Shell shell = tooltip.getShell();
                Point sizeInPix = shell.getSize();
                this.fPreferredSize.x = sizeInPix.x;
                this.fPreferredSize.y = sizeInPix.y;
            }
            this.fToolTip = null;
            this.fCurrentContent = null;
            if (SWT.getPlatform().startsWith("win")) {
                tooltip.dispose();
            }
            if (this.fDisableNativeTooltip && this.fParent != null && !this.fParent.isDisposed()) {
                this.fParent.setToolTipText(null);
            }
        }
    }

    protected Rectangle getParentBounds() {
        return this.fParent.getDisplay().map(this.fParent, null, this.fParent.getBounds());
    }

    public void dispose() {
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.removeSelectionChangedListener(this.fSelectionChangedListener);
            this.fSelectionProvider = null;
        }
        if (this.fParent != null && !this.fParent.isDisposed()) {
            this.fParent.removeKeyListener(this.fKeyListener);
            this.fParent.removeFocusListener(this.fParentFocusListener);
            this.fParent.removeTraverseListener(this.fParentTraverseListener);
            this.fParent.removeMouseListener(this.fMouseListener);
            this.fParent = null;
        }
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.removeShellListener((ShellListener)this.fParentShellListener);
            this.fShell = null;
        }
        if (this.fToolTip != null) {
            this.fToolTip.removeKeyListener(this.fKeyListener);
        }
        this.store();
    }

    private void close() {
        if (this.fToolTip != null) {
            this.fToolTip.removeKeyListener(this.fKeyListener);
            this.fToolTip.close();
            this.fCurrentContent = null;
            if (this.fDisableNativeTooltip && this.fParent != null && !this.fParent.isDisposed()) {
                this.fParent.setToolTipText(null);
            }
        }
    }

    public boolean isSlideoutVisible() {
        if (this.fToolTip == null || this.fToolTip.isDisposed()) {
            return false;
        }
        return this.fToolTip.isVisible();
    }

    public void showSlideout() {
        if (this.isSlideoutVisible()) {
            return;
        }
        if (this.fCurrentContent == null) {
            INavigatorContent navigatorContent;
            ISelection selection;
            this.fCurrentSelection = selection = this.fSelectionProvider.getSelection();
            this.fCurrentContent = navigatorContent = this.convertSelectionToNavigatorContent(selection);
        }
        if (this.fCurrentContent != null) {
            this.internalShowSlideout();
        }
    }

    public void closeSlideout() {
        if (this.isSlideoutVisible()) {
            this.close();
        }
    }

    public static interface ISlideoutHoverSite
    extends IHoverSite {
        public void parentFocusRequested(boolean var1);

        public void slideoutResized();
    }
}

