/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.tooltip;

import com.ibm.team.jface.tooltip.INavigatorContent;
import java.util.List;

public class NavigatorContentAdapter
implements INavigatorContent {
    private Object[] fArray;
    private int fPos;
    private final int fUnread;

    public NavigatorContentAdapter(List list) {
        this.fArray = list.toArray();
        this.fPos = 0;
        this.fUnread = 0;
    }

    public NavigatorContentAdapter(List list, Object current) {
        this(list, current, 0);
    }

    public NavigatorContentAdapter(List list, Object current, int unread) {
        this.fArray = list.toArray();
        int indexOf = list.indexOf(current);
        if (indexOf >= 0) {
            this.fPos = indexOf;
        }
        this.fUnread = unread;
    }

    public int getUnreadCount() {
        return this.fUnread;
    }

    @Override
    public Object current() {
        if (this.fPos >= 0 && this.fPos < this.fArray.length) {
            return this.fArray[this.fPos];
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.fPos;
    }

    @Override
    public boolean hasNext() {
        return this.fPos < this.fArray.length - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.fPos > 0 && this.fPos < this.fArray.length;
    }

    @Override
    public Object next() {
        return this.hasNext() ? this.fArray[++this.fPos] : null;
    }

    @Override
    public Object previous() {
        return this.hasPrevious() ? this.fArray[--this.fPos] : null;
    }

    @Override
    public void setPosition(int position) {
        this.fPos = position;
    }

    @Override
    public int size() {
        return this.fArray.length;
    }
}

