/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.tooltip;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.tooltip.FocusTooltip;
import com.ibm.team.jface.internal.tooltip.HoverTooltip;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import com.ibm.team.jface.internal.tooltip.NavigatorFocusTooltip;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.internal.tooltip.TooltipUtils;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.INavigatorContent;
import com.ibm.team.jface.tooltip.Messages;
import com.ibm.team.jface.util.UIUpdaterJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class EditorTooltipSupport
implements IInformationControl {
    private IHoverSite fHoverSite = new IHoverSite(){

        @Override
        public void closeRequested() {
            if (EditorTooltipSupport.this.fUpdaterJob != null) {
                EditorTooltipSupport.this.fUpdaterJob.cancel();
                EditorTooltipSupport.this.fUpdaterJob = null;
            }
        }

        @Override
        public void focusRequested() {
            EditorTooltipSupport.this.focusRequested();
        }

        @Override
        public void navigatedToNext(Tooltip tooltip) {
            EditorTooltipSupport.this.navigatedToNext(tooltip);
        }

        @Override
        public void navigatedToPrevious(Tooltip tooltip) {
            EditorTooltipSupport.this.navigatedToPrevious(tooltip);
        }

        @Override
        public void openRequested() {
            EditorTooltipSupport.this.openRequested();
        }
    };
    private Object fElement;
    private ContextProvider fContextProvider;
    private boolean fIsFocusable;
    private boolean fIsOpenable;
    private Point fLocation;
    private Shell fShell;
    private Tooltip fTooltip;
    private UIUpdaterJob fUpdaterJob;

    public EditorTooltipSupport(Shell parent, boolean isFocusable, boolean isOpenable) {
        this(parent, (ContextProvider)new StandardContextProvider(null), isFocusable, isOpenable);
    }

    public EditorTooltipSupport(Shell parent, ContextProvider contextProvider, boolean isFocusable, boolean isOpenable) {
        this.fShell = parent;
        this.fContextProvider = contextProvider;
        this.fIsFocusable = isFocusable;
        this.fIsOpenable = isOpenable;
        if (this.fContextProvider instanceof StandardContextProvider) {
            ((StandardContextProvider)this.fContextProvider).setUIContext((Object)this.fShell);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            this.fTooltip.getShell().addDisposeListener(listener);
        }
    }

    public void addFocusListener(FocusListener listener) {
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            this.fTooltip.getShell().addFocusListener(listener);
        }
    }

    public Point computeSizeHint() {
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            return this.fTooltip.getShell().computeSize(-1, -1);
        }
        return new Point(0, 0);
    }

    public void dispose() {
        if (this.fTooltip != null) {
            this.fTooltip.close();
        }
    }

    public void focusRequested() {
        Tooltip tooltip = this.showFocusToolTip(this.fElement);
        if (tooltip != null) {
            this.fLocation.y -= 16;
            tooltip.open(this.fLocation);
        }
    }

    protected String getMarkup(Object element, boolean isFocus) {
        IDomainAdapter adapter;
        if (element != null && (adapter = DomainAdapterUtils.getDomainAdapter(element)) != null) {
            IDomainAdapter.Info info = new IDomainAdapter.Info();
            info.isHoverTooltip = !isFocus;
            info.isFocusTooltip = isFocus;
            return DomainAdapterUtils.generateContentAsHTML(adapter, element, info);
        }
        return null;
    }

    protected URIReference getContext(Object element) {
        return Hyperlinks.create((Object)element, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isFocusControl() {
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            return this.fTooltip.getShell().isFocusControl();
        }
        return false;
    }

    private void navigatedToNext(Tooltip navTooltip) {
        if (this.fElement instanceof INavigatorContent && navTooltip instanceof NavigatorFocusTooltip) {
            INavigatorContent content = (INavigatorContent)this.fElement;
            Object next = content.next();
            navTooltip.setText(this.getMarkup(next, true));
            navTooltip.setContext(this.getContext(next));
            NavigatorFocusTooltip nt = (NavigatorFocusTooltip)navTooltip;
            nt.setNextEnabled(content.hasNext());
            nt.setPrevEnabled(content.hasPrevious());
            nt.setTitle(NLS.bind((String)Messages.EditorTooltipSupport_SHOWING_N_OF_M, (Object)(content.getPosition() + 1), (Object)content.size()));
        }
    }

    private void navigatedToPrevious(Tooltip navTooltip) {
        if (this.fElement instanceof INavigatorContent && navTooltip instanceof NavigatorFocusTooltip) {
            INavigatorContent content = (INavigatorContent)this.fElement;
            Object previous = content.previous();
            navTooltip.setText(this.getMarkup(previous, true));
            navTooltip.setContext(this.getContext(previous));
            NavigatorFocusTooltip nt = (NavigatorFocusTooltip)navTooltip;
            nt.setNextEnabled(content.hasNext());
            nt.setPrevEnabled(content.hasPrevious());
            nt.setTitle(NLS.bind((String)Messages.EditorTooltipSupport_SHOWING_N_OF_M, (Object)(content.getPosition() + 1), (Object)content.size()));
        }
    }

    public void openRequested() {
        this.openRequested(this.fElement);
    }

    protected void openRequested(Object element) {
    }

    public void removeDisposeListener(DisposeListener listener) {
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            this.fTooltip.getShell().removeDisposeListener(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            this.fTooltip.getShell().removeFocusListener(listener);
        }
    }

    public void setBackgroundColor(Color background) {
    }

    public void setFocus() {
        if (this.fTooltip != null) {
            this.fTooltip.getShell().forceFocus();
        }
    }

    public void setForegroundColor(Color foreground) {
    }

    public void setInformation(String information) {
        try {
            this.fElement = information;
            if (this.fElement != null) {
                this.fTooltip = this.showHoverToolTip(this.fElement);
            }
        }
        catch (Exception e) {
            JFacePlugin.log(e);
        }
    }

    public void setElement(String element) {
        this.fElement = element;
    }

    protected Object doResolve(String information, IProgressMonitor monitor) {
        return information;
    }

    public void setInput(Object input) {
        this.fElement = input;
        if (this.fElement != null) {
            this.fTooltip = this.showHoverToolTip(this.fElement);
        }
    }

    public void setLocation(Point location) {
        this.fLocation = location;
        if (this.fTooltip != null && this.fTooltip.getShell() != null) {
            Rectangle trim = this.fTooltip.getShell().computeTrim(0, 0, 0, 0);
            location.x += trim.x;
            location.y += trim.y;
            this.fTooltip.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (this.fTooltip != null) {
            if (visible) {
                Shell tooltipShell = this.fTooltip.getShell();
                if (tooltipShell != null && !tooltipShell.isDisposed()) {
                    Point location = tooltipShell.getLocation();
                    Point cursorLocation = tooltipShell.getDisplay().getCursorLocation();
                    if (location.y <= cursorLocation.y) {
                        location.y = cursorLocation.y;
                        this.fTooltip.open(location);
                    } else {
                        this.fTooltip.open(null);
                    }
                } else {
                    this.fTooltip.open(null);
                }
                if (this.fTooltip.getShell() != null && !this.fTooltip.getShell().isDisposed()) {
                    this.fLocation = this.fTooltip.getShell().getLocation();
                }
            } else {
                this.fTooltip.close();
            }
        }
    }

    protected Tooltip showFocusToolTip(Object element) {
        FocusTooltip focusToolTip;
        if (element instanceof INavigatorContent) {
            element = ((INavigatorContent)element).current();
        }
        if ((focusToolTip = element instanceof INavigatorContent ? NavigatorFocusTooltip.createTooltip(this.fShell, this.fHoverSite, this.fIsOpenable, FocusTooltip.PREFERRED_SIZE) : FocusTooltip.createTooltip(this.fShell, this.fHoverSite, this.fIsOpenable, FocusTooltip.PREFERRED_SIZE)) instanceof NavigatorFocusTooltip) {
            NavigatorFocusTooltip navTooltip = (NavigatorFocusTooltip)focusToolTip;
            INavigatorContent content = (INavigatorContent)element;
            navTooltip.setNextEnabled(content.hasNext());
            navTooltip.setPrevEnabled(content.hasPrevious());
            navTooltip.setTitle(NLS.bind((String)Messages.EditorTooltipSupport_SHOWING_N_OF_M, (Object)(content.getPosition() + 1), (Object)content.size()));
        }
        if (this.getMarkupInJob(focusToolTip, element, true)) {
            return focusToolTip;
        }
        return null;
    }

    protected final Tooltip showHoverToolTip(Object element) {
        if (Tooltip.isBlocked()) {
            return null;
        }
        if (element instanceof INavigatorContent) {
            element = ((INavigatorContent)element).current();
        }
        if (element != null) {
            IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter(element);
            HoverTooltip hoverTooltip = HoverTooltip.createTooltip(this.fShell, this.fHoverSite, this.fIsFocusable, true, Tooltip.PREFERRED_SIZE);
            if (this.getMarkupInJob(hoverTooltip, element, false)) {
                return hoverTooltip;
            }
        }
        return null;
    }

    protected boolean getMarkupInJob(final Tooltip tooltip, final Object element, final boolean isFocus) {
        IDomainAdapter adapter;
        if (element == null) {
            return false;
        }
        if (!(element instanceof String) && (adapter = DomainAdapterUtils.getDomainAdapter(element)) == null) {
            return false;
        }
        tooltip.setText(Messages.EditorTooltipSupport_CREATING_CONTENT);
        tooltip.setContext(null);
        if (this.fUpdaterJob != null) {
            this.fUpdaterJob.cancel();
        }
        this.fUpdaterJob = new UIUpdaterJob(Messages.EditorTooltipSupport_CREATING_MARKUP){
            String fMarkup;
            URIReference fContext;
            Object fFinalelem;
            {
                super($anonymous0);
                this.fFinalelem = object;
            }

            @Override
            public IStatus runInBackground(IProgressMonitor monitor) {
                if (element instanceof String) {
                    this.fFinalelem = EditorTooltipSupport.this.doResolve((String)element, monitor);
                    if (this.fFinalelem != null) {
                        try {
                            this.fMarkup = EditorTooltipSupport.this.getMarkup(this.fFinalelem, isFocus);
                        }
                        catch (Exception e) {
                            JFacePlugin.log(e);
                        }
                        TooltipUtils.updateTooltipTitle(this.fFinalelem, tooltip);
                    } else {
                        this.fMarkup = (String)element;
                    }
                }
                this.fContext = EditorTooltipSupport.this.getContext(this.fFinalelem);
                return super.runInBackground(monitor);
            }

            @Override
            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fMarkup == null) {
                    tooltip.setText(Messages.EditorTooltipSupport_COULD_NOT_CREATE_CONTENT);
                    tooltip.setContext(null);
                } else {
                    IDomainAdapter adapter;
                    if (this.fFinalelem != null && (adapter = DomainAdapterUtils.getDomainAdapter(this.fFinalelem)) != null) {
                        adapter.markAsRead(this.fFinalelem, 2000);
                    }
                    tooltip.setText(this.fMarkup);
                    tooltip.setContext(this.fContext);
                }
                return super.runInUI(monitor);
            }
        };
        this.fUpdaterJob.schedule();
        return true;
    }

    protected ContextProvider getContextProvider() {
        return this.fContextProvider;
    }
}

