/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.ITimelineLabelProvider;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.Scale;
import com.ibm.team.jface.timeline.Timeline;
import com.ibm.team.jface.timeline.TimelineSelectionEvent;
import com.ibm.team.jface.timeline.TimelineSelectionListener;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TimelineViewer
extends ContentViewer {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long YEAR = 31536000000L;
    private static final float DEFAULT_ZOOM_OUT_FACTOR = 0.625f;
    private static final float DEFAULT_ZOOM_IN_FACTOR = 1.6f;
    private static final long DEFAULT_MIN_ZOOM = 86400000L;
    private static final long DEFAULT_MAX_ZOOM = 315360000000L;
    private Timeline fTimeline;
    private Range fVisibleRange;
    private long fMinZoom;
    private long fMaxZoom;

    public TimelineViewer(Composite parent, int style) {
        this.fTimeline = new Timeline(parent, style);
        this.fMinZoom = 86400000L;
        this.fMaxZoom = 315360000000L;
        this.hookControl((Control)this.fTimeline);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        ((Timeline)control).addTimelineSelectionListener(new TimelineSelectionListener(){

            @Override
            public void selectedRangeChanged(TimelineSelectionEvent event) {
                TimelineViewer.this.handleSelect(event);
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000003) {
                    TimelineViewer.this.scrollLeft(1);
                } else if (e.keyCode == 0x1000004) {
                    TimelineViewer.this.scrollRight(1);
                } else if (e.keyCode == 0x1000001) {
                    TimelineViewer.this.zoomIn();
                } else if (e.keyCode == 0x1000002) {
                    TimelineViewer.this.zoomOut();
                }
            }
        });
    }

    protected void handleSelect(TimelineSelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateSelection(this.getSelection());
        }
    }

    protected void updateSelection(ISelection selection) {
        SelectionChangedEvent selChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        this.fireSelectionChanged(selChangedEvent);
    }

    public void refresh() {
        if (this.getContentProvider() == null || !(this.getContentProvider() instanceof ITimelineContentProvider)) {
            return;
        }
        ITimelineContentProvider contentProvider = (ITimelineContentProvider)this.getContentProvider();
        Scale primaryScale = contentProvider.getScale(this.fVisibleRange, true);
        Scale secondaryScale = contentProvider.getScale(this.fVisibleRange, false);
        if (this.getLabelProvider() != null && this.getLabelProvider() instanceof ITimelineLabelProvider) {
            Range r;
            ITimelineLabelProvider labelProvider = (ITimelineLabelProvider)this.getLabelProvider();
            int i = 0;
            while (i < primaryScale.getTickCount()) {
                r = primaryScale.getRange(i);
                primaryScale.setText(labelProvider.getScaleText(r, true), i);
                primaryScale.setTextAlign(labelProvider.getTextAlign(r, true), i);
                primaryScale.setFont(labelProvider.getFont(r, true), i);
                primaryScale.setBarBackground(labelProvider.getBarBackground(r), i);
                primaryScale.setBarForeground(labelProvider.getBarForeground(r), i);
                primaryScale.setBarBorder(labelProvider.getBarBorder(r), i);
                ++i;
            }
            if (secondaryScale != null) {
                i = 0;
                while (i < secondaryScale.getTickCount()) {
                    r = secondaryScale.getRange(i);
                    secondaryScale.setText(labelProvider.getScaleText(r, false), i);
                    secondaryScale.setTextAlign(labelProvider.getTextAlign(r, false), i);
                    secondaryScale.setFont(labelProvider.getFont(r, false), i);
                    ++i;
                }
            }
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        int tickCount = primaryScale.getTickCount();
        int i = 0;
        while (i < tickCount - 1 && !this.fTimeline.isDisposed()) {
            Range tickRange = primaryScale.getRange(i);
            if (this.fVisibleRange.overlaps(tickRange)) {
                values.add(new Integer(contentProvider.getElementCount(this.getInput(), tickRange)));
            }
            ++i;
        }
        int[] intArray = new int[values.size()];
        int i2 = 0;
        while (i2 < values.size()) {
            intArray[i2] = (Integer)values.get(i2);
            ++i2;
        }
        this.fTimeline.setValues(this.fVisibleRange, primaryScale, secondaryScale, intArray);
    }

    public Control getControl() {
        return this.fTimeline;
    }

    public void setVisibleRange(Range range) {
        this.fVisibleRange = range;
        this.refresh();
    }

    public Range getVisibleRange() {
        return this.fVisibleRange;
    }

    public void setMinimum(long range) {
        this.fMinZoom = range;
    }

    public void setMaximum(long range) {
        this.fMaxZoom = range;
    }

    public boolean zoomIn() {
        return this.zoomIn(1.6f);
    }

    public boolean zoomIn(float ratio) {
        return this.zoom(ratio);
    }

    public boolean zoomOut() {
        return this.zoomOut(0.625f);
    }

    public boolean zoomOut(float ratio) {
        return this.zoom(ratio);
    }

    private boolean zoom(float ratio) {
        if (this.fVisibleRange.getDif() <= this.fMinZoom && ratio > 1.0f) {
            return false;
        }
        if (this.fVisibleRange.getDif() >= this.fMaxZoom && ratio < 1.0f) {
            return false;
        }
        Range selectorRange = this.fTimeline.getSelection();
        this.fVisibleRange.multiply(selectorRange.getCenter(), ratio);
        if (selectorRange.getDif() > this.fVisibleRange.getDif()) {
            selectorRange = new Range(this.fVisibleRange);
        }
        this.refresh();
        this.fTimeline.setSelection(selectorRange);
        return true;
    }

    public void scrollLeft(int ticks) {
        this.scroll(true, ticks);
    }

    public void scrollRight(int ticks) {
        this.scroll(false, ticks);
    }

    private void scroll(boolean left, int ticks) {
        if (this.getContentProvider() == null || !(this.getContentProvider() instanceof ITimelineContentProvider)) {
            return;
        }
        ITimelineContentProvider contentProvider = (ITimelineContentProvider)this.getContentProvider();
        Scale primaryScale = contentProvider.getScale(this.fVisibleRange, true);
        long range = 0L;
        if (primaryScale.getTickCount() > ticks) {
            range = primaryScale.getTick(ticks) - primaryScale.getTick(0);
        }
        if (left) {
            this.fVisibleRange.shift(-range);
        } else {
            this.fVisibleRange.shift(range);
        }
        this.refresh();
        Range newSelection = new Range(this.fTimeline.getSelection());
        if (left) {
            newSelection.shift(-range);
        } else {
            newSelection.shift(range);
        }
        this.fTimeline.setSelection(newSelection);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        super.setContentProvider(contentProvider);
        if (contentProvider instanceof ITimelineContentProvider) {
            this.fVisibleRange = ((ITimelineContentProvider)contentProvider).getDefaultRange();
        }
    }

    public ISelection getSelection() {
        Range selection = this.fTimeline.getSelection();
        if (selection == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.fTimeline.getSelection());
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Object element;
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof Range) {
            this.fTimeline.setSelection((Range)element);
        }
    }
}

