/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.timeline.ITimelineLabelProvider;
import com.ibm.team.jface.timeline.Messages;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.TimelineColors;
import java.util.Date;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class TimelineLabelProvider
implements ITimelineLabelProvider {
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    protected static final long DST = 3600000L;
    protected static final long DAY = 86400000L;
    protected static final long WEEK = 604800000L;
    protected static final long MONTH = 2678400000L;
    protected DateFormat fMonthDayFormat = DateFormat.getDateInstance((int)2);
    protected DateFormat fMonthFormat = new SimpleDateFormat("MMM");
    protected DateFormat fLongMonthFormat = new SimpleDateFormat("MMMM");
    protected DateFormat fDayFormat = new SimpleDateFormat("EEE");
    private Calendar fCal = Calendar.getInstance();
    private FontDescriptor fFont;
    protected LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private TimelineColors fColors = TimelineColors.createInstance((ResourceManager)this.fResources);

    public TimelineLabelProvider() {
        FontData defaultFontData = Display.getDefault().getSystemFont().getFontData()[0];
        this.fFont = FontDescriptor.createFrom((String)defaultFontData.getName(), (int)(defaultFontData.getHeight() - 1), (int)defaultFontData.getStyle());
    }

    @Override
    public String getScaleText(Range range, boolean primary) {
        if (range.getDif() > 0L && range.getDif() <= 90000000L) {
            if (primary) {
                return this.fDayFormat.format(new Date(range.getStart()));
            }
            return this.fMonthDayFormat.format(new Date(range.getStart()));
        }
        if (range.getDif() <= 608400000L) {
            this.fCal.setTimeInMillis(range.getStart());
            if (primary) {
                return NLS.bind((String)Messages.TimelineLabelProvider_WEEK_N, (Object)this.fCal.get(3));
            }
            return NLS.bind((String)Messages.TimelineLabelProvider_MONTH_WEEK_N, (Object)this.fMonthDayFormat.format(new Date(range.getStart())), (Object)this.fCal.get(3));
        }
        if (range.getDif() <= 2682000000L) {
            if (primary) {
                return this.fMonthFormat.format(new Date(range.getStart()));
            }
            return this.fLongMonthFormat.format(new Date(range.getStart()));
        }
        if (range.getDif() > 2678400000L) {
            this.fCal.setTimeInMillis(range.getStart());
            return String.valueOf(this.fCal.get(1));
        }
        return "";
    }

    @Override
    public Color getBarBackground(Range range) {
        long from = range.getStart();
        long to = range.getEnd();
        if (to - from <= 90000000L) {
            long d = range.getCenter();
            this.fCal.setTimeInMillis(d);
            int day = this.fCal.get(7);
            if (day == 7 || day == 1) {
                return this.fColors.getColor(TimelineColors.WEEKEND_BG);
            }
        }
        return null;
    }

    @Override
    public Color getBarForeground(Range range) {
        return null;
    }

    @Override
    public Color getBarBorder(Range range) {
        return null;
    }

    @Override
    public Font getFont(Range range, boolean primary) {
        return JazzResources.getFont((ResourceManager)this.fResources, this.fFont, JFaceResources.getDefaultFont());
    }

    @Override
    public int getTextAlign(Range range, boolean primary) {
        if (range.getDif() > 608400000L && range.getDif() <= 2682000000L && !primary) {
            return 2;
        }
        return primary ? 2 : 0;
    }

    @Override
    public void dispose() {
        this.fResources.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

