/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TimelineColors {
    public static String WEEKEND_BG = "WEEKEND_BG";
    public static String BORDER = "BORDER";
    public static String SCALE_TEXT_FG = "SCALE_TEXT_FG";
    public static String SEPARATOR = "SEPARATOR";
    public static String SELECTOR_OUTER_INNER_BORDER = "SELECTOR_OUTER_INNER_BORDER";
    public static String SELECTOR_MIDDLE_BORDER = "SELECTOR_MIDDLE_BORDER";
    public static String BAR_BORDER = "BAR_BORDER";
    public static String BAR_GRADIENT_BEGIN = "BAR_GRADIENT_BEGIN";
    public static String BAR_GRADIENT_END = "BAR_GRADIENT_END";
    public static String TODAY_INDICATOR = "TODAY_INDICATOR";
    private ResourceManager fResourceManager;
    private Map<String, ColorDescriptor> fColors;

    private TimelineColors(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
        this.fColors = new HashMap<String, ColorDescriptor>();
        this.init();
    }

    public static TimelineColors createInstance(ResourceManager resourceManager) {
        return new TimelineColors(resourceManager);
    }

    public Color getColor(String key) {
        return JazzResources.getColor(this.fResourceManager, this.fColors.get(key));
    }

    private void init() {
        boolean useReducedColors = "org.eclipse.ui.ide.systemDefault".equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
        if (useReducedColors) {
            this.initReducedColors();
            return;
        }
        RGB listSelection = Display.getDefault().getSystemColor(26).getRGB();
        RGB widgetBackground = Display.getDefault().getSystemColor(22).getRGB();
        RGB titleBackground = Display.getDefault().getSystemColor(31).getRGB();
        RGB black = new RGB(0, 0, 0);
        RGB rgb = ColorUtils.addColor(widgetBackground, 30.0f);
        this.fColors.put(WEEKEND_BG, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(black, 60.0f);
        this.fColors.put(BORDER, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(black, 15.0f);
        this.fColors.put(SCALE_TEXT_FG, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(black, 80.0f);
        this.fColors.put(SEPARATOR, ColorDescriptor.createFrom((RGB)rgb));
        this.fColors.put(SELECTOR_OUTER_INNER_BORDER, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(listSelection, 80.0f);
        this.fColors.put(SELECTOR_MIDDLE_BORDER, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(titleBackground, 40.0f);
        this.fColors.put(BAR_BORDER, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(titleBackground, 80.0f);
        this.fColors.put(BAR_GRADIENT_BEGIN, ColorDescriptor.createFrom((RGB)rgb));
        rgb = ColorUtils.addColor(titleBackground, 95.0f);
        this.fColors.put(BAR_GRADIENT_END, ColorDescriptor.createFrom((RGB)rgb));
        this.fColors.put(TODAY_INDICATOR, ColorDescriptor.createFrom((Color)Display.getDefault().getSystemColor(6)));
    }

    private void initReducedColors() {
        RGB listSelection = Display.getDefault().getSystemColor(26).getRGB();
        RGB listForeground = Display.getDefault().getSystemColor(24).getRGB();
        RGB listBackground = Display.getDefault().getSystemColor(25).getRGB();
        this.fColors.put(WEEKEND_BG, ColorDescriptor.createFrom((RGB)listSelection));
        this.fColors.put(BORDER, ColorDescriptor.createFrom((RGB)listForeground));
        this.fColors.put(SCALE_TEXT_FG, ColorDescriptor.createFrom((RGB)listForeground));
        this.fColors.put(SEPARATOR, ColorDescriptor.createFrom((RGB)listForeground));
        this.fColors.put(SELECTOR_OUTER_INNER_BORDER, ColorDescriptor.createFrom((RGB)listForeground));
        this.fColors.put(SELECTOR_MIDDLE_BORDER, ColorDescriptor.createFrom((RGB)listForeground));
        this.fColors.put(BAR_BORDER, ColorDescriptor.createFrom((RGB)listSelection));
        this.fColors.put(BAR_GRADIENT_BEGIN, ColorDescriptor.createFrom((RGB)listSelection));
        this.fColors.put(BAR_GRADIENT_END, ColorDescriptor.createFrom((RGB)listBackground));
        this.fColors.put(TODAY_INDICATOR, ColorDescriptor.createFrom((RGB)listForeground));
    }
}

