/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.preview;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class HTMLGenerator {
    private IDomainAdapter.Info fInfo;

    public static void getHeadDefinitions(StringBuffer buffer, HashMap definitions) {
        for (String definition : definitions.values()) {
            buffer.append(definition);
        }
    }

    protected void generateHead(HashMap headDefinitions) {
    }

    public void generate(HashMap headDefinitions, StringBuffer buffer, IDomainAdapter.Info info) {
        this.generate(headDefinitions, buffer, info, null);
    }

    public void generate(HashMap headDefinitions, StringBuffer buffer, IDomainAdapter.Info info, IProgressMonitor monitor) {
        this.fInfo = info;
        Composite composite = new Composite(null);
        this.createControl(composite, monitor);
        composite.appendTo(buffer);
        this.generateHead(headDefinitions);
    }

    public String generate(IDomainAdapter.Info info) {
        return this.generate(info, null);
    }

    public String generate(IDomainAdapter.Info info, IProgressMonitor monitor) {
        StringBuffer strBuf = new StringBuffer();
        this.fInfo = info;
        Document document = new Document();
        this.createControl(document, monitor);
        document.appendTo(strBuf);
        return strBuf.toString();
    }

    protected abstract void createControl(Composite var1);

    protected void createControl(Composite composite, IProgressMonitor monitor) {
        this.createControl(composite);
    }

    public IDomainAdapter.Info getInfo() {
        return this.fInfo;
    }

    protected class BulletList
    extends Composite {
        public BulletList(Composite parent) {
            super(parent);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            buffer.append("\n<ul style='padding-left:5px;margin-left:20px; margin-top:5px'>");
            super.appendTo(buffer);
            buffer.append("</ul>");
        }

        @Override
        protected void appendTo(StringBuffer buffer, Control component) {
            buffer.append("<li>");
            super.appendTo(buffer, component);
            buffer.append("</li>");
        }
    }

    protected class Composite
    extends Control {
        private List<Control> fComponents;

        public Composite(Composite parent) {
            super(parent);
            this.fComponents = new ArrayList<Control>();
        }

        public Control[] getComponents() {
            return this.fComponents.toArray(new Control[this.fComponents.size()]);
        }

        public void addComponent(Control control) {
            this.fComponents.add(control);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            Control[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                this.appendTo(buffer, components[i]);
                ++i;
            }
        }

        protected void appendTo(StringBuffer buffer, Control component) {
            component.appendTo(buffer);
        }
    }

    protected class Container
    extends Composite {
        public Container(Composite parent) {
            super(parent);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            if (this.getCSSClass() == null) {
                buffer.append("<div>");
            } else {
                buffer.append("<div class=\"").append(this.getCSSClass()).append("\">");
            }
            super.appendTo(buffer);
            buffer.append("</div>");
        }
    }

    protected abstract class Control {
        private Composite fParent;
        private String fClass;

        public Control(Composite parent) {
            this.fParent = parent;
            if (parent != null) {
                parent.addComponent(this);
            }
        }

        public Composite getParent() {
            return this.fParent;
        }

        public void setParent(Composite parent) {
            this.fParent = parent;
        }

        public abstract void appendTo(StringBuffer var1);

        public void setCSSClass(String clazz) {
            this.fClass = clazz;
        }

        public String getCSSClass() {
            return this.fClass;
        }
    }

    protected class Document
    extends Composite {
        public Document() {
            super(null);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            buffer.append("<html><head>");
            HashMap definitions = new HashMap();
            HTMLGenerator.this.generateHead(definitions);
            HTMLGenerator.getHeadDefinitions(buffer, definitions);
            buffer.append("</head><body>");
            super.appendTo(buffer);
        }
    }

    protected class Header
    extends Composite {
        private int fHeader;

        public Header(Composite parent, int header) {
            super(parent);
            this.fHeader = header;
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            buffer.append("<h");
            buffer.append(this.fHeader);
            buffer.append(">");
            super.appendTo(buffer);
            buffer.append("</h");
            buffer.append(this.fHeader);
            buffer.append(">");
        }
    }

    protected class Label
    extends Control {
        private XMLString fText;
        private String fFont;
        private String fImgUrl;
        private int fHeight;

        public Label(Composite parent, String text) {
            this(parent, XMLString.createFromXMLText((String)text));
        }

        public void setImage(String imgUrl) {
            this.fImgUrl = imgUrl;
        }

        public void setImageHeight(int height) {
            this.fHeight = height;
        }

        public Label(String text) {
            this(null, text);
        }

        public Label(Composite parent, XMLString text) {
            super(parent);
            this.fText = text;
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            String img = "";
            if (this.fImgUrl != null) {
                img = "<img src=\"" + this.fImgUrl + "\"";
                if (this.fHeight > 0) {
                    img = String.valueOf(img) + " height=" + this.fHeight;
                }
                img = String.valueOf(img) + ">&nbsp;";
            }
            if (this.getCSSClass() == null && this.fFont == null) {
                buffer.append(img).append(this.fText.getXMLText());
            } else {
                buffer.append("<span ");
                if (this.getCSSClass() != null) {
                    buffer.append("class=\"").append(this.getCSSClass()).append("\" ");
                }
                if (this.fFont != null) {
                    buffer.append("style=\"").append(this.fFont).append("\"");
                }
                buffer.append(">").append(img).append(this.fText.getXMLText()).append("</span>");
            }
        }

        public void setFont(String fontName, int height, boolean italic, boolean bold) {
            StringBuffer fontBuf = new StringBuffer();
            if (fontName != null) {
                fontBuf.append("font-family: ").append(fontName).append("; ");
            }
            if (height != -1) {
                fontBuf.append("font-size: ").append(height).append("pt;");
            }
            if (bold) {
                fontBuf.append("font-weight: bold; ");
            }
            if (italic) {
                fontBuf.append("font-style: italic; ");
            }
            this.fFont = fontBuf.toString();
        }
    }

    protected class LineBreak
    extends Control {
        public LineBreak(Composite parent) {
            super(parent);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            buffer.append("<br/>");
        }
    }

    protected class Link
    extends Composite {
        private String fHref;

        public Link(Composite parent, String href) {
            super(parent);
            this.fHref = href;
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            if (this.getCSSClass() == null) {
                buffer.append("<a href=\"" + this.fHref + "\">");
            } else {
                buffer.append("<a href=\"" + this.fHref + "\"").append(" class=\"").append(this.getCSSClass()).append("\">");
            }
            super.appendTo(buffer);
            buffer.append("</a>");
        }
    }

    protected class Markup
    extends Control {
        private final String fMarkup;

        public Markup(Composite parent, String markup) {
            super(parent);
            this.fMarkup = markup;
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            buffer.append(this.fMarkup);
        }
    }

    protected class Paragraph
    extends Composite {
        public Paragraph(Composite parent) {
            super(parent);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            if (this.getCSSClass() == null) {
                buffer.append("\n<p>");
            } else {
                buffer.append("\n<p class=\"").append(this.getCSSClass()).append("\">");
            }
            super.appendTo(buffer);
            buffer.append("</p>\n");
        }
    }

    protected class Section
    extends Composite {
        private Control fTitle;

        public Section(Composite parent, Control title) {
            super(parent);
            this.fTitle = title;
            title.setParent(this);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            if (this.getCSSClass() == null) {
                buffer.append("<div style=\"margin: 0 1em 1em 0;\">");
            } else {
                buffer.append("<div class=\"").append(this.getCSSClass()).append("\">");
            }
            buffer.append("<b>");
            this.fTitle.appendTo(buffer);
            buffer.append("</b>");
            buffer.append("<br/>");
            super.appendTo(buffer);
            buffer.append("</div>");
        }
    }

    protected class Table
    extends Composite {
        private int fColumns;
        private int fWidth;
        private String fCellPadding;
        private Map<Control, Integer> fSpans;

        public Table(Composite parent, int columns, int width, String cellPadding) {
            super(parent);
            this.fSpans = new HashMap<Control, Integer>();
            this.fColumns = columns;
            this.fWidth = width;
            this.fCellPadding = cellPadding;
        }

        public Table(Composite parent, int columns) {
            this(parent, columns, -1, null);
        }

        public void addComponent(Control control, int span) {
            super.addComponent(control);
            this.fSpans.put(control, new Integer(span));
        }

        @Override
        public void addComponent(Control control) {
            this.addComponent(control, 1);
        }

        @Override
        public void appendTo(StringBuffer buffer) {
            int column = 0;
            buffer.append("<table");
            if (this.getCSSClass() != null) {
                buffer.append(" class=\"");
                buffer.append(this.getCSSClass());
                buffer.append("\"");
            }
            if (this.fWidth > -1) {
                buffer.append(" width=\"");
                buffer.append(this.fWidth);
                buffer.append("%\"");
            }
            buffer.append(">");
            Control[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                Control control = components[i];
                int span = this.fSpans.get(control);
                if (column == 0) {
                    buffer.append("\n  <tr>");
                }
                buffer.append("\n    <td valign='top'");
                if (span > 1) {
                    buffer.append(" colspan=\"");
                    buffer.append(span);
                    buffer.append("\"");
                }
                buffer.append(">");
                if (column > 0 && this.fCellPadding != null) {
                    buffer.append("<span style=\"margin-left: ");
                    buffer.append(this.fCellPadding);
                    buffer.append("\">");
                }
                control.appendTo(buffer);
                if (column > 0 && this.fCellPadding != null) {
                    buffer.append("</span>");
                }
                buffer.append("</td>");
                if ((column += span) >= this.fColumns) {
                    buffer.append("\n  </tr>");
                    column = 0;
                }
                ++i;
            }
            buffer.append("\n</table>");
        }
    }
}

