/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.preview;

import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.preview.IInformationProvider;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class DomainAdapter
implements IDomainAdapter,
IInformationProvider {
    private static volatile int fTicket;

    @Override
    public final Object convertToDomainObject(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objects.length) {
                Object result;
                Object obj = objects[i];
                if (obj instanceof GenericAggregationBin) {
                    obj = ((GenericAggregationBin)obj).getMostRecent();
                }
                if ((result = this.convertToDomainObject(obj)) != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    protected abstract Object convertToDomainObject(Object var1);

    @Override
    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
    }

    @Override
    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info, IProgressMonitor monitor) {
        this.generateContentAsHTML(head, body, input, info);
    }

    @Override
    public String generateContentAsText(Object input) {
        return null;
    }

    @Override
    public String generateTitle(Object input) {
        return null;
    }

    public String generateTitle(Object input, IDomainAdapter.Info info) {
        return this.generateTitle(input);
    }

    @Override
    public IAction getGotoInputAction() {
        return null;
    }

    public void markAsRead(Object input) {
        final IReadStateTracker[] tracker = new IReadStateTracker[1];
        if (input instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)input;
            tracker[0] = (IReadStateTracker)adaptable.getAdapter(IReadStateTracker.class);
        } else {
            IAdapterManager manager = Platform.getAdapterManager();
            tracker[0] = (IReadStateTracker)manager.getAdapter(input, IReadStateTracker.class);
        }
        if (tracker[0] != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (tracker[0] != null) {
                        tracker[0].markRead();
                    }
                }
            });
        }
    }

    @Override
    public void markAsRead(Object input, int afterMilis) {
        ++fTicket;
        Display.getDefault().timerExec(afterMilis, (Runnable)new Marker(input));
    }

    @Override
    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return "TODO: implement DomainAdapter.generateJobInfo(...)";
    }

    public Point getPreferredSize(Object input, IDomainAdapter.Info info) {
        return new Point(-1, -1);
    }

    private class Marker
    implements Runnable {
        private final Object fInput;
        private final int fStartTicket;

        public Marker(Object input) {
            this.fInput = input;
            this.fStartTicket = fTicket;
        }

        @Override
        public void run() {
            if (fTicket == this.fStartTicket) {
                DomainAdapter.this.markAsRead(this.fInput);
            }
        }
    }
}

