/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.preview;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.BrowserLocationListener;
import com.ibm.team.jface.internal.HelpContextIds;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.preview.AbstractInfoView;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.preview.Messages;
import com.ibm.team.jface.tooltip.BrowserTooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BrowserInfoView
extends AbstractInfoView {
    private Browser fBrowser;
    private boolean fIsUsingBrowserWidget;
    private StyledText fText;
    private StandardContextProvider fContextProvider = new StandardContextProvider(null);

    public BrowserInfoView() {
        super(null);
    }

    @Override
    protected void doCreatePartControl(Composite parent) {
        try {
            this.fContextProvider.setUIContext((Object)parent.getShell());
            this.fBrowser = new Browser(parent, 0);
            this.fBrowser.addLocationListener((LocationListener)new BrowserLocationListener((ContextProvider)this.fContextProvider));
            this.fIsUsingBrowserWidget = true;
            new BrowserTooltipSupport(this.fBrowser, true, true);
        }
        catch (SWTError x) {
            this.handleBrowserError(x);
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    BrowserInfoView.this.setInput(BrowserInfoView.this.fText.getText());
                }
            });
        }
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.jface.preview_view");
    }

    protected void handleBrowserError(SWTError error) {
        JFacePlugin.getDefault().log(Messages.BrowserInfoView_ERROR_CREATE_BROWSER, error);
    }

    @Override
    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    @Override
    protected void doDispose() {
        this.fBrowser = null;
        this.fText = null;
    }

    @Override
    protected void handleInputChanged(Object oldInput, final Object newInput) {
        final IDomainAdapter.Info info = new IDomainAdapter.Info();
        info.rightToLeft = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
        UIUpdaterJob job = new UIUpdaterJob(Messages.BrowserInfoView_GENERATE_PREVIEW){
            private String fHtml;

            @Override
            public IStatus runInBackground(IProgressMonitor monitor) {
                URIReference reference = Hyperlinks.create((Object)newInput, (IProgressMonitor)new NullProgressMonitor());
                BrowserInfoView.this.fContextProvider.setContext(reference);
                IDomainAdapter domainAdapter = BrowserInfoView.this.getDomainAdapter();
                if (domainAdapter != null) {
                    this.fHtml = DomainAdapterUtils.generateContentAsHTML(domainAdapter, newInput, info);
                }
                return Status.OK_STATUS;
            }

            @Override
            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fHtml != null) {
                    if (BrowserInfoView.this.fIsUsingBrowserWidget) {
                        if (BrowserInfoView.this.fBrowser != null && !BrowserInfoView.this.fBrowser.isDisposed()) {
                            BrowserInfoView.this.fBrowser.setText(this.fHtml);
                        }
                    } else if (BrowserInfoView.this.fText != null && !BrowserInfoView.this.fText.isDisposed()) {
                        BrowserInfoView.this.fText.setText(this.fHtml);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                StyledText text = (StyledText)this.fControl;
                text.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.fireSelectionChanged();
                    }
                });
            }
        }

        protected void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                StyledText text = (StyledText)this.fControl;
                Document document = new Document(text.getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void setSelection(ISelection selection) {
        }
    }
}

