/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.preview;

import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractInfoView
extends ViewPart {
    private static final String GROUP_OPEN = "group.open";
    private static final String GROUP_EDIT = "group.edit";
    private final PartListener fPartListener = new PartListener();
    private final SelectionListener fSelectionListener = new SelectionListener();
    private volatile int fComputeCount;
    private IDomainAdapter fDomainAdapter;
    private Object fInput;

    protected abstract void doCreatePartControl(Composite var1);

    protected abstract Control getControl();

    protected abstract void doDispose();

    protected abstract void handleInputChanged(Object var1, Object var2);

    protected AbstractInfoView(IDomainAdapter adapter) {
        this.fDomainAdapter = adapter;
    }

    protected Object getInput() {
        return this.fInput;
    }

    protected IDomainAdapter getDomainAdapter() {
        return this.fDomainAdapter;
    }

    public final void createPartControl(Composite parent) {
        this.doCreatePartControl(parent);
        this.initializeColors();
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.fPartListener);
    }

    protected void initializeColors() {
        Display display = this.getDisplay();
        if (display != null) {
            this.setForeground(display.getSystemColor(28));
            this.setBackground(display.getSystemColor(29));
        }
    }

    protected void setForeground(Color color) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setForeground(color);
        }
    }

    protected void setBackground(Color color) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setBackground(color);
        }
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    protected Display getDisplay() {
        Shell shell = this.getSite().getShell();
        if (shell == null || shell.isDisposed()) {
            return null;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractInfoView.this.contextMenuAboutToShow(manager);
            }
        });
        this.getSite().registerContextMenu(menuManager, this.getViewSite().getSelectionProvider());
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_OPEN));
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup(GROUP_EDIT, action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup(GROUP_EDIT, action);
        }
        if (this.fDomainAdapter != null && (action = this.fDomainAdapter.getGotoInputAction()) != null) {
            menu.appendToGroup(GROUP_OPEN, action);
        }
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IAction action = null;
        if (this.fDomainAdapter != null && (action = this.fDomainAdapter.getGotoInputAction()) != null) {
            toolBar.add(action);
        }
        if ((action = this.getCopyToClipboardAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this.fSelectionListener);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this.fSelectionListener);
    }

    protected boolean isIgnoringEqualInput() {
        return true;
    }

    public final void dispose() {
        ++this.fComputeCount;
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.fPartListener);
        this.doDispose();
    }

    private void computeAndSetInput(IWorkbenchPart part) {
        final int currentCount = ++this.fComputeCount;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider == null) {
            return;
        }
        final ISelection selection = provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Thread thread = new Thread("Info view input computer"){

            @Override
            public void run() {
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                Object oldInput = AbstractInfoView.this.getInput();
                final Object newInput = AbstractInfoView.this.computeInput(selection);
                if (newInput == null || AbstractInfoView.this.isIgnoringEqualInput() && oldInput != null && oldInput.equals(newInput)) {
                    return;
                }
                Display display = AbstractInfoView.this.getDisplay();
                if (display != null) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractInfoView.this.fComputeCount != currentCount || AbstractInfoView.this.getViewSite().getShell().isDisposed()) {
                                return;
                            }
                            AbstractInfoView.this.setInput(newInput);
                        }
                    });
                }
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    protected Object computeInput(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objects.length) {
                IDomainAdapter domainAdapter;
                Object obj = objects[i];
                if (obj instanceof GenericAggregationBin) {
                    obj = ((GenericAggregationBin)obj).getMostRecent();
                }
                if ((domainAdapter = DomainAdapterUtils.getDomainAdapter(obj)) != null) {
                    this.fDomainAdapter = domainAdapter;
                    break;
                }
                ++i;
            }
        }
        if (this.fDomainAdapter != null) {
            return this.fDomainAdapter.convertToDomainObject(selection);
        }
        return null;
    }

    protected final void setInput(Object input) {
        Object oldInput = this.fInput;
        this.fInput = input;
        this.handleInputChanged(oldInput, this.fInput);
        if (this.fDomainAdapter != null) {
            String titleContent;
            IAction action = this.fDomainAdapter.getGotoInputAction();
            if (action != null) {
                action.setEnabled(input != null);
            }
            if ((titleContent = this.fDomainAdapter.generateTitle(this.getInput())) != null) {
                this.setContentDescription(titleContent);
            }
            this.setTitleToolTip(this.fDomainAdapter.generateTitle(this.getInput()));
        }
    }

    protected void createActions() {
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return null;
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = partRef.getPage().getActivePart();
                if (activePart != null && !activePart.equals((Object)AbstractInfoView.this)) {
                    AbstractInfoView.this.computeAndSetInput(activePart);
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            if (!partRef.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(partRef.getPart(false));
            }
        }
    }

    private class SelectionListener
    implements ISelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!part.equals((Object)AbstractInfoView.this)) {
                AbstractInfoView.this.computeAndSetInput(part);
            }
        }
    }
}

