/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.labelProviders;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.JFacePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class TypeLabelProvider
extends LabelProvider
implements IViewerLabelProvider,
IFontProvider,
IColorProvider {
    private List<ILabelProviderListener> fListenerList = new ArrayList<ILabelProviderListener>();
    private ResourceManager fResources;

    public abstract void updateLabel(ViewerLabel var1, Object var2);

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public final Image getImage(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        Image image = label.getImage();
        if (image != null) {
            return image;
        }
        return super.getImage(element);
    }

    public final String getText(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        String text = label.getText();
        if (text != null) {
            return text;
        }
        return super.getText(element);
    }

    protected final ResourceManager getResources() {
        this.checkState();
        if (this.fResources == null) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            this.fResources = new LocalResourceManager(JFaceResources.getResources((Display)display));
        }
        return this.fResources;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Assert.isNotNull((Object)descriptor);
        ResourceManager res = this.getResources();
        Object existingImage = res.find((DeviceResourceDescriptor)descriptor);
        if (existingImage instanceof Image) {
            return (Image)existingImage;
        }
        return JazzResources.getImageWithDefault(this.getResources(), descriptor);
    }

    protected final void disposeImage(ImageDescriptor descriptor) {
        Assert.isNotNull((Object)descriptor);
        this.getResources().destroyImage(descriptor);
    }

    protected final void fireLabelProviderChanged(LabelProviderChangedEvent event) {
        this.checkState();
        ILabelProviderListener[] listeners = this.fListenerList.toArray(new ILabelProviderListener[this.fListenerList.size()]);
        int i = 0;
        while (i < listeners.length) {
            ILabelProviderListener listener = listeners[i];
            try {
                try {
                    listener.labelProviderChanged(event);
                }
                catch (SWTException e) {
                    if (e.code == 24) {
                        return;
                    }
                    throw e;
                }
            }
            catch (RuntimeException e) {
                JFacePlugin.getDefault().log("Unhandled exception in label provider listener (the listener will be removed)", e);
                this.removeListener(listener);
            }
            ++i;
        }
    }

    private void checkState() {
        if (this.fListenerList == null) {
            throw new IllegalStateException("Label provider disposed");
        }
    }

    public final void addListener(ILabelProviderListener listener) {
        this.checkState();
        if (this.fListenerList.isEmpty()) {
            this.firstListenerAdded();
        }
        this.fListenerList.add(listener);
    }

    public final void removeListener(ILabelProviderListener listener) {
        if (this.isDisposed()) {
            return;
        }
        if (this.fListenerList.isEmpty()) {
            return;
        }
        this.fListenerList.remove(listener);
        if (this.fListenerList.isEmpty()) {
            this.lastListenerRemoved();
        }
    }

    public void dispose() {
        if (this.fListenerList == null) {
            return;
        }
        if (!this.fListenerList.isEmpty()) {
            this.lastListenerRemoved();
        }
        this.fListenerList.clear();
        if (this.fResources != null) {
            this.fResources.dispose();
            this.fResources = null;
        }
    }

    protected boolean isDisposed() {
        return this.fListenerList == null;
    }

    public Color getBackground(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        return label.getBackground();
    }

    public Color getForeground(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        return label.getForeground();
    }

    public Font getFont(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        return label.getFont();
    }
}

