/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NotifyingFilterSet
extends HashSet {
    private static final long serialVersionUID = "FilterSet".hashCode();
    Set<IFilterSelectionChangedListener> fListeners = new HashSet<IFilterSelectionChangedListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterSelectionChangedListener(IFilterSelectionChangedListener listener) {
        Set<IFilterSelectionChangedListener> set = this.fListeners;
        synchronized (set) {
            this.fListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterSelectionChangeListener(IFilterSelectionChangedListener listener) {
        Set<IFilterSelectionChangedListener> set = this.fListeners;
        synchronized (set) {
            this.fListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFilterSelectionChanged(Collection enabled, Collection disabled) {
        IFilterSelectionChangedListener[] listeners;
        Set<IFilterSelectionChangedListener> set = this.fListeners;
        synchronized (set) {
            listeners = this.fListeners.toArray(new IFilterSelectionChangedListener[this.fListeners.size()]);
        }
        IFilterSelectionChangedListener[] iFilterSelectionChangedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterSelectionChangedListener listener = iFilterSelectionChangedListenerArray[n2];
            listener.filterSelectionChanged(enabled, disabled);
            ++n2;
        }
    }

    @Override
    public boolean add(Object o) {
        boolean ret = super.add(o);
        if (ret) {
            this.fireFilterSelectionChanged(Arrays.asList(o), new ArrayList());
        }
        return ret;
    }

    @Override
    public boolean addAll(Collection c) {
        ArrayList added = new ArrayList();
        for (Object o : c) {
            if (!super.add(o)) continue;
            added.add(o);
        }
        if (added.size() > 0) {
            this.fireFilterSelectionChanged(added, new ArrayList());
        }
        return added.size() > 0;
    }

    @Override
    public void clear() {
        this.fireFilterSelectionChanged(new ArrayList(), Arrays.asList(super.toArray()));
    }

    @Override
    public Iterator iterator() {
        return super.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        if (ret) {
            this.fireFilterSelectionChanged(new ArrayList(), Arrays.asList(o));
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection c) {
        ArrayList removed = new ArrayList();
        for (Object o : c) {
            if (!super.remove(o)) continue;
            removed.add(o);
        }
        if (removed.size() > 0) {
            this.fireFilterSelectionChanged(new ArrayList(), removed);
        }
        return removed.size() > 0;
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public static interface IFilterSelectionChangedListener {
        public void filterSelectionChanged(Collection var1, Collection var2);
    }
}

