/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.feed.core.TempChannel;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.jface.internal.HelpContextIds;
import com.ibm.team.jface.internal.ItemViewAdvisorManager;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import com.ibm.team.jface.itemview.FullTextSearchFilter;
import com.ibm.team.jface.itemview.IItemViewListener;
import com.ibm.team.jface.itemview.IItemViewerLabelProvider;
import com.ibm.team.jface.itemview.ItemViewControl;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import com.ibm.team.jface.itemview.Messages;
import com.ibm.team.jface.itemview.TimelineFilter;
import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.TimelineUtils;
import com.ibm.team.ui.editor.TeamFormPage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractMarkupItemViewPage
extends TeamFormPage {
    static final String PREF_SIDE_BAR_HIDDEN = "fSideBarHidden";
    private static final String PREF_SHOW_FULL_CONTENTS = "fShowFullContents";
    private static final String PREF_GLOBAL_SORTER_ID = "globalSorterId";
    private static final String PREF_GLOBAL_FILTER_MEMENTO = "globalFilters";
    private static final String PREF_GLOBAL_FILTER_ID = "globalFilterId";
    public static final String PAGE_ID = "com.ibm.team.workitem.query.editor.page.details";
    private static final int QUICKSEARCH_DELAY = 500;
    private static final int TIMELINE_FILTER_DELAY = 300;
    static final String EDITOR_SETTINGS = "MarkupItemViewSettings";
    private UIJob fFilterJob;
    private UIJob fTimelineFilterJob;
    private IStructuredContentProvider fContentProvider;
    private Object fViewerInput;
    private ItemViewer fViewer;
    private FullTextSearchFilter fItemViewFilter;
    private IMemento fMemento;
    private ItemViewControl fItemViewControl;
    private TimelineFilter fTimelineFilter;
    private ItemViewUIConfigurer fUIConfigurer;
    private Set<String> fSelectedFilterIds;
    private Set<String> fGlobalFilterIds = new HashSet<String>();
    private String fGlobalSorterId;
    private boolean fShowFullContents;
    private boolean fSideBarHidden;
    private String fHelpContextId;

    public AbstractMarkupItemViewPage(FormEditor editor, String helpContextId) {
        super(editor, PAGE_ID, Messages.AbstractMarkupItemViewPage_NEWS_ITEMS);
        this.fHelpContextId = helpContextId;
        this.loadContributions();
        this.loadSettings();
    }

    protected abstract ITimelineContentProvider createTimelineContentProvider();

    protected abstract IStructuredContentProvider createItemViewerContentProvider();

    protected abstract IItemViewerLabelProvider createItemViewerLabelProvider();

    private void loadSettings() {
        String settings;
        IDialogSettings section = JFacePlugin.getDefault().getDialogSettings().getSection(PAGE_ID);
        if (section != null && (settings = section.get(EDITOR_SETTINGS)) != null) {
            try {
                this.fMemento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
                this.fShowFullContents = Boolean.valueOf(this.fMemento.getString(PREF_SHOW_FULL_CONTENTS));
                this.fSideBarHidden = Boolean.valueOf(this.fMemento.getString(PREF_SIDE_BAR_HIDDEN));
                this.fGlobalSorterId = this.fMemento.getString(PREF_GLOBAL_SORTER_ID);
                IMemento[] filters = this.fMemento.getChildren(PREF_GLOBAL_FILTER_MEMENTO);
                if (filters != null) {
                    IMemento[] iMementoArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento filter = iMementoArray[n2];
                        String filterId = filter.getString(PREF_GLOBAL_FILTER_ID);
                        if (filterId != null) {
                            this.fGlobalFilterIds.add(filterId);
                        }
                        ++n2;
                    }
                }
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
    }

    private void reloadGlobalSettings() {
        String settings;
        this.fGlobalFilterIds.clear();
        this.fGlobalSorterId = null;
        IDialogSettings section = JFacePlugin.getDefault().getDialogSettings().getSection(PAGE_ID);
        if (section != null && (settings = section.get(EDITOR_SETTINGS)) != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
                this.fGlobalSorterId = memento.getString(PREF_GLOBAL_SORTER_ID);
                IMemento[] filters = memento.getChildren(PREF_GLOBAL_FILTER_MEMENTO);
                if (filters != null) {
                    IMemento[] iMementoArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento filter = iMementoArray[n2];
                        String filterId = filter.getString(PREF_GLOBAL_FILTER_ID);
                        if (filterId != null) {
                            this.fGlobalFilterIds.add(filterId);
                        }
                        ++n2;
                    }
                }
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
    }

    private void saveSettings() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)EDITOR_SETTINGS);
        StringWriter writer = new StringWriter();
        try {
            memento.putString(PREF_SHOW_FULL_CONTENTS, String.valueOf(this.fShowFullContents));
            memento.putString(PREF_SIDE_BAR_HIDDEN, String.valueOf(this.fSideBarHidden));
            if (this.getEditorInput() instanceof MarkupItemViewInput && !((MarkupItemViewInput)this.getEditorInput()).useGlobalSettings()) {
                this.reloadGlobalSettings();
            }
            if (this.fGlobalSorterId != null) {
                memento.putString(PREF_GLOBAL_SORTER_ID, this.fGlobalSorterId);
            }
            for (String filterId : this.fGlobalFilterIds) {
                IMemento filter = memento.createChild(PREF_GLOBAL_FILTER_MEMENTO);
                filter.putString(PREF_GLOBAL_FILTER_ID, filterId);
            }
            memento.save((Writer)writer);
            String sectionName = PAGE_ID;
            IDialogSettings section = JFacePlugin.getDefault().getDialogSettings().getSection(sectionName);
            if (section == null) {
                section = JFacePlugin.getDefault().getDialogSettings().addNewSection(sectionName);
            }
            section.put(EDITOR_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadContributions() {
        this.fUIConfigurer = ItemViewAdvisorManager.getConfigurer();
    }

    @Override
    public void setInput(IEditorInput input) {
        super.setInputWithNotify(input);
        if (input instanceof MarkupItemViewInput) {
            MarkupItemViewInput in = (MarkupItemViewInput)input;
            this.setTitleToolTip(in.getToolTipText());
            this.setViewerInput(in.getInput());
            this.fSelectedFilterIds = in.getFilterIds();
        }
    }

    private void setViewerInput(Object input) {
        this.fViewerInput = input;
        if (this.fViewer != null) {
            this.fViewer.setInput(input);
            this.fItemViewControl.getTimelineViewer().setInput(this.fViewerInput);
            this.performRefresh(true);
            this.fItemViewControl.getTimelineViewer().refresh();
        }
    }

    @Override
    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    protected void createFormContent(IManagedForm managedForm) {
        IEditorInput editorInput = this.getEditorInput();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        body.setLayout((Layout)layout);
        body.setBackground(body.getDisplay().getSystemColor(9));
        Composite composite = toolkit.createComposite(body);
        GridLayout complayout = new GridLayout();
        complayout.marginWidth = 0;
        complayout.marginHeight = 0;
        complayout.verticalSpacing = 0;
        composite.setLayout((Layout)complayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(body.getDisplay().getSystemColor(5));
        ITimelineContentProvider timelineContentProvider = this.createTimelineContentProvider();
        Set presetFilterIds = null;
        String presetSorterId = null;
        if (editorInput instanceof MarkupItemViewInput && ((MarkupItemViewInput)editorInput).useGlobalSettings()) {
            presetFilterIds = this.fGlobalFilterIds;
            presetSorterId = this.fGlobalSorterId;
        } else if (editorInput instanceof MarkupItemViewInput) {
            presetFilterIds = ((MarkupItemViewInput)editorInput).getFilterIds();
            presetSorterId = ((MarkupItemViewInput)editorInput).getSorterId();
        }
        this.fItemViewControl = new ItemViewControl(this.fUIConfigurer, timelineContentProvider, presetSorterId, presetFilterIds, this.fSideBarHidden);
        this.fItemViewControl.create(composite, toolkit);
        this.fItemViewControl.addItemViewListener(new IItemViewListener(){

            @Override
            public void quickSearched(String search) {
                AbstractMarkupItemViewPage.this.performQuicksearch(search, 500);
            }

            @Override
            public void quickSearchCanceld() {
                AbstractMarkupItemViewPage.this.performQuicksearch("", 0);
            }

            @Override
            public void expandedAll() {
                AbstractMarkupItemViewPage.this.fShowFullContents = true;
                AbstractMarkupItemViewPage.this.fViewer.expandAll();
            }

            @Override
            public void collapsedAll() {
                AbstractMarkupItemViewPage.this.fShowFullContents = false;
                AbstractMarkupItemViewPage.this.fViewer.collapseAll();
            }

            @Override
            public void sideBarToggled(boolean visible) {
                Composite sideBar = AbstractMarkupItemViewPage.this.fItemViewControl.getSideBarContainer();
                Composite parent = sideBar.getParent();
                GridData gd = (GridData)sideBar.getLayoutData();
                gd.exclude = !gd.exclude;
                sideBar.setVisible(!sideBar.getVisible());
                if (parent instanceof ScrolledComposite) {
                    parent.setVisible(sideBar.getVisible());
                    parent = parent.getParent();
                }
                ((GridLayout)parent.getLayout()).numColumns = gd.exclude ? 1 : 2;
                parent.layout();
                AbstractMarkupItemViewPage.this.fSideBarHidden = !visible;
            }

            @Override
            public void sorted(String id) {
                if (AbstractMarkupItemViewPage.this.getEditorInput() instanceof MarkupItemViewInput && ((MarkupItemViewInput)AbstractMarkupItemViewPage.this.getEditorInput()).useGlobalSettings()) {
                    AbstractMarkupItemViewPage.this.fGlobalSorterId = id;
                }
                List sorters = AbstractMarkupItemViewPage.this.fUIConfigurer.getSorters();
                for (ItemViewerSorter sorter : sorters) {
                    if (!id.equals(sorter.getId())) continue;
                    if (sorter.equals(AbstractMarkupItemViewPage.this.fViewer.getSorter())) break;
                    AbstractMarkupItemViewPage.this.fViewer.setSorter(sorter.getViewerSorter());
                    AbstractMarkupItemViewPage.this.fViewer.getControl().setFocus();
                    break;
                }
            }

            @Override
            public void filtered(String id, boolean enabled) {
                if (AbstractMarkupItemViewPage.this.getEditorInput() instanceof MarkupItemViewInput && ((MarkupItemViewInput)AbstractMarkupItemViewPage.this.getEditorInput()).useGlobalSettings()) {
                    if (enabled) {
                        AbstractMarkupItemViewPage.this.fGlobalFilterIds.add(id);
                    } else {
                        AbstractMarkupItemViewPage.this.fGlobalFilterIds.remove(id);
                    }
                }
                List filters = AbstractMarkupItemViewPage.this.fUIConfigurer.getFilters();
                if (AbstractMarkupItemViewPage.this.fSelectedFilterIds == null) {
                    return;
                }
                for (ItemViewerFilter filter : filters) {
                    if (!id.equals(filter.getId())) continue;
                    if (enabled) {
                        AbstractMarkupItemViewPage.this.fSelectedFilterIds.add(filter.getId());
                        AbstractMarkupItemViewPage.this.fViewer.addFilter(filter.getViewerFilter());
                        continue;
                    }
                    AbstractMarkupItemViewPage.this.fSelectedFilterIds.remove(filter.getId());
                    AbstractMarkupItemViewPage.this.fViewer.removeFilter(filter.getViewerFilter());
                }
            }
        });
        this.fItemViewControl.getTimelineViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Range range = (Range)selection.getFirstElement();
                AbstractMarkupItemViewPage.this.performTimelineFilter(range, 300);
            }
        });
        this.fViewer = new ItemViewer(this.fItemViewControl.getBrowserContainer(), 0x800000, 3);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 64;
        data.heightHint = 64;
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fViewer.setShowFullContent(this.fShowFullContents);
        this.fItemViewFilter = new FullTextSearchFilter();
        this.fViewer.addFilter(this.fItemViewFilter, false);
        this.fTimelineFilter = new TimelineFilter(timelineContentProvider.getDefaultRange());
        this.fViewer.addFilter(this.fTimelineFilter, false);
        if (editorInput instanceof MarkupItemViewInput) {
            List filters = this.fUIConfigurer.getFilters();
            for (ItemViewerFilter filter : filters) {
                if (presetFilterIds == null || !presetFilterIds.contains(filter.getId())) continue;
                this.fViewer.addFilter(filter.getViewerFilter());
            }
        }
        if (editorInput instanceof MarkupItemViewInput) {
            List sorters = this.fUIConfigurer.getSorters();
            for (ItemViewerSorter sorter : sorters) {
                if (presetSorterId == null || !presetSorterId.equals(sorter.getId())) continue;
                this.fViewer.setSorter(sorter.getViewerSorter());
                break;
            }
            if (this.fViewer.getSorter() == null && this.fUIConfigurer.getDefaultSorter() != null) {
                this.fViewer.setSorter(this.fUIConfigurer.getDefaultSorter().getViewerSorter());
            }
        }
        this.fContentProvider = this.createItemViewerContentProvider();
        this.fViewer.setContentProvider(this.fContentProvider);
        this.fViewer.setLabelProvider(this.createItemViewerLabelProvider());
        if (this.fViewerInput != null) {
            this.fViewer.setInput(this.fViewerInput);
            this.performRefresh(true);
            this.fItemViewControl.getTimelineViewer().setInput(this.fViewerInput);
            this.fItemViewControl.getTimelineViewer().refresh();
        }
        if (this.fHelpContextId != null) {
            HelpContextIds.hookHelpListener((Control)managedForm.getForm(), this.fHelpContextId);
        }
    }

    public void dispose() {
        Object in;
        MarkupItemViewInput itemviewInput;
        super.dispose();
        this.fContentProvider.dispose();
        this.saveSettings();
        IEditorInput input = this.getEditorInput();
        if (input instanceof MarkupItemViewInput && (itemviewInput = (MarkupItemViewInput)input).getDisposeTempChannelsOnClose() && (in = itemviewInput.getInput()) instanceof Channel[]) {
            Channel[] channels;
            Channel[] channelArray = channels = (Channel[])in;
            int n = channels.length;
            int n2 = 0;
            while (n2 < n) {
                Channel channel = channelArray[n2];
                if (channel instanceof TempChannel) {
                    ((TempChannel)channel).dispose();
                }
                ++n2;
            }
        }
    }

    void performQuicksearch(final String search, int delay) {
        if (this.fFilterJob != null) {
            this.fFilterJob.cancel();
        }
        this.fFilterJob = new LoggingUIJob(Messages.AbstractMarkupItemViewPage_FILTER_ITEMS){

            @Override
            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    AbstractMarkupItemViewPage.this.fItemViewFilter.setSearchFilter(search);
                    AbstractMarkupItemViewPage.this.performRefresh(true);
                }
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
        this.fFilterJob.schedule((long)delay);
    }

    void performRefresh(boolean clearMessage) {
        this.performRefresh(clearMessage, false);
    }

    void performRefresh(boolean clearMessage, boolean resetRange) {
        if (clearMessage && this.getEditor() instanceof MarkupItemView) {
            ((MarkupItemView)this.getEditor()).showMessage(null, 0);
        }
        if (resetRange) {
            Range defaultRange = ((ITimelineContentProvider)this.fItemViewControl.getTimelineViewer().getContentProvider()).getDefaultRange();
            this.fTimelineFilter.setSelectedRange(defaultRange);
            this.fItemViewControl.getTimelineViewer().setVisibleRange(defaultRange);
            this.fItemViewControl.getTimelineViewer().setSelection((ISelection)new StructuredSelection((Object)defaultRange));
        }
        this.fViewer.refresh();
    }

    void performTimelineFilter(final Range range, int delay) {
        if (this.fTimelineFilterJob != null) {
            this.fTimelineFilterJob.cancel();
        }
        this.fTimelineFilterJob = new LoggingUIJob(Messages.AbstractMarkupItemViewPage_FILTER_TIMELINE_ITEMS){

            @Override
            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    if (AbstractMarkupItemViewPage.this.fTimelineFilter.getSelectedRange() != null) {
                        Range oldRange = AbstractMarkupItemViewPage.this.fTimelineFilter.getSelectedRange();
                        Range newRange = range;
                        Date oldDateFrom = new Date(TimelineUtils.trimToDay(oldRange.getStart()));
                        Date oldDateTo = new Date(TimelineUtils.trimToDay(oldRange.getEnd()));
                        Date newDateFrom = new Date(TimelineUtils.trimToDay(newRange.getStart()));
                        Date newDateTo = new Date(TimelineUtils.trimToDay(newRange.getEnd()));
                        if (oldDateFrom.equals(newDateFrom) && oldDateTo.equals(newDateTo)) {
                            return Status.OK_STATUS;
                        }
                    }
                    AbstractMarkupItemViewPage.this.fTimelineFilter.setSelectedRange(range);
                    AbstractMarkupItemViewPage.this.performRefresh(true);
                }
                return Status.OK_STATUS;
            }
        };
        this.fTimelineFilterJob.setSystem(true);
        this.fTimelineFilterJob.schedule((long)delay);
    }

    void toggleExpandAll() {
        this.fViewer.toggleExpandAll();
    }

    void toggleSideBar(boolean show) {
        this.fItemViewControl.notifySideBarToggled(show);
    }
}

